/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.features;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.MessageHandler;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopCreator
implements Listener {
    private String name = "";
    private String title;
    private final MessageHandler mh;
    private final BossShop plugin;

    public ShopCreator(BossShop plugin, MessageHandler handler) {
        this.plugin = plugin;
        this.mh = handler;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void startCreate(Player p, String shopName, String title) {
        this.setName(shopName);
        this.title = title;
        String inv_title = this.mh.get("ShopCreate.Title").replace("%shop%", this.getName());
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)inv_title);
        p.openInventory(inv);
    }

    @EventHandler
    private void Listen(InventoryCloseEvent e) {
        Inventory inv;
        Player p;
        if (e.getPlayer() instanceof Player && (p = (Player)e.getPlayer()).getOpenInventory().getTitle().startsWith(this.mh.get("ShopCreate.TitleHead")) && (p.hasPermission("BossShop.create") || e.getPlayer().isOp()) && (inv = e.getInventory()).getSize() == 54) {
            this.SaveAsFile(inv, p, this.getName(), this.getTitle());
        }
    }

    private void SaveAsFile(Inventory inv, Player p, String shopName, String title) {
        if (Objects.equals(shopName, "")) {
            return;
        }
        File f = new File(this.plugin.getDataFolder(), "shops" + File.separator + shopName + ".yml");
        if (f.exists()) {
            this.mh.sendMessage("ShopCreate.FileExists", (CommandSender)p);
            f.delete();
        }
        YamlConfiguration shop = YamlConfiguration.loadConfiguration((File)f);
        shop.set("ShopName", (Object)shopName);
        shop.set("DisplayName", (Object)title);
        ConfigurationSection c = shop.createSection("signs");
        c.set("text", (Object)("[" + shopName + "]"));
        c.set("NeedPermissionToCreateSign", (Object)true);
        ConfigurationSection shopItems = shop.createSection("shop");
        for (int real_slot = 0; real_slot < 53; ++real_slot) {
            ItemStack is = inv.getItem(real_slot);
            if (is == null) continue;
            ConfigurationSection item = shopItems.createSection(String.valueOf(real_slot + 1));
            item.set("MenuItem", ItemDataPart.readItem(is));
            item.set("RewardType", (Object)"nothing");
            item.set("PriceType", (Object)"nothing");
            item.set("ExtraPermission", (Object)"");
            item.set("Message", (Object)"");
            item.set("InventoryLocation", (Object)(real_slot + 1));
        }
        try {
            shop.save(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setName("");
        this.mh.sendMessage("ShopCreate.Success", (CommandSender)p);
        if (ClassManager.manager.getSettings().getReloadAfterCreateShop()) {
            ClassManager.manager.getPlugin().reloadPlugin((CommandSender)p);
        } else {
            ClassManager.manager.getMessageHandler().sendMessage("ShopCreate.Success2", (CommandSender)p);
        }
    }

    private String getName() {
        return this.name;
    }

    private String getTitle() {
        return this.title;
    }

    private void setName(String name) {
        this.name = name;
    }
}

