/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.serverpinging;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.serverpinging.ServerConnector;
import org.black_ixx.bossshop.managers.serverpinging.ServerInfo;

public class ServerConnector1
implements ServerConnector {
    private Gson gson = new Gson();

    @Override
    public boolean update(ServerInfo info) {
        try {
            StatusResponse response = this.fetchData(info);
            info.setOnline(true);
            info.setPlayers(response.getPlayers().getOnline());
            info.setMaxPlayers(response.getPlayers().getMax());
            info.setMotd(response.getDescription());
            return true;
        }
        catch (Exception e) {
            info.setNoConnection();
            if (ClassManager.manager.getSettings().isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public StatusResponse fetchData(ServerInfo info) throws IOException, IllegalStateException {
        Socket socket = new Socket();
        socket.setSoTimeout(info.getTimeout());
        socket.connect(info.getAddress(), info.getTimeout());
        OutputStream outputStream = socket.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        InputStream inputStream = socket.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream handshake = new DataOutputStream(b);
        handshake.writeByte(0);
        this.writeVarInt(handshake, 4);
        this.writeVarInt(handshake, info.getAddress().getHostString().length());
        handshake.writeBytes(info.getAddress().getHostString());
        handshake.writeShort(info.getAddress().getPort());
        this.writeVarInt(handshake, 1);
        this.writeVarInt(dataOutputStream, b.size());
        dataOutputStream.write(b.toByteArray());
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int size = this.readVarInt(dataInputStream);
        int id = this.readVarInt(dataInputStream);
        if (id == -1) {
            throw new IOException("Premature end of stream.");
        }
        if (id != 0) {
            throw new IOException("Invalid packetID");
        }
        int length = this.readVarInt(dataInputStream);
        if (length == -1) {
            throw new IOException("Premature end of stream.");
        }
        if (length == 0) {
            throw new IOException("Invalid string length.");
        }
        byte[] in = new byte[length];
        dataInputStream.readFully(in);
        String json = new String(in);
        long now = System.currentTimeMillis();
        dataOutputStream.writeByte(9);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeLong(now);
        this.readVarInt(dataInputStream);
        id = this.readVarInt(dataInputStream);
        if (id == -1) {
            throw new IOException("Premature end of stream.");
        }
        if (id != 1) {
            throw new IOException("Invalid packetID");
        }
        long pingtime = dataInputStream.readLong();
        StatusResponse response = (StatusResponse)this.gson.fromJson(json, StatusResponse.class);
        response.setTime((int)(now - pingtime));
        dataOutputStream.close();
        outputStream.close();
        inputStreamReader.close();
        inputStream.close();
        socket.close();
        return response;
    }

    public int readVarInt(DataInputStream in) throws IOException {
        byte k;
        int i = 0;
        int j = 0;
        do {
            k = in.readByte();
            i |= (k & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((k & 0x80) == 128);
        return i;
    }

    public void writeVarInt(DataOutputStream out, int paramInt) throws IOException {
        while (true) {
            if ((paramInt & 0xFFFFFF80) == 0) {
                out.writeByte(paramInt);
                return;
            }
            out.writeByte(paramInt & 0x7F | 0x80);
            paramInt >>>= 7;
        }
    }

    public class StatusResponse {
        private String description;
        private Players players;
        private Version version;
        private String favicon;
        private int time;

        public String getDescription() {
            return this.description;
        }

        public Players getPlayers() {
            return this.players;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getFavicon() {
            return this.favicon;
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }
    }

    public class Players {
        private int max;
        private int online;
        private List<Player> sample;

        public int getMax() {
            return this.max;
        }

        public int getOnline() {
            return this.online;
        }

        public List<Player> getSample() {
            return this.sample;
        }
    }

    public class Version {
        private String name;
        private String protocol;

        public String getName() {
            return this.name;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }

    public class Player {
        private String name;
        private String id;

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

