/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.serverpinging;

import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.serverpinging.ConnectedBuyItem;
import org.black_ixx.bossshop.managers.serverpinging.ServerConnector;

public class ServerInfo {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_BUNGEECORD = 1;
    private int type;
    private String host;
    private int port;
    private int timeout;
    private InetSocketAddress address;
    private int players;
    private int max_players;
    private boolean online;
    private String motd;
    private long wait;
    private boolean being_pinged;
    private Set<ConnectedBuyItem> buyitems = new LinkedHashSet<ConnectedBuyItem>();

    public ServerInfo(String host, int port, int timeout) {
        this.type = 0;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.address = new InetSocketAddress(host, port);
    }

    public ServerInfo(String bungeecord_servername, int timeout) {
        this.type = 1;
        ClassManager.manager.getSettings().setBungeeCordServerEnabled(true);
        this.host = bungeecord_servername;
        this.port = -1;
        this.timeout = -1;
        this.address = null;
        this.motd = "unknown";
        this.timeout = timeout;
    }

    public void update(ServerConnector current_connector) {
        switch (this.type) {
            case 0: {
                current_connector.update(this);
                break;
            }
            case 1: {
                ClassManager.manager.getBungeeCordManager().sendPluginMessage(null, ClassManager.manager.getPlugin(), "PlayerCount", this.host);
            }
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getPlayers() {
        return this.players;
    }

    public void setPlayers(int i) {
        this.players = i;
    }

    public int getMaxPlayers() {
        return this.max_players;
    }

    public void setMaxPlayers(int i) {
        this.max_players = i;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean b) {
        this.online = b;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String s) {
        this.motd = s;
    }

    public void setBeingPinged(boolean b) {
        this.being_pinged = b;
    }

    public void setNoConnection() {
        this.online = false;
        this.players = 0;
        this.max_players = 0;
        this.motd = "Offline";
    }

    public void hadNoSuccess() {
        int delay = ClassManager.manager.getSettings().getServerPingingWaittime();
        if (delay > 0) {
            this.wait = System.currentTimeMillis() + (long)delay;
        }
    }

    public boolean isWaiting() {
        return this.wait > System.currentTimeMillis() || this.being_pinged;
    }

    public void addShopItem(ConnectedBuyItem shopitem) {
        this.buyitems.add(shopitem);
    }

    public Set<ConnectedBuyItem> getConnectedBuyItems() {
        return this.buyitems;
    }
}

