/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.settings;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.features.PointsManager;
import org.black_ixx.bossshop.settings.SettingsProperty;
import org.black_ixx.bossshop.settings.ShopItemProperty;
import org.black_ixx.bossshop.settings.ShopProperty;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class Settings {
    public static final int HIDE_ITEMS_PLAYERS_DONT_HAVE_PERMISSIONS_FOR = 0;
    public static final int ALLOW_UNSAFE_ENCHANTMENTS = 1;
    public static final int ALLOW_SELLING_GREATER_ENCHANTS = 2;
    public static final int CLOSE_SHOP_AFTER_PURCHASE = 3;
    public static final int CLICK_DELAY = 4;
    public static final int SOUND_SHOPITEM_PURCHASE = 5;
    public static final int SOUND_SHOPITEM_CLICK = 6;
    public static final int SOUND_SHOPITEM_NOPERMISSION = 7;
    public static final int SOUND_SHOPITEM_NOTENOUGHMONEY = 8;
    public static final int SOUND_SHOP_OPEN = 9;
    public static final int SOUND_SHOP_CLOSE = 10;
    public static final int SOUND_SHOP_CHANGE_PAGE = 11;
    public static final int SOUND_SHOP_CHANGE_SHOP = 12;
    private boolean signs;
    private boolean money;
    private boolean points;
    private boolean vault;
    private boolean permissions;
    private boolean bungeecord;
    private boolean pointsdisplay;
    private boolean moneydisplay;
    private boolean serverpinging;
    private boolean load_subfolders;
    private boolean transactionslog;
    private boolean check_stacksize;
    private boolean exp_use_level;
    private boolean shopcommands;
    private boolean serverpinging_fixconnector;
    private boolean itemall_show_final_reward;
    private boolean inventory_full_drop_items;
    private boolean purchase_async;
    private boolean allow_selling_damaged_items;
    private boolean reload_after_create_shop;
    private boolean metrics = true;
    private int serverpinging_delay;
    private int serverpinging_waittime;
    private int serverpinging_timeout;
    private int autorefresh_delay;
    private int max_line_length;
    private int number_grouping_size;
    private int input_timeout;
    private String mainshop;
    private String number_locale;
    private PointsManager.PointsPlugin pointsplugin;
    private List<String> money_formatting;
    private List<String> points_formatting;
    private boolean debug;
    private final Map<Integer, SettingsProperty> properties = new LinkedHashMap<Integer, SettingsProperty>();
    private String language;

    public void loadConfig(ConfigurationSection config) {
        this.properties.clear();
        this.properties.put(0, new ShopItemProperty(config, "HideItemsPlayersDoNotHavePermissionsFor", Boolean.class));
        this.properties.put(1, new ShopItemProperty(config, "AllowUnsafeEnchantments", Boolean.class));
        this.properties.put(2, new ShopItemProperty(config, "CanPlayersSellItemsWithGreaterEnchants", Boolean.class));
        this.properties.put(3, new ShopItemProperty(config, "CloseShopAfterPurchase", Boolean.class));
        this.properties.put(4, new ShopItemProperty(config, "ClickDelay", Integer.class));
        this.properties.put(5, new ShopItemProperty(config, "Sound.Shopitem.Purchase", String.class));
        this.properties.put(6, new ShopItemProperty(config, "Sound.Shopitem.Click", String.class));
        this.properties.put(7, new ShopItemProperty(config, "Sound.Shopitem.NoPermission", String.class));
        this.properties.put(8, new ShopItemProperty(config, "Sound.Shopitem.NotEnoughMoney", String.class));
        this.properties.put(9, new ShopProperty(config, "Sound.Shop.Open", String.class));
        this.properties.put(10, new ShopProperty(config, "Sound.Shop.Close", String.class));
        this.properties.put(11, new ShopProperty(config, "Sound.Shop.ChangePage", String.class));
        this.properties.put(12, new ShopProperty(config, "Sound.Shop.ChangeShop", String.class));
    }

    public void update(Object o) {
        for (SettingsProperty property : this.properties.values()) {
            property.update(o);
        }
    }

    public void update() {
        FileConfiguration main_config = ClassManager.manager.getPlugin().getConfig();
        for (SettingsProperty property : this.properties.values()) {
            property.load((ConfigurationSection)main_config);
        }
    }

    public SettingsProperty getProperty(int id) {
        return this.properties.get(id);
    }

    public boolean getPropertyBoolean(int id, Object input) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getBoolean(input);
        }
        return false;
    }

    public int getPropertyInt(int id, Object input, int def) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getInt(input);
        }
        return def;
    }

    public String getPropertyString(int id, Object input, String def) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getString(input);
        }
        return def;
    }

    public void setPurchaseAsyncEnabled(boolean b) {
        this.purchase_async = b;
    }

    public void setServerPingingEnabled(boolean b) {
        this.serverpinging = b;
    }

    public void setServerPingingWaitTime(int i) {
        this.serverpinging_waittime = i;
    }

    public boolean getMetricsEnabled() {
        return this.metrics;
    }

    public void setMetricsEnabled(boolean b) {
        this.metrics = b;
    }

    public boolean getShopCommandsEnabled() {
        return this.shopcommands;
    }

    public void setShopCommandsEnabled(boolean b) {
        this.shopcommands = b;
    }

    public boolean getSignsEnabled() {
        return this.signs;
    }

    public void setSignsEnabled(boolean b) {
        this.signs = b;
        if (ClassManager.manager.getPlugin().getSignListener() != null) {
            ClassManager.manager.getPlugin().getSignListener().setSignsEnabled(b);
        }
    }

    public boolean getMoneyEnabled() {
        return this.money;
    }

    public void setMoneyEnabled(boolean b) {
        this.money = b;
    }

    public boolean getPointsEnabled() {
        return this.points;
    }

    public void setPointsEnabled(boolean b) {
        this.points = b;
    }

    public boolean getVaultEnabled() {
        return this.vault;
    }

    public void setVaultEnabled(boolean b) {
        this.vault = b;
    }

    public boolean getPermissionsEnabled() {
        return this.permissions;
    }

    public void setPermissionsEnabled(boolean b) {
        this.permissions = b;
    }

    public boolean getPurchaseAsync() {
        return this.purchase_async;
    }

    public boolean getExpUseLevel() {
        return this.exp_use_level;
    }

    public void setExpUseLevel(boolean b) {
        this.exp_use_level = b;
    }

    public String getMainShop() {
        return this.mainshop;
    }

    public void setMainShop(String main) {
        this.mainshop = main;
    }

    public boolean getBungeeCordServerEnabled() {
        return this.bungeecord;
    }

    public void setBungeeCordServerEnabled(boolean b) {
        this.bungeecord = b;
    }

    public boolean getBalanceVariableEnabled() {
        return this.moneydisplay;
    }

    public void setBalanceVariableEnabled(boolean b) {
        this.moneydisplay = b;
    }

    public boolean getBalancePointsVariableEnabled() {
        return this.pointsdisplay;
    }

    public void setBalancePointsVariableEnabled(boolean b) {
        this.pointsdisplay = b;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void setDebugEnabled(boolean b) {
        this.debug = b;
    }

    public PointsManager.PointsPlugin getPointsPlugin() {
        return this.pointsplugin;
    }

    public void setPointsPlugin(PointsManager.PointsPlugin p) {
        this.pointsplugin = p;
    }

    public boolean getTransactionLogEnabled() {
        return this.transactionslog;
    }

    public void setTransactionLogEnabled(boolean b) {
        this.transactionslog = b;
    }

    public boolean getServerPingingEnabled(boolean check_if_loaded_already) {
        if (check_if_loaded_already) {
            return ClassManager.manager.getServerPingingManager() != null;
        }
        return this.serverpinging;
    }

    public int getServerPingingSpeed() {
        return this.serverpinging_delay;
    }

    public void setServerPingingSpeed(int i) {
        this.serverpinging_delay = i;
    }

    public int getServerPingingWaittime() {
        return this.serverpinging_waittime;
    }

    public int getServerPingingTimeout() {
        return this.serverpinging_timeout;
    }

    public void setServerPingingTimeout(int i) {
        this.serverpinging_timeout = i;
    }

    public boolean getServerPingingFixConnector() {
        return this.serverpinging_fixconnector;
    }

    public void setServerPingingFixConnector(boolean b) {
        this.serverpinging_fixconnector = b;
    }

    public boolean getInventoryFullDropItems() {
        return this.inventory_full_drop_items;
    }

    public void setInventoryFullDropItems(boolean b) {
        this.inventory_full_drop_items = b;
    }

    public int getMaxLineLength() {
        return this.max_line_length;
    }

    public void setMaxLineLength(int i) {
        this.max_line_length = i;
    }

    public int getAutoRefreshSpeed() {
        return this.autorefresh_delay;
    }

    public void setAutoRefreshSpeed(int i) {
        this.autorefresh_delay = i;
    }

    public boolean getLoadSubfoldersEnabled() {
        return this.load_subfolders;
    }

    public void setLoadSubfoldersEnabled(boolean b) {
        this.load_subfolders = b;
    }

    public boolean getCheckStackSize() {
        return this.check_stacksize;
    }

    public void setCheckStackSize(boolean b) {
        this.check_stacksize = b;
    }

    public List<String> getMoneyFormatting() {
        return this.money_formatting;
    }

    public void setMoneyFormatting(List<String> formatting) {
        this.money_formatting = formatting;
    }

    public List<String> getPointsFormatting() {
        return this.points_formatting;
    }

    public void setPointsFormatting(List<String> formatting) {
        this.points_formatting = formatting;
    }

    public String getNumberLocale() {
        return this.number_locale;
    }

    public void setNumberLocale(String s) {
        this.number_locale = s;
    }

    public int getNumberGroupingSize() {
        return this.number_grouping_size;
    }

    public void setNumberGroupingSize(int i) {
        this.number_grouping_size = i;
    }

    public boolean getItemAllShowFinalReward() {
        return this.itemall_show_final_reward;
    }

    public void setItemAllShowFinalReward(boolean b) {
        this.itemall_show_final_reward = b;
    }

    public boolean getAllowSellingDamagedItems() {
        return this.allow_selling_damaged_items;
    }

    public void setAllowSellingDamagedItems(boolean b) {
        this.allow_selling_damaged_items = b;
    }

    public int getInputTimeout() {
        return this.input_timeout;
    }

    public void setInputTimeout(int i) {
        this.input_timeout = i;
    }

    public boolean getReloadAfterCreateShop() {
        return this.reload_after_create_shop;
    }

    public void setReloadAfterCreateShop(boolean b) {
        this.reload_after_create_shop = b;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String l) {
        this.language = l;
    }
}

