/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks;

import com.alonsoaliaga.betterbackpacks.commands.MainCommand;
import com.alonsoaliaga.betterbackpacks.enums.ItemType;
import com.alonsoaliaga.betterbackpacks.enums.UpgradeType;
import com.alonsoaliaga.betterbackpacks.listeners.ChestSortListener;
import com.alonsoaliaga.betterbackpacks.listeners.ClickListener;
import com.alonsoaliaga.betterbackpacks.listeners.CloseListener;
import com.alonsoaliaga.betterbackpacks.listeners.CraftListener;
import com.alonsoaliaga.betterbackpacks.listeners.DamageListener;
import com.alonsoaliaga.betterbackpacks.listeners.DropListener;
import com.alonsoaliaga.betterbackpacks.listeners.InteractListener;
import com.alonsoaliaga.betterbackpacks.listeners.SwapHandListener;
import com.alonsoaliaga.betterbackpacks.metrics.Metrics;
import com.alonsoaliaga.betterbackpacks.others.BackpackHolder;
import com.alonsoaliaga.betterbackpacks.others.BackpackSkin;
import com.alonsoaliaga.betterbackpacks.others.BuyerSkinUpgrade;
import com.alonsoaliaga.betterbackpacks.others.Color;
import com.alonsoaliaga.betterbackpacks.others.CommandData;
import com.alonsoaliaga.betterbackpacks.others.FileManager;
import com.alonsoaliaga.betterbackpacks.others.Materials;
import com.alonsoaliaga.betterbackpacks.others.Messages;
import com.alonsoaliaga.betterbackpacks.others.OwnerSkinUpgrade;
import com.alonsoaliaga.betterbackpacks.others.Permissions;
import com.alonsoaliaga.betterbackpacks.others.Tank;
import com.alonsoaliaga.betterbackpacks.others.TierBackpack;
import com.alonsoaliaga.betterbackpacks.others.TierUpgrade;
import com.alonsoaliaga.betterbackpacks.others.UniqueBackpack;
import com.alonsoaliaga.betterbackpacks.others.UpgradeData;
import com.alonsoaliaga.betterbackpacks.tanks.HoneyTank;
import com.alonsoaliaga.betterbackpacks.tanks.LavaTank;
import com.alonsoaliaga.betterbackpacks.tanks.MilkTank;
import com.alonsoaliaga.betterbackpacks.tanks.PowderSnowTank;
import com.alonsoaliaga.betterbackpacks.tanks.WaterTank;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.BukkitSerializers;
import com.alonsoaliaga.betterbackpacks.utils.ItemUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import com.alonsoaliaga.betterbackpacks.utils.WorldGuardUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTListCompound;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class BetterBackpacks
extends JavaPlugin
implements AlonsoUtils.AlonsoPlugin {
    private static BetterBackpacks instance;
    private AlonsoUtils.PluginUtils pluginUtils;
    private FileManager fileManager;
    private AlonsoUtils.Updater updater = null;
    public MainCommand mainCommand;
    public Messages messages;
    public Permissions permissions;
    public CraftListener craftListener = null;
    public InteractListener interactListener = null;
    public CloseListener closeListener = null;
    public ClickListener clickListener = null;
    public DamageListener damageListener = null;
    public DropListener dropListener = null;
    public SwapHandListener swapHandListener = null;
    public Material backpackMaterial;
    public ItemStack backpackItem;
    public boolean reload;
    public boolean debugMode;
    public boolean logMode;
    public int skinsShopRows;
    public int upgradesShopRows;
    public boolean skinsEnabled;
    public boolean upgradesEnabled;
    public boolean upgradesFrameEnabled;
    public boolean upgradesShopEnabled;
    public boolean skinsShopEnabled;
    public boolean backpackception;
    public boolean worldGuardSupport;
    public boolean chestSortSupport;
    public boolean defaultFlagIfNotSelected;
    public Inventory upgradesInventory;
    public boolean uniqueBackpacks;
    public List<String> disabledWorlds;
    public List<Material> disabledLeftClickMaterials;
    public HashMap<Integer, NBTItem> backpacksMap;
    public HashMap<Integer, Inventory> backpacksRecipesMap;
    public HashMap<Integer, String> backpackPermissionMap;
    public HashMap<Integer, String> backpackCraftMessageMap;
    public HashMap<Integer, String> backpackRecipeMessageMap;
    public HashMap<Integer, Tank> tanksMap;
    public HashMap<Integer, UniqueBackpack> uniqueBackpacksMap = new HashMap();
    public HashMap<Integer, TierBackpack> tierBackpacksMap;
    public HashMap<Integer, ItemStack> tierUniqueSelectorMap;
    public HashMap<Integer, ItemStack> tierRecipeSelectorMap;
    public TreeMap<Integer, TreeMap<Integer, BackpackSkin>> skinsPageMap = new TreeMap();
    public HashMap<String, BackpackSkin> skinsMap = new HashMap();
    public HashMap<String, UpgradeData> upgradesMap = new HashMap();
    public TreeMap<Integer, UpgradeData> upgradesSlotsMap = new TreeMap();
    public TreeMap<Integer, UpgradeData> upgradesLevelMap = new TreeMap();
    public CommandData closeSkinsCommand = null;
    public CommandData closeUpgradesCommand = null;
    public ItemStack emptyTank;
    public Inventory uniqueInventory = null;
    private int bStatsID = 12376;
    private int[] skinsShopArray = new int[]{1, 2, 3, 4, 5, 6, 7};
    private List<Integer> framesShopArray = new ArrayList<Integer>();
    public int previousSlot;
    public int closeSkinsSlot;
    public int closeUpgradesSlot;
    public int nextSlot;
    public ItemStack previousItem;
    public ItemStack nextItem;
    public ItemStack closeSkinsItem;
    public ItemStack skinsFramePane;
    public ItemStack closeUpgradesItem;
    public ItemStack upgradesFramePane;
    public boolean economySupport;
    public Economy economy = null;
    private final String RESPECT_MY_WORK = "997807";
    private final String HEADER = "     ___      _   _           ___          _                 _       ___                 Our plugins: https://alonsoaliaga.com/plugins\n    | _ ) ___| |_| |_ ___ _ _| _ ) __ _ __| |___ __  __ _ __| |__ __| _ \\_ _ ___         Support server: https://alonsoaliaga.com/discord\n    | _ \\/ -_)  _|  _/ -_) '_| _ \\/ _` / _| / / '_ \\/ _` / _| / /(_-<  _/ '_/ _ \\        Youtube: https://alonsoaliaga.com/play\n    |___/\\___|\\__|\\__\\___|_| |___/\\__,_\\__|_\\_\\ .__/\\__,_\\__|_\\_\\/__/_| |_| \\___/        Test server: plugins.alonsoaliaga.com\n                              by AlonsoAliaga |_|                                        Twitch: https://alonsoaliaga.com/twitch\n              Considering donating? https://alonsoaliaga.com/donate                      Thanks for purchasing my plugin! Only buyers receive support.\n\n                         >> If your spigot profile link is not https://www.spigotmc.org/members/997807/\n               consider purchasing our plugin from https://alonsoaliaga.com/BetterBackpacksPro to support our hard work. <<";

    public void onLoad() {
        boolean bl = this.worldGuardSupport = this.getServer().getPluginManager().getPlugin("WorldGuard") != null;
        if (this.worldGuardSupport) {
            LocalUtils.logp("WorldGuard found! Registering custom flag(s)..");
            WorldGuardUtils.registerFlags(this);
        }
    }

    public void onEnable() {
        BetterBackpacks.loadConfig0();
        instance = this;
        if (!Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            LocalUtils.loge("================================================================================");
            LocalUtils.loge("This plugin requires NBTAPI. It's needed for this plugin to work.");
            LocalUtils.loge("NBTAPI couldn't be found in your server. Disabling plugin..");
            LocalUtils.loge("Download latest version of NBTAPI in https://alonsoaliaga.com/NBTAPI");
            LocalUtils.loge("Please install NBTAPI to use this plugin or it won't work.");
            LocalUtils.loge("For more questions join us on https://alonsoaliaga.com/discord");
            LocalUtils.loge("================================================================================");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        AlonsoUtils.sendEnableText(this);
        AlonsoUtils.isSupported();
        boolean bl = this.chestSortSupport = this.getServer().getPluginManager().getPlugin("ChestSort") != null;
        if (this.chestSortSupport) {
            LocalUtils.logp("======================================================================================");
            LocalUtils.logp("Seems that you are using ChestSort! Be careful when using it with any other backpack");
            LocalUtils.logp("plugins, looks like it breaks backpack plugins and allow players to dupe items.");
            LocalUtils.logp("Hopefully BetterBackpacks prevents this from happening. If you still have issues with");
            LocalUtils.logp("it join us on https://alonsoaliaga.com/discord as soon as possible to help you!");
            LocalUtils.logp("======================================================================================");
            new ChestSortListener(this);
        }
        this.economySupport = this.setupEconomy();
        this.tanksMap = new HashMap();
        this.backpacksMap = new LinkedHashMap<Integer, NBTItem>();
        this.backpacksRecipesMap = new LinkedHashMap<Integer, Inventory>();
        this.backpackPermissionMap = new LinkedHashMap<Integer, String>();
        this.backpackCraftMessageMap = new LinkedHashMap<Integer, String>();
        this.backpackRecipeMessageMap = new LinkedHashMap<Integer, String>();
        this.uniqueBackpacksMap = new HashMap();
        this.tierBackpacksMap = new HashMap();
        this.tierUniqueSelectorMap = new HashMap();
        this.tierRecipeSelectorMap = new HashMap();
        this.reload = false;
        this.pluginUtils = new AlonsoUtils.PluginUtils(this);
        this.backpackMaterial = LocalUtils.findMaterial("PLAYER_HEAD", "SKULL_ITEM");
        this.backpackItem = this.backpackMaterial.name().equals("PLAYER_HEAD") ? new ItemStack(this.backpackMaterial) : new ItemStack(this.backpackMaterial, 1, 3);
        this.fileManager = new FileManager(this);
        this.updateConfiguration();
        this.messages = new Messages(this);
        this.permissions = new Permissions(this);
        this.reloadMessages();
        String string2 = this.getFiles().getConfig().get().getString("Options.Main-command", "betterbackpacks").replaceAll("\\s+", "");
        if (string2.isEmpty()) {
            string2 = "betterbackpacks";
        }
        List<String> list = this.getFiles().getConfig().get().getStringList("Options.Aliases").stream().map(string -> string.replace(" ", "").trim()).filter(string -> !string.isEmpty()).collect(Collectors.toList());
        this.mainCommand = new MainCommand(this, string2, list);
        this.clickListener = new ClickListener(this);
        this.interactListener = new InteractListener(this);
        this.craftListener = new CraftListener(this);
        this.closeListener = new CloseListener(this);
        this.damageListener = new DamageListener(this);
        this.dropListener = new DropListener(this);
        try {
            Class.forName("org.bukkit.event.player.PlayerSwapHandItemsEvent");
            this.swapHandListener = new SwapHandListener(this);
            LocalUtils.logp("PlayerSwapHandItemsEvent available. Listening..");
        }
        catch (Throwable throwable) {
            LocalUtils.logp("PlayerSwapHandItemsEvent not available. Skipping..");
        }
        Metrics metrics = new Metrics((Plugin)this, this.bStatsID);
        metrics.addCustomChart(new Metrics.SimplePie("protocollib_hooked", () -> this.pluginUtils.isProtocolLibSupported() ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("nbtapi_hooked", () -> this.getServer().getPluginManager().getPlugin("NBTAPI") != null ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("placeholderapi_hooked", () -> this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("chestsort_hooked", () -> this.getServer().getPluginManager().getPlugin("ChestSort") != null ? "Yes" : "No"));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> metrics.addCustomChart(new Metrics.AdvancedPie("plugins_from_alonsoaliaga", () -> {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Plugin plugin : this.getServer().getPluginManager().getPlugins()) {
                if (!plugin.getDescription().getAuthors().contains("AlonsoAliaga") || plugin.getName().equalsIgnoreCase(this.getDescription().getName())) continue;
                hashMap.put(plugin.getName(), 1);
            }
            return hashMap;
        })), 1200L);
        if (this.getFiles().getConfig().get().getBoolean("Updates.Check-updates", true)) {
            this.updater = new AlonsoUtils.Updater(this, "95254", this.getFiles().getConfig().get().getBoolean("Updates.Notify-updates", true), this.getFiles().getConfig().get().getString("Updates.Permission", null), this.getFiles().getConfig().get().getString("Updates.Message", null));
        }
        this.reload = true;
        LocalUtils.logp("Initializing reflections..");
        BukkitSerializers.load();
    }

    public boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            LocalUtils.logp("Vault not found! Ignoring..");
            return false;
        }
        LocalUtils.logp("Vault found! Hooking..");
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            LocalUtils.logp("Vault couldn't be hooked correctly. Skipping..");
            return false;
        }
        this.economy = (Economy)registeredServiceProvider.getProvider();
        return this.economy != null;
    }

    public void onDisable() {
        this.closeInventories();
        AlonsoUtils.sendDisableText();
    }

    public void closeInventories() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            try {
                if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof BackpackHolder)) continue;
                player.closeInventory();
            }
            catch (Throwable throwable) {
                player.closeInventory();
            }
        }
    }

    @Override
    public BetterBackpacks getMain() {
        return this;
    }

    public void loadRecipes() {
        if (!this.reload) {
            this.backpacksMap.clear();
        }
        this.tierBackpacksMap.clear();
        this.loadBackpack("Tier1", 1);
        this.loadBackpack("Tier2", 2);
        this.loadBackpack("Tier3", 3);
        this.loadBackpack("Tier4", 4);
        this.loadBackpack("Tier5", 5);
        this.loadBackpack("Tier6", 6);
        this.loadUniqueBackpacks();
    }

    private void loadUniqueBackpacks() {
        this.uniqueBackpacksMap.clear();
        this.uniqueBackpacks = this.getFiles().getConfig().get().getBoolean("Unique-backpacks.Enabled", true);
        this.tierUniqueSelectorMap.clear();
        if (this.uniqueBackpacks) {
            List list = this.getFiles().getConfig().get().getStringList("Unique-backpacks.Textures");
            if (list.size() >= 1) {
                Iterator<Object> iterator;
                int n = 0;
                int n2 = 0;
                for (String object2 : list) {
                    String string;
                    String string2;
                    String[] stringArray = object2.split("\\|");
                    if (stringArray.length == 0) continue;
                    if (stringArray.length >= 2) {
                        if (stringArray.length >= 3) {
                            if (LocalUtils.isInteger(stringArray[2])) {
                                n2 = Integer.parseInt(stringArray[2]);
                            }
                            string2 = stringArray[0];
                            string = stringArray[1];
                        } else {
                            string2 = stringArray[0];
                            string = stringArray[1];
                        }
                    } else {
                        string2 = "&cUnknown Backpack";
                        string = stringArray[0];
                    }
                    NBTItem nBTItem = this.createSampleBackpack(string, string2, n2);
                    this.uniqueBackpacksMap.put(n, new UniqueBackpack(string, nBTItem));
                    if (++n < 54) continue;
                    LocalUtils.logp("&7Max amount of unique backpacks textures reached. Max allowed: 54, current: " + list.size() + ". Skipping..");
                    break;
                }
                this.uniqueInventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(), (int)((int)Math.ceil((double)this.uniqueBackpacksMap.size() / 9.0) * 9), (String)LocalUtils.colorize(this.getFiles().getConfig().get().getString("Unique-backpacks.Title")));
                for (Map.Entry entry : this.uniqueBackpacksMap.entrySet()) {
                    this.uniqueInventory.setItem(((Integer)entry.getKey()).intValue(), ((UniqueBackpack)entry.getValue()).getNbtItem().getItem());
                }
                LocalUtils.logp("&7Unique texture is enabled. Loaded textures: " + this.uniqueBackpacksMap.size() + "!");
                try {
                    iterator = new ItemStack(Material.valueOf((String)"BLACK_STAINED_GLASS_PANE"));
                }
                catch (Exception exception) {
                    iterator = new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, (short)DyeColor.BLACK.getDyeData());
                }
                FileConfiguration fileConfiguration = this.getFiles().getItems().get();
                this.tierUniqueSelectorMap.put(11, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.1"), 1));
                this.tierUniqueSelectorMap.put(12, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.2"), 2));
                this.tierUniqueSelectorMap.put(13, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.3"), 3));
                this.tierUniqueSelectorMap.put(14, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.4"), 4));
                this.tierUniqueSelectorMap.put(15, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.5"), 5));
                this.tierUniqueSelectorMap.put(16, this.simpleItem((ItemStack)iterator, fileConfiguration.getConfigurationSection("Items.Tiers-build.6"), 6));
            } else {
                LocalUtils.logp("&cUnique textures feature is enabled but texture list amount is less than 1. Disabling feature!");
                this.uniqueInventory = null;
                this.uniqueBackpacks = false;
            }
        } else {
            LocalUtils.logp("&cUnique textures feature is disabled!");
            this.uniqueInventory = null;
        }
    }

    public NBTItem createSampleBackpack(String string, String string2) {
        return this.createSampleBackpack(string, string2, 0);
    }

    public NBTItem createSampleBackpack(String string, String string2, int n) {
        ItemStack itemStack = this.backpackItem.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(LocalUtils.colorize(string2));
        itemMeta.setLore(new ArrayList());
        if (n > 0 && this.pluginUtils.isCustomModelSupported()) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        itemStack.setItemMeta(itemMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-backpack");
        nBTCompound.setString("betterbackpacks-backpack-texture", string);
        NBTCompound nBTCompound2 = nBTItem.addCompound("SkullOwner");
        LocalUtils.setUUID(nBTCompound2, "Id", UUID.randomUUID());
        NBTListCompound nBTListCompound = nBTCompound2.addCompound("Properties").getCompoundList("textures").addCompound();
        nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
        nBTListCompound.setString("Value", string);
        return nBTItem;
    }

    public static BetterBackpacks getInstance() {
        return instance;
    }

    private void loadBackpack(String string, int n) {
        int n2;
        ConfigurationSection configurationSection = this.getFiles().getBackpacks().get().getConfigurationSection("Backpacks." + string);
        ItemStack itemStack = this.backpackItem.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        String string2 = LocalUtils.colorize(configurationSection.getString("Displayname"));
        String string3 = configurationSection.getString("Texture");
        List<String> list = LocalUtils.colorize(configurationSection.getStringList("Lore"));
        this.tierBackpacksMap.put(n, new TierBackpack(string2, list, string3));
        itemMeta.setDisplayName(string2);
        itemMeta.setLore(list);
        itemMeta.addItemFlags(ItemFlag.values());
        int n3 = n2 = this.pluginUtils.isCustomModelSupported() ? configurationSection.getInt("Custom-model-data") : 0;
        if (n2 > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n2));
        }
        itemStack.setItemMeta(itemMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-backpack");
        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
        NBTCompound nBTCompound2 = nBTItem.addCompound("SkullOwner");
        LocalUtils.setUUID(nBTCompound2, "Id", UUID.randomUUID());
        NBTListCompound nBTListCompound = nBTCompound2.addCompound("Properties").getCompoundList("textures").addCompound();
        nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
        nBTListCompound.setString("Value", string3);
        if (this.permissions.tierPermission == null) {
            this.backpackPermissionMap.remove(n);
        } else {
            this.backpackPermissionMap.put(n, this.permissions.tierPermission.replace("{TIER}", String.valueOf(n)));
        }
        this.backpackCraftMessageMap.put(n, LocalUtils.colorize(configurationSection.getString("Recipe.Cannot-craft", "&cYou don't have permission to craft this backpack!")));
        this.backpackRecipeMessageMap.put(n, LocalUtils.colorize(configurationSection.getString("Recipe.Cannot-recipe", "&cYou don't have permission to view this backpack recipe or it isn't craftable!!")));
        this.backpacksMap.put(n, nBTItem);
        if (configurationSection.getBoolean("Recipe.Enabled", false)) {
            if (this.reload) {
                LocalUtils.logp("Reloading configuration doesn't update backpack " + string + " recipe. Skipping.. Please restart server if you want to reload recipes!");
            } else {
                String string4;
                char[] cArray;
                String string5;
                char[] cArray2;
                Object object222;
                if (this.logMode) {
                    LocalUtils.logp("Loading backpack " + string + " recipe..");
                }
                ShapedRecipe shapedRecipe = this.pluginUtils.getServerVersion().getWeight() >= AlonsoUtils.ServerVersion.v1_12.getWeight() ? new ShapedRecipe(new NamespacedKey((Plugin)this, "betterbackpacks-backpack-" + string.toLowerCase()), nBTItem.getItem()) : new ShapedRecipe(nBTItem.getItem());
                shapedRecipe.shape(configurationSection.getStringList("Recipe.Shape").toArray(new String[0]));
                for (Object object222 : configurationSection.getConfigurationSection("Recipe.Ingredients").getKeys(false)) {
                    try {
                        Material exception = Material.valueOf((String)configurationSection.getString("Recipe.Ingredients." + (String)object222));
                        shapedRecipe.setIngredient(((String)object222).charAt(0), exception);
                    }
                    catch (Exception exception) {
                        LocalUtils.logp("&cInvalid ingredient material for " + string + ": '" + configurationSection.getString("Recipe.Ingredients." + (String)object222) + "'");
                    }
                }
                Inventory inventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(n, nBTItem), (int)54, (String)LocalUtils.colorize(configurationSection.getString("Recipe.Title")));
                for (Map.Entry entry : this.tierRecipeSelectorMap.entrySet()) {
                    inventory.setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                }
                object222 = shapedRecipe.getShape()[0];
                char[] cArray3 = ((String)object222).toCharArray();
                if (cArray3[0] != ' ') {
                    inventory.setItem(19, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray3[0])));
                }
                if (cArray3[1] != ' ') {
                    inventory.setItem(20, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray3[1])));
                }
                if (cArray3[2] != ' ') {
                    inventory.setItem(21, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray3[2])));
                }
                if ((cArray2 = (string5 = shapedRecipe.getShape()[1]).toCharArray())[0] != ' ') {
                    inventory.setItem(28, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray2[0])));
                }
                if (cArray2[1] != ' ') {
                    inventory.setItem(29, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray2[1])));
                }
                if (cArray2[2] != ' ') {
                    inventory.setItem(30, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray2[2])));
                }
                if ((cArray = (string4 = shapedRecipe.getShape()[2]).toCharArray())[0] != ' ') {
                    inventory.setItem(37, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray[0])));
                }
                if (cArray[1] != ' ') {
                    inventory.setItem(38, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray[1])));
                }
                if (cArray[2] != ' ') {
                    inventory.setItem(39, (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(cArray[2])));
                }
                inventory.setItem(33, nBTItem.getItem());
                if (this.logMode) {
                    LocalUtils.logp("Loaded backpack " + string + " recipe!");
                }
                this.backpacksRecipesMap.put(n, inventory);
                Bukkit.addRecipe((Recipe)shapedRecipe);
            }
        } else if (this.reload) {
            LocalUtils.logp("Reloading configuration doesn't update backpack " + string + " recipe. Skipping.. Please restart server if you want to reload recipes!");
        } else {
            LocalUtils.logp("Backpack " + string + " recipe is disabled!");
        }
    }

    public void reloadMessages() {
        this.debugMode = this.getFiles().getConfig().get().getBoolean("Options.Debug-mode", false);
        this.logMode = this.getFiles().getConfig().get().getBoolean("Options.Log-mode", false);
        this.disabledWorlds = this.getFiles().getConfig().get().getStringList("Options.Disabled-worlds");
        this.backpackception = this.getFiles().getConfig().get().getBoolean("Options.Backpackception", false);
        this.defaultFlagIfNotSelected = this.getFiles().getConfig().get().getBoolean("Options.WorldGuard.Default-flag", true);
        this.disabledLeftClickMaterials = LocalUtils.getMaterials(this.getFiles().getConfig().get().getStringList("Options.Disabled-click"));
        if (this.disabledLeftClickMaterials.isEmpty()) {
            LocalUtils.logp("No materials were added to restrict right-click list! Ignoring..");
        } else {
            LocalUtils.logp("Successfully loaded " + this.disabledLeftClickMaterials.size() + " materials to restrict right-click in backpacks!");
        }
        this.loadGuiItems();
        this.loadRecipes();
        this.emptyTank = ItemUtils.buildHead(LocalUtils.colorize(this.getFiles().getItems().get().getString("Items.Tank.Empty.Displayname")), LocalUtils.colorize(this.getFiles().getItems().get().getStringList("Items.Tank.Empty.Lore")), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjkxYjdiMjE3MjVmMTQ2ZDI5YzE5MmI3NDVkNzlkMjI2MDMyNjdjN2FkODkzYmFkZWI2NTQ2ZTc0NjYwMDA2MCJ9fX0=");
        if (this.tanksMap.isEmpty()) {
            this.tanksMap.put(0, new WaterTank(this));
            this.tanksMap.put(1, new LavaTank(this));
            this.tanksMap.put(2, new MilkTank(this));
            if (LocalUtils.findMaterialOrDefault("HONEY_BOTTLE", null) != null) {
                this.tanksMap.put(3, new HoneyTank(this));
            }
            if (LocalUtils.findMaterialOrDefault("POWDER_SNOW_BUCKET", null) != null) {
                this.tanksMap.put(4, new PowderSnowTank(this));
            }
        } else {
            for (Tank object2 : this.tanksMap.values()) {
                object2.loadItems();
            }
        }
        this.skinsEnabled = this.getFiles().getConfig().get().getBoolean("Options.Skins.Enabled", true);
        this.skinsShopEnabled = this.getFiles().getConfig().get().getBoolean("Options.Skins.Shop.Enabled", true);
        this.upgradesEnabled = this.getFiles().getConfig().get().getBoolean("Options.Upgrades.Enabled", true);
        this.upgradesShopEnabled = this.getFiles().getConfig().get().getBoolean("Options.Upgrades.Shop.Enabled", true);
        this.upgradesFrameEnabled = this.getFiles().getConfig().get().getBoolean("Options.Upgrades.Shop.Frame", true);
        this.skinsShopRows = Math.max(1, Math.min(this.getFiles().getConfig().get().getInt("Options.Skins.Shop.Rows", 6), 6));
        this.upgradesShopRows = Math.max(1, Math.min(this.getFiles().getConfig().get().getInt("Options.Upgrades.Shop.Rows", 4), 6));
        this.skinsMap.clear();
        this.skinsPageMap.clear();
        this.upgradesSlotsMap.clear();
        this.upgradesMap.clear();
        this.skinsPageMap.put(1, new TreeMap());
        if (this.skinsEnabled) {
            LocalUtils.logp("Skins are enabled! Players can apply skins to backpacks!");
        } else {
            LocalUtils.logp("Skins are disabled! Players cannot apply skins to backpacks..");
        }
        if (this.skinsShopEnabled) {
            String string = this.getFiles().getConfig().get().getString("Options.Skins.Shop.Frames.Slots", "0,1,2,3,4,5,6,7,8,9,17,18,26,27,35,36,44,45,46,47,48,49,50,51,52,53");
            this.framesShopArray = Arrays.stream(string.split(",")).filter(LocalUtils::isInteger).map(Integer::valueOf).filter(n -> n >= 0 && n <= this.skinsShopRows * 9 - 1).collect(Collectors.toList());
            String string2 = this.getFiles().getConfig().get().getString("Options.Skins.Shop.Slots", "10,11,12,13,14,15,16,19,20,21,22,23,24,25,28,29,30,31,32,33,34,37,38,39,40,41,42,43");
            IntStream intStream = Arrays.stream(string2.split(",")).filter(LocalUtils::isInteger).map(Integer::parseInt).filter(n -> n >= 0 && n <= this.skinsShopRows * 9 - 1).mapToInt(n -> n);
            this.skinsShopArray = intStream.toArray();
            if (this.skinsShopArray.length == 0) {
                LocalUtils.logp("Slots selected are not valid! Using default values: 1,2,3,4,5,6 and 7. Please edit your config to customize slots.");
                this.skinsShopArray = new int[]{1, 2, 3, 4, 5, 6, 7};
            }
            Arrays.sort(this.skinsShopArray);
            int n2 = this.skinsShopRows * 9 - 1;
            this.previousItem = LocalUtils.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Previous"), Material.ARROW);
            this.nextItem = LocalUtils.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Next"), Material.ARROW);
            this.closeSkinsItem = LocalUtils.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Close-skins"), Material.BOOK);
            this.skinsFramePane = LocalUtils.createColored(this.getFiles().getConfig().get().getConfigurationSection("Items.Skins-shop-frame"), Color.BLACK);
            this.previousSlot = Math.max(0, Math.min(this.getFiles().getConfig().get().getInt("Items.Previous.Slot", 48), n2));
            this.nextSlot = Math.max(0, Math.min(this.getFiles().getConfig().get().getInt("Items.Next.Slot", 50), n2));
            this.closeSkinsSlot = Math.max(-1, Math.min(this.getFiles().getConfig().get().getInt("Items.Close-skins.Slot", 49), n2));
            String string3 = this.getFiles().getConfig().get().getString("Items.Close-skins.Command", "none");
            this.closeSkinsCommand = string3.equalsIgnoreCase("none") ? null : new CommandData(string3);
            LocalUtils.logp("Skins shop is enabled! Loading skins..");
        } else {
            LocalUtils.logp("Skins shop is disabled! Skipping..");
        }
        this.loadSkins();
        if (this.upgradesEnabled) {
            LocalUtils.logp("Upgrades are enabled! Players can use upgrade items with backpacks!");
        } else {
            LocalUtils.logp("Upgrades are disabled! Players cannot use upgrade items with backpacks..");
        }
        if (this.upgradesShopEnabled) {
            int n3 = this.upgradesShopRows * 9 - 1;
            this.closeUpgradesItem = LocalUtils.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Close-upgrades"), Material.BOOK);
            this.upgradesFramePane = LocalUtils.createColored(this.getFiles().getConfig().get().getConfigurationSection("Items.Upgrades-shop-frame"), Color.BLACK);
            this.closeUpgradesSlot = Math.max(-1, Math.min(this.getFiles().getConfig().get().getInt("Items.Close-upgrades.Slot", 49), n3));
            String string = this.getFiles().getConfig().get().getString("Items.Close-upgrades.Command", "none");
            this.closeUpgradesCommand = string.equalsIgnoreCase("none") ? null : new CommandData(string);
        } else {
            LocalUtils.logp("Upgrades shop is disabled! Skipping..");
            this.upgradesInventory = null;
        }
        this.loadUpgrades();
    }

    private void loadUpgrades() {
        this.loadTierUpgrade("one-tier", UpgradeType.ONE_TIER);
        this.loadTierUpgrade("tier-two", UpgradeType.DIRECT_TIER_2);
        this.loadTierUpgrade("tier-three", UpgradeType.DIRECT_TIER_3);
        this.loadTierUpgrade("tier-four", UpgradeType.DIRECT_TIER_4);
        this.loadTierUpgrade("tier-five", UpgradeType.DIRECT_TIER_5);
        this.loadTierUpgrade("tier-six", UpgradeType.DIRECT_TIER_6);
        this.loadOwnerSkinUpgrade("owner-skin", UpgradeType.OWNER_SKIN);
        this.loadBuyerSkinUpgrade("buyer-skin", UpgradeType.BUYER_SKIN);
        LocalUtils.logp("Successfully loaded " + this.upgradesMap.size() + " upgrades!");
    }

    private void loadTierUpgrade(String string, UpgradeType upgradeType) {
        ConfigurationSection configurationSection = this.getFiles().getConfig().get().getConfigurationSection("Upgrades." + string);
        if (configurationSection != null) {
            int n = configurationSection.getInt("Slot", 0);
            String string2 = configurationSection.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=");
            String string3 = configurationSection.getString("Displayname", "&4&lUnknown Upgrade");
            String string4 = configurationSection.getString("Permission", "none");
            int n2 = configurationSection.getInt("Price", 0);
            int n3 = this.pluginUtils.isCustomModelSupported() ? configurationSection.getInt("Custom-model-data", 0) : 0;
            boolean bl = configurationSection.getBoolean("Strict", false);
            List list = configurationSection.getStringList("Shop-lore");
            List list2 = configurationSection.getStringList("Item");
            String string5 = configurationSection.getString("No-permission-message", "&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!");
            String string6 = configurationSection.getString("Not-enough-money-message", "&cYou cannot afford this upgrade :(");
            String string7 = configurationSection.getString("Cannot-apply-permission", "&cYou cannot apply this upgrade! You require &a[VIP]&c rank, purchase it on &bstore.yournetwork.net&c!");
            TierUpgrade tierUpgrade = new TierUpgrade(string, string2, n2, n3, string4, string3, upgradeType, list, list2, bl, string5, string6, string7);
            this.upgradesMap.put(string, tierUpgrade);
            this.upgradesSlotsMap.put(n, tierUpgrade);
            this.upgradesLevelMap.put(upgradeType.getId(), tierUpgrade);
            if (this.logMode) {
                LocalUtils.logp("Successfully loaded '" + string + "' upgrade!");
            }
        }
    }

    private void loadOwnerSkinUpgrade(String string, UpgradeType upgradeType) {
        ConfigurationSection configurationSection = this.getFiles().getConfig().get().getConfigurationSection("Upgrades." + string);
        if (configurationSection != null) {
            int n = configurationSection.getInt("Slot", 0);
            String string2 = configurationSection.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=");
            String string3 = configurationSection.getString("Displayname", "&4&lUnknown Upgrade");
            String string4 = configurationSection.getString("Permission", "none");
            String string5 = configurationSection.getString("Rename", null);
            int n2 = configurationSection.getInt("Price", 0);
            int n3 = this.pluginUtils.isCustomModelSupported() ? configurationSection.getInt("Custom-model-data", 0) : 0;
            boolean bl = configurationSection.getBoolean("Strict", false);
            List list = configurationSection.getStringList("Shop-lore");
            List list2 = configurationSection.getStringList("Item");
            String string6 = configurationSection.getString("No-permission-message", "&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!");
            String string7 = configurationSection.getString("Not-enough-money-message", "&cYou cannot afford this upgrade :(");
            String string8 = configurationSection.getString("Cannot-apply-permission", "&cYou cannot apply this upgrade! You require &a[VIP]&c rank, purchase it on &bstore.yournetwork.net&c!");
            OwnerSkinUpgrade ownerSkinUpgrade = new OwnerSkinUpgrade(string, string2, n2, n3, string4, string3, string5, upgradeType, list, list2, bl, string6, string7, string8);
            this.upgradesMap.put(string, ownerSkinUpgrade);
            this.upgradesSlotsMap.put(n, ownerSkinUpgrade);
            this.upgradesLevelMap.put(upgradeType.getId(), ownerSkinUpgrade);
            if (this.logMode) {
                LocalUtils.logp("Successfully loaded '" + string + "' upgrade!");
            }
        }
    }

    private void loadBuyerSkinUpgrade(String string, UpgradeType upgradeType) {
        ConfigurationSection configurationSection = this.getFiles().getConfig().get().getConfigurationSection("Upgrades." + string);
        if (configurationSection != null) {
            int n = configurationSection.getInt("Slot", 0);
            String string2 = configurationSection.getString("Displayname", "&4&lUnknown Upgrade");
            String string3 = configurationSection.getString("Permission", "none");
            String string4 = configurationSection.getString("Rename", null);
            int n2 = configurationSection.getInt("Price", 0);
            int n3 = this.pluginUtils.isCustomModelSupported() ? configurationSection.getInt("Custom-model-data", 0) : 0;
            boolean bl = configurationSection.getBoolean("Strict", false);
            List list = configurationSection.getStringList("Shop-lore");
            List list2 = configurationSection.getStringList("Item");
            String string5 = configurationSection.getString("No-permission-message", "&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!");
            String string6 = configurationSection.getString("Not-enough-money-message", "&cYou cannot afford this upgrade :(");
            String string7 = configurationSection.getString("Cannot-apply-permission", "&cYou cannot apply this upgrade! You require &a[VIP]&c rank, purchase it on &bstore.yournetwork.net&c!");
            BuyerSkinUpgrade buyerSkinUpgrade = new BuyerSkinUpgrade(string, n2, n3, string3, string2, string4, upgradeType, list, list2, bl, string5, string6, string7);
            this.upgradesMap.put(string, buyerSkinUpgrade);
            this.upgradesSlotsMap.put(n, buyerSkinUpgrade);
            this.upgradesLevelMap.put(upgradeType.getId(), buyerSkinUpgrade);
            if (this.logMode) {
                LocalUtils.logp("Successfully loaded '" + string + "' upgrade!");
            }
        }
    }

    private void loadSkins() {
        ConfigurationSection configurationSection = this.getFiles().getSkins().get().getConfigurationSection("Skins");
        if (configurationSection == null) {
            LocalUtils.logp("Skins section in skins.yml file is not valid. Skipping..");
            return;
        }
        int n = 0;
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            String string2 = configurationSection2.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=");
            String string3 = configurationSection2.getString("Displayname", "&4&lUnknown Skin");
            String string4 = configurationSection2.getString("Permission", "none");
            boolean bl = configurationSection2.getBoolean("Strict", false);
            int n2 = configurationSection2.getInt("Price", 0);
            int n3 = this.pluginUtils.isCustomModelSupported() ? configurationSection2.getInt("Custom-model-data", 0) : 0;
            String string5 = configurationSection2.getString("Rename", "none");
            List list = configurationSection2.getStringList("Shop-lore");
            List list2 = configurationSection2.getStringList("Item");
            String string6 = configurationSection2.getString("No-permission-message", "&cYou don't have permission to purchase this skin! Purchase a rank on &bstore.yournetwork.net&c!");
            String string7 = configurationSection2.getString("Not-enough-money-message", "&cYou cannot afford this skin :(");
            String string8 = configurationSection2.getString("Cannot-apply-permission", "&cYou cannot apply this skin! You require &a[VIP]&c rank, purchase it on &bstore.yournetwork.net&c!");
            BackpackSkin backpackSkin = new BackpackSkin(string, string2, string3, string4, bl, n2, n3, string5, list, list2, string6, string7, string8);
            this.skinsMap.put(string, backpackSkin);
            int n4 = (int)Math.ceil((double)this.skinsMap.size() / ((double)this.skinsShopArray.length * 1.0));
            if (!this.skinsPageMap.containsKey(n4)) {
                this.skinsPageMap.put(n4, new TreeMap());
            }
            TreeMap<Integer, BackpackSkin> treeMap = this.skinsPageMap.get(n4);
            int n5 = (this.skinsMap.size() - 1) % this.skinsShopArray.length;
            treeMap.put(this.skinsShopArray[n5], backpackSkin);
            ++n;
            if (!this.logMode) continue;
            LocalUtils.logp("Successfully loaded '" + string + "' skin!");
        }
        if (n == 0) {
            LocalUtils.logp("Couldn't load skins for the shop! Maybe add some..");
        } else {
            LocalUtils.logp("Successfully loaded " + n + " backpacks skins in " + this.skinsPageMap.size() + " pages for the Skin Shop!");
        }
    }

    private void loadGuiItems() {
        ItemStack itemStack;
        int n;
        ItemStack itemStack2;
        this.tierRecipeSelectorMap.clear();
        try {
            itemStack2 = new ItemStack(Material.valueOf((String)"RED_STAINED_GLASS_PANE"));
        }
        catch (Exception exception) {
            itemStack2 = new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, 14);
        }
        ItemMeta itemMeta = itemStack2.getItemMeta();
        itemMeta.setDisplayName(LocalUtils.colorize(this.getFiles().getItems().get().getString("Items.Tiers-recipes.Close.Displayname")));
        itemMeta.setLore(LocalUtils.colorize(this.getFiles().getItems().get().getStringList("Items.Tiers-recipes.Close.Lore")));
        itemMeta.addItemFlags(ItemFlag.values());
        int n2 = n = this.pluginUtils.isCustomModelSupported() ? this.getFiles().getItems().get().getInt("Items.Tiers-recipes.Close.Custom-model-data", 0) : 0;
        if (n > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        itemStack2.setItemMeta(itemMeta);
        this.tierRecipeSelectorMap.put(1, itemStack2);
        try {
            itemStack = new ItemStack(Material.valueOf((String)"BLACK_STAINED_GLASS_PANE"));
        }
        catch (Exception exception) {
            itemStack = new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, 15);
        }
        FileConfiguration fileConfiguration = this.getFiles().getItems().get();
        this.tierRecipeSelectorMap.put(2, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.1"), 1));
        this.tierRecipeSelectorMap.put(3, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.2"), 2));
        this.tierRecipeSelectorMap.put(4, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.3"), 3));
        this.tierRecipeSelectorMap.put(5, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.4"), 4));
        this.tierRecipeSelectorMap.put(6, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.5"), 5));
        this.tierRecipeSelectorMap.put(7, this.simpleItem(itemStack, fileConfiguration.getConfigurationSection("Items.Tiers-recipes.6"), 6));
    }

    private ItemStack simpleItem(ItemStack itemStack, ConfigurationSection configurationSection, int n) {
        int n2;
        ItemStack itemStack2 = itemStack.clone();
        itemStack2.setAmount(n);
        ItemMeta itemMeta = itemStack2.getItemMeta();
        itemMeta.setDisplayName(LocalUtils.colorize(configurationSection.getString("Displayname")));
        itemMeta.setLore(LocalUtils.colorize(configurationSection.getStringList("Lore")));
        int n3 = n2 = this.pluginUtils.isCustomModelSupported() ? configurationSection.getInt("Custom-model-data", 0) : 0;
        if (n2 > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n2));
        }
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack2.setItemMeta(itemMeta);
        return itemStack2;
    }

    public ItemStack buildHead(String string, List<String> list, String string2) {
        ItemStack itemStack = this.backpackItem.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(string);
        itemMeta.setLore(list);
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
        LocalUtils.setUUID(nBTCompound, "Id", UUID.randomUUID());
        NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
        nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
        nBTListCompound.setString("Value", string2);
        return nBTItem.getItem();
    }

    private void updateConfiguration() {
        this.updateConfigConfiguration();
        this.updateItemsConfiguration();
        this.updateSkinsConfiguration();
        this.updateBackpacksConfiguration();
    }

    private void updateItemsConfiguration() {
        if (this.getFiles().getConfig().get().getBoolean("Updates.Auto-update-configuration", true)) {
            ArrayList<String> arrayList;
            boolean bl = false;
            List list = this.getFiles().getItems().get().getStringList("Items.Tank.Empty.Lore");
            if (list.equals(arrayList = new ArrayList<String>(Arrays.asList("&7Store up to 6 buckets of", "&7water, lava, milk or honey.")))) {
                this.getFiles().getItems().get().set("Items.Tank.Empty.Lore", Arrays.asList("&7Store up to 6 buckets of", "&7water, lava, milk, honey", "&7or powder snow."));
                bl = true;
            }
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tank.Empty.Lore", Arrays.asList("&7Store up to 6 buckets of", "&7water, lava, milk, honey", "&7or powder snow.")) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tank.Filled.Powder-snow", (Object)"&f&lPowder Snow tank") || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.Close.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.1.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.2.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.3.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.4.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.5.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-recipes.6.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.1.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.2.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.3.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.4.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.5.Custom-model-data", (Object)0) || bl;
            boolean bl2 = bl = this.addConfig(this.getFiles().getItems().get(), "Items.Tiers-build.6.Custom-model-data", (Object)0) || bl;
            if (bl) {
                this.getFiles().getItems().get().options().header(" This file was generated by BetterBackpacks Pro.\n Do not add new items here or you'll get errors.");
                this.getFiles().getItems().save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77items.yml is up-to-date!");
        } else {
            LocalUtils.logp("&cConfiguration auto-update is not enabled! &7Ignoring items.yml changes..");
            LocalUtils.logp("&cYou might get a lot of errors as you don't allow plugin to generate the new config");
            LocalUtils.logp("&cadded in new updates! Make sure you enable it and restart if you have errors.");
        }
    }

    private void updateSkinsConfiguration() {
        if (this.getFiles().getConfig().get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean bl = false;
            ConfigurationSection configurationSection = this.getFiles().getSkins().get().getConfigurationSection("Skins");
            if (configurationSection != null) {
                for (String string : configurationSection.getKeys(false)) {
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                    if (configurationSection2 == null) continue;
                    bl = this.addConfig(configurationSection2, "Custom-model-data", (Object)0) || bl;
                }
            }
            if (bl) {
                this.getFiles().getSkins().get().options().header(" This file has been updated by BetterBackpacks Pro plugin automatically.\n You can't select skins slots directly. Slots are selected in config file, skins will be sorted there automatically.\n Create as many skins as you WANT! These are automatically placed in the inventory.");
                this.getFiles().getSkins().save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77skins.yml is up-to-date!");
        } else {
            LocalUtils.logp("&cConfiguration auto-update is not enabled! &7Ignoring skins.yml changes..");
            LocalUtils.logp("&cYou might get a lot of errors as you don't allow plugin to generate the new config");
            LocalUtils.logp("&cadded in new updates! Make sure you enable it and restart if you have errors.");
        }
    }

    private void updateBackpacksConfiguration() {
        if (this.getFiles().getConfig().get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean bl = false;
            ConfigurationSection configurationSection = this.getFiles().getBackpacks().get().getConfigurationSection("Backpacks");
            if (configurationSection != null) {
                for (String string : configurationSection.getKeys(false)) {
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                    if (configurationSection2 == null) continue;
                    bl = this.addConfig(configurationSection2, "Custom-model-data", (Object)0) || bl;
                }
            }
            if (bl) {
                this.getFiles().getBackpacks().get().options().header(" This file has been updated by BetterBackpacks plugin automatically.\n You cannot add more backpacks here. PLEASE DON'T TRY!");
                this.getFiles().getBackpacks().save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77skins.yml is up-to-date!");
        } else {
            LocalUtils.logp("&cConfiguration auto-update is not enabled! &7Ignoring skins.yml changes..");
            LocalUtils.logp("&cYou might get a lot of errors as you don't allow plugin to generate the new config");
            LocalUtils.logp("&cadded in new updates! Make sure you enable it and restart if you have errors.");
        }
    }

    private void updateConfigConfiguration() {
        if (this.getFiles().getConfig().get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean bl = false;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Updates.Auto-update-configuration", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Aliases", Arrays.asList("betterbackpack", "bbackpack", "bbackpacks", "bbp")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Help.Admin", Arrays.asList("&2 /betterbackpacks skins <player> &f- &aOpen skins shop for player", "&2 /betterbackpacks upgrades <player> &f- &aOpen upgrades shop for player", "&2 /betterbackpacks recipe <player> &f- &aOpen recipe for player", "&2 /betterbackpacks unique <player> &f- &aOpen unique backpacks for player", "&2 /betterbackpacks give <player> <tier> &f- &aGive backpack to player", "&2 /betterbackpacks giveskin <player> <skin> &f- &aGive a skin to player", "&2 /betterbackpacks giveupgrade <player> <upgrade> &f- &aGive a skin to player", "&2 /betterbackpacks build <player> <tier> <texture> &f- &aBuild backpack for player with texture", "&2 /betterbackpacks reload &f- &aReload configuration")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Help.User", Arrays.asList("&2 /betterbackpacks skins &f- &aOpen skins shop", "&2 /betterbackpacks upgrades &f- &aOpen upgrades shop", "&2 /betterbackpacks recipe &f- &aOpen recipe", "&2 /betterbackpacks unique &f- &aOpen unique backpacks")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Cannot-number-key", (Object)"&cYou cannot use number keys in backpacks!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Cannot-craft-stacked", (Object)"&cYou cannot craft stacked backpacks. Craft one by one..") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Debug-mode", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Corrupted-backpack", (Object)"&cThis backpack seems to be corrupted or was obtained illegally. Please destroy it :)") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Cooldown-message", (Object)"&cYou are using backpacks too fast. Wait some seconds!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.WorldGuard.Warning", Arrays.asList("Default flag:", " This is the default behavior if the flag is not specified BUT you are inside in a WorldGuard region.", "  true - Players can open backpacks.", "  false - Players cannot open backpacks.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.WorldGuard.Default-flag", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.WorldGuard.Disabled-region", (Object)"&cYou cannot use backpacks in this region!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Disabled-click", Arrays.asList("SHULKER_BOX", "BLACK_SHULKER_BOX", "WHITE_SHULKER_BOX", "ORANGE_SHULKER_BOX", "MAGENTA_SHULKER_BOX", "LIGHT_BLUE_SHULKER_BOX", "YELLOW_SHULKER_BOX", "LIME_SHULKER_BOX", "PINK_SHULKER_BOX", "GRAY_SHULKER_BOX", "SILVER_SHULKER_BOX", "CYAN_SHULKER_BOX", "PURPLE_SHULKER_BOX", "BLUE_SHULKER_BOX", "BROWN_SHULKER_BOX", "GREEN_SHULKER_BOX", "RED_SHULKER_BOX")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Cannot-right-click", (Object)"&cYou cannot right click this item in backpack!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Economy-not-supported", (Object)"&cEconomy system is not available in this server :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Transaction-error", (Object)"&cCouldn't perform transaction. Try again later, if error persists contact an administrator!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skin-purchased", (Object)"&aYou successfully purchased &r{SKIN}&a for ${PRICE}!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Corrupted-skin", (Object)"&cThis skin seems to be corrupted or was obtained illegally. Please destroy it :)") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skin-applied", (Object)"&aSuccessfully applied &r{SKIN}&r&a to your backpack :)") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Sorting-disabled", (Object)"&cYou cannot sort items when using backpacks!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Corrupted", (Object)"&cThis upgrade seems to be corrupted or was obtained illegally. Please destroy it :)") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Cannot-security", (Object)"&cThis backpack seems a bit weird.. To prevent the loss of your items you cannot upgrade this backpack, try opening your backpack once or getting a new one!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Already-last-tier", (Object)"&cYour backpack is already last tier!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Backpack-tier-is-greater", (Object)"&cYour backpack tier is better than this upgrade! Why doing that?") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Unknown-upgrade", (Object)"&cUnknown upgrade! Are you coming from the future..?") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Direct-upgrade-success", (Object)"&aYou upgraded your backpack from {OLD_SIZE} to {NEW_SIZE} slots!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.One-upgrade-success", (Object)"&aYou upgraded your backpack from {OLD_SIZE} to {NEW_SIZE} slots!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Main-command", (Object)"betterbackpacks") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Support-developer", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Log-mode", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Upgrades.Enabled", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Upgrades.Shop.Enabled", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Upgrades.Shop.Frame", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Upgrades.Shop.Rows", (Object)4) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Upgrades.Shop.Title", (Object)"&8Upgrades Shop") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Purchased", (Object)"&aYou purchased &r{UPGRADE}&a for {PRICE}.") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Enabled", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Shop.Enabled", (Object)true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Shop.Rows", (Object)6) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Shop.Slots", (Object)"10,11,12,13,14,15,16,19,20,21,22,23,24,25,28,29,30,31,32,33,34,37,38,39,40,41,42,43") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Shop.Title", (Object)"&8Skins Shop ({PAGE}/{MAX})") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Skins.Shop.Frames.Slots", (Object)"0,1,2,3,4,5,6,7,8,9,17,18,26,27,35,36,44,45,46,47,48,49,50,51,52,53") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Slot", (Object)48) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Material", (Object)"ARROW") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Displayname", (Object)"&9Previous page") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Previous.Lore", Arrays.asList("&7Go to previous page.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Slot", (Object)50) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Material", (Object)"ARROW") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTNmYzUyMjY0ZDhhZDllNjU0ZjQxNWJlZjAxYTIzOTQ3ZWRiY2NjY2Y2NDkzNzMyODliZWE0ZDE0OTU0MWY3MCJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Displayname", (Object)"&9Next page") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Next.Lore", Arrays.asList("&7Go to next page.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Slot", (Object)49) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Material", (Object)"BOOK") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Displayname", (Object)"&cClose") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Lore", Arrays.asList("&7Close Skins shop.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-skins.Command", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Slot", (Object)31) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Material", (Object)"BOOK") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Displayname", (Object)"&cClose") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Lore", Arrays.asList("&7Close Upgrades shop.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close-upgrades.Command", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Skins-shop-frame.Dyeable-type", (Object)"GLASS_PANE") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Skins-shop-frame.Color", (Object)"BLACK") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Skins-shop-frame.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Skins-shop-frame.Displayname", (Object)"&r") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Skins-shop-frame.Lore", new ArrayList()) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Upgrades-shop-frame.Dyeable-type", (Object)"GLASS_PANE") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Upgrades-shop-frame.Color", (Object)"BLACK") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Upgrades-shop-frame.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Upgrades-shop-frame.Displayname", (Object)"&r") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Upgrades-shop-frame.Lore", new ArrayList()) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Permissions.Skins-shop", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Permissions.Skins-apply", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Permissions.Upgrades-shop", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Permissions.Upgrades-apply", (Object)"none") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins-shop-disabled", (Object)"&cSkins shop is not enabled in this server :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Shop-disabled", (Object)"&cUpgrades shop is not enabled in this server :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins-shop-opened-other", (Object)"&aYou opened skins shop for {TARGET}.") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Shop-opened-other", (Object)"&aYou opened upgrades shop for {TARGET}.") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Cannot-apply-skin-permission", (Object)"&cYou cannot apply this skin! You require permission '&b{PERMISSION}&c'!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins.Shop-no-permission", (Object)"&cYou don't have permission to open skins shop :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins.No-permission", (Object)"&cYou cannot apply skins! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Shop-no-permission", (Object)"&cYou don't have permission to open upgrades shop :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.No-permission", (Object)"&cYou cannot use upgrades! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Successfully-owner-skin", (Object)"&aSuccessfully applied &r{UPGRADE}&r&a to your backpack!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Successfully-buyer-skin", (Object)"&aSuccessfully applied &r{UPGRADE}&r&a to your backpack!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.Invalid-identifier", (Object)"&cProvided upgrade identifier doesn't exist.") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.You-received", (Object)"&aYou received a &r{UPGRADE}&r&a!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Upgrades.You-gave", (Object)"&6You gave {TARGET} a &r{UPGRADE}&r&6!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins.Invalid-identifier", (Object)"&cProvided skin identifier doesn't exist.") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins.You-received", (Object)"&aYou received a &r{SKIN}&r&a!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Skins.You-gave", (Object)"&6You gave {TARGET} a &r{SKIN}&r&6!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Slot", (Object)12) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTA1YTJjYWI4YjY4ZWE1N2UzYWY5OTJhMzZlNDdjOGZmOWFhODdjYzg3NzYyODE5NjZmOGMzY2YzMWEzOCJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Displayname", (Object)"&f&lOne Tier Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Price", (Object)10000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Permission", (Object)"betterbackpacks.upgrades.one-tier") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Shop-lore", Arrays.asList("&7Upgrade you backpack to the next Tier!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Item", Arrays.asList("&7Upgrade you backpack to the next Tier!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.one-tier.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Slot", (Object)14) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjEzYjc3OGM2ZTUxMjgwMjQyMTRmODU5YjRmYWRjNzczOGM3YmUzNjdlZTRiOWI4ZGJhZDc5NTRjZmYzYSJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Displayname", (Object)"&c&lTier 2 Backpack Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Price", (Object)15000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Permission", (Object)"betterbackpacks.upgrades.tier-two") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Shop-lore", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 2 and get a total of", "&216 slots&7 for your items!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Item", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 2 and get a total of", "&216 slots&7 for your items!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-two.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Slot", (Object)15) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTA0Y2NmOGI1MzMyYzE5NmM5ZWEwMmIyMmIzOWI5OWZhY2QxY2M4MmJmZTNmN2Q3YWVlZGMzYzMzMjkwMzkifX19") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Displayname", (Object)"&7&lTier 3 Backpack Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Price", (Object)25000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Permission", (Object)"betterbackpacks.upgrades.tier-three") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Shop-lore", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 3 and get a total of", "&725 slots for your items!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Item", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 3 and get a total of", "&725 slots for your items!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-three.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Slot", (Object)16) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWYyZDI2MDFmOWMxYWNlZmZjYzgyMzY1N2UyMjU5ZDM1OGJiNTJiZDQ2MzEyYmYxYzc2ZWUyM2QzYjE3In19fQ==") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Displayname", (Object)"&6&lTier 4 Backpack Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Price", (Object)35000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Permission", (Object)"betterbackpacks.upgrades.tier-four") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Shop-lore", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 4 and get a total of", "&634 slots&7 for your items!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Item", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 4 and get a total of", "&634 slots&7 for your items!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-four.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Slot", (Object)24) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTJjMTQyYWY1OWYyOWViMzVhYjI5YzZhNDVlMzM2MzVkY2ZjMmE5NTZkYmQ0ZDJlNTU3MmIwZDM4ODkxYjM1NCJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Displayname", (Object)"&a&lTier 5 Backpack Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Price", (Object)45000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Permission", (Object)"betterbackpacks.upgrades.tier-five") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Shop-lore", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 5 and get a total of", "&a43 slots&7 for your items!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Item", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 5 and get a total of", "&a43 slots&7 for your items!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-five.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Slot", (Object)25) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzk4NGI5MjVjM2NjMzhjZmFjYWZiYTc1M2ViZDFhMzllYTYzZjkyNzMxMGFlZTM4MGUyNzBmZTJjMjgxOCJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Displayname", (Object)"&b&lTier 6 Backpack Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Price", (Object)55000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Permission", (Object)"betterbackpacks.upgrades.tier-six") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Shop-lore", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 6 and get a total of", "&b52 slots&7 for your items!", "&7Price: &a{PRICE}", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Item", Arrays.asList("&7Upgrade your backpack directly", "&7to Tier 6 and get a total of", "&b52 slots&7 for your items!", "", "&eApply this upgrade to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.tier-six.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Slot", (Object)10) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Texture", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWQ1OTdhYTQ0ODY1MWFhZTYwMjAxYWUxM2Y3ZTAzMGQxM2RhMzk3ZmJiZTc1YzM1ZDY3MTQ2MTJiMGM3NmE1YiJ9fX0=") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Displayname", (Object)"&b&lOwner Skin Upgrade") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Price", (Object)100000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Permission", (Object)"betterbackpacks.upgrades.owner-skin") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Rename", (Object)"&6&l{PLAYER} backpack") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Shop-lore", Arrays.asList("&7Upgrade your backpack style", "&7with your own skin!", "&7Skin applied will be from the", "&7player using the upgrade.", "&7Price: &a{PRICE}", "", "&7Your backpack will be renamed", "&7to: &r&6&lYourName backpack&r", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Item", Arrays.asList("&7Love your own skin? This backpack", "&7is for you! Apply your own skin", "&7to your favorite backpack!", "", "&7Your backpack will be renamed", "&7to: &r&6&lYourName backpack&r", "", "&eApply this skin to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.owner-skin.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Slot", (Object)19) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Displayname", (Object)"&6&l{PLAYER} Skin") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Price", (Object)50000) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Permission", (Object)"betterbackpacks.upgrades.buyer-skin") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Rename", (Object)"&6&l{PLAYER} backpack") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Strict", (Object)false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Shop-lore", Arrays.asList("&7Hey {PLAYER}, upgrade your", "&7backpack with your own skin!", "&7Price: &a{PRICE}", "", "&7Your backpack will be renamed", "&7to: &r{RENAME}&r", "", "&eClick to purchase.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Item", Arrays.asList("&7Backpack skin created using", "&7{PLAYER} as model!", "", "&7Your backpack will be renamed", "&7to: &r{RENAME}&r", "", "&eApply this skin to your backpack.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.No-permission-message", (Object)"&cYou don't have permission to purchase this upgrade! Purchase a rank on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Not-enough-money-message", (Object)"&cYou cannot afford this upgrade :(") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Upgrades.buyer-skin.Cannot-apply-permission", (Object)"&cYou cannot apply this upgrade! You require &b[MVP]&c rank, purchase it on &bstore.yournetwork.net&c!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Money-format", (Object)"${PRICE}") || bl;
            boolean bl2 = bl = this.addConfig(this.getFiles().getConfig().get(), "Messages.Build.Invalid-model-data", (Object)"&cCustom model data must be a number greater equal than 0.") || bl;
            if (bl) {
                this.getFiles().getConfig().get().options().header("     ___      _   _           ___          _                 _       ___                 Our plugins: https://alonsoaliaga.com/plugins\n    | _ ) ___| |_| |_ ___ _ _| _ ) __ _ __| |___ __  __ _ __| |__ __| _ \\_ _ ___         Support server: https://alonsoaliaga.com/discord\n    | _ \\/ -_)  _|  _/ -_) '_| _ \\/ _` / _| / / '_ \\/ _` / _| / /(_-<  _/ '_/ _ \\        Youtube: https://alonsoaliaga.com/play\n    |___/\\___|\\__|\\__\\___|_| |___/\\__,_\\__|_\\_\\ .__/\\__,_\\__|_\\_\\/__/_| |_| \\___/        Test server: plugins.alonsoaliaga.com\n                              by AlonsoAliaga |_|                                        Twitch: https://alonsoaliaga.com/twitch\n              Considering donating? https://alonsoaliaga.com/donate                      Thanks for purchasing my plugin! Only buyers receive support.\n\n                         >> If your spigot profile link is not https://www.spigotmc.org/members/997807/\n               consider purchasing our plugin from https://alonsoaliaga.com/BetterBackpacksPro to support our hard work. <<");
                this.getFiles().getConfig().save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Configuration is up-to-date!");
        } else {
            LocalUtils.logp("&cConfiguration auto-update is not enabled! &7Ignoring config.yml changes..");
            LocalUtils.logp("&cYou might get a lot of errors as you don't allow plugin to generate the new config");
            LocalUtils.logp("&cadded in new updates! Make sure you enable it and restart if you have errors.");
        }
    }

    private boolean addConfig(FileConfiguration fileConfiguration, String string, Object object) {
        if (!fileConfiguration.contains(string)) {
            fileConfiguration.set(string, object);
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] Adding default configuration in path: " + AlonsoUtils.first + string);
            return true;
        }
        return false;
    }

    private boolean addConfig(ConfigurationSection configurationSection, String string, Object object) {
        if (!configurationSection.contains(string)) {
            configurationSection.set(string, object);
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] Adding default configuration in path: " + AlonsoUtils.first + string);
            return true;
        }
        return false;
    }

    @Override
    public AlonsoUtils.PluginUtils getPluginUtils() {
        return this.pluginUtils;
    }

    @Override
    public FileManager getFiles() {
        return this.fileManager;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this;
    }

    public boolean hasTierAllowed(Player player, int n) {
        if (this.permissions.tierPermission == null) {
            return true;
        }
        for (Map.Entry<Integer, String> entry : this.backpackPermissionMap.entrySet()) {
            if (entry.getKey() < n || !player.hasPermission(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public Inventory getMinAllowedRecipe(Player player) {
        if (this.permissions.tierPermission == null) {
            return (Inventory)Collections.min(this.backpacksRecipesMap.entrySet(), Map.Entry.comparingByKey()).getValue();
        }
        for (Map.Entry<Integer, Inventory> entry : this.backpacksRecipesMap.entrySet()) {
            if (!this.hasTierAllowed(player, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean openUniqueBackpacksGUI(Player player) {
        if (player == null || !player.isOnline() || !this.uniqueBackpacks) {
            return false;
        }
        player.openInventory(this.uniqueInventory);
        return true;
    }

    public void openUniqueTierGUI(Player player, UniqueBackpack uniqueBackpack) {
        if (!this.uniqueBackpacks) {
            return;
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(uniqueBackpack.getNbtItem()), (int)27, (String)this.messages.uniqueBackpackTierTitle);
        for (Map.Entry<Integer, ItemStack> entry : this.tierUniqueSelectorMap.entrySet()) {
            inventory.setItem(entry.getKey().intValue(), entry.getValue());
        }
        inventory.setItem(10, uniqueBackpack.getNbtItem().getItem());
        player.openInventory(inventory);
    }

    public NBTItem createBackpack(int n) {
        NBTItem nBTItem = this.backpacksMap.get(n);
        NBTCompound nBTCompound = nBTItem.hasKey("betterbackpacks-backpack") != false ? nBTItem.getCompound("betterbackpacks-backpack") : nBTItem.addCompound("betterbackpacks-backpack");
        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
        return nBTItem;
    }

    public NBTItem createBackpack(int n, String string) {
        return this.createBackpack(n, string, 0);
    }

    public NBTItem createBackpack(int n, String string, int n2) {
        TierBackpack tierBackpack = this.tierBackpacksMap.get(n);
        ItemStack itemStack = ItemUtils.buildHead(string, UUID.randomUUID());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(tierBackpack.getLore());
        itemMeta.addItemFlags(ItemFlag.values());
        if (this.pluginUtils.isCustomModelSupported() && n2 > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n2));
        }
        itemStack.setItemMeta(itemMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-backpack");
        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
        return nBTItem;
    }

    public NBTItem createBackpack(int n, String string, String string2) {
        return this.createBackpack(n, string, string2, 0);
    }

    public NBTItem createBackpack(int n, String string, String string2, int n2) {
        TierBackpack tierBackpack = this.tierBackpacksMap.get(n);
        ItemStack itemStack = ItemUtils.buildHead(string2, null, string, UUID.randomUUID());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(tierBackpack.getLore());
        itemMeta.addItemFlags(ItemFlag.values());
        if (this.pluginUtils.isCustomModelSupported() && n2 > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n2));
        }
        itemStack.setItemMeta(itemMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-backpack");
        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
        return nBTItem;
    }

    public boolean isBackpackItem(@Nonnull ItemStack itemStack) {
        int n;
        NBTItem nBTItem = new NBTItem(itemStack);
        if (nBTItem.hasKey("betterbackpacks-backpack-tier").booleanValue() && (n = nBTItem.getInteger("betterbackpacks-backpack-tier").intValue()) >= 1 && n <= 6) {
            return nBTItem.hasKey("betterbackpacks-backpack-uuid");
        }
        return false;
    }

    public Inventory openSkinsShop(Player player) {
        return this.openSkinsShop(player, 1, true);
    }

    public Inventory openSkinsShop(Player player, boolean bl) {
        return this.openSkinsShop(player, 1, bl);
    }

    public Inventory openSkinsShop(Player player, int n) {
        return this.openSkinsShop(player, n, true);
    }

    @Nullable
    public Inventory openUpgradesShop(Player player) {
        if (!this.upgradesShopEnabled) {
            return null;
        }
        this.upgradesInventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(true), (int)(this.upgradesShopRows * 9), (String)LocalUtils.fixInventoryTitle(this.messages.upgradesShopTitle));
        for (Map.Entry<Integer, UpgradeData> itemStack : this.upgradesSlotsMap.entrySet()) {
            int n = itemStack.getKey();
            if (n < 0 || n >= this.upgradesShopRows * 9) continue;
            this.upgradesInventory.setItem(n, itemStack.getValue().getShopItem(player));
        }
        if (this.closeUpgradesSlot != -1) {
            this.upgradesInventory.setItem(this.closeUpgradesSlot, this.closeUpgradesItem);
        }
        if (this.upgradesFrameEnabled) {
            for (int i = 0; i < this.upgradesInventory.getSize(); ++i) {
                ItemStack itemStack = this.upgradesInventory.getItem(i);
                if (itemStack != null && itemStack.getType() != Material.AIR) continue;
                this.upgradesInventory.setItem(i, this.upgradesFramePane);
            }
        }
        player.openInventory(this.upgradesInventory);
        return this.upgradesInventory;
    }

    @Nullable
    public Inventory openSkinsShop(Player player, int n, boolean bl) {
        if (!this.skinsShopEnabled) {
            return null;
        }
        n = Math.max(1, Math.min(this.skinsPageMap.size(), n));
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(n), (int)(this.skinsShopRows * 9), (String)LocalUtils.fixInventoryTitle(this.messages.shopTitle.replace("{PAGE}", String.valueOf(n)).replace("{MAX}", String.valueOf(this.skinsPageMap.size()))));
        TreeMap<Integer, BackpackSkin> treeMap = this.skinsPageMap.get(n);
        for (Map.Entry<Integer, BackpackSkin> entry : treeMap.entrySet()) {
            inventory.setItem(entry.getKey().intValue(), entry.getValue().getShopItem());
        }
        if (n != 1) {
            inventory.setItem(this.previousSlot, this.previousItem);
        }
        if (n != this.skinsPageMap.size() && this.skinsPageMap.size() != 0) {
            inventory.setItem(this.nextSlot, this.nextItem);
        }
        if (this.closeSkinsSlot != -1) {
            inventory.setItem(this.closeSkinsSlot, this.closeSkinsItem);
        }
        Iterator<Object> iterator = this.framesShopArray.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            ItemStack itemStack = inventory.getItem(n2);
            if (itemStack != null && itemStack.getType() != Material.AIR) continue;
            inventory.setItem(n2, this.skinsFramePane);
        }
        if (bl) {
            player.openInventory(inventory);
        }
        return inventory;
    }

    public ItemStack createSkinItem(@Nonnull String string, @Nullable List<String> list, @Nonnull String string2, @Nullable String string3) {
        return this.createSkinItem(string, list, string2, string3, false, null, "&cYou cannot apply this skin! You require a rank, purchase it on &bstore.yournetwork.net&c!");
    }

    public ItemStack createSkinItem(@Nonnull String string, @Nullable List<String> list, @Nonnull String string2, @Nullable String string3, int n) {
        return this.createSkinItem(string, list, string2, string3, false, null, "&cYou cannot apply this skin! You require a rank, purchase it on &bstore.yournetwork.net&c!", n);
    }

    public ItemStack createSkinItem(@Nonnull String string, @Nullable List<String> list, @Nonnull String string2, @Nullable String string3, boolean bl, @Nullable String string4, @Nullable String string5) {
        return this.createSkinItem(string, list, string2, string3, bl, string4, string5, 0);
    }

    public ItemStack createSkinItem(@Nonnull String string, @Nullable List<String> list, @Nonnull String string2, @Nullable String string3, boolean bl, @Nullable String string4, @Nullable String string5, int n) {
        NBTItem nBTItem;
        ItemStack itemStack = ItemUtils.buildHead(string, list, string2, AlonsoUtils.UNKNOWN_UUID);
        if (n > 0 && this.pluginUtils.isCustomModelSupported()) {
            nBTItem = itemStack.getItemMeta();
            nBTItem.setCustomModelData(Integer.valueOf(0));
            itemStack.setItemMeta((ItemMeta)nBTItem);
        }
        nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-skin");
        nBTCompound.setString("betterbackpacks-skin-displayname", string);
        nBTCompound.setString("betterbackpacks-skin-texture", string2);
        nBTCompound.setString("betterbackpacks-skin-uuid", AlonsoUtils.DEVELOPER_UUID.toString());
        if (bl && string4 != null && string5 != null) {
            nBTCompound.setString("betterbackpacks-skin-strict-permission", string4);
            nBTCompound.setString("betterbackpacks-skin-strict-permission-message", string5);
        }
        if (string3 != null) {
            nBTCompound.setString("betterbackpacks-skin-rename", string3);
        }
        return nBTItem.getItem();
    }

    public boolean isSkinItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        if (nBTItem.hasKey("betterbackpacks-skin").booleanValue()) {
            NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-skin");
            return nBTCompound.hasKey("betterbackpacks-skin-uuid") != false && nBTCompound.hasKey("betterbackpacks-skin-texture") != false && nBTCompound.hasKey("betterbackpacks-skin-displayname") != false;
        }
        return false;
    }

    public boolean isPluginItem(ItemStack itemStack) {
        return this.getPluginItemType(itemStack) != null;
    }

    public ItemType getPluginItemType(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() != Materials.PLAYER_HEAD.getMaterial()) {
            return null;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        if (nBTItem.hasKey("betterbackpacks-skin").booleanValue()) {
            return ItemType.SKIN;
        }
        if (nBTItem.hasKey("betterbackpacks-upgrade").booleanValue()) {
            return ItemType.UPGRADE;
        }
        if (nBTItem.hasKey("betterbackpacks-backpack").booleanValue()) {
            return ItemType.BACKPACK;
        }
        return null;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=95254&nonce=-1324352491").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

