/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.commands;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.commands.AbstractCommand;
import com.alonsoaliaga.betterbackpacks.others.BackpackSkin;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.others.UpgradeData;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MainCommand
extends AbstractCommand {
    private BetterBackpacks plugin;
    private List<String> emptyList = new ArrayList<String>();
    private List<String> adminList = Arrays.asList("giveskin", "giveupgrade", "upgrades", "skins", "recipe", "unique", "give", "build", "reload", "nbt");
    private List<String> userList = Arrays.asList("upgrades", "skins", "recipe", "unique");
    private boolean testServer = false;
    private String testError = "&cHey {PLAYER}! For security reasons, you can only use commands to modify your player in this test server!";
    private String testBuildError = "&cHey {PLAYER}! This command requires you to use a really long string (custom texture) to build a backpack. Due to minecraft limits commands performed by players cannot be that long, this command can only be used in console!";
    private String testReloadError = "&cHey {PLAYER}! For security reasons, this command is disabled in this test server!";
    private String testPaste = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private boolean supportDeveloper;

    public MainCommand(BetterBackpacks betterBackpacks, String string, List<String> list) {
        super(string, "/" + string, "BetterBackpacks main command.", list);
        this.plugin = betterBackpacks;
        this.register();
        this.reloadMessages();
    }

    private void reloadMessages() {
        this.supportDeveloper = this.plugin.getFiles().getConfig().get().getBoolean("Options.Support-developer", true);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length >= 1) {
            if (stringArray[0].equalsIgnoreCase("paste") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testPaste.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    String string;
                    String string2 = string = "Plugin: " + this.plugin.getDescription().getName() + "\nVersion: " + this.plugin.getDescription().getVersion() + "\nJava: " + System.getProperty("java.version") + "\nOS: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")\nServer: " + this.plugin.getServer().getName() + " (" + this.plugin.getServer().getVersion() + ")\nUser: www.spigotmc.org/members/997807/\nDebug: " + this.plugin.debugMode + " (" + AlonsoUtils.serverVersion.name() + ")\nLog mode: " + this.plugin.logMode + "\nBackpackception: " + this.plugin.backpackception + "\nChestSort: " + this.plugin.chestSortSupport + "\nWorldGuard: " + this.plugin.worldGuardSupport + "\nDate: " + new Date().toString() + "\nUnique: " + this.plugin.uniqueBackpacks + "(" + this.plugin.uniqueBackpacksMap.size() + ")\nSkins: " + this.plugin.skinsShopEnabled + "(" + this.plugin.skinsMap.size() + ") - Shop: " + this.plugin.skinsShopEnabled + "\nUpgrades: " + this.plugin.upgradesEnabled + "(" + this.plugin.upgradesMap.size() + ") - Shop: " + this.plugin.upgradesShopEnabled + "\nVault: " + this.plugin.economySupport + "\nDisabled-right-click: " + (this.plugin.disabledLeftClickMaterials.isEmpty() ? "Empty" : this.plugin.disabledLeftClickMaterials.size() + " materials") + "\n" + (!this.plugin.disabledLeftClickMaterials.isEmpty() ? "" : "Disabled-right-click materials: " + this.plugin.disabledLeftClickMaterials.stream().map(Enum::name).collect(Collectors.joining(", ")) + "\n") + "Debug: " + this.plugin.debugMode;
                    int n = ThreadLocalRandom.current().nextInt(1, 11);
                    for (int i = 0; i < n; ++i) {
                        string2 = Base64.getEncoder().encodeToString(string2.getBytes());
                    }
                    String string3 = String.valueOf(n).length() + "" + n + string2 + n + "A";
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                        LocalUtils.send(commandSender, "&aRequired data has been sent to console! Share it with the developer.");
                    }
                    LocalUtils.log("&c***************************************************************************");
                    LocalUtils.log("&eRequested data by " + commandSender.getName() + ", share this with the developer:");
                    Bukkit.getServer().getConsoleSender().sendMessage("\u00a7e" + string3);
                    LocalUtils.log("&c***************************************************************************");
                });
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("nbt") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (!(commandSender instanceof Player)) {
                    LocalUtils.send(commandSender, "&cConsole cannot use this command.");
                    return true;
                }
                if (this.testServer && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testReloadError.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                Player player = (Player)commandSender;
                ItemStack itemStack2 = this.plugin.getPluginUtils().isV1_8() ? player.getInventory().getItemInHand() : player.getInventory().getItemInMainHand();
                if (itemStack2 == null || itemStack2.getType() == Material.AIR) {
                    LocalUtils.send(commandSender, "&cYou must have an item in main hand.");
                    return true;
                }
                LocalUtils.send(commandSender, "&aThis is a command added to help developer fix issues reported by players.");
                LocalUtils.send(commandSender, "&6NBT data was sent to console. Make sure you send the whole message to the developer if he request it.");
                LocalUtils.log("&c=========== Debug NBT data from " + player.getName() + "'s item ===========");
                LocalUtils.log("&e" + new NBTItem(itemStack2).toString());
                LocalUtils.log("&c========================== Debug from BetterBackpacks ==========================");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("giveskin") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 3) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player2 = (Player)commandSender;
                            player2.playSound(player2.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    String string2 = stringArray[2];
                    if (!this.plugin.skinsMap.containsKey(string2)) {
                        commandSender.sendMessage(this.plugin.messages.invalidSkinIdentifier);
                        return true;
                    }
                    BackpackSkin backpackSkin = this.plugin.skinsMap.get(string2);
                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{backpackSkin.getSkinItem()});
                    if (!hashMap.isEmpty()) {
                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                    }
                    player.sendMessage(this.plugin.messages.youReceivedSkin.replace("{SKIN}", backpackSkin.getDisplayName()));
                    commandSender.sendMessage(this.plugin.messages.youGaveSkin.replace("{SKIN}", backpackSkin.getDisplayName()).replace("{TARGET}", player.getName()));
                    return true;
                }
                LocalUtils.send(commandSender, "&cError. Usage: /betterbackpacks giveskin [player] [skin-identifier]");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("giveupgrade") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 3) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player3 = (Player)commandSender;
                            player3.playSound(player3.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    String string3 = stringArray[2];
                    if (!this.plugin.upgradesMap.containsKey(string3)) {
                        commandSender.sendMessage(this.plugin.messages.invalidUpgradeIdentifier);
                        return true;
                    }
                    UpgradeData upgradeData = this.plugin.upgradesMap.get(string3);
                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{upgradeData.getUpgradeItem(player)});
                    if (!hashMap.isEmpty()) {
                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                    }
                    player.sendMessage(this.plugin.messages.youReceivedUpgrade.replace("{UPGRADE}", upgradeData.getDisplayName(player)));
                    commandSender.sendMessage(this.plugin.messages.youGaveUpgrade.replace("{UPGRADE}", upgradeData.getDisplayName(player)).replace("{TARGET}", player.getName()));
                    return true;
                }
                LocalUtils.send(commandSender, "&cError. Usage: /betterbackpacks giveupgrade [player] [upgrade-identifier]");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("give") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 3) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (!LocalUtils.isInteger(stringArray[2])) {
                        commandSender.sendMessage(this.plugin.messages.invalidTier);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player4 = (Player)commandSender;
                            player4.playSound(player4.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    int n = Math.max(1, Math.min(6, Integer.parseInt(stringArray[2])));
                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{this.plugin.createBackpack(n).getItem()});
                    if (!hashMap.isEmpty()) {
                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                    }
                    player.sendMessage(this.plugin.messages.receivedMessage.replace("{TIER}", String.valueOf(n)));
                    commandSender.sendMessage(this.plugin.messages.gaveMessage.replace("{TIER}", String.valueOf(n)).replace("{TARGET}", player.getName()));
                    player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                    return true;
                }
                LocalUtils.send(commandSender, "&cError. Usage: /betterbackpacks give [player] [tier]");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("skins")) {
                if (!this.plugin.skinsShopEnabled) {
                    commandSender.sendMessage(this.plugin.messages.skinsShopDisabled);
                    return true;
                }
                if (this.plugin.permissions.skinsShopPermission != null && !commandSender.hasPermission(this.plugin.permissions.skinsShopPermission)) {
                    commandSender.sendMessage(this.plugin.messages.skinsShopNoPermission);
                    return true;
                }
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player5 = (Player)commandSender;
                            player5.playSound(player5.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    this.plugin.openSkinsShop(player);
                    commandSender.sendMessage(this.plugin.messages.skinsShopOpenedOther.replace("{TARGET}", player.getName()));
                } else if (commandSender instanceof Player) {
                    this.plugin.openSkinsShop((Player)commandSender);
                } else {
                    LocalUtils.send(commandSender, "&cCannot open gui in console. Try /betterbackpacks skins [player]");
                }
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("upgrades")) {
                if (!this.plugin.upgradesShopEnabled) {
                    commandSender.sendMessage(this.plugin.messages.upgradesShopDisabled);
                    return true;
                }
                if (this.plugin.permissions.upgradesShopPermission != null && !commandSender.hasPermission(this.plugin.permissions.upgradesShopPermission)) {
                    commandSender.sendMessage(this.plugin.messages.upgradesShopNoPermission);
                    return true;
                }
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player6 = (Player)commandSender;
                            player6.playSound(player6.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    this.plugin.openUpgradesShop(player);
                    commandSender.sendMessage(this.plugin.messages.upgradesShopOpenedOther.replace("{TARGET}", player.getName()));
                } else if (commandSender instanceof Player) {
                    this.plugin.openUpgradesShop((Player)commandSender);
                } else {
                    LocalUtils.send(commandSender, "&cCannot open gui in console. Try /betterbackpacks upgrades [player]");
                }
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("unique")) {
                if (this.plugin.permissions.uniquePermission != null && !commandSender.hasPermission(this.plugin.permissions.uniquePermission)) {
                    commandSender.sendMessage(this.plugin.messages.noPermission);
                    return true;
                }
                if (!this.plugin.uniqueBackpacks) {
                    commandSender.sendMessage(this.plugin.messages.uniqueDisabled);
                    return true;
                }
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player7 = (Player)commandSender;
                            player7.playSound(player7.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    player.openInventory(this.plugin.uniqueInventory);
                    commandSender.sendMessage(this.plugin.messages.uniqueOpenedOther.replace("{TARGET}", player.getName()));
                } else if (commandSender instanceof Player) {
                    ((Player)commandSender).openInventory(this.plugin.uniqueInventory);
                } else {
                    LocalUtils.send(commandSender, "&cCannot open gui in console. Try /betterbackpacks unique [player]");
                }
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("recipe")) {
                if (this.plugin.permissions.recipePermission != null && !commandSender.hasPermission(this.plugin.permissions.recipePermission)) {
                    commandSender.sendMessage(this.plugin.messages.noPermission);
                    return true;
                }
                if (this.plugin.backpacksRecipesMap.size() == 0) {
                    commandSender.sendMessage(this.plugin.messages.showRecipeDisabled);
                    return true;
                }
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player8 = (Player)commandSender;
                            player8.playSound(player8.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    Inventory inventory = this.plugin.getMinAllowedRecipe(player);
                    if (inventory == null) {
                        commandSender.sendMessage(this.plugin.messages.showRecipeDisabledForOther);
                        player.sendMessage(this.plugin.messages.showRecipeDisabledForYou);
                        return true;
                    }
                    player.openInventory(inventory);
                    commandSender.sendMessage(this.plugin.messages.recipeOpenedOther.replace("{TARGET}", player.getName()));
                } else if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    Inventory inventory = this.plugin.getMinAllowedRecipe(player);
                    if (inventory == null) {
                        commandSender.sendMessage(this.plugin.messages.showRecipeDisabledForYou);
                        return true;
                    }
                    player.openInventory(inventory);
                } else {
                    LocalUtils.send(commandSender, "&cCannot open gui in console. Try /betterbackpacks recipe [player]");
                }
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("build") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 4) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (!LocalUtils.isInteger(stringArray[2])) {
                        commandSender.sendMessage(this.plugin.messages.invalidTier);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player9 = (Player)commandSender;
                            player9.playSound(player9.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    if (this.testServer && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testBuildError.replace("{PLAYER}", commandSender.getName()));
                        if (commandSender instanceof Player) {
                            Player player10 = (Player)commandSender;
                            player10.playSound(player10.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    int n = Math.max(1, Math.min(6, Integer.parseInt(stringArray[2])));
                    String string4 = stringArray[3];
                    if (stringArray.length >= 5 && !LocalUtils.isInteger(stringArray[4])) {
                        return true;
                    }
                    try {
                        NBTItem nBTItem = this.plugin.createBackpack(n, string4);
                        HashMap hashMap = player.getInventory().addItem(new ItemStack[]{nBTItem.getItem()});
                        if (!hashMap.isEmpty()) {
                            hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                        }
                        commandSender.sendMessage(this.plugin.messages.buildSuccess.replace("{TARGET}", player.getName()));
                        player.sendMessage(this.plugin.messages.buildSuccessOther);
                        return true;
                    }
                    catch (Exception exception) {
                        LocalUtils.send(commandSender, "&cError performing command. Provide a valid texture!");
                        return true;
                    }
                }
                LocalUtils.send(commandSender, "&cError. Usage: /betterbackpacks build [player] [tier] [texture] <custom-model-data>");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("reload") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && commandSender instanceof Player && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testReloadError.replace("{PLAYER}", commandSender.getName()));
                    Player player = (Player)commandSender;
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                this.plugin.getFiles().getConfig().reload();
                this.plugin.getFiles().getBackpacks().reload();
                this.plugin.getFiles().getItems().reload();
                this.plugin.getFiles().getSkins().reload();
                this.plugin.permissions.reloadMessages();
                this.plugin.messages.reloadMessages();
                this.plugin.reloadMessages();
                this.reloadMessages();
                this.plugin.interactListener.reloadMessages();
                this.plugin.clickListener.reloadMessages();
                this.plugin.craftListener.reloadMessages();
                this.plugin.closeListener.reloadMessages();
                this.plugin.damageListener.reloadMessages();
                if (this.plugin.swapHandListener != null) {
                    this.plugin.swapHandListener.reloadMessages();
                }
                commandSender.sendMessage(this.plugin.messages.reloaded);
                return true;
            }
        }
        LocalUtils.send(commandSender, " ");
        if (this.supportDeveloper) {
            LocalUtils.send(commandSender, "&2&lBetterBackpacks Pro &aby &2&lAlonsoAliaga &aVersion &6" + this.plugin.getDescription().getVersion());
        }
        if (commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
            for (String string5 : this.plugin.messages.helpMessageAdmin) {
                commandSender.sendMessage(string5);
            }
        } else {
            for (String string6 : this.plugin.messages.helpMessageUser) {
                commandSender.sendMessage(string6);
            }
        }
        LocalUtils.send(commandSender, " ");
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            player.playSound(player.getLocation(), Sounds.PICKUP.getSound(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length >= 1) {
            if (stringArray.length == 1) {
                return commandSender.hasPermission(this.plugin.permissions.adminPermission) ? this.adminList : this.userList;
            }
            if (commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (!stringArray[0].equalsIgnoreCase("reload") && this.adminList.contains(stringArray[0].toLowerCase())) {
                    if (stringArray.length == 2 && this.adminList.contains(stringArray[1].toLowerCase())) {
                        return this.onlinePlayers(commandSender, stringArray);
                    }
                    if (stringArray.length == 3) {
                        if (stringArray[0].equalsIgnoreCase("give") || stringArray[0].equalsIgnoreCase("build")) {
                            return Arrays.asList("1", "2", "3", "4", "5", "6");
                        }
                        if (stringArray[0].equalsIgnoreCase("giveskin")) {
                            return new ArrayList<String>(this.plugin.skinsMap.keySet());
                        }
                        if (stringArray[0].equalsIgnoreCase("giveupgrade")) {
                            return new ArrayList<String>(this.plugin.upgradesMap.keySet());
                        }
                    }
                } else {
                    return this.emptyList;
                }
            }
        }
        return this.onlinePlayers(commandSender, stringArray);
    }
}

