/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.legacy;

import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.IWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.IWorldGuardImplementation;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.legacy.flag.AbstractWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.legacy.region.WrappedRegion;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.legacy.utility.WorldGuardFlagUtilities;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.legacy.utility.WorldGuardVectorUtilities;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.region.IWrappedRegion;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ICuboidSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.IPolygonalSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ISelection;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Polygonal2DSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldGuardImplementation
implements IWorldGuardImplementation {
    private final WorldGuardPlugin worldGuardPlugin = WorldGuardPlugin.inst();
    private final WorldEditPlugin worldEditPlugin;

    public WorldGuardImplementation() {
        try {
            this.worldEditPlugin = this.worldGuardPlugin.getWorldEdit();
        }
        catch (CommandException commandException) {
            throw new RuntimeException(commandException);
        }
    }

    private Optional<LocalPlayer> wrapPlayer(Player player) {
        return Optional.ofNullable(player).map(player2 -> this.worldGuardPlugin.wrapPlayer(player));
    }

    private Optional<RegionManager> getWorldManager(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return Optional.ofNullable(this.worldGuardPlugin.getRegionManager(world));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(regionManager -> regionManager.getApplicableRegions(location));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location, @NonNull Location location2) {
        if (location == null) {
            throw new NullPointerException("minimum is marked non-null but is null");
        }
        if (location2 == null) {
            throw new NullPointerException("maximum is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(regionManager -> regionManager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("temp", WorldGuardVectorUtilities.toBlockVector(location), WorldGuardVectorUtilities.toBlockVector(location2))));
    }

    private <V> Optional<V> queryValue(Player player, @NonNull Location location, @NonNull Flag<V> flag) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.getApplicableRegions(location).map(applicableRegionSet -> applicableRegionSet.queryValue((RegionAssociable)this.wrapPlayer(player).orElse(null), flag));
    }

    @Override
    public JavaPlugin getWorldGuardPlugin() {
        return WorldGuardPlugin.inst();
    }

    @Override
    public int getApiVersion() {
        return -6;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> getFlag(String string, Class<T> clazz) {
        for (Flag flag : DefaultFlag.getFlags()) {
            if (!flag.getName().equalsIgnoreCase(string)) continue;
            return Optional.of(WorldGuardFlagUtilities.wrap(flag, clazz));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> queryFlag(Player player, Location location, IWrappedFlag<T> iWrappedFlag) {
        AbstractWrappedFlag abstractWrappedFlag = (AbstractWrappedFlag)iWrappedFlag;
        return this.queryValue(player, location, abstractWrappedFlag.getHandle()).flatMap(object -> abstractWrappedFlag.fromWGValue(object));
    }

    @Override
    public Map<IWrappedFlag<?>, Object> queryApplicableFlags(Player player, Location location) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location).orElse(null);
        if (applicableRegionSet == null) {
            return Collections.emptyMap();
        }
        LocalPlayer localPlayer = this.wrapPlayer(player).orElse(null);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        for (ProtectedRegion protectedRegion : applicableRegionSet.getRegions()) {
            for (Flag flag : protectedRegion.getFlags().keySet()) {
                Object object;
                if (!hashSet.add(flag.getName()) || (object = applicableRegionSet.queryValue((RegionAssociable)localPlayer, flag)) == null) continue;
                try {
                    Map.Entry<IWrappedFlag<?>, Object> entry = WorldGuardFlagUtilities.wrap(flag, object);
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return hashMap;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String string, Class<T> clazz, T t) {
        throw new UnsupportedOperationException("Custom flags aren't supported in this version of WorldGuard!");
    }

    @Override
    public Optional<IWrappedRegion> getRegion(World world, String string) {
        return this.getWorldManager(world).map(regionManager -> regionManager.getRegion(string)).map(protectedRegion -> new WrappedRegion(world, (ProtectedRegion)protectedRegion));
    }

    @Override
    public Map<String, IWrappedRegion> getRegions(World world) {
        RegionManager regionManager = this.worldGuardPlugin.getRegionManager(world);
        Map map = regionManager.getRegions();
        HashMap<String, IWrappedRegion> hashMap = new HashMap<String, IWrappedRegion>();
        map.forEach((string, protectedRegion) -> {
            IWrappedRegion cfr_ignored_0 = hashMap.put((String)string, new WrappedRegion(world, (ProtectedRegion)protectedRegion));
        });
        return hashMap;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location).orElse(null);
        HashSet<IWrappedRegion> hashSet = new HashSet<IWrappedRegion>();
        if (applicableRegionSet == null) {
            return hashSet;
        }
        applicableRegionSet.forEach(protectedRegion -> hashSet.add(new WrappedRegion(location.getWorld(), (ProtectedRegion)protectedRegion)));
        return hashSet;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location, Location location2) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location, location2).orElse(null);
        HashSet<IWrappedRegion> hashSet = new HashSet<IWrappedRegion>();
        if (applicableRegionSet == null) {
            return hashSet;
        }
        applicableRegionSet.forEach(protectedRegion -> hashSet.add(new WrappedRegion(location.getWorld(), (ProtectedRegion)protectedRegion)));
        return hashSet;
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String string, List<Location> list, int n, int n2) {
        World world = list.get(0).getWorld();
        Object object = list.size() == 2 ? new ProtectedCuboidRegion(string, WorldGuardVectorUtilities.toBlockVector(list.get(0)), WorldGuardVectorUtilities.toBlockVector(list.get(1))) : new ProtectedPolygonalRegion(string, WorldGuardVectorUtilities.toBlockVector2DList(list), n, n2);
        Optional<RegionManager> optional = this.getWorldManager(world);
        if (optional.isPresent()) {
            optional.get().addRegion((ProtectedRegion)object);
            return Optional.of(new WrappedRegion(world, (ProtectedRegion)object));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Set<IWrappedRegion>> removeRegion(World world, String string) {
        Optional<Set> optional = this.getWorldManager(world).map(regionManager -> regionManager.removeRegion(string));
        return optional.map(set -> set.stream().map(protectedRegion -> new WrappedRegion(world, (ProtectedRegion)protectedRegion)).collect(Collectors.toSet()));
    }

    @Override
    public Optional<ISelection> getPlayerSelection(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return Optional.ofNullable(this.worldEditPlugin.getSelection(player)).map(selection -> {
            if (selection instanceof CuboidSelection) {
                return new ICuboidSelection((Selection)selection){
                    final /* synthetic */ Selection val$selection;
                    {
                        this.val$selection = selection;
                    }

                    @Override
                    public Location getMinimumPoint() {
                        return this.val$selection.getMinimumPoint();
                    }

                    @Override
                    public Location getMaximumPoint() {
                        return this.val$selection.getMaximumPoint();
                    }
                };
            }
            if (selection instanceof Polygonal2DSelection) {
                return new IPolygonalSelection((Selection)selection){
                    final /* synthetic */ Selection val$selection;
                    {
                        this.val$selection = selection;
                    }

                    @Override
                    public Set<Location> getPoints() {
                        return ((Polygonal2DSelection)this.val$selection).getNativePoints().stream().map(blockVector2D -> new BlockVector(blockVector2D.toVector())).map(blockVector -> WorldGuardVectorUtilities.fromBlockVector(this.val$selection.getWorld(), blockVector)).collect(Collectors.toSet());
                    }

                    @Override
                    public int getMinimumY() {
                        return this.val$selection.getMinimumPoint().getBlockY();
                    }

                    @Override
                    public int getMaximumY() {
                        return this.val$selection.getMaximumPoint().getBlockY();
                    }
                };
            }
            throw new UnsupportedOperationException("Unsupported " + selection.getClass().getSimpleName() + " selection!");
        });
    }
}

