/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.region;

import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.IWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.flag.AbstractWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.utility.WorldGuardFlagUtilities;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.region.IWrappedDomain;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.region.IWrappedRegion;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ICuboidSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.IPolygonalSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ISelection;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;

public class WrappedRegion
implements IWrappedRegion {
    private final World world;
    private final ProtectedRegion handle;

    @Override
    public ISelection getSelection() {
        if (this.handle instanceof ProtectedCuboidRegion) {
            return new ICuboidSelection(){

                @Override
                public Location getMinimumPoint() {
                    return BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)WrappedRegion.this.handle.getMinimumPoint());
                }

                @Override
                public Location getMaximumPoint() {
                    return BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)WrappedRegion.this.handle.getMaximumPoint());
                }
            };
        }
        if (this.handle instanceof ProtectedPolygonalRegion) {
            return new IPolygonalSelection(){

                @Override
                public Set<Location> getPoints() {
                    return WrappedRegion.this.handle.getPoints().stream().map(BlockVector2::toBlockVector3).map(blockVector3 -> BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)blockVector3)).collect(Collectors.toSet());
                }

                @Override
                public int getMinimumY() {
                    return WrappedRegion.this.handle.getMinimumPoint().getBlockY();
                }

                @Override
                public int getMaximumY() {
                    return WrappedRegion.this.handle.getMaximumPoint().getBlockY();
                }
            };
        }
        throw new UnsupportedOperationException("Unsupported " + this.handle.getClass().getSimpleName() + " region!");
    }

    @Override
    public String getId() {
        return this.handle.getId();
    }

    @Override
    public Map<IWrappedFlag<?>, Object> getFlags() {
        HashMap hashMap = new HashMap();
        this.handle.getFlags().forEach((flag, object) -> {
            if (object != null) {
                try {
                    Map.Entry<IWrappedFlag<?>, Object> entry = WorldGuardFlagUtilities.wrap(flag, object);
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        return hashMap;
    }

    @Override
    public <T> Optional<T> getFlag(IWrappedFlag<T> iWrappedFlag) {
        AbstractWrappedFlag abstractWrappedFlag = (AbstractWrappedFlag)iWrappedFlag;
        return Optional.ofNullable(this.handle.getFlag(abstractWrappedFlag.getHandle())).map(object -> abstractWrappedFlag.fromWGValue(object));
    }

    @Override
    public <T> void setFlag(IWrappedFlag<T> iWrappedFlag, T t) {
        AbstractWrappedFlag abstractWrappedFlag = (AbstractWrappedFlag)iWrappedFlag;
        this.handle.setFlag(abstractWrappedFlag.getHandle(), abstractWrappedFlag.fromWrapperValue(t).orElse(null));
    }

    @Override
    public int getPriority() {
        return this.handle.getPriority();
    }

    @Override
    public IWrappedDomain getOwners() {
        return new IWrappedDomain(){

            @Override
            public Set<UUID> getPlayers() {
                return WrappedRegion.this.handle.getOwners().getUniqueIds();
            }

            @Override
            public void addPlayer(UUID uUID) {
                WrappedRegion.this.handle.getOwners().addPlayer(uUID);
            }

            @Override
            public void removePlayer(UUID uUID) {
                WrappedRegion.this.handle.getOwners().removePlayer(uUID);
            }

            @Override
            public Set<String> getGroups() {
                return WrappedRegion.this.handle.getOwners().getGroups();
            }

            @Override
            public void addGroup(String string) {
                WrappedRegion.this.handle.getOwners().addGroup(string);
            }

            @Override
            public void removeGroup(String string) {
                WrappedRegion.this.handle.getOwners().removeGroup(string);
            }
        };
    }

    @Override
    public IWrappedDomain getMembers() {
        return new IWrappedDomain(){

            @Override
            public Set<UUID> getPlayers() {
                return WrappedRegion.this.handle.getMembers().getUniqueIds();
            }

            @Override
            public void addPlayer(UUID uUID) {
                WrappedRegion.this.handle.getMembers().addPlayer(uUID);
            }

            @Override
            public void removePlayer(UUID uUID) {
                WrappedRegion.this.handle.getMembers().removePlayer(uUID);
            }

            @Override
            public Set<String> getGroups() {
                return WrappedRegion.this.handle.getMembers().getGroups();
            }

            @Override
            public void addGroup(String string) {
                WrappedRegion.this.handle.getMembers().addGroup(string);
            }

            @Override
            public void removeGroup(String string) {
                WrappedRegion.this.handle.getMembers().removeGroup(string);
            }
        };
    }

    @Override
    public boolean contains(Location location) {
        return this.handle.contains(BukkitAdapter.asBlockVector((Location)location));
    }

    public WrappedRegion(World world, ProtectedRegion protectedRegion) {
        this.world = world;
        this.handle = protectedRegion;
    }

    public World getWorld() {
        return this.world;
    }

    public ProtectedRegion getHandle() {
        return this.handle;
    }
}

