/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.enums.UpgradeType;
import com.alonsoaliaga.betterbackpacks.others.UpgradeData;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.ItemUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class BuyerSkinUpgrade
implements UpgradeData {
    private String identifier;
    private int price;
    private int customModelData;
    private String permission;
    private String displayName;
    private UpgradeType type;
    private List<String> shopLore;
    private List<String> upgradeLore;
    private final boolean strict;
    private final String noPermissionMessage;
    private final String notEnoughMoneyMessage;
    private final String cannotApplyPermission;
    private ItemStack shopItem;
    private ItemStack upgradeItem;
    private String rename;

    public BuyerSkinUpgrade(String string, int n, int n2, String string3, String string4, String string5, UpgradeType upgradeType, List<String> list, List<String> list2, boolean bl, String string6, String string7, String string8) {
        this.identifier = string;
        this.price = Math.max(0, n);
        this.customModelData = Math.max(0, n2);
        this.permission = string3.equalsIgnoreCase("none") ? null : string3;
        this.displayName = LocalUtils.colorize(string4);
        this.rename = string5;
        this.type = upgradeType;
        String string9 = BetterBackpacks.getInstance().messages.moneyFormat;
        this.shopLore = list.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string9).replace("{PRICE}", String.valueOf(this.price)))).collect(Collectors.toList());
        this.upgradeLore = list2.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string9).replace("{PRICE}", String.valueOf(this.price)))).collect(Collectors.toList());
        this.strict = bl && this.permission != null;
        this.noPermissionMessage = LocalUtils.colorize(string6);
        this.notEnoughMoneyMessage = LocalUtils.colorize(string7);
        this.cannotApplyPermission = LocalUtils.colorize(string8);
        this.buildItems();
    }

    private void buildItems() {
        this.shopItem = ItemUtils.getHeadBase();
        this.upgradeItem = ItemUtils.getHeadBase();
    }

    @Override
    public boolean hasPermission() {
        return this.permission != null;
    }

    @Override
    public boolean hasPermission(Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public ItemStack getShopItem(Player player) {
        ItemStack itemStack = this.shopItem.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.getDisplayName(player));
        itemMeta.setLore(this.getShopLore(player));
        if (this.customModelData > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        LocalUtils.setSkullOwner(player, skullMeta);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    @Override
    public ItemStack getUpgradeItem(Player player) {
        ItemStack itemStack = this.upgradeItem.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.getDisplayName(player));
        itemMeta.setLore(this.getUpgradeLore(player));
        if (this.customModelData > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        LocalUtils.setSkullOwner(player, skullMeta);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        NBTItem nBTItem = new NBTItem(itemStack);
        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-upgrade");
        nBTCompound.setString("betterbackpacks-upgrade-uuid", AlonsoUtils.DEVELOPER_UUID.toString());
        nBTCompound.setString("betterbackpacks-upgrade-type-identifier", this.identifier);
        if (this.hasRename()) {
            nBTCompound.setString("betterbackpacks-upgrade-rename", this.getRename(player));
        }
        nBTCompound.setString("betterbackpacks-upgrade-buyer-name", player.getName());
        nBTCompound.setString("betterbackpacks-upgrade-buyer-uuid", player.getUniqueId().toString());
        nBTCompound.setInteger("betterbackpacks-upgrade-type", Integer.valueOf(this.type.getId()));
        return nBTItem.getItem();
    }

    @Override
    public String getNoPermissionMessage() {
        return this.noPermissionMessage;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getTexture() {
        return "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=";
    }

    @Override
    public String getNotEnoughMoneyMessage() {
        return this.notEnoughMoneyMessage;
    }

    @Override
    public String getCannotApplyPermission() {
        return this.cannotApplyPermission;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public String getDisplayName(Player player) {
        return LocalUtils.setPlaceholders(player, this.displayName.replace("{PLAYER}", player.getName()));
    }

    private List<String> getShopLore(Player player) {
        String string;
        String string3 = string = this.rename == null ? "\u00a7cRemove this line!" : this.rename;
        if (AlonsoUtils.PluginUtils.hasPlaceholderApiSupport()) {
            return this.shopLore.stream().map(string2 -> PlaceholderAPI.setPlaceholders((Player)player, (String)string2.replace("{RENAME}", string).replace("{PLAYER}", player.getName()))).collect(Collectors.toList());
        }
        return this.shopLore.stream().map(string2 -> string2.replace("{RENAME}", string).replace("{PLAYER}", player.getName())).collect(Collectors.toList());
    }

    private List<String> getUpgradeLore(Player player) {
        String string;
        String string3 = string = this.rename == null ? "\u00a7cRemove this line!" : this.rename;
        if (AlonsoUtils.PluginUtils.hasPlaceholderApiSupport()) {
            return this.upgradeLore.stream().map(string2 -> PlaceholderAPI.setPlaceholders((Player)player, (String)string2.replace("{RENAME}", string).replace("{PLAYER}", player.getName()))).collect(Collectors.toList());
        }
        return this.upgradeLore.stream().map(string2 -> string2.replace("{RENAME}", string).replace("{PLAYER}", player.getName())).collect(Collectors.toList());
    }

    public boolean hasRename() {
        return this.rename != null;
    }

    @Override
    public String getRename(Player player) {
        return LocalUtils.setPlaceholders(player, this.rename == null ? "\u00a7cRemove this line!" : this.rename).replace("{PLAYER}", player.getName());
    }

    @Override
    public UpgradeType getType() {
        return this.type;
    }

    @Override
    public boolean isFree() {
        return this.price == 0;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }
}

