/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private JavaPlugin plugin;
    private Configuration configuration;
    private Configuration backpacks;
    private Configuration items;
    private Configuration skins;
    private Configuration newSkins;

    public FileManager(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.configuration = this.setupConfigFile("config");
        this.backpacks = this.setupConfigFile("backpacks");
        this.items = this.setupConfigFile("items");
        this.skins = this.setupConfigFile("skins");
        this.newSkins = this.setupConfigFile("new_skins", true);
    }

    private Configuration setupConfigFile(String string) {
        boolean bl;
        File file = new File(this.plugin.getDataFolder(), "/");
        if (!file.exists() && (bl = file.mkdir())) {
            LocalUtils.logp("Creating datafolder '/BetterBackpacks/ ..'");
        }
        String string2 = string.endsWith(".yml") ? string : string + ".yml";
        return new Configuration(this.plugin, string2);
    }

    private Configuration setupConfigFile(String string, boolean bl) {
        boolean bl2;
        File file = new File(this.plugin.getDataFolder(), "/");
        if (!file.exists() && (bl2 = file.mkdir())) {
            LocalUtils.logp("Creating datafolder '/BetterBackpacks/ ..'");
        }
        String string2 = string.endsWith(".yml") ? string : string + ".yml";
        return new Configuration(this.plugin, string2, bl);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Configuration getBackpacks() {
        return this.backpacks;
    }

    public Configuration getItems() {
        return this.items;
    }

    public Configuration getSkins() {
        return this.skins;
    }

    public class Configuration {
        private JavaPlugin plugin;
        private String fileName;
        private FileConfiguration fileConfiguration = null;
        private File file = null;
        private final String RESPECT_MY_WORK = "997807";

        public Configuration(JavaPlugin javaPlugin, String string, boolean bl) {
            this.plugin = javaPlugin;
            String string2 = this.fileName = string.endsWith(".yml") ? string : string + ".yml";
            if (bl) {
                this.initReplace();
            } else {
                this.init();
            }
        }

        public Configuration(JavaPlugin javaPlugin, String string) {
            this.plugin = javaPlugin;
            this.fileName = string.endsWith(".yml") ? string : string + ".yml";
            this.init();
        }

        private void initReplace() {
            this.plugin.saveResource(this.fileName, true);
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }

        private void init() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            if (!this.file.exists()) {
                this.plugin.saveResource(this.fileName, false);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }

        public Configuration saveDefaults() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            this.plugin.saveResource(this.fileName, true);
            return this;
        }

        public Configuration save() {
            if (this.fileConfiguration == null || this.file == null) {
                return this;
            }
            try {
                if (this.fileConfiguration.getConfigurationSection("").getKeys(true).size() != 0) {
                    this.fileConfiguration.save(this.file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return this;
        }

        public Configuration reload() {
            if (this.file == null) {
                this.file = new File(this.plugin.getDataFolder(), this.fileName);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            return this;
        }

        public FileConfiguration get() {
            return this.fileConfiguration;
        }
    }
}

