/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.enums.UpgradeType;
import com.alonsoaliaga.betterbackpacks.others.UpgradeData;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.ItemUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TierUpgrade
implements UpgradeData {
    private String identifier;
    private String texture;
    private int price;
    private int customModelData;
    private String permission;
    private String displayName;
    private UpgradeType type;
    private List<String> shopLore;
    private List<String> upgradeLore;
    private final boolean strict;
    private final String noPermissionMessage;
    private final String notEnoughMoneyMessage;
    private final String cannotApplyPermission;
    private ItemStack shopItem;
    private ItemStack upgradeItem;

    public TierUpgrade(String string, String string3, int n, int n2, String string4, String string5, UpgradeType upgradeType, List<String> list, List<String> list2, boolean bl, String string6, String string7, String string8) {
        this.identifier = string;
        this.texture = string3;
        this.price = Math.max(0, n);
        this.customModelData = Math.max(0, n2);
        this.permission = string4.equalsIgnoreCase("none") ? null : string4;
        this.displayName = LocalUtils.colorize(string5);
        this.type = upgradeType;
        String string9 = BetterBackpacks.getInstance().messages.moneyFormat;
        this.shopLore = list.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string9).replace("{PRICE}", String.valueOf(this.price)))).collect(Collectors.toList());
        this.upgradeLore = list2.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string9).replace("{PRICE}", String.valueOf(this.price)))).collect(Collectors.toList());
        this.strict = bl && this.permission != null;
        this.noPermissionMessage = LocalUtils.colorize(string6);
        this.notEnoughMoneyMessage = LocalUtils.colorize(string7);
        this.cannotApplyPermission = LocalUtils.colorize(string8);
        this.buildItems();
    }

    private void buildItems() {
        ItemMeta itemMeta;
        this.shopItem = ItemUtils.buildHead(this.displayName, this.shopLore, this.texture, AlonsoUtils.UNKNOWN_UUID);
        if (this.customModelData > 0) {
            itemMeta = this.shopItem.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            this.shopItem.setItemMeta(itemMeta);
        }
        this.upgradeItem = ItemUtils.buildHead(this.displayName, this.upgradeLore, this.texture, AlonsoUtils.UNKNOWN_UUID);
        if (this.customModelData > 0) {
            itemMeta = this.upgradeItem.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            this.upgradeItem.setItemMeta(itemMeta);
        }
        itemMeta = new NBTItem(this.upgradeItem);
        NBTCompound nBTCompound = itemMeta.addCompound("betterbackpacks-upgrade");
        nBTCompound.setString("betterbackpacks-upgrade-uuid", AlonsoUtils.DEVELOPER_UUID.toString());
        nBTCompound.setString("betterbackpacks-upgrade-type-identifier", this.identifier);
        nBTCompound.setInteger("betterbackpacks-upgrade-type", Integer.valueOf(this.type.getId()));
        this.upgradeItem = itemMeta.getItem();
    }

    @Override
    public boolean hasPermission() {
        return this.permission != null;
    }

    @Override
    public boolean hasPermission(Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public ItemStack getShopItem(Player player) {
        return this.shopItem;
    }

    @Override
    public ItemStack getUpgradeItem(Player player) {
        return this.upgradeItem;
    }

    @Override
    public String getNoPermissionMessage() {
        return this.noPermissionMessage;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getTexture() {
        return this.texture;
    }

    @Override
    public String getNotEnoughMoneyMessage() {
        return this.notEnoughMoneyMessage;
    }

    @Override
    public String getCannotApplyPermission() {
        return this.cannotApplyPermission;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public String getDisplayName(Player player) {
        return this.displayName;
    }

    @Override
    public UpgradeType getType() {
        return this.type;
    }

    @Override
    public boolean isFree() {
        return this.price == 0;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }
}

