/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.utils;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.others.FileManager;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import com.alonsoaliaga.betterbackpacks.utils.ProtocolLibUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AlonsoUtils {
    public static final String PLUGIN = "BetterBackpacks";
    public static final boolean DEBUG = true;
    public static String first = "&a";
    public static String second = "&2";
    public static final String PREFIX = second + "[" + "BetterBackpacks" + "] &7";
    public static final String PREFIXC = "[BetterBackpacks] ";
    public static ServerType serverType = AlonsoUtils.getServerType();
    public static ServerVersion serverVersion = AlonsoUtils.getServerVersion();
    public static final String DEVELOPER_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=";
    public static final String HEAD_SIGNATURE = "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=";
    public static final UUID DEVELOPER_UUID = UUID.fromString("e1c1a194-7e86-414f-86bb-42d82a21cfb8");
    public static final UUID UNKNOWN_UUID = UUID.fromString("7b37729d-b9ac-44d9-8d08-0dbfb95c777d");

    public static void sendEnableText(JavaPlugin javaPlugin) {
        LocalUtils.log(first + "  ___      _   _           ___          _                 _       ___         ");
        LocalUtils.log(first + " | _ ) ___| |_| |_ ___ _ _| _ ) __ _ __| |___ __  __ _ __| |__ __| _ \\_ _ ___ ");
        LocalUtils.log(first + " | _ \\/ -_)  _|  _/ -_) '_| _ \\/ _` / _| / / '_ \\/ _` / _| / /(_-<  _/ '_/ _ \\");
        LocalUtils.log(second + " |___/\\___|\\__|\\__\\___|_| |___/\\__,_\\__|_\\_\\ .__/\\__,_\\__|_\\_\\/__/_| |_| \\___/");
        LocalUtils.log(second + "                                           |_|                                ");
        LocalUtils.log(first + "   Running plugin " + second + javaPlugin.getDescription().getName() + " v" + javaPlugin.getDescription().getVersion() + " (" + serverVersion.name() + ")");
        LocalUtils.log(first + "   Server running " + second + Bukkit.getServer().getName() + first + " version " + second + Bukkit.getVersion());
        LocalUtils.log(first + "   (Implementing API version " + second + Bukkit.getBukkitVersion().trim() + first + ")");
        LocalUtils.log(first + "   (Developed by " + second + " AlonsoAliaga" + first + " - Thanks for using my plugin " + second + "<3" + first + ")");
        LocalUtils.log(first + "   Thanks for purchasing my plugin 997807! If you didn't, do it or you won't receive support :D");
        LocalUtils.log(first + "   Join us on our official discord server to receive support: alonsoaliaga.com/discord");
        LocalUtils.log(first + "   If you loved the plugin consider leaving a 5-stars review and mentioning your server IP in it!");
        LocalUtils.log("");
        if (javaPlugin.getDescription().getVersion().contains("-DEV") || javaPlugin.getDescription().getVersion().contains("-DEV-")) {
            LocalUtils.log(first + "   You are using a Development build of " + second + javaPlugin.getDescription().getName() + first + ". Make sure you update the plugin once");
            LocalUtils.log(first + "   an official update is released on SpigotMC to ensure plugin is free of bugs.");
            LocalUtils.log("");
        }
    }

    public static boolean isSupported() {
        if (serverType == ServerType.PAPER) {
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log(first + PREFIXC + "This is not a error! This is just a warning to keep in mind if you have issues!");
            LocalUtils.log(first + PREFIXC + "You are using a Paper fork (" + Bukkit.getName() + "). This plugin was made for Spigot");
            LocalUtils.log(first + PREFIXC + "but was (in most cases) tested with different builds of Paper and Purpur.");
            LocalUtils.log(first + PREFIXC + "Spigot and forks API are really similar and should be compatible, however there are");
            LocalUtils.log(first + PREFIXC + "some cases in which they aren't compatible. If you have issues report them to the");
            LocalUtils.log(first + PREFIXC + "developer instead of reviewing 1 star. Thanks in advanced!");
            LocalUtils.log(first + PREFIXC + "Join us in our official support server on alonsoaliaga.com/discord");
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log("");
        } else if (serverType == ServerType.SPIGOT) {
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log(first + PREFIXC + "You are using a Spigot or a Spigot fork (" + Bukkit.getName() + "), plugin should work fine!");
            LocalUtils.log(first + PREFIXC + "If you have issues, join us on our official support server on alonsoaliaga.com/discord");
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log("");
        } else {
            LocalUtils.log("&c==============================================================================================");
            LocalUtils.log("&c[BetterBackpacks] This is not a error! This is just a warning to keep in mind if you have issues!");
            LocalUtils.log("&c[BetterBackpacks] You are using an Unknown fork (" + Bukkit.getName() + "). This plugin was made for Spigot");
            LocalUtils.log("&c[BetterBackpacks] but was (in most cases) tested with different builds of Paper and Purpur.");
            LocalUtils.log("&c[BetterBackpacks] Spigot and forks API are really similar and should be compatible, however there are");
            LocalUtils.log("&c[BetterBackpacks] some cases in which they aren't compatible. If you have issues report them to the");
            LocalUtils.log("&c[BetterBackpacks] developer instead of reviewing 1 star. Thanks in advanced!");
            LocalUtils.log("&c[BetterBackpacks] Join us in our official support server on alonsoaliaga.com/discord");
            LocalUtils.log("&c==============================================================================================");
            LocalUtils.log("");
        }
        return true;
    }

    public static ServerVersion getServerVersion() {
        String string = Bukkit.getBukkitVersion().trim();
        for (ServerVersion serverVersion : ServerVersion.values()) {
            if (!string.startsWith(serverVersion.getVersionString())) continue;
            return serverVersion;
        }
        return ServerVersion.v2_0;
    }

    private static ServerType getServerType() {
        try {
            LocalUtils.findClasses("com.destroystokyo.paper.event.player.PlayerJumpEvent", "com.destroystokyo.paper.event.block.BeaconEffectEvent", "com.destroystokyo.paper.PaperConfig", "org.github.paperspigot.event.block.BeaconEffectEvent", "org.github.paperspigot.PaperSpigotConfig", "org.github.paperspigot.exception.ServerException");
            return ServerType.PAPER;
        }
        catch (Throwable throwable) {
            try {
                LocalUtils.findClasses("org.spigotmc.event.entity.EntityDismountEvent", "org.spigotmc.event.entity.EntityMountEvent");
                return ServerType.SPIGOT;
            }
            catch (Throwable throwable2) {
                return ServerType.CRAFTBUKKIT;
            }
        }
    }

    public static void sendDisableText() {
        LocalUtils.log(" ");
        LocalUtils.log(String.format("&c%sPlugin has been disabled!", PREFIXC));
        LocalUtils.log(String.format("&c%sThank you for using my plugin!", PREFIXC));
        LocalUtils.log(" ");
    }

    public static class Updater {
        private String resourceID;
        private JavaPlugin plugin;
        private int updateCheckCounter = 0;
        private UpdateFound updateFound = null;
        private String notificationMessage = null;

        public Updater(JavaPlugin javaPlugin, @Nullable String string, boolean bl, @Nullable String string2, String string3) {
            this.plugin = javaPlugin;
            this.resourceID = string;
            if (javaPlugin.isEnabled() && string != null && !string.isEmpty()) {
                this.startChecking();
                if (bl) {
                    new UpdateJoinListener(javaPlugin, string2);
                }
                this.notificationMessage = LocalUtils.colorize(string3 == null ? String.format("%s&eA new update has been found! Download it here &c{LINK}", PREFIX) : string3);
            }
        }

        private void checkSafeUpdate() {
            if (this.resourceID == null || this.resourceID.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                block13: {
                    HttpsURLConnection httpsURLConnection = null;
                    try {
                        httpsURLConnection = (HttpsURLConnection)new URL(new String(Base64.getDecoder().decode("aHR0cHM6Ly9yYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tL0Fsb25zb0FsaWFnYS9BbG9uc29BbGlhZ2FBUEkvbWFpbi9hcGkvc3BpZ290bWMvdXBkYXRlcy5qc29u"))).openConnection();
                        int n = 1250;
                        httpsURLConnection.setConnectTimeout(n);
                        httpsURLConnection.setReadTimeout(n);
                        String string = this.plugin.getDescription().getVersion();
                        String string2 = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream())).readLine();
                        JsonParser jsonParser = new JsonParser();
                        JsonObject jsonObject = jsonParser.parse(string2).getAsJsonObject();
                        if (jsonObject.has(this.resourceID)) {
                            LocalUtils.logp("Checking for updates...");
                            JsonObject jsonObject2 = jsonObject.getAsJsonObject(this.resourceID);
                            String string3 = jsonObject2.get("version").getAsString();
                            if (!string3.equals(string)) {
                                this.updateFound = new UpdateFound(string3, this.resourceID);
                                LocalUtils.logp(String.format("&aNew version available: %s", string3));
                                LocalUtils.logp("&aPlease download the latest version to get support!");
                                LocalUtils.logp(String.format("&aDownload: https://www.spigotmc.org/resources/%s/", this.resourceID));
                            } else {
                                this.updateFound = null;
                                if (this.updateCheckCounter % 3 == 0) {
                                    LocalUtils.logp("&ePlugin up-to-date! You have the latest version!");
                                }
                            }
                        } else {
                            this.updateFound = null;
                            LocalUtils.log(String.format("&c%sCouldn't find updates info! Check updates on &b%s", AlonsoUtils.PREFIXC, String.format("https://www.spigotmc.org/resources/%s/", this.resourceID)));
                        }
                        try {
                            httpsURLConnection.disconnect();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.updateCheckCounter;
                    }
                    catch (Throwable throwable) {
                        if (BetterBackpacks.getInstance().debugMode) {
                            LocalUtils.log(String.format("&c%sFailed to check for an update on RestAPI: %s", AlonsoUtils.PREFIXC, throwable.getMessage()));
                        } else {
                            LocalUtils.log(String.format("&c%sFailed to check for an update on RestAPI!", AlonsoUtils.PREFIXC));
                        }
                        ++this.updateCheckCounter;
                        if (httpsURLConnection == null) break block13;
                        try {
                            httpsURLConnection.disconnect();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        private void checkUpdate() {
            if (this.resourceID == null || this.resourceID.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                HttpURLConnection httpURLConnection = null;
                try {
                    httpURLConnection = (HttpsURLConnection)new URL(String.format("https://api.spigotmc.org/legacy/update.php?resource=%s", this.resourceID)).openConnection();
                    int n = 1250;
                    httpURLConnection.setConnectTimeout(n);
                    httpURLConnection.setReadTimeout(n);
                    String string = this.plugin.getDescription().getVersion();
                    String string2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())).readLine();
                    LocalUtils.logp("Checking for updates...");
                    if (!string2.equals(string)) {
                        this.updateFound = new UpdateFound(string2, this.resourceID);
                        LocalUtils.logp(String.format("&aNew version available: %s", string2));
                        LocalUtils.logp("&aPlease download the latest version to get support!");
                        LocalUtils.logp(String.format("&aDownload: https://www.spigotmc.org/resources/%s/", this.resourceID));
                    } else {
                        this.updateFound = null;
                        if (this.updateCheckCounter % 3 == 0) {
                            LocalUtils.logp("&ePlugin up-to-date! You have the latest version!");
                        }
                    }
                    try {
                        httpURLConnection.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++this.updateCheckCounter;
                }
                catch (Throwable throwable) {
                    if (BetterBackpacks.getInstance().debugMode) {
                        LocalUtils.log(String.format("&c%sFailed to check for an update on SpigotMC. Error: %s", AlonsoUtils.PREFIXC, throwable.getMessage()));
                        LocalUtils.log(String.format("&c%sAttempting RestAPI..", AlonsoUtils.PREFIXC));
                    }
                    if (httpURLConnection != null) {
                        try {
                            httpURLConnection.disconnect();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    this.checkSafeUpdate();
                }
            });
        }

        private void startChecking() {
            new BukkitRunnable(){

                public void run() {
                    if (!plugin.isEnabled()) {
                        this.cancel();
                        return;
                    }
                    this.checkUpdate();
                }
            }.runTaskTimerAsynchronously((Plugin)this.plugin, (long)(ThreadLocalRandom.current().nextInt(5) * 10), 86400000L);
        }

        public class UpdateJoinListener
        implements Listener {
            private JavaPlugin plugin;
            private String notifyPermission;

            public UpdateJoinListener(@Nullable JavaPlugin javaPlugin, String string) {
                this.plugin = javaPlugin;
                this.notifyPermission = string == null || string.equalsIgnoreCase("none") ? null : string;
                javaPlugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
            }

            @EventHandler
            public void onJoinUpdate(PlayerJoinEvent playerJoinEvent) {
                if (Updater.this.updateFound != null && (playerJoinEvent.getPlayer().isOp() || this.notifyPermission != null && playerJoinEvent.getPlayer().hasPermission(this.notifyPermission))) {
                    playerJoinEvent.getPlayer().sendMessage(Updater.this.notificationMessage.replace("{NEWLINE}", "\n").replace("{CURRENT}", this.plugin.getDescription().getVersion()).replace("{NEW}", Updater.this.updateFound.getNewVersion()).replace("{LINK}", Updater.this.updateFound.getDownloadLink()));
                }
            }
        }

        public class UpdateFound {
            private final String RESPECT_MY_WORK = "997807";
            private String newVersion;
            private String resourceID;

            public UpdateFound(String string, String string2) {
                this.newVersion = string;
                this.resourceID = string2;
            }

            public String getNewVersion() {
                return this.newVersion;
            }

            public String getDownloadLink() {
                return String.format("https://www.spigotmc.org/resources/%s/history", this.resourceID);
            }
        }
    }

    public static class PluginUtils {
        private JavaPlugin plugin;
        private ActionBarType actionBarType;
        private ServerType serverType;
        private ServerVersion serverVersion;
        private boolean protocolLibSupport;
        private boolean customModelSupport;
        private static boolean customModelSupported;
        private int actionBarProtocolMethod;
        private boolean betterHeadsSupported;
        private static boolean betterHeadsSupport;
        private boolean nbtApiSupported;
        private static boolean nbtApiSupport;
        private boolean placeholderApiSupported;
        private static boolean placeholderApiSupport;

        public PluginUtils(JavaPlugin javaPlugin) {
            this.plugin = javaPlugin;
            this.load();
        }

        private void load() {
            this.actionBarType = ActionBarType.UNSUPPORTED;
            this.serverType = serverType;
            this.serverVersion = serverVersion;
            this.customModelSupport = this.serverVersion.getWeight() >= ServerVersion.v1_14.getWeight();
            this.protocolLibSupport = false;
            this.betterHeadsSupported = Bukkit.getServer().getPluginManager().getPlugin("BetterHeads") != null;
            this.nbtApiSupported = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
            this.placeholderApiSupported = Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
            this.actionBarProtocolMethod = -1;
            try {
                Class<?> clazz = Class.forName("net.md_5.bungee.api.ChatMessageType");
                Class<?> clazz2 = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
                Player.Spigot.class.getDeclaredMethod("sendMessage", clazz, clazz2);
                LocalUtils.logp("BungeeCord action bar available. Hooking..");
                this.actionBarType = ActionBarType.BUNGEE;
            }
            catch (Throwable throwable) {
                LocalUtils.logp("BungeeCord action bar not available for your server type/version! Skipping..");
            }
            if (this.plugin.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
                LocalUtils.logp("ProtocolLib found! Checking..");
                this.protocolLibSupport = true;
                if (this.actionBarType != ActionBarType.BUNGEE) {
                    this.actionBarProtocolMethod = ProtocolLibUtils.getProtocolActionBarMethod();
                    if (this.actionBarProtocolMethod != -1) {
                        this.actionBarType = ActionBarType.PROTOCOL;
                    }
                }
            } else {
                LocalUtils.logp("ProtocolLib not found! Skipping..");
            }
        }

        public ServerType getServerType() {
            return this.serverType;
        }

        public ServerVersion getServerVersion() {
            return this.serverVersion;
        }

        public ActionBarType getActionBarType() {
            return this.actionBarType;
        }

        public boolean isProtocolLibSupported() {
            return this.protocolLibSupport;
        }

        public boolean isCustomModelSupported() {
            return this.customModelSupport;
        }

        public static boolean hasCustomModelSupport() {
            return customModelSupported;
        }

        public boolean isV1_8() {
            return this.serverVersion == ServerVersion.v1_8;
        }

        public int getActionBarProtocolMethod() {
            return this.actionBarProtocolMethod;
        }

        public boolean isBetterHeadsSupported() {
            return this.betterHeadsSupported;
        }

        public static boolean hasBetterHeadsSupport() {
            return betterHeadsSupport;
        }

        public boolean isNbtApiSupported() {
            return this.nbtApiSupported;
        }

        public static boolean hasNbtApiSupport() {
            return nbtApiSupport;
        }

        public boolean isPlaceholderApiSupported() {
            return this.placeholderApiSupported;
        }

        public static boolean hasPlaceholderApiSupport() {
            return placeholderApiSupport;
        }

        static {
            betterHeadsSupport = Bukkit.getServer().getPluginManager().getPlugin("BetterHeads") != null;
            nbtApiSupport = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
            placeholderApiSupport = Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
            customModelSupported = serverVersion.getWeight() >= ServerVersion.v1_14.getWeight();
        }
    }

    public static interface AlonsoPlugin {
        public PluginUtils getPluginUtils();

        public FileManager getFiles();

        public JavaPlugin getPlugin();

        public BetterBackpacks getMain();
    }

    public static enum ActionBarType {
        PROTOCOL,
        BUNGEE,
        UNSUPPORTED;

    }

    public static enum ServerVersion {
        v1_7(0, "1.7"),
        v1_8(1, "1.8"),
        v1_9(2, "1.9"),
        v1_10(3, "1.10"),
        v1_11(4, "1.11"),
        v1_12(5, "1.12"),
        v1_13(6, "1.13"),
        v1_14(7, "1.14"),
        v1_15(8, "1.15"),
        v1_16(9, "1.16"),
        v1_17(10, "1.17"),
        v1_18(11, "1.18"),
        v1_19(12, "1.19"),
        v2_0(13, "2.0");

        int weight;
        String versionString;

        private ServerVersion(int n2, String string2) {
            this.weight = n2;
            this.versionString = string2;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public boolean isOlderEqualThan(ServerVersion serverVersion) {
            return this.getWeight() <= serverVersion.getWeight();
        }

        public boolean isOlderThan(ServerVersion serverVersion) {
            return this.getWeight() < serverVersion.getWeight();
        }

        public boolean isLegacy() {
            return this.getWeight() <= v1_12.getWeight();
        }

        public boolean isNewerEqualThanV1_13() {
            return this.getWeight() >= v1_13.getWeight();
        }

        public boolean isNewerThanV1_13() {
            return this.getWeight() > v1_13.getWeight();
        }

        public boolean isNewerThanV1_12() {
            return this.getWeight() > v1_12.getWeight();
        }

        public boolean isNewerEqualThanV1_11() {
            return this.getWeight() >= v1_11.getWeight();
        }

        public boolean isNewerEqualThanV1_17() {
            return this.getWeight() >= v1_17.getWeight();
        }

        public boolean isNewerEqualThanV1_16() {
            return this.getWeight() >= v1_16.getWeight();
        }

        public boolean isNewerThanV1_16() {
            return this.getWeight() > v1_16.getWeight();
        }

        public boolean isNewerThanV1_17() {
            return this.getWeight() > v1_17.getWeight();
        }

        public boolean isNewerThanV2_0() {
            return this.getWeight() > v2_0.getWeight();
        }

        public boolean isNewerEqualThanV2_0() {
            return this.getWeight() >= v2_0.getWeight();
        }
    }

    public static enum ServerType {
        CRAFTBUKKIT,
        SPIGOT,
        PAPER;

    }
}

