/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.utils;

import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class BukkitSerializers {
    private static final String ERR_NBT_LOAD = "Failed to find a load method in NBTCompressedStreamTools";
    private static final String ERR_NBT_SAVE = "Failed to find a save method in NBTCompressedStreamTools";
    private static final Constructor<?> CONSTRUCTOR_NBT;
    private static final Method METHOD_NBT_SAVE;
    private static final Method METHOD_NBT_LOAD_DATAINPUT;
    private static final Method METHOD_NBT_LOAD_DATAINPUTSTREAM;
    private static final Class<?> CLASS_ITEM;
    protected static final Class<?> CLASS_CRAFT_ITEM;
    private static final Constructor<?> CONSTRUCTOR_ITEM;
    private static final Method METHOD_ITEM_CREATE;
    private static final Method METHOD_ITEM_TO;
    private static final Method METHOD_ITEM_FROM;
    private static Method METHOD_ITEM_SAVE;
    private static boolean NEW_NMS;
    private static final String nms = "net.minecraft.server.%s.%s";
    private static final String cb = "org.bukkit.craftbukkit.%s.%s";
    private static final String version;

    private static Class<?> getOcbClass(String string, String string2) {
        return Class.forName(String.format(cb, string, string2));
    }

    private static Class<?> getNmsClass(String string, String string2, String string3) {
        if (NEW_NMS) {
            return Class.forName(string3 + "." + string2);
        }
        return Class.forName(String.format(nms, string, string2));
    }

    public static Object createNBTTagCompound() {
        return CONSTRUCTOR_NBT.newInstance(new Object[0]);
    }

    public static void saveNBT(OutputStream outputStream, Object object) {
        METHOD_NBT_SAVE.invoke(null, object, new DataOutputStream(outputStream));
    }

    public static Object loadNBT(InputStream inputStream) {
        return METHOD_NBT_LOAD_DATAINPUTSTREAM == null ? METHOD_NBT_LOAD_DATAINPUT.invoke(null, inputStream) : METHOD_NBT_LOAD_DATAINPUTSTREAM.invoke(null, new DataInputStream(inputStream));
    }

    public static Object itemFromBukkit(ItemStack itemStack) {
        return METHOD_ITEM_TO.invoke(null, itemStack);
    }

    public static ItemStack itemToBukkit(Object object) {
        return (ItemStack)METHOD_ITEM_FROM.invoke(null, object);
    }

    public static void saveItems(ItemStack[] itemStackArray, OutputStream outputStream) {
        outputStream.write(itemStackArray.length);
        for (ItemStack itemStack : itemStackArray) {
            BukkitSerializers.saveItem(itemStack, outputStream);
        }
    }

    public static ItemStack[] loadItems(InputStream inputStream) {
        ItemStack[] itemStackArray = new ItemStack[inputStream.read()];
        for (int i = 0; i < itemStackArray.length; ++i) {
            itemStackArray[i] = BukkitSerializers.loadItem(inputStream);
        }
        return itemStackArray;
    }

    public static void saveItem(ItemStack itemStack, OutputStream outputStream) {
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            outputStream.write(1);
            BukkitSerializers.saveNBT(outputStream, METHOD_ITEM_SAVE.invoke(BukkitSerializers.itemFromBukkit(itemStack), BukkitSerializers.createNBTTagCompound()));
        } else {
            outputStream.write(0);
        }
    }

    public static ItemStack loadItem(InputStream inputStream) {
        if (inputStream.read() != 1) {
            return null;
        }
        return BukkitSerializers.itemToBukkit(CONSTRUCTOR_ITEM == null ? METHOD_ITEM_CREATE.invoke(null, BukkitSerializers.loadNBT(inputStream)) : CONSTRUCTOR_ITEM.newInstance(BukkitSerializers.loadNBT(inputStream)));
    }

    public static void load() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        version = Bukkit.getServer().getClass().getName().split("\\.")[3];
        try {
            void var4_8;
            NEW_NMS = AlonsoUtils.serverVersion.isNewerEqualThanV1_17();
            if (NEW_NMS) {
                LocalUtils.logp("1.17.x or newer was detected! Attempting to use new nms style. Please report bugs");
                LocalUtils.logp("if any in our discord server. Join us on https://alonsoaliaga.com/discord");
            }
            Class<?> clazz = BukkitSerializers.getNmsClass(version, "NBTTagCompound", "net.minecraft.nbt");
            CONSTRUCTOR_NBT = clazz.getConstructor(new Class[0]);
            CONSTRUCTOR_NBT.setAccessible(true);
            Method method = null;
            Method method2 = null;
            Method method3 = null;
            for (Method method4 : BukkitSerializers.getNmsClass(version, "NBTCompressedStreamTools", "net.minecraft.nbt").getDeclaredMethods()) {
                Class<?>[] classArray = method4.getParameterTypes();
                if (classArray.length == 2 && classArray[1] == DataOutput.class) {
                    method = method4;
                    continue;
                }
                if (classArray.length == 1 && classArray[0] == DataInputStream.class) {
                    method2 = method4;
                    continue;
                }
                if (classArray.length != 1 || classArray[0] != DataInput.class) continue;
                method3 = method4;
            }
            METHOD_NBT_SAVE = method;
            if (METHOD_NBT_SAVE == null) {
                throw new IllegalStateException(ERR_NBT_SAVE);
            }
            METHOD_NBT_LOAD_DATAINPUTSTREAM = method2;
            if (METHOD_NBT_LOAD_DATAINPUTSTREAM == null) {
                METHOD_NBT_LOAD_DATAINPUT = method3;
                if (METHOD_NBT_LOAD_DATAINPUT == null) {
                    throw new IllegalStateException(ERR_NBT_LOAD);
                }
                METHOD_NBT_LOAD_DATAINPUT.setAccessible(true);
            } else {
                METHOD_NBT_LOAD_DATAINPUTSTREAM.setAccessible(true);
                METHOD_NBT_LOAD_DATAINPUT = null;
            }
            METHOD_NBT_SAVE.setAccessible(true);
            CLASS_ITEM = BukkitSerializers.getNmsClass(version, "ItemStack", "net.minecraft.world.item");
            CLASS_CRAFT_ITEM = BukkitSerializers.getOcbClass(version, "inventory.CraftItemStack");
            METHOD_ITEM_FROM = CLASS_CRAFT_ITEM.getDeclaredMethod("asBukkitCopy", CLASS_ITEM);
            METHOD_ITEM_TO = CLASS_CRAFT_ITEM.getDeclaredMethod("asNMSCopy", ItemStack.class);
            Object var4_6 = null;
            Method method5 = null;
            try {
                Constructor<?> constructor = CLASS_ITEM.getConstructor(clazz);
            }
            catch (Throwable throwable) {
                try {
                    method5 = CLASS_ITEM.getDeclaredMethod("createStack", clazz);
                }
                catch (Throwable throwable2) {
                    method5 = CLASS_ITEM.getDeclaredMethod("a", clazz);
                }
            }
            CONSTRUCTOR_ITEM = var4_8;
            METHOD_ITEM_CREATE = method5;
            try {
                METHOD_ITEM_SAVE = CLASS_ITEM.getDeclaredMethod("save", clazz);
            }
            catch (Throwable throwable) {
                METHOD_ITEM_SAVE = CLASS_ITEM.getDeclaredMethod("b", clazz);
            }
            METHOD_ITEM_SAVE.setAccessible(true);
            LocalUtils.logp("Successfully initialized reflections!");
        }
        catch (Throwable throwable) {
            LocalUtils.logp("Reflections failed! This plugin is for 1.8.8 and newer versions.");
            LocalUtils.logp("If you are using a recently released minecraft version not listed in 'Tested versions'");
            LocalUtils.logp("please be patient. The developer has a lot of plugins to update when new minecraft versions");
            LocalUtils.logp("are released. NMS issues are really hard to fix sometimes, so please be patient.");
            throw new IllegalStateException("Could not initialize reflection!", throwable);
        }
    }
}

