/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.utils;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.others.Color;
import com.alonsoaliaga.betterbackpacks.others.DyeableType;
import com.alonsoaliaga.betterbackpacks.others.Materials;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.ItemUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.tr7zw.nbtapi.NBTCompound;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.Vector;

public class LocalUtils {
    public static boolean hexColorSupport;
    public static boolean oldHoverMethod;
    public static boolean newSetUnbreakableMethod;
    public static boolean newIsUnbreakableMethod;
    public static boolean setUnbreakableSupport;
    public static boolean isUnbreakableSupport;
    public static boolean oldSendTitleMethod;
    public static boolean oldItemStackSupport;
    public static boolean owningPlayerSupport;
    public static boolean longInventoryTitleSupport;
    public static Method METHOD_SET_UNBREAKABLE_OLD;
    public static Method METHOD_IS_UNBREAKABLE_OLD;
    public static Method METHOD_SET_OWNER;
    public static Method METHOD_ITEM_META_SPIGOT;
    private static boolean papiSupport;
    public static Constructor<?> CONSTRUCTOR_ITEM_STACK_OLD;
    private static final NavigableMap<Long, String> suffixes;

    public static String translateAlternateHexColorCodes(Character c, String string) {
        string = org.bukkit.ChatColor.translateAlternateColorCodes((char)c.charValue(), (String)string);
        if (string.length() < 7 || !string.contains("#")) {
            return string;
        }
        Matcher matcher = Pattern.compile("#[A-Fa-f0-9]{6}").matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            string = string.replace(string2, ChatColor.of((String)string2).toString());
        }
        return string;
    }

    public static String colorize(String string) {
        return hexColorSupport ? LocalUtils.translateAlternateHexColorCodes(Character.valueOf('&'), string) : org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static List<String> colorize(List<String> list) {
        return list.stream().map(LocalUtils::colorize).collect(Collectors.toList());
    }

    public static void logp(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "BetterBackpacks" + "] &7" + string));
    }

    public static void logd(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "BetterBackpacks" + "]" + AlonsoUtils.first + "&l[Debug] &7" + string));
    }

    public static void log(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(string));
    }

    public static void loge(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize("&c[BetterBackpacks] " + string));
    }

    public static String numberFormat(long l) {
        if (l == Long.MIN_VALUE) {
            return LocalUtils.numberFormat(-9223372036854775807L);
        }
        if (l < 0L) {
            return "-" + LocalUtils.numberFormat(-l);
        }
        if (l < 1000L) {
            return Long.toString(l);
        }
        Map.Entry<Long, String> entry = suffixes.floorEntry(l);
        Long l2 = entry.getKey();
        String string = entry.getValue();
        long l3 = l / (l2 / 10L);
        boolean bl = l3 < 100L && (double)l3 / 10.0 != (double)(l3 / 10L);
        return bl ? (double)l3 / 10.0 + string : l3 / 10L + string;
    }

    public static Material findMaterialOrDefault(String string, Material material) {
        try {
            return Material.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return material;
        }
    }

    public static Material findMaterial(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Material.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.COBBLESTONE;
    }

    public static Sound findSound(String string, Sound sound) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return sound;
            }
        }
    }

    public static Sound findSound(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            return Sound.valueOf((String)"CLICK");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Sound.valueOf((String)"UI_BUTTON_CLICK");
        }
    }

    public static List<EntityType> getEntityTypes(String ... stringArray) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : stringArray) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List<EntityType> getEntityTypes(List<String> list) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : list) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LocalUtils.logp("&cInvalid entity type: " + string.toUpperCase());
            }
        }
        return arrayList;
    }

    public static String firstCase(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string.length() <= 1) {
            return string2.toUpperCase();
        }
        return string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase();
    }

    public static void setSkullName(AlonsoUtils.ServerVersion serverVersion, NBTCompound nBTCompound, String string) {
        if (serverVersion.getWeight() == AlonsoUtils.ServerVersion.v1_8.getWeight()) {
            nBTCompound.setString("Name", string);
        }
    }

    public static void setSkullName(AlonsoUtils.ServerVersion serverVersion, NBTCompound nBTCompound) {
        LocalUtils.setSkullName(serverVersion, nBTCompound, "AlonsoAliaga");
    }

    @Nullable
    public static Location decodeLocation(String string) {
        if (string == null) {
            return null;
        }
        try {
            String[] stringArray = string.split("\\|");
            World world = Bukkit.getWorld((String)stringArray[0]);
            if (world == null) {
                return null;
            }
            return new Location(world, Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, packetContainer);
        }
        catch (Exception exception) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to %s", "[BetterBackpacks] ", player.getName()));
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Collection<Player> collection, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            for (Player player : collection) {
                protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (Exception exception) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to players.", "[BetterBackpacks] "));
        }
    }

    public static void sendBungeeActionBar(Player player, String string) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            LocalUtils.sendBungeeActionBar(player, string);
        } else if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(alonsoPlugin, player, string);
        } else {
            player.sendMessage(string);
        }
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Collection<Player> collection, String string) {
        if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            for (Player player : collection) {
                LocalUtils.sendBungeeActionBar(player, string);
            }
        } else if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(alonsoPlugin, collection, string);
        } else {
            for (Player player : collection) {
                player.sendMessage(string);
            }
        }
    }

    @Nullable
    public static String encodeLocation(Location location) {
        if (location == null) {
            return null;
        }
        try {
            String string = "%s|%s|%s|%s|%s|%s";
            return String.format(string, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void send(CommandSender commandSender, String string) {
        commandSender.sendMessage(LocalUtils.colorize(string));
    }

    public static Collection<Material> getMaterials(String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return Stream.of(Material.values()).filter(material -> list.contains(material.name())).collect(Collectors.toList());
    }

    public static List<Material> getMaterials(List<String> list) {
        return Stream.of(Material.values()).filter(material -> list.contains(material.name())).collect(Collectors.toList());
    }

    public static List<Location> getLocationsInLine(Location location, Location location2) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        int n = 0;
        while ((double)n < d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
            ++n;
        }
        return arrayList;
    }

    public static List<Location> getLocationsInLine(Location location, Location location2, double d) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d2 = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        for (double d3 = 0.0; d3 < d2; d3 += d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
        }
        return arrayList;
    }

    public static String getDuration(long l) {
        return LocalUtils.getDuration(l, false);
    }

    public static String getDuration(long l, boolean bl) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (l > 86399999L) {
            return Math.abs(l5) + "d " + Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 59999L || !bl) {
            return Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        long l6 = Math.abs(l2) % 60L;
        return (l6 <= 0L ? 1L : l6) + "s";
    }

    public static String getWatchDuration(long l) {
        return LocalUtils.getWatchDuration(l, true);
    }

    public static String getWatchDuration(long l, boolean bl) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (bl) {
            if (l > 86399999L) {
                long l6 = Math.abs(l5);
                long l7 = Math.abs(l4 % 24L);
                long l8 = Math.abs(l3 % 60L);
                long l9 = Math.abs(l2 % 60L);
                return (l6 < 10L ? "0" + l6 : Long.valueOf(l7)) + ":" + (l7 < 10L ? "0" + l7 : Long.valueOf(l7)) + ":" + (l8 < 10L ? "0" + l8 : Long.valueOf(l8)) + ":" + (l9 < 10L ? "0" + l9 : Long.valueOf(l9));
            }
            if (l > 1439999L) {
                long l10 = Math.abs(l4 % 24L);
                long l11 = Math.abs(l3 % 60L);
                long l12 = Math.abs(l2 % 60L);
                return (l10 < 10L ? "0" + l10 : Long.valueOf(l10)) + ":" + (l11 < 10L ? "0" + l11 : Long.valueOf(l11)) + ":" + (l12 < 10L ? "0" + l12 : Long.valueOf(l12));
            }
            long l13 = Math.abs(l3) % 60L;
            long l14 = Math.abs(l2) % 60L;
            return (l13 < 10L ? "0" + l13 : Long.valueOf(l13)) + ":" + (l14 < 10L ? "0" + l14 : Long.valueOf(l14));
        }
        if (l > 86399999L) {
            return Math.abs(l5) + ":" + Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        return Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
    }

    public static String random(List<String> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E randomNbt(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void setUUID(NBTCompound nBTCompound, String string, UUID uUID) {
        if (AlonsoUtils.serverVersion.isOlderThan(AlonsoUtils.ServerVersion.v1_16)) {
            nBTCompound.setString(string, uUID.toString());
        } else {
            nBTCompound.setUUID(string, uUID);
        }
    }

    public static LivingEntity getLivingEntityAround(Player player, UUID uUID, int n, int n2) {
        Optional<Entity> optional = player.getNearbyEntities((double)n2, (double)n2, (double)n2).stream().filter(entity -> entity instanceof LivingEntity && entity.getEntityId() == n).findFirst();
        return optional.orElse(null);
    }

    public static TextComponent createClickable(@Nonnull String string, HoverEvent.Action action, @Nullable String string2, ClickEvent.Action action2, String string3) {
        TextComponent textComponent = new TextComponent(LocalUtils.colorize(string));
        if (string2 != null && action != null) {
            if (oldHoverMethod) {
                textComponent.setHoverEvent(new HoverEvent(action, new ComponentBuilder(LocalUtils.colorize(string2)).create()));
            } else {
                textComponent.setHoverEvent(new HoverEvent(action, new Content[]{new Text(LocalUtils.colorize(string2))}));
            }
        }
        if (string3 != null && action2 != null) {
            textComponent.setClickEvent(new ClickEvent(action2, string3));
        }
        return textComponent;
    }

    public static void sendTitle(Player player, String string, String string2, int n, int n2, int n3) {
        if (oldSendTitleMethod) {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2));
        } else {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2), n, n2, n3);
        }
    }

    public static void sendTitle(Player player, String string, String string2) {
        LocalUtils.sendTitle(player, string, string2, 15, 30, 15);
    }

    public static ItemMeta setUnbreakable(ItemMeta itemMeta, boolean bl) {
        block5: {
            if (newSetUnbreakableMethod) {
                itemMeta.setUnbreakable(bl);
            } else if (setUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    METHOD_SET_UNBREAKABLE_OLD.invoke(object, bl);
                }
                catch (Throwable throwable) {
                    if (!BetterBackpacks.getInstance().debugMode) break block5;
                    LocalUtils.loge("Reflections for setUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return itemMeta;
    }

    public static boolean isUnbreakable(ItemMeta itemMeta) {
        block4: {
            if (newSetUnbreakableMethod) {
                return itemMeta.isUnbreakable();
            }
            if (setUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    return (Boolean)METHOD_IS_UNBREAKABLE_OLD.invoke(object, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!BetterBackpacks.getInstance().debugMode) break block4;
                    LocalUtils.loge("Reflections for isUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return false;
    }

    public static String fixInventoryTitle(String string) {
        return longInventoryTitleSupport ? string : (string.length() > 32 ? string.substring(0, 32) : string);
    }

    public static void findClasses(String string, String ... stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            try {
                Class.forName(string2);
                bl = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (!bl) {
            Class.forName(string);
        }
    }

    public static ItemStack createItem(ConfigurationSection configurationSection, Material material) {
        ItemMeta itemMeta;
        ItemStack itemStack;
        String string = configurationSection.getString("Material");
        if (string.equalsIgnoreCase("custom_head")) {
            if (ItemUtils.isCustomHeadSupported()) {
                itemStack = ItemUtils.buildHead(configurationSection.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
            } else {
                itemStack = new ItemStack(material);
                LocalUtils.loge("CUSTOM_HEAD is not support for '" + configurationSection.getName() + "' section. Using '" + material.name() + "'");
            }
        } else {
            itemMeta = string.split(":");
            Material material2 = LocalUtils.findMaterialOrDefault(itemMeta[0], material);
            if (((ItemMeta)itemMeta).length >= 2) {
                if (LocalUtils.isInteger((String)itemMeta[1])) {
                    int n = Integer.parseInt((String)itemMeta[1]);
                    itemStack = LocalUtils.createDurabilityItem(material2, n);
                } else {
                    itemStack = new ItemStack(material2);
                }
            } else {
                itemStack = new ItemStack(material2);
            }
        }
        itemMeta = itemStack.getItemMeta();
        if (configurationSection.contains("Displayname")) {
            itemMeta.setDisplayName(LocalUtils.colorize(configurationSection.getString("Displayname")));
        }
        if (configurationSection.contains("Lore")) {
            itemMeta.setLore(LocalUtils.colorize(configurationSection.getStringList("Lore")));
        }
        if (configurationSection.contains("Custom-model-data") && BetterBackpacks.getInstance().getPluginUtils().isCustomModelSupported()) {
            itemMeta.setCustomModelData(Integer.valueOf(Math.max(0, configurationSection.getInt("Custom-model-data", 0))));
        }
        if (configurationSection.contains("Unbreakable")) {
            LocalUtils.setUnbreakable(itemMeta, configurationSection.getBoolean("Unbreakable", false));
        }
        itemStack.setItemMeta(itemMeta);
        if (configurationSection.contains("Glow")) {
            itemStack.addUnsafeEnchantment(Enchantment.LURE, 1);
        }
        return itemStack;
    }

    public static ItemStack createOnlyDurability(Material material, int n) {
        if (oldItemStackSupport) {
            try {
                return (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (short)n);
            }
            catch (Throwable throwable) {
                if (BetterBackpacks.getInstance().debugMode) {
                    LocalUtils.loge("Error creating new instance for ItemStack using reflections..");
                    throwable.printStackTrace();
                }
                return new ItemStack(material);
            }
        }
        return new ItemStack(material);
    }

    public static ItemStack createDurabilityItem(Material material, int n) {
        if (oldItemStackSupport) {
            try {
                return (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (short)n);
            }
            catch (Throwable throwable) {
                if (BetterBackpacks.getInstance().debugMode) {
                    LocalUtils.loge("Error creating new instance for ItemStack using reflections..");
                    throwable.printStackTrace();
                }
                return new ItemStack(material);
            }
        }
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(n);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static ItemStack createColored(ConfigurationSection configurationSection) {
        return LocalUtils.createColored(configurationSection, Color.WHITE);
    }

    public static ItemStack createColored(ConfigurationSection configurationSection, DyeableType dyeableType, Color color) {
        String string = configurationSection.getString("Dyeable-type", "GLASS_PANE");
        DyeableType dyeableType2 = DyeableType.fromString(string, dyeableType);
        ItemStack itemStack = dyeableType2.getItemStack(Color.getByName(configurationSection.getString("Color", "WHITE"), color));
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (configurationSection.contains("Displayname")) {
            itemMeta.setDisplayName(LocalUtils.colorize(configurationSection.getString("Displayname")));
        }
        if (configurationSection.contains("Lore")) {
            itemMeta.setLore(LocalUtils.colorize(configurationSection.getStringList("Lore")));
        }
        if (configurationSection.contains("Custom-model-data") && BetterBackpacks.getInstance().getPluginUtils().isCustomModelSupported()) {
            itemMeta.setCustomModelData(Integer.valueOf(Math.max(0, configurationSection.getInt("Custom-model-data", 0))));
        }
        if (configurationSection.contains("Unbreakable")) {
            LocalUtils.setUnbreakable(itemMeta, configurationSection.getBoolean("Unbreakable", false));
        }
        itemStack.setItemMeta(itemMeta);
        if (configurationSection.contains("Glow")) {
            itemStack.addUnsafeEnchantment(Enchantment.LURE, 1);
        }
        return itemStack;
    }

    public static ItemStack createColored(ConfigurationSection configurationSection, Color color) {
        return LocalUtils.createColored(configurationSection, DyeableType.GLASS_PANE, color);
    }

    public static String setPlaceholders(Player player, String string) {
        return papiSupport ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string;
    }

    public static List<String> setPlaceholders(Player player, List<String> list) {
        return papiSupport ? PlaceholderAPI.setPlaceholders((Player)player, list) : list;
    }

    public static void setSkullOwner(Player player, SkullMeta skullMeta) {
        block4: {
            if (owningPlayerSupport) {
                skullMeta.setOwningPlayer((OfflinePlayer)player);
            } else {
                try {
                    METHOD_SET_OWNER.invoke((Object)skullMeta, player.getName());
                }
                catch (Throwable throwable) {
                    LocalUtils.loge("Error setting skull meta owner using reflections. (This shouldn't happen)");
                    if (!BetterBackpacks.getInstance().debugMode) break block4;
                    LocalUtils.loge("Following stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static void setSkullOwner(String string, UUID uUID, SkullMeta skullMeta) {
        block6: {
            if (owningPlayerSupport) {
                try {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
                    skullMeta.setOwningPlayer(offlinePlayer);
                }
                catch (Throwable throwable) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                    skullMeta.setOwningPlayer(offlinePlayer);
                }
            } else {
                try {
                    METHOD_SET_OWNER.invoke((Object)skullMeta, string);
                }
                catch (Throwable throwable) {
                    LocalUtils.loge("Error setting skull meta owner using reflections. (This shouldn't happen)");
                    if (!BetterBackpacks.getInstance().debugMode) break block6;
                    LocalUtils.loge("Following stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
            }
        }
    }

    static {
        Object object;
        ItemMeta itemMeta;
        ItemStack itemStack;
        Object object2;
        METHOD_SET_UNBREAKABLE_OLD = null;
        METHOD_IS_UNBREAKABLE_OLD = null;
        METHOD_SET_OWNER = null;
        METHOD_ITEM_META_SPIGOT = null;
        papiSupport = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        CONSTRUCTOR_ITEM_STACK_OLD = null;
        try {
            SkullMeta.class.getMethod("setOwningPlayer", OfflinePlayer.class);
            owningPlayerSupport = true;
            LocalUtils.logp("New setOwningPlayer method is available!");
        }
        catch (Throwable throwable) {
            owningPlayerSupport = false;
            try {
                METHOD_SET_OWNER = SkullMeta.class.getMethod("setOwner", String.class);
                LocalUtils.logp("New setOwningPlayer method is NOT available! setOwner is available!");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LocalUtils.logp("New setOwningPlayer method is NOT available! setOwner is NOT available either!");
            }
        }
        try {
            CONSTRUCTOR_ITEM_STACK_OLD = ItemStack.class.getConstructor(Material.class, Integer.TYPE, Short.TYPE);
            oldItemStackSupport = true;
            LocalUtils.logp("Old ItemStack constructor is available!");
        }
        catch (Throwable throwable) {
            oldItemStackSupport = false;
            LocalUtils.logp("Old ItemStack constructor is not available!");
        }
        try {
            object2 = Bukkit.createInventory(null, (int)9, (String)"Hello Thanks For Downloading My Plugin. Consider donating to support my work on https://alonsoaliaga.com/donate");
            object2.setItem(0, new ItemStack(Materials.PLAYER_HEAD.getMaterial()));
            longInventoryTitleSupport = true;
            LocalUtils.logp("Inventory title with support for more than 32 characters. Skipping..");
        }
        catch (Throwable throwable) {
            longInventoryTitleSupport = false;
            LocalUtils.logp("Inventory title without support for more than 32 characters. Limiting..");
        }
        try {
            object2 = Class.forName("net.md_5.bungee.api.ChatColor");
            ((Class)object2).getDeclaredMethod("of", String.class);
            hexColorSupport = true;
            LocalUtils.logp("Hex colors are available! Ready for RGB..");
        }
        catch (Throwable throwable) {
            hexColorSupport = false;
            LocalUtils.logp("Hex colors are not available! Ignoring..");
        }
        try {
            HoverEvent.class.getDeclaredConstructor(HoverEvent.Action.class, BaseComponent[].class);
            oldHoverMethod = true;
            LocalUtils.logp("Old constructor for HoverEvent found! Using it..");
        }
        catch (Throwable throwable) {
            oldHoverMethod = false;
            LocalUtils.logp("Old constructor for HoverEvent not found! Using the new one..");
        }
        try {
            Player.class.getDeclaredMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            oldSendTitleMethod = false;
            LocalUtils.logp("New sendTitle method found! Using it..");
        }
        catch (Throwable throwable) {
            oldSendTitleMethod = true;
            LocalUtils.logp("New sendTitle method not found! Using the old one..");
        }
        try {
            ItemMeta.class.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
            newSetUnbreakableMethod = true;
            setUnbreakableSupport = true;
            LocalUtils.logp("New setUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                itemStack = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                itemMeta = itemStack.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                METHOD_SET_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("setUnbreakable", Boolean.TYPE);
                itemStack.setItemMeta(itemMeta);
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = true;
                LocalUtils.logp("New setUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable2) {
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support setUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            ItemMeta.class.getDeclaredMethod("isUnbreakable", new Class[0]);
            newIsUnbreakableMethod = true;
            isUnbreakableSupport = true;
            LocalUtils.logp("New isUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                itemStack = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                itemMeta = itemStack.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                METHOD_SET_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("isUnbreakable", new Class[0]);
                itemStack.setItemMeta(itemMeta);
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = true;
                LocalUtils.logp("New isUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable3) {
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support isUnbreakable method. Consider using spigot/paper!");
            }
        }
        suffixes = new TreeMap<Long, String>();
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

