/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.metrics;

import java.util.concurrent.atomic.AtomicLong;
import me.angeschossen.betterfarming.hikari.util.ClockSource;

public abstract class PoolStats {
    private final AtomicLong RLHXh;
    private final long HXvGq;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;
    protected volatile int maxConnections;
    protected volatile int minConnections;

    public PoolStats(long l) {
        this.HXvGq = l;
        this.RLHXh = new AtomicLong();
    }

    public int getTotalConnections() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.totalConnections;
    }

    public int getIdleConnections() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.idleConnections;
    }

    public int getActiveConnections() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.activeConnections;
    }

    public int getPendingThreads() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.pendingThreads;
    }

    public int getMaxConnections() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.maxConnections;
    }

    public int getMinConnections() {
        if (this.RLHXh()) {
            this.update();
        }
        return this.minConnections;
    }

    protected abstract void update();

    private boolean RLHXh() {
        long l;
        long l2;
        do {
            l = ClockSource.currentTime();
            l2 = this.RLHXh.get();
            if (l2 <= l) continue;
            return false;
        } while (!this.RLHXh.compareAndSet(l2, ClockSource.plusMillis(l, this.HXvGq)));
        return true;
    }
}

