/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import me.angeschossen.betterfarming.hikari.metrics.IMetricsTracker;
import me.angeschossen.betterfarming.hikari.metrics.PoolStats;

public class MicrometerMetricsTracker
implements IMetricsTracker {
    public static final String HIKARI_METRIC_NAME_PREFIX = "hikaricp";
    private static final String RLHXh = "pool";
    private static final String HXvGq = "hikaricp.connections.acquire";
    private static final String pdjAO = "hikaricp.connections.usage";
    private static final String UhzX = "hikaricp.connections.creation";
    private static final String Dgduf = "hikaricp.connections.timeout";
    private static final String ztTjN = "hikaricp.connections";
    private static final String JHesM = "hikaricp.connections.idle";
    private static final String igzHW = "hikaricp.connections.active";
    private static final String SknVT = "hikaricp.connections.pending";
    private static final String lGdKv = "hikaricp.connections.max";
    private static final String DFkJL = "hikaricp.connections.min";
    private final Timer BdHcv;
    private final Counter OvlG;
    private final Timer AgSRZ;
    private final Timer cKfg;
    private final Gauge rndpt;
    private final Gauge Vjrip;
    private final Gauge ygtt;
    private final Gauge VRYJH;
    private final Gauge wybtH;
    private final Gauge wGVzD;
    private final MeterRegistry AEoc;
    private final PoolStats XOcdi;

    MicrometerMetricsTracker(String string, PoolStats poolStats, MeterRegistry meterRegistry) {
        this.XOcdi = poolStats;
        this.AEoc = meterRegistry;
        this.BdHcv = Timer.builder((String)HXvGq).description("Connection acquire time").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.cKfg = Timer.builder((String)UhzX).description("Connection creation time").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.AgSRZ = Timer.builder((String)pdjAO).description("Connection usage time").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.OvlG = Counter.builder((String)Dgduf).description("Connection timeout total count").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.rndpt = Gauge.builder((String)ztTjN, (Object)poolStats, PoolStats::getTotalConnections).description("Total connections").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.Vjrip = Gauge.builder((String)JHesM, (Object)poolStats, PoolStats::getIdleConnections).description("Idle connections").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.ygtt = Gauge.builder((String)igzHW, (Object)poolStats, PoolStats::getActiveConnections).description("Active connections").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.VRYJH = Gauge.builder((String)SknVT, (Object)poolStats, PoolStats::getPendingThreads).description("Pending threads").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.wybtH = Gauge.builder((String)lGdKv, (Object)poolStats, PoolStats::getMaxConnections).description("Max connections").tags(new String[]{RLHXh, string}).register(meterRegistry);
        this.wGVzD = Gauge.builder((String)DFkJL, (Object)poolStats, PoolStats::getMinConnections).description("Min connections").tags(new String[]{RLHXh, string}).register(meterRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.BdHcv.record(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.AgSRZ.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordConnectionTimeout() {
        this.OvlG.increment();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.cKfg.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.AEoc.remove((Meter)this.BdHcv);
        this.AEoc.remove((Meter)this.OvlG);
        this.AEoc.remove((Meter)this.AgSRZ);
        this.AEoc.remove((Meter)this.cKfg);
        this.AEoc.remove((Meter)this.rndpt);
        this.AEoc.remove((Meter)this.Vjrip);
        this.AEoc.remove((Meter)this.ygtt);
        this.AEoc.remove((Meter)this.VRYJH);
        this.AEoc.remove((Meter)this.wybtH);
        this.AEoc.remove((Meter)this.wGVzD);
    }
}

