/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.packets;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bukkit.Location;
import org.bukkit.World;

public class BlockChangeArray {
    private static final int RECORD_SIZE = 4;
    private int[] data;

    public BlockChangeArray(int n) {
        this.data = new int[n];
    }

    public BlockChangeArray(byte[] byArray) {
        if (byArray.length % 4 != 0) {
            throw new IllegalArgumentException("The lenght of the input data array should be a multiple of 4.");
        }
        IntBuffer intBuffer = ByteBuffer.wrap(byArray).asIntBuffer();
        IntBuffer intBuffer2 = IntBuffer.allocate(byArray.length / 4);
        intBuffer2.put(intBuffer);
        this.data = intBuffer2.array();
    }

    public BlockChange getBlockChange(int n) {
        if (n < 0 || n >= this.getSize()) {
            throw new IllegalArgumentException("Index is out of bounds.");
        }
        return new BlockChange(n);
    }

    public void setBlockChange(int n, BlockChange blockChange) {
        if (blockChange == null) {
            throw new IllegalArgumentException("Block change cannot be NULL.");
        }
        this.data[n] = blockChange.asInteger();
    }

    public int getSize() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.data.length * 4);
        byteBuffer.asIntBuffer().put(this.data);
        return byteBuffer.array();
    }

    public class BlockChange {
        private final int index;

        private BlockChange(int n) {
            this.index = n;
        }

        public BlockChange setLocation(Location location) {
            this.setRelativeX(location.getBlockX() & 0xF);
            this.setRelativeZ(location.getBlockZ() & 0xF);
            this.setAbsoluteY(location.getBlockY());
            return this;
        }

        public Location getLocation(World world, int n, int n2) {
            if (world == null) {
                throw new IllegalArgumentException("World cannot be NULL.");
            }
            return new Location(world, (double)((n << 4) + this.getRelativeX()), (double)this.getAbsoluteY(), (double)((n2 << 4) + this.getRelativeZ()));
        }

        public BlockChange setRelativeX(int n) {
            this.setValue(n, 28, -268435456);
            return this;
        }

        public int getRelativeX() {
            return this.getValue(28, -268435456);
        }

        public BlockChange setRelativeZ(int n) {
            this.setValue(n, 24, 0xF000000);
            return this;
        }

        public byte getRelativeZ() {
            return (byte)this.getValue(24, 0xF000000);
        }

        public BlockChange setAbsoluteY(int n) {
            this.setValue(n, 16, 0xFF0000);
            return this;
        }

        public int getAbsoluteY() {
            return this.getValue(16, 0xFF0000);
        }

        public BlockChange setBlockID(int n) {
            this.setValue(n, 4, 65520);
            return this;
        }

        public int getBlockID() {
            return this.getValue(4, 65520);
        }

        public BlockChange setMetadata(int n) {
            this.setValue(n, 0, 15);
            return this;
        }

        public int getMetadata() {
            return this.getValue(0, 15);
        }

        public int getIndex() {
            return this.index;
        }

        private int asInteger() {
            return BlockChangeArray.this.data[this.index];
        }

        private void setValue(int n, int n2, int n3) {
            ((BlockChangeArray)BlockChangeArray.this).data[this.index] = n << n2 & n3 | BlockChangeArray.this.data[this.index] & ~n3;
        }

        private int getValue(int n, int n2) {
            return (BlockChangeArray.this.data[this.index] & n2) >> n;
        }
    }
}

