/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DeathMessages;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.DeathMessages.CMIDeathType;
import com.Zrips.CMI.Modules.DeathMessages.DeathMessages;
import com.Zrips.CMI.utils.FileDownloader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.RawMessages.RawMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DeathMessageManager {
    private CMI plugin;
    HashMap<String, DeathMessages> messages = new HashMap();
    private List<String> playerHover = new ArrayList<String>();
    private List<String> killerHover = new ArrayList<String>();
    private List<String> disabledWorlds = new ArrayList<String>();
    private List<String> mutedWorlds = new ArrayList<String>();
    private List<String> ignoredPlayers = new ArrayList<String>();
    private String prefix = "";
    private long spamTimeRange = 30000L;
    private int spamCount = 3;
    private HashMap<UUID, List<Long>> spamProtection = new HashMap();
    private boolean enabled = false;
    private int autoHideFrom = -1;
    private int range = -1;
    private String destination = "plain";

    public DeathMessageManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void relocateDeathMessageLocaleFiles() {
        File file;
        File file2 = new File(this.plugin.getDataFolder(), "Translations" + File.separator + "DeathMessages");
        if (!file2.isDirectory()) {
            file2.mkdir();
        }
        if ((file = new File(this.plugin.getDataFolder(), "Settings" + File.separator + "DeathMessages")).isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray[n2];
                File file4 = new File(file2, String.valueOf(file3.getName().substring(0, 1).toUpperCase()) + file3.getName().substring(1, file3.getName().length()));
                if (!file4.isFile()) {
                    file3.renameTo(file4);
                }
                ++n2;
            }
            file.delete();
        }
    }

    public void defaultLocaleDownloader() {
        try {
            List<String> list2 = Arrays.asList("ES", "EN");
            String object2 = null;
            boolean bl = true;
            try {
                File object4 = new File(this.plugin.getDataFolder(), "config.yml");
                if (object4.isFile()) {
                    YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)object4);
                    bl = yamlConfiguration.getBoolean("LanguageDownload", true);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (!bl) {
                return;
            }
            for (String string : list2) {
                File file = new File(this.plugin.getDataFolder() + File.separator + "Translations" + File.separator + "DeathMessages", "Locale_" + string + ".yml");
                if (file.isFile()) continue;
                object2 = string;
            }
            final String string = object2;
            for (final String string2 : list2) {
                File file = new File(this.plugin.getDataFolder() + File.separator + "Translations" + File.separator + "DeathMessages", "Locale_" + string2 + ".yml");
                if (file.isFile()) continue;
                FileDownloader fileDownloader = new FileDownloader(){

                    @Override
                    public void afterDownload() {
                        CMI.getInstance().consoleMessage("Downloaded Death Messages Locale_" + string2 + ".yml file");
                        if (string != null && string2.equalsIgnoreCase(string)) {
                            CMI.getInstance().getConfigManager().reloadLanguage();
                        }
                    }
                };
                fileDownloader.downloadUsingStream("https://raw.githubusercontent.com/Zrips/CMI/master/Settings/DeathMessages/Locale_" + string2 + ".yml", file.getPath());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void load() {
        this.loadConfig();
        this.loadLocale();
    }

    private void loadConfig() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "DeathMessages.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        ConfigReader configReader2 = this.plugin.getConfigManager().getConfig();
        if (configReader2.getC().isInt("Messages.DeathMessage.AutoHideFrom") && !configReader.getC().isInt("AutoHideFrom")) {
            configReader.set("AutoHideFrom", (Object)configReader2.getC().getInt("Messages.DeathMessage.AutoHideFrom"));
            configReader.save();
            try {
                configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "DeathMessages.yml");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        configReader.addComment("EnableCustom", new String[]{"Enable or disable custom death messages", "Check DeathMessages dirrectory for message options", "", "Not all death situations might be included and future updates might be needed", "Report any missing death situation you encountered to github issue section with exact way to reproduce death situation"});
        this.enabled = configReader.get("EnableCustom", Boolean.valueOf(false));
        configReader.addComment("AutoHideFrom", new String[]{"Defines number of players from which to automatically start hiding death messages", "Set to -1 to disable this"});
        this.autoHideFrom = configReader.get("AutoHideFrom", -1);
        configReader.addComment("Range", new String[]{"Range in blocks we should broadcast players death message", "Setting this to any range will automatically exclude players in other worlds"});
        this.range = configReader.get("Range", -1);
        configReader.addComment("Destination", new String[]{"Where should we should death message", "Options: plain, actionBar"});
        this.destination = configReader.get("Destination", "plain");
        configReader.addComment("DisabledWorlds", new String[]{"List of worlds where deaths from them are never announced"});
        this.disabledWorlds = configReader.get("DisabledWorlds", Arrays.asList(""));
        CMIList.toLowerCase(this.disabledWorlds);
        configReader.addComment("MutedWorlds", new String[]{"List of worlds where deaths are not announced to players"});
        this.mutedWorlds = configReader.get("MutedWorlds", Arrays.asList(""));
        CMIList.toLowerCase(this.mutedWorlds);
        configReader.addComment("IgnoredPlayers", new String[]{"List of player names we should ignore and not show their death messages"});
        this.ignoredPlayers = configReader.get("IgnoredPlayers", Arrays.asList(""));
        CMIList.toLowerCase(this.ignoredPlayers);
        configReader.addComment("AntiSpam.TimeRange", new String[]{"Time range in seconds we should check when preventing death message spam", "Set to -1 if you want to disable it", "Keep in mind that player who dies will continue to see his own death messages even if its over the limit"});
        this.spamTimeRange = (long)configReader.get("AntiSpam.TimeRange", 30) * 1000L;
        configReader.addComment("AntiSpam.Count", new String[]{"How many death messages we should broadcast from player in previously defined time frame"});
        this.spamCount = configReader.get("AntiSpam.Count", 3);
        configReader.save();
    }

    private void loadLocale() {
        this.defaultLocaleDownloader();
        File file = new File(CMI.getInstance().getDataFolder(), "Translations" + File.separator + "DeathMessages");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Translations" + File.separator + "DeathMessages" + File.separator + "Locale_" + this.plugin.getConfigManager().Lang + ".yml");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (configReader == null && !this.plugin.getConfigManager().Lang.equalsIgnoreCase("EN")) {
            this.plugin.consoleMessage("Failed to load death message (" + this.plugin.getConfigManager().Lang + ") locale file. Trying to default to EN version");
            try {
                configReader = new ConfigReader((Plugin)CMI.getInstance(), "Translations" + File.separator + "DeathMessages" + File.separator + "Locale_EN.yml");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (configReader == null) {
            this.plugin.consoleMessage("Failed to load death message locale file");
            return;
        }
        configReader.addHeaderComments(Arrays.asList("[mobName] - monsters name when its applicable. This can be translated.", "[prevMobName] - monsters name when its applicable. This can be translated.", "[item] - items display name which was used to kill player. If display name isint present then items material name will be used. This can be translated.", "[itemName] - items material name which was used to kill player. This can be translated.", "[playerName] - players who died original name", "[playerDisplayName] - players who died modified name", "[sourceName] - players who caused damage original name", "[sourceDisplayName] - players who caused damage modified name"));
        configReader.addComment("Prefix", new String[]{"Defines prefix for all death messages"});
        this.prefix = configReader.get("Prefix", "\ud83d\udc80");
        configReader.addComment("PlayerHover", new String[]{"Defines hover over infomation about player who died. Use basic placeholders like %cmi_user_name% to include any information you would want", "Set this like to '' if you want to avoid including hover over message"});
        this.playerHover = configReader.get("PlayerHover", Arrays.asList(""));
        if (this.playerHover.size() == 1 && this.playerHover.get(0).isEmpty()) {
            this.playerHover.clear();
        }
        configReader.addComment("KillerHover", new String[]{"Defines hover over infomation about player who killed. Use basic placeholders like %cmi_user_name% to include any information you would want", "Set this like to '' if you want to avoid including hover over message"});
        this.killerHover = configReader.get("KillerHover", Arrays.asList(""));
        if (this.killerHover.size() == 1 && this.killerHover.get(0).isEmpty()) {
            this.killerHover.clear();
        }
        this.messages.clear();
        String string = "Escaping";
        this.addMessages(string, configReader.get(string, Arrays.asList(" &7while escaping &2[sourceDisplayName]", " &7while fighting &2[sourceDisplayName]")));
        string = "RunningAway";
        this.addMessages(string, configReader.get(string, Arrays.asList(" &7while running away from &2[prevMobName]", " &7while fighting &2[prevMobName]")));
        string = "Player.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was killed by &2[sourceDisplayName]", "&2[playerDisplayName] &7died by &2[sourceDisplayName] &7mighty hand", "&2[playerDisplayName] &7was punched to death by &2[sourceDisplayName]")));
        string = "Player.Item";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7died by &2[sourceDisplayName] &7hand who used &2[item]")));
        string = (Object)((Object)CMIDeathType.Player) + ".Projectile";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was shot by &2[sourceDisplayName] &7with &2[type]")));
        string = (Object)((Object)CMIDeathType.Player) + ".Fireball";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was fireballed by &2[sourceDisplayName]")));
        string = (Object)((Object)CMIDeathType.Player) + ".Firework";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7went off with a bang due to &2[sourceDisplayName]")));
        string = (Object)((Object)CMIDeathType.FallingBlocks) + ".Anvil.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was squashed by a falling anvil", "&2[playerDisplayName] &7was crushed by anvil", "&2[playerDisplayName] &7hit anvil with his head")));
        string = (Object)((Object)CMIDeathType.Block) + ".Cactus.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was pricked to death", "&2[playerDisplayName] &7tried to hug cactus")));
        string = (Object)((Object)CMIDeathType.Block) + ".Dispenser.Arrow";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was killed by dispenser with arrows...")));
        string = (Object)((Object)CMIDeathType.Block) + ".Dispenser.Splash_potion";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was splashed all over by dispenser...")));
        string = (Object)((Object)CMIDeathType.Block) + ".Magma_block.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7discovered the floor was lava")));
        string = (Object)((Object)CMIDeathType.Block) + ".Sweet_berry_bush.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was poked to death by a sweet berry bush")));
        string = (Object)((Object)CMIDeathType.Block) + ".Lava.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7tried to swim in lava")));
        string = (Object)((Object)CMIDeathType.Block) + ".Pointed_dripstone.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was impaled on stalagmite")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Block_explosion.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was killed by [Intentional Game Design]")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Starvation.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7starved to death")));
        string = (Object)((Object)CMIDeathType.Projectile) + ".Arrow";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was shot by arrow")));
        string = (Object)((Object)CMIDeathType.Projectile) + ".Spectral_arrow";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was shot by spectral arrow")));
        string = (Object)((Object)CMIDeathType.Projectile) + ".Tipped_arrow";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was shot by tipped arrow")));
        string = (Object)((Object)CMIDeathType.Projectile) + ".Fireball";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was fireballed")));
        string = (Object)((Object)CMIDeathType.Projectile) + ".Firework";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7went off with a bang")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Fall.Low.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7hit the ground too hard")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Fall.High.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7fell from a high place")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Fire.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7went up in flames")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Fire_tick.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7burned to death")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Lightning.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was struck by lightning")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Suffocation.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7suffocated in a wall")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Custom.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7died")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Drowning.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7drowned")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Freeze.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7frozen to death")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Suicide.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7took their own life")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Void.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7fell out of the world")));
        string = (Object)((Object)CMIDeathType.Custom) + ".EndCrystal.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7shattered like a crystal")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Wither.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7withered away")));
        string = (Object)((Object)CMIDeathType.Custom) + ".Fly_into_wall.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7experienced kinetic energy", "&2[playerDisplayName] &7learned what is conservation of momentum")));
        string = (Object)((Object)CMIDeathType.Mob) + ".Primed_tnt.General";
        this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7was blown up")));
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            if (entityType.isAlive() && entityType.isSpawnable()) {
                String string2 = CMIText.firstToUpperCase((String)entityType.toString()).replace(" ", "_");
                string = (Object)((Object)CMIDeathType.Mob) + "." + string2 + ".General";
                this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7killed by &2[mobName]")));
                string = (Object)((Object)CMIDeathType.Mob) + "." + string2 + ".Item";
                this.addMessages(string, configReader.get(string, Arrays.asList("&2[playerDisplayName] &7killed by &2[mobName] &7with &2[item]")));
            }
            ++n2;
        }
        configReader.save();
    }

    private void addMessages(String string, List<String> list2) {
        this.messages.put(string, new DeathMessages(string, list2));
    }

    public String getDeathMessage(String string) {
        DeathMessages deathMessages = this.messages.get(string = string.replace(" ", "_"));
        if (deathMessages != null) {
            return deathMessages.getRandom();
        }
        return null;
    }

    private List<Player> getPlayersFromRange(Location location, int n) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location location2 = player.getLocation();
            if (n < 0) {
                if (this.isInMutedWorld(player.getWorld())) continue;
                arrayList.add(player);
                continue;
            }
            if (location2.getWorld() != location.getWorld() || location2.getBlockX() > location.getBlockX() + n || location2.getBlockX() < location.getBlockX() - n || location2.getBlockY() > location.getBlockY() + n || location2.getBlockY() < location.getBlockY() - n || location2.getBlockZ() > location.getBlockZ() + n || location2.getBlockZ() < location.getBlockZ() - n) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public boolean broadcastDeathMessage(Player player, RawMessage rawMessage) {
        rawMessage.show((CommandSender)Bukkit.getConsoleSender());
        if (this.isInDisabledWorld(player.getWorld())) {
            return false;
        }
        if (this.ignoredPlayers.contains(player.getName().toLowerCase())) {
            return false;
        }
        this.addSpamRecord(player.getUniqueId());
        HashSet<Player> hashSet = new HashSet<Player>();
        boolean bl = this.isUnderSpamCooldown(player.getUniqueId());
        if (!bl) {
            hashSet.add(player);
        } else {
            hashSet.addAll(this.getPlayersFromRange(player.getLocation(), this.range));
        }
        if (this.autoHideFrom > 0 && this.autoHideFrom <= hashSet.size()) {
            return false;
        }
        if (this.destination.equalsIgnoreCase("plain")) {
            rawMessage.show(hashSet);
        } else {
            CMIActionBar.send(new ArrayList(hashSet), (String)rawMessage.getTextOnly());
        }
        return !bl;
    }

    private void addSpamRecord(UUID uUID) {
        if (this.spamTimeRange < 0L) {
            return;
        }
        List list2 = this.spamProtection.getOrDefault(uUID, new ArrayList());
        list2.add(System.currentTimeMillis());
        this.spamProtection.put(uUID, list2);
    }

    private boolean isUnderSpamCooldown(UUID uUID) {
        if (this.spamTimeRange < 0L) {
            return true;
        }
        List list2 = this.spamProtection.getOrDefault(uUID, new ArrayList());
        if (list2.isEmpty()) {
            return true;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            if (l + this.spamTimeRange >= System.currentTimeMillis()) continue;
            iterator.remove();
        }
        return list2.size() <= this.spamCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getAutoHideFrom() {
        return this.autoHideFrom;
    }

    public List<String> getPlayerHover() {
        return new ArrayList<String>(this.playerHover);
    }

    public List<String> getKillerHover() {
        return new ArrayList<String>(this.killerHover);
    }

    private boolean isInMutedWorld(World world2) {
        if (world2 == null || world2.getName() == null) {
            return false;
        }
        return this.isInMutedWorld(world2.getName());
    }

    private boolean isInMutedWorld(String string) {
        return this.mutedWorlds.contains(string.toLowerCase());
    }

    private boolean isInDisabledWorld(World world2) {
        if (world2 == null || world2.getName() == null) {
            return false;
        }
        return this.isInDisabledWorld(world2.getName());
    }

    private boolean isInDisabledWorld(String string) {
        return this.disabledWorlds.contains(string.toLowerCase());
    }

    public String getPrefix() {
        return this.prefix;
    }
}

