/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Enchants;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Enchants.CMIEnchantment;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;

public class EnchantManager {
    private Map<String, Object> maxValues = new HashMap<String, Object>();
    private HashMap<String, Enchantment> disabled = new HashMap();
    private CMI plugin;
    private boolean RequireSpecificPermission;
    private boolean EnforceValidEnchants;
    private boolean PermissionLevelLimit;
    private boolean enchantLimitEnabled = false;
    private String fileName = "DisabledEnchants.yml";

    public EnchantManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Enchanting.enchantLimits.Enabled", new String[]{"By disabling this, no limitation to enchanting will be applied", "This only applies for enchant command not for natural enchanting"});
        this.enchantLimitEnabled = configReader.get("Enchanting.enchantLimits.Enabled", Boolean.valueOf(true));
        Enchantment[] enchantmentArray = Enchantment.values();
        int n = enchantmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchantment enchantment = enchantmentArray[n2];
            try {
                String string;
                if (enchantment != null && (string = enchantment.getName()) != null && !string.isEmpty() && string != " ") {
                    configReader.get("Enchanting.enchantLimits.MaxLevel." + string.toLowerCase(), enchantment.getMaxLevel());
                }
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
        this.maxValues.clear();
        if (this.enchantLimitEnabled && configReader.getC().isConfigurationSection("Enchanting.enchantLimits.MaxLevel")) {
            this.maxValues = configReader.getC().getConfigurationSection("Enchanting.enchantLimits.MaxLevel").getValues(true);
        }
        configReader.addComment("Enchanting.RequireSpecificPermission", new String[]{"When set to true, players will be required to have " + PermissionsManager.CMIPerm.enchantments_$1.getPermission("[enchantName]") + " permission node"});
        this.RequireSpecificPermission = configReader.get("Enchanting.RequireSpecificPermission", Boolean.valueOf(false));
        configReader.addComment("Enchanting.EnforceValidEnchants", new String[]{"When enabled we will only allow to enchant items with valid enchantments", "This can be bypasses with " + PermissionsManager.CMIPerm.command_enchant_bypassinvalid.getPermission() + " permission node"});
        this.EnforceValidEnchants = configReader.get("Enchanting.EnforceValidEnchants", Boolean.valueOf(true));
        configReader.addComment("Enchanting.PermissionLevelLimit", new String[]{"When set to true, players will be required to have " + PermissionsManager.CMIPerm.enchantments_$1_$2.getPermission("[enchantName]", "[maxLevel]") + " permission node to be abble to enchant item to defined max level", "Higest permission will be taken if player has more then one", "Keep in mind that this will not prevent player from enchanting item to lower levels then permission was set too", "And keep in mind that players without defined permission node will have access to level 1 enchants by default"});
        this.PermissionLevelLimit = configReader.get("Enchanting.PermissionLevelLimit", Boolean.valueOf(false));
    }

    public Integer getMaxLevel(Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        String string = enchantment.getName();
        if (string == null) {
            return 0;
        }
        if (string.isEmpty()) {
            return 0;
        }
        if (string == " ") {
            return 0;
        }
        for (Map.Entry<String, Object> entry : this.maxValues.entrySet()) {
            if (!entry.getKey().replace("_", "").equalsIgnoreCase(enchantment.getName().replace("_", ""))) continue;
            return (Integer)entry.getValue();
        }
        return enchantment.getMaxLevel();
    }

    public void reEnableEnchantsOnDisable() {
        for (Map.Entry<String, Enchantment> entry : this.disabled.entrySet()) {
            this.plugin.getRef().manageEnchantment(entry.getValue(), false);
        }
    }

    public void disableEnchantsOnLoad() {
        for (Map.Entry<String, Enchantment> entry : this.disabled.entrySet()) {
            this.plugin.getRef().manageEnchantment(entry.getValue(), true);
        }
    }

    public HashMap<String, Enchantment> getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled(Enchantment enchantment) {
        String string = enchantment.getName();
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return false;
        }
        if (string == " ") {
            return false;
        }
        return this.disabled.containsKey(enchantment.getName());
    }

    public void addDisabled(Enchantment enchantment) {
        String string = enchantment.getName();
        if (string == null) {
            return;
        }
        if (string.isEmpty()) {
            return;
        }
        if (string == " ") {
            return;
        }
        this.disabled.put(enchantment.getName(), enchantment);
    }

    public void removeDisabled(Enchantment enchantment) {
        String string = enchantment.getName();
        if (string == null) {
            return;
        }
        if (string.isEmpty()) {
            return;
        }
        if (string == " ") {
            return;
        }
        this.disabled.remove(enchantment.getName());
    }

    public void loadDisabledEnchants() {
        this.plugin.safeRenameFile("DisabledEnchants.yml", "Saves" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        configReader.addComment("List", new String[]{"List of enchants you want to disable ingame. Optionaly /cmi disableenchant command can be used"});
        List list2 = configReader.get("List", new ArrayList());
        this.disabled.clear();
        for (String string : list2) {
            try {
                String string2;
                Enchantment enchantment = CMIEnchantment.get((String)string);
                if (enchantment == null || (string2 = enchantment.getName()) == null || string2.isEmpty() || string2 == " ") continue;
                this.disabled.put(enchantment.getName(), enchantment);
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
        }
        configReader.save();
    }

    public void updateConfig() {
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Enchantment> entry : this.disabled.entrySet()) {
            try {
                String string = entry.getValue().getName();
                if (string == null || string.isEmpty() || string == " ") continue;
                arrayList.add(entry.getValue().getName());
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
        }
        yamlConfiguration.set("List", arrayList);
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isRequireSpecificPermission() {
        return this.RequireSpecificPermission;
    }

    public boolean isPermissionLevelLimit() {
        return this.PermissionLevelLimit;
    }

    public boolean isEnchantLimitEnabled() {
        return this.enchantLimitEnabled;
    }

    public boolean isEnforceValidEnchants() {
        return this.EnforceValidEnchants;
    }
}

