/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Sheduler;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Sheduler.SchedTime;
import com.Zrips.CMI.Modules.Sheduler.Schedule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SchedulerManager {
    private HashMap<String, Schedule> map = new HashMap();
    private CMI plugin;
    private int autoTimerBukkitId = 0;
    public static final String randomPlayerLabel = "[randomPlayer]";
    private String fileName = "Schedules.yml";
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            try {
                SchedulerManager.this.checkSchedulers();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            SchedulerManager.this.runTimer();
        }
    };

    public SchedulerManager(CMI cMI) {
        this.plugin = cMI;
    }

    public Schedule getSchedule(String string) {
        return this.getSchedule(string, false);
    }

    public Schedule getSchedule(String string, boolean bl) {
        Schedule schedule2 = this.map.get(string.toLowerCase());
        if (schedule2 == null) {
            return null;
        }
        if (!schedule2.isEnabled() && !bl) {
            return null;
        }
        return schedule2;
    }

    public void stop() {
        if (this.autoTimerBukkitId != 0) {
            Bukkit.getScheduler().cancelTask(this.autoTimerBukkitId);
            this.autoTimerBukkitId = 0;
        }
    }

    public void load() {
        Long l = System.currentTimeMillis();
        this.stop();
        CMI.getInstance().safeRenameFile(this.fileName.toLowerCase(), "Settings" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Settings" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + this.fileName);
            configReader.load();
            configReader.getC().options().copyDefaults(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader != null) {
            configReader.header(new ArrayList<String>(Arrays.asList("Scheduler file where you can set commands to be performed in regular intervals or in particular time", "Enabled: (true/false) only schedulers which are enabled will be included", "  There can be 2 types, performed in regular time intervals (in seconds) or on particular time", "Delay: (number) defines how long to wait between each action, 600 means that actions will be performed every 10 minutes", "Randomize: (true/false) if set to true, then only one and random of defined commands will be used. Commands will not repeat untill all of them got used up. Usefull for repeating random announcements", "DuplicateRandomize: (true/false) if set to true, then only one and random of defined commands will be used. Commands might repeat. Usefull for repeating random announcements", "SingleLinear: (true/false) if set to true, then only one of defined commands will be used in a row without repeating until all of them have been executed. Usefull in cases when it needs to be shown in exact order one by one", "PerformOn: section will define particular times when perform commands. First of name should be defined and then additional time frames should be given", "  It can have: Month, Day, Hour, Minute, Second sections. All of them in number format and hours uses 24 hour format", "  Example", "  PerformOn:", "    FirstTimeFrame:", "      Hour: 4", "    SecondTimeFrame:", "      Hour: 22", "      Minute: 30", "  You can use week day names to indicate at which day in a week this sheduler should be performed. Example - Day: Monday", "  This will set commands to be performed on 4 a clock in morning and at 22:30. Good way to control server backups when there is less players online", "Repeat: (true/false) if set to false, action will be performed only once other wise it will be repeated all the time in intervals or on particular time", "MinPlayers: (amount) Will limit minimum player amount there should be online when command performe", "MinPlayersCommands: List of commands to be performed when online player amount is under specified limit", "MaxPlayers: (amount) Will skip scheduler if there is more than defined amount of players", "Feedback: (true/false) if set to false will not show feedback message in console in case there is not enough players to perform this schedule", "Commands: List of commands to be performed when time is correct. ", "  If command starts with msg! and then player name is given, simple message will be sent to that player if he is online.", "  If command starts with broadcast! then message will be sent to everyone on server in simple manear", "  If command starts with actionbar! then all players will get action bar message defined after this variable", "  If command starts with title! then all players will get title message defined after this variable", "  If command starts with subtitle! then all players will get subtitle message defined after this variable", "  If command starts with kickall! then all players will be kicked from server with defined message. Usefull before server stop.", "  If command starts with perm:[permissionNode]! then command will get performed if player has permission node. This will not work when we dont know who is target player. In example: perm:cmi.announce.vip! broadcast! Hello vip guys", "  If command starts with moneycost:[amount]! then command will get performed if player has enough money. ", "  If command starts with expcost:[amount]! then command will get performed if player has enough exp.", "  If command starts with allPlayers! then command will get performed by using everyones who is online name. Command itself need to contain [allPlayers] to indicate where player name needs to be added", "  Insert line with 'delay! 5' to perform rest of commands after 5 seconds from scheduler trigger. This allows to create in example counter before server stop. Check example.", "  [randomPlayer] placeholder can be used to get random online player name who dont have cmi.scheduler.exclude permission node. This can be used to give rewards for random players on particular time. In example: - cmi give [randomPlayer] diamond %rand/1-5% will give rando mamount from 1 to 5 diamonds to random online player", "Supports PlaceHolderAPI variables", "More information about specialized commands can be found at https://www.zrips.net/cmi/commands/specialized/")));
            configReader.save();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Schedule> entry : this.map.entrySet()) {
            arrayList.add(entry.getKey());
        }
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        Map map = yamlConfiguration.getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            Schedule schedule2;
            block71: {
                schedule2 = this.getSchedule((String)entry.getKey());
                if (schedule2 == null) {
                    schedule2 = new Schedule((String)entry.getKey());
                } else {
                    schedule2.reset();
                }
                try {
                    Map map2;
                    block72: {
                        map2 = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
                        if (!map2.containsKey("Enabled") || !((Boolean)map2.get("Enabled")).booleanValue()) {
                            schedule2.setEnabled(false);
                        } else if (map2.containsKey("Enabled") || ((Boolean)map2.get("Enabled")).booleanValue()) {
                            schedule2.setEnabled(true);
                        }
                        if (map2.containsKey("Delay")) {
                            if (map2.get("Delay") instanceof Integer) {
                                schedule2.setDelay(((Integer)map2.get("Delay")).intValue());
                            } else if (map2.get("Delay") instanceof Double) {
                                schedule2.setDelay(((Double)map2.get("Delay")).longValue());
                            }
                            schedule2.setLastPerformedOn();
                        }
                        if (map2.containsKey("Repeat")) {
                            schedule2.setRepeatable((Boolean)map2.get("Repeat"));
                        }
                        if (map2.containsKey("Randomize")) {
                            schedule2.setRandomize((Boolean)map2.get("Randomize"));
                        }
                        if (map2.containsKey("DuplicateRandomize")) {
                            schedule2.setDuplicateRandomize((Boolean)map2.get("DuplicateRandomize"));
                        }
                        if (map2.containsKey("SingleLinear")) {
                            schedule2.setSingleLinear((Boolean)map2.get("SingleLinear"));
                        }
                        if (map2.containsKey("MinPlayers")) {
                            schedule2.setMinPlayer((int)((Integer)map2.get("MinPlayers")));
                        }
                        if (map2.containsKey("MaxPlayers")) {
                            schedule2.setMaxPlayer((int)((Integer)map2.get("MaxPlayers")));
                        }
                        if (map2.containsKey("FeedBack")) {
                            schedule2.setPlayerAmountFeedback((boolean)((Boolean)map2.get("FeedBack")));
                        }
                        if (map2.containsKey("Feedback")) {
                            schedule2.setPlayerAmountFeedback((boolean)((Boolean)map2.get("Feedback")));
                        }
                        if (!map2.containsKey("PerformOn")) break block72;
                        Map map3 = yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".PerformOn").getValues(false);
                        ArrayList<SchedTime> arrayList2 = new ArrayList<SchedTime>();
                        for (Map.Entry entry2 : map3.entrySet()) {
                            SchedTime schedTime;
                            Map map4;
                            block73: {
                                int n;
                                block75: {
                                    block74: {
                                        map4 = yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".PerformOn." + (String)entry2.getKey()).getValues(false);
                                        schedTime = new SchedTime();
                                        if (map4.containsKey("Year")) {
                                            schedTime.setYear((int)((Integer)map4.get("Year")));
                                        }
                                        if (map4.containsKey("Month")) {
                                            schedTime.setMonth((int)((Integer)map4.get("Month")));
                                        }
                                        if (!map4.containsKey("Day")) break block73;
                                        n = -1;
                                        Object v = map4.get("Day");
                                        if (!(v instanceof Integer)) break block74;
                                        n = (Integer)v;
                                        break block75;
                                    }
                                    Calendar calendar = Calendar.getInstance();
                                    Date date = new Date();
                                    calendar.setTime(date);
                                    int n2 = 2;
                                    switch (((String)map4.get("Day")).toLowerCase()) {
                                        case "monday": {
                                            n2 = 2;
                                            break;
                                        }
                                        case "tuesday": {
                                            n2 = 3;
                                            break;
                                        }
                                        case "wednesday": {
                                            n2 = 4;
                                            break;
                                        }
                                        case "thursday": {
                                            n2 = 5;
                                            break;
                                        }
                                        case "friday": {
                                            n2 = 6;
                                            break;
                                        }
                                        case "saturday": {
                                            n2 = 7;
                                            break;
                                        }
                                        case "sunday": {
                                            n2 = 1;
                                        }
                                    }
                                    schedTime.setDayOfWeek(n2);
                                }
                                if (n > 0) {
                                    schedTime.setDay(n);
                                }
                            }
                            if (map4.containsKey("Hour")) {
                                if (map4.get("Hour") instanceof Integer) {
                                    schedTime.setHour((int)((Integer)map4.get("Hour")));
                                } else {
                                    schedTime.setHour(((Double)map4.get("Hour")).intValue());
                                }
                            }
                            if (map4.containsKey("Minute")) {
                                if (map4.get("Minute") instanceof Integer) {
                                    schedTime.setMinute((int)((Integer)map4.get("Minute")));
                                } else {
                                    schedTime.setMinute(((Double)map4.get("Minute")).intValue());
                                }
                            }
                            if (map4.containsKey("Second")) {
                                if (map4.get("Second") instanceof Integer) {
                                    schedTime.setSecond((int)((Integer)map4.get("Second")));
                                } else {
                                    schedTime.setSecond(((Double)map4.get("Second")).intValue());
                                }
                            }
                            arrayList2.add(schedTime);
                        }
                        schedule2.setTime(arrayList2);
                    }
                    if (map2.containsKey("Commands")) {
                        schedule2.setCommands((List)map2.get("Commands"));
                    }
                    if (!map2.containsKey("MinPlayersCommands")) break block71;
                    schedule2.setMinPlayerCommands((List)map2.get("MinPlayersCommands"));
                }
                catch (Exception exception) {
                    CMIMessages.consoleMessage((String)("Cant load schedule (" + (String)entry.getKey() + ") "));
                    exception.printStackTrace();
                    continue;
                }
            }
            if (schedule2.getCommands().isEmpty()) {
                CMIMessages.consoleMessage((String)("Cant load schedule (" + (String)entry.getKey() + ") missing commands"));
                continue;
            }
            this.map.put(schedule2.getName().toLowerCase(), schedule2);
            arrayList.remove(schedule2.getName().toLowerCase());
        }
        for (String string : arrayList) {
            this.map.remove(string);
        }
        if (!this.map.isEmpty()) {
            this.plugin.loadMessage(this.map.size(), "schedules", System.currentTimeMillis() - l);
            if (CMIModule.schedule.isEnabled()) {
                this.runTimer();
            }
        }
    }

    private void runTimer() {
        Long l = SchedulerManager.nextIn();
        if (l == null) {
            return;
        }
        if (l <= 50L) {
            if (this.autoTimerBukkitId > 0) {
                Bukkit.getScheduler().cancelTask(this.autoTimerBukkitId);
            }
            if (l < 0L) {
                this.checkSchedulers();
            }
            l = l < 18L ? 18L : l;
            this.autoTimerBukkitId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this.autoTimer, l.longValue());
        } else {
            if (l > 1800000L) {
                l = 1800000L;
            }
            Bukkit.getScheduler().cancelTask(this.autoTimerBukkitId);
            this.autoTimerBukkitId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this.autoTimer, l / 50L + 1L);
        }
    }

    private static Long nextIn() {
        Long l = System.currentTimeMillis();
        Long l2 = Long.MAX_VALUE;
        for (Map.Entry<String, Schedule> entry : CMI.getInstance().getSchedulerManager().getMap().entrySet()) {
            Schedule schedule2 = entry.getValue();
            if (!schedule2.isEnabled()) continue;
            Long l3 = schedule2.getPerformOn();
            if (l2 <= l3) continue;
            l2 = l3;
        }
        return l2 == Long.MAX_VALUE ? null : Long.valueOf(l2 - l);
    }

    public int getActualWeekDay(int n) {
        switch (n) {
            case 1: {
                return 7;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 1;
    }

    private void checkSchedulers() {
        for (Map.Entry<String, Schedule> entry : this.map.entrySet()) {
            Schedule schedule2 = entry.getValue();
            if (!schedule2.isEnabled() || !schedule2.itsTimeToPerform()) continue;
            schedule2.safePerform();
        }
    }

    public HashMap<String, Schedule> getMap() {
        return this.map;
    }
}

