/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import java.util.List;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CMISpawner {
    private Block block;
    private CreatureSpawner spawner = null;

    public CMISpawner(Block block) {
        this.block = block;
        this.spawner = (CreatureSpawner)block.getState();
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockData getBlockData() {
        return this.block.getBlockData();
    }

    public byte getLightLevel() {
        return this.spawner.getLightLevel();
    }

    public Location getLocation() {
        return this.block.getLocation();
    }

    public Material getType() {
        return this.block.getType();
    }

    public World getWorld() {
        return this.block.getWorld();
    }

    public int getX() {
        return this.block.getX();
    }

    public int getY() {
        return this.block.getY();
    }

    public int getZ() {
        return this.block.getZ();
    }

    public void setBlockData(BlockData blockData) {
        this.block.setBlockData(blockData);
    }

    public boolean update() {
        return this.spawner.update();
    }

    public boolean update(boolean bl) {
        return this.spawner.update(bl);
    }

    public boolean update(boolean bl, boolean bl2) {
        return this.spawner.update(bl, bl2);
    }

    public List<MetadataValue> getMetadata(String string) {
        return this.spawner.getMetadata(string);
    }

    public boolean hasMetadata(String string) {
        return this.spawner.hasMetadata(string);
    }

    public void removeMetadata(String string, Plugin plugin) {
        this.spawner.removeMetadata(string, plugin);
    }

    public void setMetadata(String string, MetadataValue metadataValue) {
        this.spawner.setMetadata(string, metadataValue);
    }

    @Deprecated
    public String getCreatureTypeName() {
        return this.spawner.getCreatureTypeName();
    }

    public int getDelay() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getDelay();
        }
        return this.getValue("Delay");
    }

    public int getMaxNearbyEntities() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getMaxNearbyEntities();
        }
        return this.getValue("MaxNearbyEntities");
    }

    public int getMaxSpawnDelay() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getMaxSpawnDelay();
        }
        return this.getValue("MaxSpawnDelay");
    }

    public int getMinSpawnDelay() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getMinSpawnDelay();
        }
        return this.getValue("MinSpawnDelay");
    }

    public int getRequiredPlayerRange() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getRequiredPlayerRange();
        }
        return this.getValue("RequiredPlayerRange");
    }

    public int getSpawnCount() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getSpawnCount();
        }
        return this.getValue("SpawnCount");
    }

    public int getSpawnRange() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return this.spawner.getSpawnRange();
        }
        return this.getValue("SpawnRange");
    }

    private int getValue(String string) {
        Short s = new CMINBT(this.block).getShort(string);
        if (s instanceof Short) {
            return s.shortValue();
        }
        return 0;
    }

    public EntityType getSpawnedType() {
        return this.spawner.getSpawnedType();
    }

    @Deprecated
    public void setCreatureTypeByName(String string) {
        this.spawner.setCreatureTypeByName(string);
    }

    public void setDelay(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setDelay(n);
            return;
        }
        this.updateValue("Delay", n);
    }

    public void setMaxNearbyEntities(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setMaxNearbyEntities(n);
            return;
        }
        this.updateValue("MaxNearbyEntities", n);
    }

    public void setMaxSpawnDelay(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setMaxSpawnDelay(n);
            return;
        }
        this.updateValue("MaxSpawnDelay", n);
    }

    public void setMinSpawnDelay(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setMinSpawnDelay(n);
            return;
        }
        this.updateValue("MinSpawnDelay", n);
    }

    public void setRequiredPlayerRange(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setRequiredPlayerRange(n);
            return;
        }
        this.updateValue("RequiredPlayerRange", n);
    }

    public void setSpawnCount(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setSpawnCount(n);
            return;
        }
        this.updateValue("SpawnCount", n);
    }

    public void setSpawnRange(int n) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            this.spawner.setSpawnRange(n);
            return;
        }
        this.updateValue("SpawnRange", n);
    }

    private void updateValue(String string, int n) {
        Object object = new CMINBT(this.block).setShort(string, Short.valueOf((short)n));
        CMILib.getInstance().getReflectionManager().updateTileEntity(this.getLocation(), object);
        this.spawner.update();
    }

    public void setSpawnedType(EntityType entityType) {
        this.spawner.setSpawnedType(entityType);
    }
}

