/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Jail;

import com.Zrips.CMI.Modules.Jail.CMIJailCell;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.util.HashMap;
import java.util.Map;
import net.Zrips.CMILib.Container.CMILocation;
import org.bukkit.Location;

public class CMIJail {
    private String name;
    private CuboidArea area;
    private CMILocation safeLoc;
    private HashMap<Integer, CMIJailCell> cells = new HashMap();

    public CMIJail() {
        this.area = new CuboidArea(null);
    }

    public boolean containsLoc(Location location) {
        return this.area.containsLoc(location);
    }

    public boolean containsLoc(Location location, int n) {
        return this.area.containsLoc(location, n);
    }

    public CuboidArea getArea() {
        return this.area;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean checkCollision(CuboidArea cuboidArea) {
        return this.area != null && cuboidArea != null && this.area.checkCollision(cuboidArea);
    }

    public CuboidArea loadBounds(String string) {
        if (string == null || !string.contains(":")) {
            throw new Exception("Invalid portal physical location...");
        }
        String[] stringArray = string.split(":");
        try {
            String string2 = stringArray[0];
            double d = Double.parseDouble(stringArray[1]);
            double d2 = Double.parseDouble(stringArray[2]);
            double d3 = Double.parseDouble(stringArray[3]);
            double d4 = Double.parseDouble(stringArray[4]);
            double d5 = Double.parseDouble(stringArray[5]);
            double d6 = Double.parseDouble(stringArray[6]);
            CuboidArea cuboidArea = new CuboidArea(new CMILocation(string2, d, d2, d3), new CMILocation(string2, d4, d5, d6));
            this.setArea(cuboidArea);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Invalid portal physical location...");
        }
        return this.area;
    }

    public void setArea(CuboidArea cuboidArea) {
        this.area = cuboidArea;
    }

    public Location getOutsideLocation() {
        return this.safeLoc;
    }

    @Deprecated
    public void setOutsideLocation(Location location) {
        if (location != null) {
            this.safeLoc = new CMILocation(location);
        }
    }

    public void setOutsideLocation(CMILocation cMILocation) {
        this.safeLoc = cMILocation;
    }

    public HashMap<Integer, CMIJailCell> getCells() {
        return this.cells;
    }

    public void setCells(HashMap<Integer, CMIJailCell> hashMap) {
        this.cells = hashMap;
    }

    public void addCell(CMIJailCell cMIJailCell) {
        if (cMIJailCell.getId() == 0) {
            cMIJailCell.setId(this.getNextCellId());
        }
        this.cells.put(cMIJailCell.getId(), cMIJailCell);
    }

    public int getCountInCells() {
        if (this.cells.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (Map.Entry<Integer, CMIJailCell> entry : this.cells.entrySet()) {
            n += entry.getValue().getJailed().size();
        }
        return n;
    }

    public int getNextCellId() {
        if (this.cells.isEmpty()) {
            return 1;
        }
        int n = 1;
        for (Map.Entry<Integer, CMIJailCell> entry : this.cells.entrySet()) {
            if (entry.getKey() < n) continue;
            n = entry.getKey() + 1;
        }
        return n;
    }
}

