/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InteractiveCommand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Alias.AliasManager;
import com.Zrips.CMI.Modules.InteractiveCommand.CMIInteractiveCommand;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.ic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class InteractiveCommandListener
implements Listener {
    private CMI plugin;
    private static int MAX_ENTRIES = 50;
    public static LinkedHashMap<UUID, Long> limit = new LinkedHashMap<UUID, Long>(MAX_ENTRIES + 1, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, Long> entry) {
            return this.size() > MAX_ENTRIES;
        }
    };

    public InteractiveCommandListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerInteractEvent(final PlayerInteractEvent playerInteractEvent) {
        final Block block = playerInteractEvent.getClickedBlock();
        Action action = playerInteractEvent.getAction();
        if (action != Action.PHYSICAL && action != Action.RIGHT_CLICK_BLOCK && action != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        try {
            if (action != Action.PHYSICAL && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        final CMIInteractiveCommand cMIInteractiveCommand = this.plugin.getInteractiveCommandManager().getByLoc(block.getLocation());
        if (cMIInteractiveCommand == null) {
            return;
        }
        Long l = limit.get(playerInteractEvent.getPlayer().getUniqueId());
        if (l != null && l + 100L > System.currentTimeMillis()) {
            return;
        }
        limit.put(playerInteractEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
        final Player player = playerInteractEvent.getPlayer();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Object object;
                List<String> list2 = cMIInteractiveCommand.getCommands(player);
                if (block.getState() instanceof Sign) {
                    Sign sign = (Sign)block.getState();
                    object = new ArrayList<String>();
                    object.add("");
                    int n = 1;
                    while (n < 4) {
                        if (!sign.getLine(n).isEmpty()) {
                            object.addAll(Arrays.asList(sign.getLine(n).split(" ")));
                        }
                        ++n;
                    }
                    for (String string : list2) {
                        Matcher matcher = AliasManager.patern.matcher(string);
                        if (!matcher.find()) continue;
                        list2 = CMI.getInstance().getAliasManager().updateCommands(null, (List<String>)object, list2);
                        break;
                    }
                }
                int n = 0;
                while (n < list2.size()) {
                    object = list2.get(n);
                    object = ((String)object).replace("[interactedBlock]", CMIMaterial.get((Block)block).toString());
                    object = ((String)object).replace("[interactedBlockX]", String.valueOf(block.getLocation().getBlockX()));
                    object = ((String)object).replace("[interactedBlockY]", String.valueOf(block.getLocation().getBlockY()));
                    object = ((String)object).replace("[interactedBlockZ]", String.valueOf(block.getLocation().getBlockZ()));
                    list2.set(n, (String)object);
                    ++n;
                }
                CMIInteractType cMIInteractType = CMIInteractType.LeftClick;
                switch (playerInteractEvent.getAction()) {
                    case LEFT_CLICK_BLOCK: {
                        if (player.isSneaking()) {
                            cMIInteractType = CMIInteractType.LeftShiftClick;
                            break;
                        }
                        cMIInteractType = CMIInteractType.LeftClick;
                        break;
                    }
                    case RIGHT_CLICK_BLOCK: {
                        if (player.isSneaking()) {
                            cMIInteractType = CMIInteractType.RightShiftClick;
                            break;
                        }
                        cMIInteractType = CMIInteractType.RightClick;
                        break;
                    }
                }
                InteractiveCommandListener.this.plugin.getSpecializedCommandManager().processCmds("CMIIC-" + cMIInteractiveCommand.getName(), list2, player, cMIInteractType);
                cMIInteractiveCommand.updateSignText(block);
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void blockBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIInteractiveCommand cMIInteractiveCommand = this.plugin.getInteractiveCommandManager().getByLoc(blockBreakEvent.getBlock().getLocation());
        if (cMIInteractiveCommand == null) {
            return;
        }
        this.plugin.getInteractiveCommandManager().removeLoc(new CMILocation(blockBreakEvent.getBlock().getLocation()));
    }

    @EventHandler
    public void onSignChangeEvent(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        String[] stringArray = signChangeEvent.getLines();
        String string = stringArray[0];
        if (string.isEmpty()) {
            return;
        }
        Matcher matcher = Config.InteractiveCommandsSignRegex.getMatcher(string);
        if (matcher != null) {
            while (matcher.find()) {
                if (matcher.groupCount() < 2) continue;
                String string2 = matcher.group(2);
                CMIInteractiveCommand cMIInteractiveCommand = this.plugin.getInteractiveCommandManager().getByName(string2);
                if (cMIInteractiveCommand == null) {
                    CMILC.info(ic.class, (CommandSender)player, "dontExist", new Object[0]);
                    return;
                }
                if (!cMIInteractiveCommand.isPublic()) {
                    CMILC.info(ic.class, (CommandSender)player, "notPublicIc", new Object[0]);
                    return;
                }
                if (cMIInteractiveCommand.isSignRequiresPerm() && !PermissionsManager.CMIPerm.interactivesign_$1.hasPermission((CommandSender)player, true, cMIInteractiveCommand.getName())) {
                    signChangeEvent.setCancelled(true);
                    return;
                }
                cMIInteractiveCommand.addLoc(new CMILocation(signChangeEvent.getBlock().getLocation()));
                cMIInteractiveCommand.updateSignText(signChangeEvent.getBlock());
                this.plugin.getInteractiveCommandManager().addInteractiveCommand(cMIInteractiveCommand);
                CMILC.info(ic.class, (CommandSender)player, "createdPublic", "[name]", cMIInteractiveCommand.getName());
            }
        }
    }
}

