/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class NoTargetListener
implements Listener {
    private CMI plugin;
    public static Set<UUID> noTargetPlayers = new HashSet<UUID>();

    public NoTargetListener(CMI cMI) {
        this.plugin = cMI;
    }

    public static boolean isInNoTargetPlayers(UUID uUID) {
        if (noTargetPlayers.isEmpty()) {
            return false;
        }
        return noTargetPlayers.contains(uUID);
    }

    public static void toggleOn(CMIUser cMIUser) {
        Monster monster;
        NoTargetListener.addNoTargetPlayers(cMIUser.getUniqueId());
        if (!cMIUser.isOnline()) {
            return;
        }
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Chunk chunk = cMIUser.getPlayer().getLocation().getChunk();
        int n = -1;
        while (n <= 1) {
            int n2 = -1;
            while (n2 <= 1) {
                monster = chunk.getWorld().getChunkAt(chunk.getX() + n, chunk.getZ() + n2);
                arrayList.addAll(Arrays.asList(monster.getEntities()));
                ++n2;
            }
            ++n;
        }
        for (Entity entity : arrayList) {
            if (!(entity instanceof Monster) || (monster = (Monster)entity).getTarget() == null || !monster.getTarget().getUniqueId().equals(cMIUser.getUniqueId())) continue;
            monster.setTarget(null);
        }
    }

    public static void toggleOff(CMIUser cMIUser) {
        NoTargetListener.removeNoTargetPlayers(cMIUser.getUniqueId());
    }

    public static void addNoTargetPlayers(UUID uUID) {
        noTargetPlayers.add(uUID);
    }

    public static void removeNoTargetPlayers(UUID uUID) {
        noTargetPlayers.remove(uUID);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityTargetLivingEntityEvent(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.isCancelled()) {
            return;
        }
        if (noTargetPlayers.isEmpty()) {
            return;
        }
        if (!(entityTargetLivingEntityEvent.getTarget() instanceof Player)) {
            return;
        }
        if (!NoTargetListener.isInNoTargetPlayers(entityTargetLivingEntityEvent.getTarget().getUniqueId())) {
            return;
        }
        if (!entityTargetLivingEntityEvent.getReason().equals((Object)EntityTargetEvent.TargetReason.CLOSEST_PLAYER) && !entityTargetLivingEntityEvent.getReason().equals((Object)EntityTargetEvent.TargetReason.CLOSEST_ENTITY)) {
            return;
        }
        entityTargetLivingEntityEvent.setCancelled(true);
    }
}

