/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIBanEntry;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;

public class CMIBanRecords {
    private static HashMap<UUID, CMIBanEntry> banCache = new HashMap();

    public static CMIBanEntry getBanEntryRaw(UUID uUID) {
        return banCache.get(uUID);
    }

    public static CMIBanEntry getBanEntry(UUID uUID) {
        return banCache.computeIfAbsent(uUID, uUID2 -> CMIBanRecords.getBanEntry(CMIUser.getUser(uUID), true));
    }

    public static CMIBanEntry addBanEntry(UUID uUID, CMIBanEntry cMIBanEntry) {
        return banCache.put(uUID, cMIBanEntry);
    }

    public static CMIBanEntry removeBanEntry(UUID uUID) {
        return banCache.remove(uUID);
    }

    public static void updateBanEntry(CMIUser cMIUser, BanEntry banEntry) {
        if (banEntry == null) {
            return;
        }
        CMIBanEntry cMIBanEntry = new CMIBanEntry(cMIUser);
        if (banEntry.getSource() != null) {
            cMIBanEntry.setSource(CMI.getInstance().getPlayerManager().getUser(banEntry.getSource()));
        }
        if (banEntry.getCreated() != null) {
            cMIBanEntry.setCreated(banEntry.getCreated() == null ? null : Long.valueOf(banEntry.getCreated().getTime()));
        }
        cMIBanEntry.setExpiration(banEntry.getExpiration() == null ? null : Long.valueOf(banEntry.getExpiration().getTime()));
        cMIBanEntry.setReason(banEntry.getReason() == null || banEntry.getReason().isEmpty() ? CMILC.getIM("ban", "defaultReason", new Object[0]) : CMIChatColor.translate((String)banEntry.getReason()));
        CMIBanRecords.addBanEntry(cMIUser.getUniqueId(), cMIBanEntry);
    }

    public static CMIBanEntry getBanEntry(CMIUser cMIUser, boolean bl) {
        if (cMIUser == null) {
            return null;
        }
        CMIBanEntry cMIBanEntry = CMIBanRecords.getBanEntryRaw(cMIUser.getUniqueId());
        if (cMIBanEntry == null && bl && cMIUser.getName() != null) {
            CMIBanRecords.updateBanEntry(cMIUser, Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(cMIUser.getName()));
        }
        if (cMIBanEntry == null) {
            cMIBanEntry = new CMIBanEntry(cMIUser);
            CMIBanRecords.addBanEntry(cMIUser.getUniqueId(), cMIBanEntry);
        }
        return cMIBanEntry;
    }

    public static CMIUser setBanned(CMIUser cMIUser, String string, CMIUser cMIUser2, Date date, Date date2) {
        CMIBanEntry cMIBanEntry = new CMIBanEntry(cMIUser);
        cMIBanEntry.setSource(cMIUser2);
        if (date2 != null) {
            cMIBanEntry.setCreated(date2.getTime());
        }
        cMIBanEntry.setExpiration(date == null ? -1L : date.getTime());
        cMIBanEntry.setReason(string == null || string.isEmpty() ? CMILC.getIM("ban", "defaultReason", new Snd().setSender(cMIUser2).setTarget(cMIUser)) : CMIChatColor.translate((String)CMI.getInstance().getLM().updateSnd(new Snd().setSender(cMIUser2).setTarget(cMIUser), string)));
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(cMIUser.getName(), cMIBanEntry.getReason(), cMIBanEntry.getExpiration() == -1L ? null : new Date(cMIBanEntry.getExpiration()), cMIBanEntry.getSource());
        if (cMIUser.isOnline()) {
            BanEntry banEntry = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(cMIUser.getName());
            String string2 = CMIBanEntry.getBanMessage(banEntry);
            if (!string2.isEmpty()) {
                cMIUser.getPlayer().kickPlayer(string2);
            } else {
                cMIUser.getPlayer().kickPlayer(cMIBanEntry.getReason().replace("\\n", "\n"));
            }
        }
        CMIBanRecords.addBanEntry(cMIUser.getUniqueId(), cMIBanEntry);
        cMIUser.addForDelayedSave();
        return cMIUser;
    }

    public static CMIUser unBan(CMIUser cMIUser) {
        CMIBanEntry cMIBanEntry = new CMIBanEntry(cMIUser);
        if (cMIUser.getName() != null) {
            try {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(cMIUser.getName());
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        if (cMIUser.getLastIp() != null) {
            try {
                Bukkit.getBanList((BanList.Type)BanList.Type.IP).pardon(cMIUser.getLastIp());
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        CMIBanRecords.removeBanEntry(cMIUser.getUniqueId());
        cMIUser.addForDelayedSave();
        return cMIUser;
    }
}

