/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.LightFix;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.LightFix.LightFixInfo;
import com.Zrips.CMI.Modules.Region.CMIRegion;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LightFix {
    public ConcurrentHashMap<UUID, LightFixInfo> LFInfo = new ConcurrentHashMap();
    private CMI plugin;

    public LightFix(CMI cMI) {
        this.plugin = cMI;
    }

    public void start(LightFixInfo lightFixInfo) {
        if (lightFixInfo.getStartTime() == 0L) {
            lightFixInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(lightFixInfo);
    }

    private void loadChunk(LightFixInfo lightFixInfo) {
        if (lightFixInfo.getScheduleTask() != null) {
            lightFixInfo.getScheduleTask().cancel();
        }
        lightFixInfo.setScheduleTask(CMIScheduler.runTaskLater(() -> {
            if (!this.LFInfo.containsKey(lightFixInfo.getPlayer().getUniqueId())) {
                return;
            }
            if (!lightFixInfo.isRunning()) {
                return;
            }
            WorldInfo worldInfo = lightFixInfo.getRI();
            World world2 = worldInfo.getWorld();
            int n = 0;
            while (n < lightFixInfo.getSpeed()) {
                Chunk chunk = worldInfo.getNextChunk(true);
                worldInfo.addLastChecked();
                if (worldInfo.allChecked()) {
                    lightFixInfo.setRunning(false);
                    if (lightFixInfo.getScheduleTask() != null) {
                        lightFixInfo.getScheduleTask().cancel();
                    }
                    if (lightFixInfo.getPlayer().isOnline()) {
                        lightFixInfo.getPlayer().sendMessage(this.plugin.getLM().getMessage("command.lfix.info.Finished", new Object[0]));
                    }
                    return;
                }
                if (lightFixInfo.isMessages() && lightFixInfo.getShowInfo() + 2000L < System.currentTimeMillis() && worldInfo.getLastChecked() > 0L) {
                    lightFixInfo.setShowInfo(false);
                    long l = worldInfo.getLeftToScan();
                    long l2 = worldInfo.getLastChecked();
                    long l3 = System.currentTimeMillis() - lightFixInfo.getStartTime();
                    long l4 = l3 / l2;
                    int n2 = (int)(l * l4 / 1000L);
                    int n3 = n2 / 60;
                    CMIActionBar.send((Player)lightFixInfo.getPlayer(), (String)this.plugin.getLM().getMessage("command.lfix.info.InfoShow", "[tps]", String.format("%.2f", this.plugin.getLagMeter().getTPS()), "[left]", l, "[min]", n3, "[sec]", n2 -= n3 * 60, "[speed]", lightFixInfo.getSpeed()));
                    if (lightFixInfo.isAutoSpeed()) {
                        if (this.plugin.getLagMeter().getTPS() > this.plugin.getConfigManager().lfixSoftCap) {
                            lightFixInfo.setSpeed(lightFixInfo.getSpeed() + 1);
                        } else {
                            lightFixInfo.setSpeed(lightFixInfo.getSpeed() - 2);
                        }
                    }
                    lightFixInfo.setShowInfo(System.currentTimeMillis());
                }
                if (chunk != null) {
                    CMIRegion cMIRegion = worldInfo.getNextChunkLoc(true);
                    int n4 = chunk.getX();
                    int n5 = chunk.getZ();
                    ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
                    arrayList.add(world2.getChunkAt(n4 - 1, n5 - 1));
                    arrayList.add(world2.getChunkAt(n4 - 1, n5));
                    arrayList.add(world2.getChunkAt(n4 - 1, n5 + 1));
                    if (cMIRegion != null && cMIRegion.getZ() < chunk.getZ() || cMIRegion == null) {
                        arrayList.add(world2.getChunkAt(n4, n5 + 1));
                        arrayList.add(world2.getChunkAt(n4, n5));
                        arrayList.add(world2.getChunkAt(n4, n5 - 1));
                        arrayList.add(world2.getChunkAt(n4 + 1, n5 - 1));
                        arrayList.add(world2.getChunkAt(n4 + 1, n5));
                        arrayList.add(world2.getChunkAt(n4 + 1, n5 + 1));
                    } else {
                        world2.loadChunk(n4, n5 + 1);
                        world2.loadChunk(n4, n5);
                        world2.loadChunk(n4, n5 - 1);
                        world2.loadChunk(n4 + 1, n5 - 1);
                        world2.loadChunk(n4 + 1, n5);
                        world2.loadChunk(n4 + 1, n5 + 1);
                    }
                    for (Chunk chunk2 : arrayList) {
                        chunk2.load();
                    }
                    this.plugin.getNMS().relightChunk(chunk);
                    int n6 = this.plugin.getViewRange(chunk.getWorld());
                    if (lightFixInfo.getPlayer().isOnline()) {
                        int n7 = lightFixInfo.getPlayer().getLocation().getChunk().getX() - chunk.getX();
                        int n8 = lightFixInfo.getPlayer().getLocation().getChunk().getZ() - chunk.getZ();
                        n7 = n7 < 0 ? n7 * -1 : n7;
                        int n9 = n8 = n8 < 0 ? n8 * -1 : n8;
                        if (n7 <= n6 - 1 && n8 <= n6 - 1) {
                            this.plugin.getNMS().resendChunk(chunk, lightFixInfo.getPlayer());
                        }
                    }
                    for (Chunk chunk3 : arrayList) {
                        chunk3.getWorld().unloadChunkRequest(chunk3.getX(), chunk3.getZ());
                    }
                }
                ++n;
            }
            this.loadChunk(lightFixInfo);
        }, (long)20L));
    }
}

