/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Portals;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.Modules.Portals.PortalManager;
import com.Zrips.CMI.Modules.tp.Teleportations;
import com.Zrips.CMI.events.CMIPortalUseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CMIPortal {
    private CuboidArea area;
    private Location tpLoc;
    private Location safeLoc;
    private String bungeeServer;
    private String bungeeLocation;
    private boolean toExactBungeeLocation = true;
    private boolean performCommandsWithoutTp = PortalManager.performCmd;
    private World world;
    private String worldName;
    private boolean enabled = true;
    private boolean showParticles = true;
    private int particleAmount = 10;
    private boolean requiresPermission = false;
    private boolean kickBack = true;
    private boolean informOnMissingPerm = false;
    private int percentToHide = 0;
    private int activationRange = 16;
    private CMIEffect cmiEffect = null;
    private List<String> commands = null;
    private String name;
    private boolean particlesByPermission = false;
    private Set<UUID> particleForPlayers = new HashSet<UUID>();

    public CMIPortal() {
        this.area = new CuboidArea(null);
    }

    public boolean containsLoc(Location location) {
        return this.area.containsLoc(location);
    }

    public boolean containsLoc(Location location, int n) {
        return this.area.containsLoc(location, n);
    }

    public CuboidArea getArea() {
        return this.area;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public World getWorld() {
        if (this.world == null && this.getWorldName() != null) {
            return CMI.getInstance().getUtilManager().getWorld(this.worldName);
        }
        return this.world;
    }

    public void setWorld(World world2) {
        this.world = world2;
        if (world2 != null) {
            this.worldName = world2.getName();
        }
    }

    public boolean checkCollision(CuboidArea cuboidArea) {
        return this.area != null && this.area.checkCollision(cuboidArea);
    }

    public boolean teleport(Player player) {
        if (player == null) {
            return false;
        }
        if (!player.isOnline()) {
            return false;
        }
        CMIPortalUseEvent cMIPortalUseEvent = new CMIPortalUseEvent(player, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)cMIPortalUseEvent);
        if (cMIPortalUseEvent.isCancelled()) {
            return false;
        }
        boolean bl = true;
        if (this.tpLoc != null && this.getBungeeServer() == null) {
            bl = CMI.getInstance().getTeleportations().teleport(player, this.tpLoc, false, Teleportations.TeleportType.Portal);
            if (bl) {
                CMI.getInstance().getSpecializedCommandManager().processCmds("CMIPortal-" + this.getName(), this.getCommands(player), player);
            }
            return bl;
        }
        if (this.getBungeeServer() != null) {
            if (this.isToExactBungeeLocation()) {
                CMI.getInstance().getBungeeCordManager().teleporToLocation(this.getBungeeServer(), player.getUniqueId(), this.getBungeeLocation(), player.getLocation(), CMIList.listToString(this.getCommands(player), (String)";;"));
            }
            CMI.getInstance().getBungeeCordManager().connectToServer(player, this.getBungeeServer());
            return true;
        }
        if (this.getPerformCommandsWithoutTp()) {
            CMI.getInstance().getSpecializedCommandManager().processCmds("CMIPortal-" + this.getName(), this.getCommands(player), player);
        }
        return bl;
    }

    public Location loadTpLoc(Object object) {
        this.tpLoc = (Location)object;
        return this.tpLoc;
    }

    public CuboidArea loadBounds(String string) {
        if (string == null || !string.contains(":")) {
            throw new Exception("Invalid portal physical location...");
        }
        String[] stringArray = string.split(":");
        try {
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            double d4 = Double.parseDouble(stringArray[3]);
            double d5 = Double.parseDouble(stringArray[4]);
            double d6 = Double.parseDouble(stringArray[5]);
            CuboidArea cuboidArea = new CuboidArea(new Location(this.world, d, d2, d3), new Location(this.world, d4, d5, d6));
            this.setArea(cuboidArea, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Invalid portal physical location...");
        }
        return this.area;
    }

    public Location getTpLoc() {
        return this.tpLoc;
    }

    public void setTpLoc(Location location) {
        this.tpLoc = location;
    }

    public void setArea(CuboidArea cuboidArea, boolean bl) {
        this.area = cuboidArea;
        if (cuboidArea.getWorld() != null) {
            this.world = cuboidArea.getWorld();
            this.worldName = cuboidArea.getWorld().getName();
        }
        if (bl) {
            this.particleAmount = (int)cuboidArea.getSize() / 3;
            if (this.particleAmount < 20) {
                this.particleAmount = 20;
            }
            if (this.particleAmount > 300) {
                this.particleAmount = 300;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public void setShowParticles(boolean bl) {
        this.showParticles = bl;
    }

    public int getParticleAmount() {
        return this.particleAmount;
    }

    public void setParticleAmount(int n) {
        this.particleAmount = n;
        if (this.particleAmount < 0) {
            this.particleAmount = 0;
        }
        if (this.particleAmount > 300) {
            this.particleAmount = 300;
        }
    }

    public int getPercentToHide() {
        return this.percentToHide;
    }

    public void setPercentToHide(int n) {
        this.percentToHide = n;
        if (this.percentToHide < 0) {
            this.percentToHide = 0;
        }
        if (this.percentToHide > 99) {
            this.percentToHide = 99;
        }
    }

    public int getActivationRange() {
        return this.activationRange;
    }

    public void setActivationRange(int n) {
        this.activationRange = n;
        if (this.activationRange < 2) {
            this.activationRange = 2;
        }
        if (this.activationRange > 128) {
            this.activationRange = 128;
        }
    }

    public List<String> getCommands() {
        if (this.commands == null) {
            this.setCommands(CMI.getInstance().getPortalManager().getCommandsOnTeleport());
        }
        return this.commands;
    }

    public List<String> getCommands(Player player) {
        Snd snd = new Snd().setSender(player).setTarget(player);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getCommands()) {
            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string));
        }
        return arrayList;
    }

    public void setCommands(List<String> list2) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        this.commands.addAll(list2);
    }

    public boolean getPerformCommandsWithoutTp() {
        return this.performCommandsWithoutTp;
    }

    public void setPerformCommandsWithoutTp(boolean bl) {
        this.performCommandsWithoutTp = bl;
    }

    public String getBungeeServer() {
        return this.bungeeServer;
    }

    public void setBungeeServer(String string) {
        this.bungeeServer = string;
    }

    public String getBungeeLocation() {
        return this.bungeeLocation;
    }

    public void setBungeeLocation(String string) {
        this.bungeeLocation = string;
    }

    public Location getSafeLoc() {
        return this.safeLoc;
    }

    public void setSafeLoc(Location location) {
        this.safeLoc = location;
    }

    public boolean isToExactBungeeLocation() {
        return this.toExactBungeeLocation;
    }

    public void setToExactBungeeLocation(boolean bl) {
        this.toExactBungeeLocation = bl;
    }

    public boolean isRequiresPermission() {
        return this.requiresPermission;
    }

    public void setRequiresPermission(boolean bl) {
        this.requiresPermission = bl;
    }

    public boolean isInformOnMissingPerm() {
        return this.informOnMissingPerm;
    }

    public void setInformOnMissingPerm(boolean bl) {
        this.informOnMissingPerm = bl;
    }

    public String getWorldName() {
        if (this.worldName == null && this.world != null) {
            return this.world.getName();
        }
        return this.worldName;
    }

    public void setWorldName(String string) {
        this.worldName = string;
        this.world = CMI.getInstance().getUtilManager().getWorld(string);
    }

    public Set<UUID> getParticleForPlayers() {
        return this.particleForPlayers;
    }

    public void setParticleForPlayers(Set<UUID> set) {
        this.particleForPlayers = set;
    }

    public Set<UUID> removeParticleLimitations(Player player) {
        return this.removeParticleLimitations(player.getUniqueId());
    }

    public Set<UUID> removeParticleLimitations(UUID uUID) {
        this.particleForPlayers.remove(uUID);
        return this.particleForPlayers;
    }

    public Set<UUID> updateParticleLimitations(Player player) {
        if (player != null && (!this.isParticlesByPermission() || player.isOnline() && PermissionsManager.CMIPerm.command_portal_$1.hasPermission((CommandSender)player, this.getName()))) {
            this.particleForPlayers.add(player.getUniqueId());
        }
        return this.particleForPlayers;
    }

    public boolean isParticlesByPermission() {
        return this.particlesByPermission;
    }

    public void setParticlesByPermission(boolean bl) {
        this.particlesByPermission = bl;
    }

    public boolean isKickBack() {
        return this.kickBack;
    }

    public void setKickBack(boolean bl) {
        this.kickBack = bl;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getEffect() {
        return this.getCMIEffect().getParticle();
    }

    public void setEffect(CMIEffectManager.CMIParticle cMIParticle) {
        this.getCMIEffect().setParticle(cMIParticle);
    }

    public CMIEffect getCMIEffect() {
        if (this.cmiEffect == null) {
            this.cmiEffect = new CMIEffect(CMIEffectManager.CMIParticle.COLOURED_DUST);
            this.cmiEffect.setColor(Color.fromRGB((int)125, (int)125, (int)125));
        }
        return this.cmiEffect;
    }

    public void setCMIEffect(CMIEffect cMIEffect) {
        this.cmiEffect = cMIEffect;
    }

    public CMIPortal setEffectColor(Color color) {
        this.getCMIEffect().setColor(color);
        return this;
    }
}

