/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Portals;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Portals.CMIPortal;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.Modules.Worlds.CMIWorldListener;
import com.Zrips.CMI.Modules.Worlds.UpdateOnWorldLoad;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PortalManager {
    private SortedMap<String, CMIPortal> portals;
    protected Map<String, Map<CuboidArea.ChunkRef, Set<CMIPortal>>> chunkPortals;
    protected Map<String, Map<CuboidArea.ChunkRef, Set<CMIPortal>>> chunkPortalsRange1;
    private Map<UUID, Set<CMIPortal>> playerNearPortals;
    private Map<UUID, Set<CMIPortal>> lastPortals;
    private Map<CMIPortal, Set<UUID>> lastPortalInRange;
    private int PortalsCheckInterval = 500;
    private int PortalsCheckParticleInterval = 500;
    private List<String> commandsOnTeleport = new ArrayList<String>();
    public static Boolean performCmd = true;
    private CMI plugin;
    private CMITask sched = null;
    private String fileName = "Portals.yml";
    private CMITask id = null;
    private boolean saving = false;

    public PortalManager(CMI cMI) {
        this.plugin = cMI;
        this.lastPortals = new HashMap<UUID, Set<CMIPortal>>();
        this.lastPortalInRange = new HashMap<CMIPortal, Set<UUID>>();
        this.portals = new TreeMap<String, CMIPortal>();
        this.chunkPortals = new HashMap<String, Map<CuboidArea.ChunkRef, Set<CMIPortal>>>();
        this.chunkPortalsRange1 = new HashMap<String, Map<CuboidArea.ChunkRef, Set<CMIPortal>>>();
        this.playerNearPortals = new HashMap<UUID, Set<CMIPortal>>();
        this.tasker();
    }

    public void stop() {
        if (this.sched == null) {
            return;
        }
        this.sched.cancel();
        this.sched = null;
    }

    private void tasker() {
        if (!Version.isSpigot()) {
            return;
        }
        this.sched = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.lastPortalInRange.isEmpty() && this.sched != null) {
                this.sched.cancel();
                this.sched = null;
                return;
            }
            CMIScheduler.runTaskAsynchronously(() -> {
                for (Map.Entry<CMIPortal, Set<UUID>> entry : new HashMap<CMIPortal, Set<UUID>>(this.lastPortalInRange).entrySet()) {
                    PortalManager.showParticlesForPortal(entry.getKey());
                }
            });
        }, (long)0L, (long)2L);
    }

    private static void showParticlesForPortal(CMIPortal cMIPortal) {
        if (!cMIPortal.isEnabled()) {
            return;
        }
        if (!cMIPortal.isShowParticles()) {
            return;
        }
        Location location = cMIPortal.getArea().getLowLoc();
        Random random = new Random(System.nanoTime());
        if (cMIPortal.getCMIEffect() != null && cMIPortal.getCMIEffect().getParticle() != null) {
            int n = 0;
            while (n < cMIPortal.getParticleAmount()) {
                double d = (double)random.nextInt(cMIPortal.getArea().getXSize() * 100) / 100.0;
                double d2 = (double)random.nextInt(cMIPortal.getArea().getYSize() * 100) / 100.0;
                double d3 = (double)random.nextInt(cMIPortal.getArea().getZSize() * 100) / 100.0;
                int n2 = random.nextInt(100 - cMIPortal.getPercentToHide());
                double d4 = (double)cMIPortal.getArea().getXSize() / 2.0 - d;
                if (d4 < 0.0) {
                    d4 *= -1.0;
                }
                double d5 = d4 * 100.0 / ((double)cMIPortal.getArea().getXSize() / 2.0);
                if (cMIPortal.getPercentToHide() <= 0 || !((double)n2 < d5)) {
                    double d6 = (double)cMIPortal.getArea().getYSize() / 2.0 - d2;
                    if (d6 < 0.0) {
                        d6 *= -1.0;
                    }
                    double d7 = d6 * 100.0 / ((double)cMIPortal.getArea().getYSize() / 2.0);
                    if (cMIPortal.getPercentToHide() <= 0 || !((double)n2 < d7)) {
                        double d8 = (double)cMIPortal.getArea().getZSize() / 2.0 - d3;
                        if (d8 < 0.0) {
                            d8 *= -1.0;
                        }
                        double d9 = d8 * 100.0 / ((double)cMIPortal.getArea().getZSize() / 2.0);
                        if (cMIPortal.getPercentToHide() <= 0 || !((double)n2 < d9)) {
                            CMIEffect cMIEffect = cMIPortal.getCMIEffect();
                            Location location2 = location.clone().add(d, d2, d3);
                            for (UUID uUID : new HashSet<UUID>(cMIPortal.getParticleForPlayers())) {
                                Player player = CMIUser.getOnlinePlayer(uUID);
                                CMI.getInstance().getNMS().playEffect(player, location2, cMIEffect);
                            }
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void addPortal(CMIPortal cMIPortal) {
        this.portals.put(cMIPortal.getName().toLowerCase(), cMIPortal);
        this.recalculateChunks(cMIPortal);
    }

    public void recalculateChunks() {
        this.chunkPortals.clear();
        this.chunkPortalsRange1.clear();
        for (Map.Entry<String, CMIPortal> entry : this.portals.entrySet()) {
            this.recalculateChunks(entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void recalculateChunks(final CMIPortal cMIPortal) {
        void var3_9;
        HashMap hashMap2;
        if (cMIPortal.getArea().getWorld() == null) {
            hashMap2 = new UpdateOnWorldLoad(){

                @Override
                public void update(World world2) {
                    cMIPortal.getArea().setWorld(world2);
                    PortalManager.this.recalculateChunks(cMIPortal);
                    PortalManager.this.plugin.consoleMessage("Missing (" + world2.getName() + ") world loaded. Recalculating " + cMIPortal.getName() + " portal position");
                }
            };
            CMIWorldListener.delayRecheck(cMIPortal.getWorldName(), (UpdateOnWorldLoad)((Object)hashMap2));
        }
        if ((hashMap2 = this.chunkPortals.get(cMIPortal.getWorldName())) == null) {
            hashMap2 = new HashMap();
        }
        for (CuboidArea.ChunkRef chunkRef : PortalManager.getChunks(cMIPortal)) {
            HashSet<CMIPortal> hashSet = new HashSet<CMIPortal>();
            if (hashMap2.containsKey(chunkRef)) {
                hashSet.addAll((Collection)hashMap2.get(chunkRef));
            }
            hashSet.add(cMIPortal);
            hashMap2.put(chunkRef, hashSet);
        }
        this.chunkPortals.put(cMIPortal.getWorldName(), hashMap2);
        Map<CuboidArea.ChunkRef, Set<CMIPortal>> map = this.chunkPortalsRange1.get(cMIPortal.getWorldName());
        if (map == null) {
            HashMap hashMap = new HashMap();
        }
        for (CuboidArea.ChunkRef chunkRef : PortalManager.getChunks(cMIPortal, cMIPortal.getActivationRange())) {
            HashSet<CMIPortal> hashSet = new HashSet<CMIPortal>();
            if (var3_9.containsKey(chunkRef)) {
                hashSet.addAll((Collection)var3_9.get(chunkRef));
            }
            hashSet.add(cMIPortal);
            var3_9.put(chunkRef, hashSet);
        }
        this.chunkPortalsRange1.put(cMIPortal.getWorldName(), (Map<CuboidArea.ChunkRef, Set<CMIPortal>>)var3_9);
    }

    public CMIPortal getByName(String string) {
        if (string == null) {
            return null;
        }
        return (CMIPortal)this.portals.get(string.toLowerCase());
    }

    public CMIPortal getByLoc(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        CMIPortal cMIPortal = null;
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkPortals.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMIPortal>> map = this.chunkPortals.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIPortal cMIPortal2 : map.get(chunkRef)) {
                if (cMIPortal2 == null || !cMIPortal2.containsLoc(location)) continue;
                cMIPortal = cMIPortal2;
                break;
            }
        }
        return cMIPortal;
    }

    public Set<CMIPortal> getByLocList(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        HashSet<CMIPortal> hashSet = new HashSet<CMIPortal>();
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkPortals.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMIPortal>> map = this.chunkPortals.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIPortal cMIPortal : map.get(chunkRef)) {
                if (cMIPortal == null || !cMIPortal.containsLoc(location)) continue;
                hashSet.add(cMIPortal);
            }
        }
        return hashSet;
    }

    public Set<CMIPortal> getByLocExtended(Location location) {
        HashSet<CMIPortal> hashSet = new HashSet<CMIPortal>();
        if (location == null) {
            return hashSet;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return hashSet;
        }
        String string = world2.getName();
        if (string == null) {
            return hashSet;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkPortalsRange1.containsKey(string)) {
            return hashSet;
        }
        Map<CuboidArea.ChunkRef, Set<CMIPortal>> map = this.chunkPortalsRange1.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIPortal cMIPortal : map.get(chunkRef)) {
                if (cMIPortal == null || !cMIPortal.containsLoc(location, cMIPortal.getActivationRange())) continue;
                hashSet.add(cMIPortal);
            }
        }
        return hashSet;
    }

    public CMIPortal collidesWithPortal(CuboidArea cuboidArea) {
        Set<Map.Entry<String, CMIPortal>> set = this.portals.entrySet();
        for (Map.Entry<String, CMIPortal> entry : set) {
            CMIPortal cMIPortal = entry.getValue();
            if (!cMIPortal.checkCollision(cuboidArea)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static List<CuboidArea.ChunkRef> getChunks(CMIPortal cMIPortal) {
        ArrayList<CuboidArea.ChunkRef> arrayList = new ArrayList<CuboidArea.ChunkRef>();
        arrayList.addAll(cMIPortal.getArea().getChunks());
        return arrayList;
    }

    private static List<CuboidArea.ChunkRef> getChunks(CMIPortal cMIPortal, int n) {
        ArrayList<CuboidArea.ChunkRef> arrayList = new ArrayList<CuboidArea.ChunkRef>();
        arrayList.addAll(cMIPortal.getArea().getChunks(n));
        return arrayList;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Portals.CheckInterval", new String[]{"Defines in milliseconds how often to check if player entered portal or not", "Bigger numbers can help slightly lower server load but small portals, 1 block depth without back wall can be passed through without teleportations if player moves fast enought"});
        this.PortalsCheckInterval = configReader.get("Portals.CheckInterval", 300);
        configReader.addComment("Portals.CheckParticleInterval", new String[]{"Defines in milliseconds how often to check if player entered portal range for particles to apear"});
        this.PortalsCheckParticleInterval = configReader.get("Portals.CheckParticleInterval", 500);
        configReader.addComment("Portals.Defaults.PerformCommands", new String[]{"Should we perform commands without set destination location by default", "This only effects newly created portal areas", "When set to true at moment you create portal you can enter it and commands defined belove will be performed without teleporting you anywhere", "This can be change for each portal independently with ingame portal editor"});
        performCmd = configReader.get("Portals.Defaults.PerformCommands", Boolean.valueOf(true));
        configReader.addComment("Portals.Defaults.Commands", new String[]{"Commands to be performed on teleport event"});
        this.commandsOnTeleport = configReader.get("Portals.Defaults.Commands", Arrays.asList("cmi effect [playerName] blindness 2 1 -s"));
    }

    public void load() {
        Long l = System.currentTimeMillis();
        this.portals.clear();
        this.chunkPortals.clear();
        this.chunkPortalsRange1.clear();
        CMI.getInstance().safeRenameFile("portals.yml", "Saves" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        YamlConfiguration yamlConfiguration = null;
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Error | Exception throwable) {
            return;
        }
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        Map map = yamlConfiguration.getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            Map map2 = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
            if (map2 == null) continue;
            try {
                this.loadMap((String)entry.getKey(), map2);
            }
            catch (Exception exception) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Error in loading portal file for world: " + (String)entry.getKey());
            }
        }
        this.plugin.loadMessage(this.portals.size(), "portals", System.currentTimeMillis() - l);
    }

    public void loadMap(String string, Map<String, Object> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                CMIPortal cMIPortal = new CMIPortal();
                cMIPortal.setName(entry.getKey());
                cMIPortal.setWorldName(string);
                MemorySection memorySection = (MemorySection)entry.getValue();
                if (memorySection.isString("world")) {
                    cMIPortal.setWorldName(memorySection.getString("world"));
                }
                if (memorySection.contains("Tp")) {
                    if (memorySection.isString("Tp")) {
                        cMIPortal.setTpLoc((Location)this.plugin.getPlayerManager().convertStringToLocation(memorySection.getString("Tp")));
                    } else {
                        cMIPortal.loadTpLoc(memorySection.get("Tp"));
                    }
                }
                cMIPortal.loadBounds(memorySection.getString("Loc"));
                if (memorySection.isString("effect")) {
                    cMIPortal.getCMIEffect().setParticle(CMIEffectManager.CMIParticle.getCMIParticle((String)memorySection.getString("effect")));
                }
                if (memorySection.isInt("color")) {
                    cMIPortal.getCMIEffect().setColor(Color.fromRGB((int)memorySection.getInt("color")));
                }
                if (memorySection.isInt("size")) {
                    cMIPortal.getCMIEffect().setSize(memorySection.getInt("size"));
                }
                if (memorySection.contains("safeLoc")) {
                    if (memorySection.isString("safeLoc")) {
                        cMIPortal.setSafeLoc((Location)this.plugin.getPlayerManager().convertStringToLocation(memorySection.getString("safeLoc")));
                    } else {
                        cMIPortal.setSafeLoc((Location)memorySection.get("safeLoc"));
                    }
                }
                if (memorySection.isString("bungeeServer")) {
                    cMIPortal.setBungeeServer(memorySection.getString("bungeeServer"));
                }
                if (memorySection.isBoolean("kickBack")) {
                    cMIPortal.setKickBack(memorySection.getBoolean("kickBack"));
                }
                if (memorySection.isBoolean("particlesByPermission")) {
                    cMIPortal.setParticlesByPermission(memorySection.getBoolean("particlesByPermission"));
                }
                if (memorySection.isBoolean("exactBungeeLocation")) {
                    cMIPortal.setToExactBungeeLocation(memorySection.getBoolean("exactBungeeLocation"));
                }
                if (memorySection.isString("bungeeLocation")) {
                    cMIPortal.setBungeeLocation(memorySection.getString("bungeeLocation"));
                }
                if (memorySection.isBoolean("enabled")) {
                    cMIPortal.setEnabled(memorySection.getBoolean("enabled"));
                }
                if (memorySection.isBoolean("showParticles")) {
                    cMIPortal.setShowParticles(memorySection.getBoolean("showParticles"));
                }
                if (memorySection.isInt("particleAmount")) {
                    cMIPortal.setParticleAmount(memorySection.getInt("particleAmount"));
                }
                if (memorySection.isInt("particleHide")) {
                    cMIPortal.setPercentToHide(memorySection.getInt("particleHide"));
                }
                if (memorySection.isInt("activationRange")) {
                    cMIPortal.setActivationRange(memorySection.getInt("activationRange"));
                }
                if (memorySection.isBoolean("commandsWithoutTp")) {
                    cMIPortal.setPerformCommandsWithoutTp(memorySection.getBoolean("commandsWithoutTp"));
                }
                if (memorySection.isBoolean("requiresPerm")) {
                    cMIPortal.setRequiresPermission(memorySection.getBoolean("requiresPerm"));
                }
                if (memorySection.isBoolean("informOnMissingPerm")) {
                    cMIPortal.setInformOnMissingPerm(memorySection.getBoolean("informOnMissingPerm"));
                }
                if (memorySection.isList("commands")) {
                    cMIPortal.setCommands(memorySection.getStringList("commands"));
                }
                this.addPortal(cMIPortal);
            }
            catch (Error | Exception throwable) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + " Failed to load portal (" + entry.getKey() + ")! Reason:" + throwable.getMessage() + " Error Log:");
                Logger.getLogger(PortalManager.class.getName()).log(Level.SEVERE, null, throwable);
            }
        }
    }

    public void handlePortalVisualizerUpdates() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.handlePortalVisualizerUpdates(player, null, player.getLocation());
        }
    }

    public boolean handlePortalVisualizerUpdates(Player player, Location location, Location location2) {
        Set<CMIPortal> set = this.lastPortals.get(player.getUniqueId());
        Set<CMIPortal> set2 = this.plugin.getPortalManager().getByLocExtended(location2);
        HashSet<CMIPortal> hashSet = new HashSet<CMIPortal>();
        HashSet<CMIPortal> hashSet2 = new HashSet<CMIPortal>();
        boolean bl = true;
        if (set != null) {
            for (CMIPortal cMIPortal : set) {
                if (set2.contains(cMIPortal)) continue;
                hashSet.add(cMIPortal);
            }
            for (CMIPortal cMIPortal : set2) {
                if (set.contains(cMIPortal)) continue;
                hashSet2.add(cMIPortal);
            }
        } else {
            hashSet2.addAll(set2);
        }
        this.lastPortals.put(player.getUniqueId(), set2);
        for (CMIPortal cMIPortal : hashSet) {
            this.plugin.getPortalManager().removeLastPortalInRange(cMIPortal, player.getUniqueId());
            this.removeNearPortal(player.getUniqueId(), cMIPortal);
        }
        for (CMIPortal cMIPortal : hashSet2) {
            this.plugin.getPortalManager().addLastPortalInRange(cMIPortal, player.getUniqueId());
            this.addNearPortal(player.getUniqueId(), cMIPortal);
        }
        return bl;
    }

    public void savePortals() {
        if (this.id != null) {
            return;
        }
        this.id = CMIScheduler.runTaskLater(() -> {
            CMI.getInstance().getPortalManager().save();
            this.id = null;
        }, (long)200L);
    }

    private void save() {
        if (this.saving) {
            return;
        }
        this.saving = true;
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        for (Map.Entry entry : configReader.getC().getValues(false).entrySet()) {
            configReader.getC().set((String)entry.getKey(), null);
        }
        configReader.header(Arrays.asList("Command section can utilize same custom variables as scheduler. Check Schedules.yml file for all possible variables."));
        for (Map.Entry<Object, Object> entry : this.portals.entrySet()) {
            CMIPortal cMIPortal = (CMIPortal)entry.getValue();
            String string = cMIPortal.getName().replace(".", "_");
            String string2 = cMIPortal.getWorldName();
            boolean bl = false;
            if (string2.contains(".")) {
                string2 = string2.split("\\.", 2)[0];
                bl = true;
            }
            String string3 = String.valueOf(string2) + "." + string;
            configReader.get(String.valueOf(string3) + ".Loc", cMIPortal.getArea().toString());
            if (bl) {
                configReader.get(String.valueOf(string3) + ".world", cMIPortal.getWorldName());
            }
            configReader.get(String.valueOf(string3) + ".enabled", Boolean.valueOf(cMIPortal.isEnabled()));
            configReader.get(String.valueOf(string3) + ".effect", cMIPortal.getCMIEffect().getParticle().getName());
            if (cMIPortal.getCMIEffect().getParticle().isColored()) {
                configReader.get(String.valueOf(string3) + ".color", cMIPortal.getCMIEffect().getColor().asRGB());
            }
            if (cMIPortal.getCMIEffect().getSize() != 1) {
                configReader.get(String.valueOf(string3) + ".size", cMIPortal.getCMIEffect().getSize());
            }
            configReader.get(String.valueOf(string3) + ".showParticles", Boolean.valueOf(cMIPortal.isShowParticles()));
            if (cMIPortal.getSafeLoc() != null) {
                configReader.get(String.valueOf(string3) + ".safeLoc", this.plugin.getPlayerManager().convertLocToString(cMIPortal.getSafeLoc()));
            }
            if (cMIPortal.getBungeeServer() != null) {
                configReader.get(String.valueOf(string3) + ".bungeeServer", cMIPortal.getBungeeServer());
            }
            if (cMIPortal.getBungeeServer() != null) {
                configReader.get(String.valueOf(string3) + ".exactBungeeLocation", Boolean.valueOf(cMIPortal.isToExactBungeeLocation()));
            }
            if (cMIPortal.getBungeeLocation() != null) {
                configReader.get(String.valueOf(string3) + ".bungeeLocation", cMIPortal.getBungeeLocation());
            }
            if (cMIPortal.getTpLoc() != null) {
                configReader.get(String.valueOf(string3) + ".Tp", this.plugin.getPlayerManager().convertLocToString(cMIPortal.getTpLoc()));
            }
            configReader.get(String.valueOf(string3) + ".kickBack", Boolean.valueOf(cMIPortal.isKickBack()));
            configReader.get(String.valueOf(string3) + ".particlesByPermission", Boolean.valueOf(cMIPortal.isParticlesByPermission()));
            configReader.get(String.valueOf(string3) + ".requiresPerm", Boolean.valueOf(cMIPortal.isRequiresPermission()));
            configReader.get(String.valueOf(string3) + ".informOnMissingPerm", Boolean.valueOf(cMIPortal.isInformOnMissingPerm()));
            configReader.get(String.valueOf(string3) + ".particleAmount", cMIPortal.getParticleAmount());
            configReader.get(String.valueOf(string3) + ".particleHide", cMIPortal.getPercentToHide());
            configReader.get(String.valueOf(string3) + ".activationRange", cMIPortal.getActivationRange());
            configReader.get(String.valueOf(string3) + ".commandsWithoutTp", Boolean.valueOf(cMIPortal.getPerformCommandsWithoutTp()));
            configReader.get(String.valueOf(string3) + ".commands", cMIPortal.getCommands());
        }
        configReader.save();
        this.saving = false;
    }

    public void removeLastPortalInRange(CMIPortal cMIPortal, UUID uUID) {
        Set<UUID> set = this.lastPortalInRange.get(cMIPortal);
        if (set == null) {
            return;
        }
        set.remove(uUID);
        if (set.isEmpty()) {
            this.lastPortalInRange.remove(cMIPortal);
            return;
        }
        this.lastPortalInRange.put(cMIPortal, set);
    }

    public void removeLastPortalInRange(UUID uUID) {
        HashMap<CMIPortal, Set<UUID>> hashMap = new HashMap<CMIPortal, Set<UUID>>(this.lastPortalInRange);
        for (Map.Entry<CMIPortal, Set<UUID>> entry : hashMap.entrySet()) {
            Set<UUID> set = entry.getValue();
            if (set == null) continue;
            set.remove(uUID);
            if (set.isEmpty()) {
                this.lastPortalInRange.remove(entry.getKey());
                continue;
            }
            this.lastPortalInRange.put(entry.getKey(), set);
        }
        this.lastPortals.remove(uUID);
    }

    public void addLastPortalInRange(CMIPortal cMIPortal, UUID uUID) {
        Set<UUID> set = this.lastPortalInRange.get(cMIPortal);
        if (set == null) {
            set = new HashSet<UUID>();
        }
        set.add(uUID);
        this.lastPortalInRange.put(cMIPortal, set);
        if (this.sched == null) {
            this.tasker();
        }
    }

    public SortedMap<String, CMIPortal> getPortals() {
        return this.portals;
    }

    public List<CMIPortal> getPortalsByDistance(Location location) {
        if (location == null) {
            location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        HashMap hashMap = new HashMap();
        ArrayList<CMIPortal> arrayList = new ArrayList<CMIPortal>();
        for (Map.Entry<String, CMIPortal> entry : this.portals.entrySet()) {
            if (!location.getWorld().getName().equals(entry.getValue().getWorldName())) {
                arrayList.add(entry.getValue());
                continue;
            }
            hashMap.put(entry.getValue(), (int)entry.getValue().getArea().getMiddleLocation().distance(location));
        }
        hashMap = this.plugin.getSortingManager().sortByValueObject(hashMap);
        ArrayList<CMIPortal> arrayList2 = new ArrayList<CMIPortal>();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList2.add((CMIPortal)entry.getKey());
        }
        if (!arrayList.isEmpty()) {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    public void removePortal(CMIPortal cMIPortal) {
        this.portals.remove(cMIPortal.getName().toLowerCase());
        this.lastPortalInRange.remove(cMIPortal);
        this.recalculateChunks();
        this.savePortals();
    }

    public int getPortalsCheckInterval() {
        return this.PortalsCheckInterval;
    }

    public int getPortalsCheckParticleInterval() {
        return this.PortalsCheckParticleInterval;
    }

    public List<String> getCommandsOnTeleport() {
        return this.commandsOnTeleport;
    }

    public boolean isNearPortal(UUID uUID) {
        if (this.playerNearPortals.isEmpty()) {
            return false;
        }
        if (uUID == null) {
            return false;
        }
        Set<CMIPortal> set = this.playerNearPortals.get(uUID);
        return set != null && !set.isEmpty();
    }

    public void addNearPortal(UUID uUID, CMIPortal cMIPortal) {
        Set<CMIPortal> set = this.playerNearPortals.get(uUID);
        if (set == null) {
            set = new HashSet<CMIPortal>();
        }
        set.add(cMIPortal);
        cMIPortal.updateParticleLimitations(CMIUser.getOnlinePlayer(uUID));
        this.playerNearPortals.put(uUID, set);
    }

    public void removeNearPortal(UUID uUID, CMIPortal cMIPortal) {
        Set<CMIPortal> set = this.playerNearPortals.get(uUID);
        if (set == null) {
            return;
        }
        set.remove(cMIPortal);
        cMIPortal.removeParticleLimitations(uUID);
        this.playerNearPortals.put(uUID, set);
    }

    public void removeNearPortal(UUID uUID) {
        Set<CMIPortal> set = this.playerNearPortals.remove(uUID);
        if (set != null) {
            for (CMIPortal cMIPortal : set) {
                cMIPortal.removeParticleLimitations(uUID);
            }
        }
    }

    public void forceUpdate(CMIPortal cMIPortal) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.forceUpdate(player.getUniqueId(), cMIPortal);
        }
    }

    public void forceUpdate(UUID uUID, CMIPortal cMIPortal) {
        if (cMIPortal == null || uUID == null) {
            return;
        }
        this.plugin.getPortalManager().removeNearPortal(uUID, cMIPortal);
        this.plugin.getPortalManager().removeLastPortalInRange(uUID);
        this.plugin.getPortalManager().handlePortalVisualizerUpdates();
    }
}

