/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Statistics;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsManager {
    private CMI plugin;
    private static HashMap<String, CMIStatistic> cache = new HashMap();
    private CMITask autoTimerBukkitId = null;
    private CompletableFuture<Void> task;
    SortedMap<Long, CMIUser> sm = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    SortedMap<UUID, Long> smt = Collections.synchronizedSortedMap(new TreeMap());
    private boolean loaded = false;
    long lastUpdate = 0L;
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            for (Player player : Bukkit.getOnlinePlayers()) {
                CMIUser cMIUser = StatsManager.this.plugin.getPlayerManager().getUser(player);
                if (cMIUser.isVanished()) continue;
                StatsManager.this.addUserData(cMIUser);
            }
        }
    };

    static {
        CMIStatistic[] cMIStatisticArray = CMIStatistic.values();
        int n = cMIStatisticArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIStatistic cMIStatistic = cMIStatisticArray[n2];
            cache.put(cMIStatistic.toString().replace("_", "").toLowerCase(), cMIStatistic);
            cache.put(cMIStatistic.getName().replace("_", "").replace(" ", "").toLowerCase(), cMIStatistic);
            if (cMIStatistic.getNewName() != null) {
                cache.put(cMIStatistic.getNewName().replace("_", "").replace(" ", "").toLowerCase(), cMIStatistic);
            }
            ++n2;
        }
    }

    public StatsManager(CMI cMI) {
        this.plugin = cMI;
        this.autoTimerBukkitId = CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.autoTimer, (long)1200L, (long)1200L);
    }

    public void stop() {
        if (this.autoTimerBukkitId != null) {
            this.autoTimerBukkitId.cancel();
        }
    }

    public CMIStatistic getStatisticByName(String string) {
        return cache.get(string.toLowerCase().replace("_", "").replace(" ", ""));
    }

    public Statistic getStatistic(CMIStatistic cMIStatistic) {
        if (cMIStatistic.getBukkitStat() != null) {
            return cMIStatistic.getBukkitStat();
        }
        Statistic[] statisticArray = Statistic.values();
        int n = statisticArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statistic statistic = statisticArray[n2];
            if (statistic.name().equalsIgnoreCase(cMIStatistic.name())) {
                return statistic;
            }
            ++n2;
        }
        return null;
    }

    public synchronized boolean changeTo(Player player, CMIStatistic cMIStatistic, String string, Long l) {
        if (cMIStatistic.getBukkitStat() == null) {
            return false;
        }
        int n = 0;
        n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : l.intValue();
        switch (cMIStatistic.getSubType()) {
            case Block: {
                CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(string);
                if (cMIItemStack == null) {
                    return false;
                }
                if (!cMIItemStack.getMaterial().isBlock()) {
                    return false;
                }
                try {
                    player.setStatistic(cMIStatistic.getBukkitStat(), cMIItemStack.getMaterial(), n);
                    break;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            case Entity: {
                CMIEntityType cMIEntityType = CMIEntityType.getByName((String)string);
                if (cMIEntityType == null) {
                    return false;
                }
                if (cMIEntityType.getType() == null) {
                    return false;
                }
                try {
                    player.setStatistic(cMIStatistic.getBukkitStat(), cMIEntityType.getType(), n);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            case Material: {
                CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(string);
                if (cMIItemStack == null) {
                    return false;
                }
                if (cMIItemStack.getMaterial() == null) {
                    return false;
                }
                try {
                    player.setStatistic(cMIStatistic.getBukkitStat(), cMIItemStack.getMaterial(), n);
                    break;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            default: {
                try {
                    player.setStatistic(cMIStatistic.getBukkitStat(), n);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isScanning() {
        return this.task != null;
    }

    public boolean isDataLoaded() {
        return this.loaded;
    }

    public int getTotalCount() {
        return this.sm.size();
    }

    public int getPages() {
        return this.sm.size() / 10;
    }

    public void addUserData(CMIUser cMIUser) {
        if (this.isScanning()) {
            return;
        }
        if (Config.PlaytimeTopExclude.contains(cMIUser.getName(false).toLowerCase())) {
            return;
        }
        if (this.plugin.getPlayerManager().getFakeUserName().equals(cMIUser.getName(false))) {
            return;
        }
        Long l = cMIUser.getTotalPlayTime(false);
        Long l2 = (Long)this.smt.get(cMIUser.getUniqueId());
        if (l2 != null) {
            this.sm.remove(l2);
        }
        this.smt.put(cMIUser.getUniqueId(), l);
        this.sm.put(l, cMIUser);
    }

    public Long getPlaytimeFromCache(CMIUser cMIUser) {
        return (Long)this.smt.get(cMIUser.getUniqueId());
    }

    public SortedMap<Long, CMIUser> getTop() {
        if (!Config.PlayTimeAutoUpdater && this.lastUpdate + 60000L < System.currentTimeMillis()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
                if (cMIUser.isVanished()) continue;
                this.addUserData(cMIUser);
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        return this.sm;
    }

    public synchronized SortedMap<Long, CMIUser> getTop(int n) {
        SortedMap<Long, CMIUser> sortedMap = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        for (Map.Entry<Long, CMIUser> entry : new TreeMap<Long, CMIUser>(this.getTop()).entrySet()) {
            if (n < 0) {
                return sortedMap;
            }
            sortedMap.put(entry.getKey(), entry.getValue());
            --n;
        }
        return sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Long getTimeByPlace(int n) {
        int n2 = 0;
        if (n < 1 || n > 100) {
            return null;
        }
        SortedMap<Long, CMIUser> sortedMap = this.sm;
        synchronized (sortedMap) {
            for (Map.Entry<Long, CMIUser> entry : new TreeMap<Long, CMIUser>(this.sm).entrySet()) {
                if (++n2 != n) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CMIUser getUserByPlace(int n) {
        int n2 = 0;
        if (n < 1 || n > 100) {
            return null;
        }
        SortedMap<Long, CMIUser> sortedMap = this.sm;
        synchronized (sortedMap) {
            for (Map.Entry<Long, CMIUser> entry : new TreeMap<Long, CMIUser>(this.sm).entrySet()) {
                if (++n2 != n) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlace(CMIUser cMIUser) {
        int n = 0;
        UUID uUID = cMIUser.getUniqueId();
        SortedMap<Long, CMIUser> sortedMap = this.sm;
        synchronized (sortedMap) {
            for (Map.Entry<Long, CMIUser> entry : new TreeMap<Long, CMIUser>(this.sm).entrySet()) {
                ++n;
                if (!entry.getValue().getUniqueId().equals(uUID)) continue;
                return n;
            }
        }
        return 0;
    }

    public void loadStats(CommandSender commandSender, String string) {
        long l = 86400000L * Config.PlaytimeTopOffline;
        if (this.loaded) {
            return;
        }
        this.task = CMIScheduler.runTaskAsynchronously(() -> {
            try {
                new HashMap<UUID, CMIUser>(this.plugin.getPlayerManager().getAllUsers()).values().forEach(cMIUser -> {
                    if (cMIUser.getTotalPlayTimeClean() <= 0L) {
                        return;
                    }
                    if (cMIUser.getName(false) == null) {
                        return;
                    }
                    if (Config.PlaytimeTopExclude.contains(cMIUser.getName(false).toLowerCase())) {
                        return;
                    }
                    if (Config.PlaytimeTopOffline > 0L && cMIUser.getLastLogin(false) != 0L && System.currentTimeMillis() - cMIUser.getLastLogin(false) > l) {
                        return;
                    }
                    Long l2 = (Long)this.smt.get(cMIUser.getUniqueId());
                    if (l2 != null) {
                        this.sm.remove(l2);
                    }
                    this.smt.put(cMIUser.getUniqueId(), cMIUser.getTotalPlayTimeClean());
                    this.sm.put(cMIUser.getTotalPlayTimeClean(), (CMIUser)cMIUser);
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.loaded = true;
            this.task = null;
            if (commandSender != null) {
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    Player player2 = CMIUser.getOnlinePlayer(player.getUniqueId());
                    if (player2 != null) {
                        CMIScheduler.runTask(() -> {
                            if (string != null) {
                                player2.performCommand("cmi playtimetop " + string);
                            } else {
                                player2.performCommand("cmi playtimetop");
                            }
                        });
                    }
                } else {
                    commandSender.sendMessage("Stats loaded!");
                }
            }
        });
    }

    public static enum CMIStatistic {
        LEAVE_GAME("Game quit", svt.Number, false, false, CMIType.None),
        PLAY_ONE_TICK("Play time", svt.Time, false, false, CMIType.None, "PLAY_ONE_MINUTE"),
        TIME_SINCE_DEATH("From last death", svt.Time, false, false, CMIType.None),
        TIME_SINCE_REST("From last rest", svt.Time, false, false, CMIType.None),
        SNEAK_TIME("Sneak time", svt.Time, false, false, CMIType.None),
        ACOUNT_AGE("Account age", svt.Time, false, false, CMIType.None),
        TRAVEL("Travel", svt.Distance, false, false, CMIType.None),
        WALK_ONE_CM("Walk", svt.Distance, false, false, CMIType.None),
        CROUCH_ONE_CM("Sneak", svt.Distance, false, false, CMIType.None),
        SPRINT_ONE_CM("Sprint", svt.Distance, false, false, CMIType.None),
        SWIM_ONE_CM("Swim", svt.Distance, false, false, CMIType.None),
        FALL_ONE_CM("Fall", svt.Distance, false, false, CMIType.None),
        CLIMB_ONE_CM("Climb", svt.Distance, false, false, CMIType.None),
        FLY_ONE_CM("Fly", svt.Distance, false, false, CMIType.None),
        DIVE_ONE_CM("Dive", svt.Distance, false, false, CMIType.None),
        WALK_UNDER_WATER_ONE_CM("Walk under water", svt.Distance, false, false, CMIType.None),
        WALK_ON_WATER_ONE_CM("Walk on water", svt.Distance, false, false, CMIType.None),
        MINECART_ONE_CM("Minecart travel", svt.Distance, false, false, CMIType.None),
        BOAT_ONE_CM("Boat travel", svt.Distance, false, false, CMIType.None),
        PIG_ONE_CM("Pig travel", svt.Distance, false, false, CMIType.None),
        HORSE_ONE_CM("Horse travel", svt.Distance, false, false, CMIType.None),
        AVIATE_ONE_CM("Elytra travel", svt.Distance, false, false, CMIType.None),
        JUMP("Jump", svt.Number, false, false, CMIType.None),
        DAMAGE_DEALT("Damage dealt", svt.Damage, false, false, CMIType.None),
        DAMAGE_TAKEN("Damage taken", svt.Damage, false, false, CMIType.None),
        DAMAGE_DEALT_ABSORBED("Damage dealt absorbed", svt.Damage, false, false, CMIType.None),
        DAMAGE_DEALT_RESISTED("Damage dealt resisted", svt.Damage, false, false, CMIType.None),
        DAMAGE_BLOCKED_BY_SHIELD("Damage blocked by shield", svt.Damage, false, false, CMIType.None),
        DAMAGE_ABSORBED("Damage absorbed", svt.Damage, false, false, CMIType.None),
        DAMAGE_RESISTED("Damage resisted", svt.Damage, false, false, CMIType.None),
        DEATHS("Deaths", svt.Number, false, false, CMIType.None),
        ENTITY_KILLED_BY("Killed by", svt.Number, false, true, CMIType.Entity),
        MOB_KILLS("Mob kills", svt.Number, false, false, CMIType.None),
        PLAYER_KILLS("Player kills", svt.Number, false, false, CMIType.None),
        ITEM_ENCHANTED("Item enchanted", svt.Number, false, false, CMIType.None),
        ANIMALS_BRED("Animals bred", svt.Number, false, false, CMIType.None),
        FISH_CAUGHT("Fish caught", svt.Number, false, false, CMIType.None),
        TALKED_TO_VILLAGER("Talked to villager", svt.Number, false, false, CMIType.None),
        TRADED_WITH_VILLAGER("Traded with villager", svt.Number, false, false, CMIType.None),
        CAKE_SLICES_EATEN("Cake slices eaten", svt.Number, false, false, CMIType.None),
        CAULDRON_FILLED("Cauldron filled", svt.Number, false, false, CMIType.None),
        CAULDRON_USED("Couldron used", svt.Number, false, false, CMIType.None),
        ARMOR_CLEANED("Armor cleaned", svt.Number, false, false, CMIType.None),
        BANNER_CLEANED("Banner cleaned", svt.Number, false, false, CMIType.None),
        BREWINGSTAND_INTERACTION("Brewing stand interactions", svt.Number, false, false, CMIType.None),
        BEACON_INTERACTION("Beacon interactions", svt.Number, false, false, CMIType.None),
        CRAFTING_TABLE_INTERACTION("Crafting table interactions", svt.Number, false, false, CMIType.None),
        FURNACE_INTERACTION("Furnace interactions", svt.Number, false, false, CMIType.None),
        DISPENSER_INSPECTED("Dispenser inspected", svt.Number, false, false, CMIType.None),
        DROPPER_INSPECTED("Dropper inspected", svt.Number, false, false, CMIType.None),
        HOPPER_INSPECTED("Hopper inspected", svt.Number, false, false, CMIType.None),
        CHEST_OPENED("Chest open", svt.Number, false, false, CMIType.None),
        TRAPPED_CHEST_TRIGGERED("Trapped chest triggered", svt.Number, false, false, CMIType.None),
        ENDERCHEST_OPENED("Ender chest opened", svt.Number, false, false, CMIType.None),
        NOTEBLOCK_PLAYED("Noteblock played", svt.Number, false, false, CMIType.None),
        NOTEBLOCK_TUNED("Noteblock tuned", svt.Number, false, false, CMIType.None),
        FLOWER_POTTED("Flower potted", svt.Number, false, false, CMIType.None),
        RECORD_PLAYED("Record played", svt.Number, false, false, CMIType.None),
        SLEEP_IN_BED("Slept in bed", svt.Number, false, false, CMIType.None),
        SHULKER_BOX_OPENED("Shulker box opened", svt.Number, false, false, CMIType.None),
        CLEAN_SHULKER_BOX("Shulker box cleaned", svt.Number, false, false, CMIType.None),
        DROP("Item dropped", svt.Number, false, true, CMIType.Material),
        MINE_BLOCK("Blocks mined", svt.Number, true, true, CMIType.Block),
        PLACE_BLOCK("Blocks placed", svt.Number, true, true, CMIType.Block, Statistic.USE_ITEM),
        BREAK_ITEM("Item breaks", svt.Number, false, true, CMIType.Material),
        CRAFT_ITEM("Item crafts", svt.Number, false, true, CMIType.Material),
        USE_ITEM("Items used", svt.Number, false, true, CMIType.Material),
        PICKUP("Item pickups", svt.Number, false, true, CMIType.Material),
        KILL_ENTITY("Monster kills", svt.Number, false, true, CMIType.Entity),
        STRIDER_ONE_CM("Strider travel", svt.Distance, false, false, CMIType.None),
        INTERACT_WITH_BLAST_FURNACE("Interaction with blast furnace", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_SMOKER("Interaction with smoker", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_LECTERN("Interaction with lectern", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_CAMPFIRE("Interaction with campfire", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_CARTOGRAPHY_TABLE("Interaction with cartography table", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_LOOM("Interaction with loom", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_STONECUTTER("Interaction with stonecutter", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_ANVIL("Interaction with anvil", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_GRINDSTONE("Interaction with grindstone", svt.Number, false, false, CMIType.None),
        INTERACT_WITH_SMITHING_TABLE("Interaction with smithing table", svt.Number, false, false, CMIType.None),
        BELL_RING("Bell rings", svt.Number, false, false, CMIType.None),
        RAID_TRIGGER("Raid triggers", svt.Number, false, false, CMIType.None),
        RAID_WIN("Raid wins", svt.Number, false, false, CMIType.None),
        TARGET_HIT("Target hits", svt.Number, false, false, CMIType.None),
        OPEN_BARREL("Opened barrels", svt.Number, false, false, CMIType.None),
        DROP_COUNT("Drop count", svt.Number, false, false, CMIType.None),
        TOTAL_WORLD_TIME("Time in world", svt.Time, false, false, CMIType.None);

        private svt type;
        private boolean isBlock;
        private boolean isSubSatistic;
        private CMIType subType;
        private String name;
        private String newName;
        private Statistic bukkit;
        private boolean checked = false;

        private CMIStatistic(String string2, svt svt2, boolean bl, boolean bl2, CMIType cMIType, Statistic statistic) {
            this(string2, svt2, bl, bl2, cMIType, "");
            this.bukkit = statistic;
        }

        private CMIStatistic(String string2, svt svt2, boolean bl, boolean bl2, CMIType cMIType, String string3) {
            this.name = string2;
            this.type = svt2;
            this.isBlock = bl;
            this.isSubSatistic = bl2;
            this.subType = cMIType;
            this.newName = string3.isEmpty() ? null : string3;
        }

        private CMIStatistic(String string2, svt svt2, boolean bl, boolean bl2, CMIType cMIType) {
            this(string2, svt2, bl, bl2, cMIType, "");
        }

        public svt getType() {
            return this.type;
        }

        public boolean isBlock() {
            return this.isBlock;
        }

        public void setBlock(boolean bl) {
            this.isBlock = bl;
        }

        public boolean isSubSatistic() {
            return this.isSubSatistic;
        }

        public void setSubSatistic(boolean bl) {
            this.isSubSatistic = bl;
        }

        public CMIType getSubType() {
            return this.subType;
        }

        public Statistic getBukkitStat() {
            if (this.bukkit == null && !this.checked) {
                this.checked = true;
                Statistic[] statisticArray = Statistic.values();
                int n = statisticArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Statistic statistic = statisticArray[n2];
                    if (statistic.name().equalsIgnoreCase(this.name())) {
                        this.bukkit = statistic;
                    }
                    if (this.getNewName() != null && statistic.name().equalsIgnoreCase(this.getNewName())) {
                        this.bukkit = statistic;
                    }
                    ++n2;
                }
            }
            return this.bukkit;
        }

        public String getName() {
            return this.name;
        }

        public String getNewName() {
            return this.newName;
        }

        public static CMIStatistic getByName(String string) {
            return (CMIStatistic)((Object)cache.get(string.toLowerCase().replace("_", "")));
        }
    }

    public static enum CMIType {
        None,
        Material,
        Block,
        Entity;

    }

    public static enum svt {
        Time,
        Distance,
        Damage,
        Number;

    }
}

