/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.TabList;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.events.CMIAfkEnterEvent;
import com.Zrips.CMI.events.CMIAfkLeaveEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TabListListener
implements Listener {
    private CMI plugin;

    public TabListListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnJoin()) {
            return;
        }
        this.plugin.getTabListManager().updateTablistName(player);
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnLeave()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnWorldChange()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnPlayerDeath()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCMIAfkLeaveEvent(CMIAfkLeaveEvent cMIAfkLeaveEvent) {
        Player player = cMIAfkLeaveEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnAfkStateChange()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCMIAfkEnterEvent(CMIAfkEnterEvent cMIAfkEnterEvent) {
        Player player = cMIAfkEnterEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnAfkStateChange()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleportEvent(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getTabListManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getTabListManager().isUpdatesOnPlayerTeleport()) {
            return;
        }
        this.plugin.getTabListManager().updateTabList(3);
    }
}

