/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Display.CMITextDisplay;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;

public class CMIChatBubble {
    private CMITextDisplay tDisplay;
    private Player player;
    private Location originPoint;
    private Location prevloc;
    private String text;
    private long startTime;
    private long endTime;
    private Set<Player> receivers;
    private CMITask schedId = null;

    public CMIChatBubble(Player player, String string, Set<Player> set) {
        this.player = player;
        this.text = string;
        this.receivers = new HashSet<Player>(set);
        this.receivers.remove(player);
        this.originPoint = this.generateLoc();
        this.startTime = System.currentTimeMillis();
        this.endTime = (long)((double)this.startTime + CMI.getInstance().getChatBubbleManager().getShowFor(string) * 1000.0);
        this.initialRecheckReceivers();
        this.generateDisplay();
    }

    public void show() {
        this.tasker();
    }

    private void tasker() {
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        this.recheckReceivers();
        this.spawnIn();
        this.schedId = CMIScheduler.runTimerAsync(() -> {
            if (this.endTime < System.currentTimeMillis() || this.receivers.isEmpty() || !this.originPoint.getWorld().equals(this.player.getWorld())) {
                this.remove();
                this.schedId.cancel();
                this.schedId = null;
                return;
            }
            this.recheckReceivers();
            if (this.prevloc == null || this.prevloc.getX() != this.player.getLocation().getX() || this.prevloc.getY() != this.player.getLocation().getY() || this.prevloc.getZ() != this.player.getLocation().getZ()) {
                this.sendUpdate();
            }
            this.prevloc = this.player.getLocation();
        }, (long)1L, (long)1L);
    }

    public void delete() {
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        this.remove();
    }

    private void remove() {
        if (this.tDisplay == null) {
            return;
        }
        for (Player player : this.receivers) {
            this.tDisplay.destroy(player);
        }
    }

    private Location generateLoc() {
        Location location = this.player.getLocation().clone().add(0.0, CMI.getInstance().getChatBubbleManager().getOffset(), 0.0);
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        return location;
    }

    private void spawnIn() {
        this.tDisplay.setLocation(this.generateLoc());
        for (Player player : this.receivers) {
            this.tDisplay.show(player);
        }
    }

    private void sendUpdate() {
        this.tDisplay.setLocation(this.generateLoc());
        for (Player player : this.receivers) {
            this.tDisplay.update(player);
        }
    }

    private void initialRecheckReceivers() {
        Iterator<Player> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            if (!CMI.getInstance().getChatBubbleManager().inRange(player.getLocation(), this.player.getLocation())) {
                if (this.tDisplay != null) {
                    this.tDisplay.destroy(player);
                }
                iterator.remove();
                continue;
            }
            if (!player.canSee(this.player)) {
                if (this.tDisplay != null) {
                    this.tDisplay.destroy(player);
                }
                iterator.remove();
                continue;
            }
            if (CMIUser.getUser(player).getOptionState(PlayerOption.chatbubble).booleanValue()) continue;
            if (this.tDisplay != null) {
                this.tDisplay.destroy(player);
            }
            iterator.remove();
        }
    }

    private void recheckReceivers() {
        Iterator<Player> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            if (!CMI.getInstance().getChatBubbleManager().inRange(player.getLocation(), this.player.getLocation())) {
                iterator.remove();
                if (this.tDisplay == null) continue;
                this.tDisplay.destroy(player);
                continue;
            }
            if (player.getGameMode().equals((Object)GameMode.SPECTATOR) || !this.player.getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
            iterator.remove();
            if (this.tDisplay == null) continue;
            this.tDisplay.destroy(player);
        }
    }

    private void generateDisplay() {
        this.tDisplay = new CMITextDisplay(this.originPoint);
        this.tDisplay.setText(" " + this.text + " ");
        this.tDisplay.setLineWidth(CMI.getInstance().getChatBubbleManager().getLineWidth());
        this.tDisplay.setBillboard(Display.Billboard.VERTICAL);
        this.tDisplay.setWidth(CMI.getInstance().getChatBubbleManager().getScale());
        this.tDisplay.setHeight(CMI.getInstance().getChatBubbleManager().getScale());
        this.tDisplay.setRange(32);
        if (CMI.getInstance().getChatBubbleManager().getBackgroundColor() != null) {
            this.tDisplay.setBackgroundColor(CMI.getInstance().getChatBubbleManager().getBackgroundColor());
        }
        this.tDisplay.setShadowed(CMI.getInstance().getChatBubbleManager().isShadow());
    }
}

