/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Display.CMIDisplay;
import com.Zrips.CMI.Modules.Display.CMIInteractionEntity;
import com.Zrips.CMI.Modules.Display.CMIItemDisplay;
import com.Zrips.CMI.Modules.Display.CMITextAlignment;
import com.Zrips.CMI.Modules.Display.CMITextDisplay;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import com.Zrips.CMI.Modules.Holograms.CMIHologramBatch;
import com.Zrips.CMI.Modules.Holograms.CMIHologramLine;
import com.Zrips.CMI.Modules.Holograms.CMIHologramPage;
import com.Zrips.CMI.Modules.Holograms.HologramManager;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.Modules.Portals.CMIPlane;
import com.Zrips.CMI.Modules.Portals.CMIPlaneIntersection;
import com.Zrips.CMI.Modules.Portals.CMIVector2D;
import com.Zrips.CMI.Modules.Portals.CMIVector3D;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CMIHologram {
    private String name = null;
    private CMITask schedId = null;
    private CMITask pageSchedId = null;
    private CMITask lineOfSightSchedId = null;
    private boolean enabled = true;
    private boolean saveToFile = false;
    private boolean showWhenNotPersistent = false;
    private Player playerToShowFor = null;
    private int selfDestructIn = 0;
    private boolean sticky = false;
    private boolean autoPagination = false;
    private CuboidArea area;
    private CuboidArea areaExtra;
    private List<String> commands = new ArrayList<String>();
    private double LOSupdateIntervalSec = 0.0;
    private double followPlayer = 1.0;
    private double updateIntervalSec = HologramManager.defaultUpdateInterval;
    private double pageChangeIntervalSec = HologramManager.defaultpageChangeInterval;
    private int updateRange = HologramManager.defaultUpdateRange;
    private int showRange = HologramManager.defaultViewRange;
    private double spacing = 0.24;
    private double iconSpacing = 0.5;
    private boolean downOrder = HologramManager.defaultsPlaceUp;
    private CMILocation loc;
    private Vector centerLocation = null;
    private boolean interactable = false;
    private boolean bigButton = true;
    private boolean showParticle = true;
    private boolean requestPermission = false;
    private static String left = "!leftclick!";
    private static String right = "!rightclick!";
    private static String shiftLeft = "!shiftleftclick!";
    private static String shiftRight = "!shiftrightclick!";
    static Pattern pagePatern = Pattern.compile("(?i)(!nextpage!)");
    private List<String> lines = new ArrayList<String>();
    private int lineCount = 0;
    private List<String> oldLines = new ArrayList<String>();
    private boolean changedLines = false;
    private ConcurrentHashMap<UUID, Integer> inPage = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Integer> hoveringLine = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Boolean> hoveringSide = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, CMIHologramPage> pages = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, CMIHologramPage> oldPages = new ConcurrentHashMap();
    private Multiset<UUID> lastHoloInRange = ConcurrentHashMultiset.create();
    private Multiset<UUID> lastHoloInRangeExtra = ConcurrentHashMultiset.create();
    private boolean uSync = true;
    private boolean newIneractionMethod = true;
    private CMITask hoverOverSchedId = null;
    private double extraInteractionHeight = 0.0;
    private double extraInteractionWidth = 0.0;
    private boolean newDisplayMethod = false;
    private CMIBillboard billboard = null;
    private CMIBillboard iconBillboard = null;
    private CMITextAlignment textAlignment = null;
    private int yaw = 0;
    private int pitch = 0;
    private CMIChatColor backgroundColor = CMIChatColor.BLACK;
    private int backgroundAlpha = 125;
    private int textAlpha = 230;
    private boolean doubleSided = false;
    private boolean shadowed = true;
    private double scaleW = 1.0;
    private double scaleH = 1.0;
    private boolean seeThrough = false;
    private double iconScale = 1.0;
    private int iconPitch = 0;
    private int iconYaw = 0;
    private int skyLevel = -1;
    private int blockLevel = -1;
    private short particlePosition = 0;
    private double particleSpacing = 0.0;
    private int particleCount = 1;
    private CMIEffect effect = new CMIEffect(CMIEffectManager.CMIParticle.SMALL_SMOKE);
    private boolean showHoverParticle = true;
    private boolean stabilizedHoverParticles = false;
    private double extraParticleHeight = 0.0;
    private double extraParticleWidth = 0.0;
    private double particleOffsetX = 0.0;
    private double particleOffsetY = 0.0;
    Set<UUID> skipPageChange = new HashSet<UUID>();
    ConcurrentHashMap<Integer, String> changed = new ConcurrentHashMap();
    List<Integer> changedPages = new ArrayList<Integer>();
    ConcurrentHashMap<UUID, Long> nextUpdate = new ConcurrentHashMap();
    List<UUID> stillUpdating = Collections.synchronizedList(new ArrayList());
    ConcurrentHashMap<UUID, CMIHologramBatch> playerDisplays = new ConcurrentHashMap();
    CompletableFuture<Void> task = null;
    ConcurrentHashMap<UUID, List<CMIDataWatcher>> cache = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, FakeInfo> clickableById = new ConcurrentHashMap();
    ConcurrentHashMap<UUID, FakeInfo> clickableByPlayer = new ConcurrentHashMap();
    Set<UUID> skipPlayers = Collections.synchronizedSet(new HashSet());

    public CMIHologram(String string, Location location) {
        this(string, new CMILocation(location));
    }

    public CMIHologram(String string, Location location, Player player) {
        this(string, new CMILocation(location));
        this.playerToShowFor = player;
        this.lastHoloInRangeExtra.add((Object)player.getUniqueId());
        this.lastHoloInRange.add((Object)player.getUniqueId());
        CMI.getInstance().getHologramManager().addHologram(this, false, false);
    }

    public CMIHologram(Location location, Player player, List<String> list2) {
        this.playerToShowFor = player;
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        this.loc = new CMILocation(location);
        this.lines = list2;
        this.lastHoloInRangeExtra.add((Object)player.getUniqueId());
        this.lastHoloInRange.add((Object)player.getUniqueId());
    }

    public CMIHologram(String string, CMILocation cMILocation) {
        this.name = string;
        cMILocation.setPitch(0.0f);
        cMILocation.setYaw(0.0f);
        this.loc = cMILocation;
        this.updatePages();
    }

    public void onInteraction(Player player, CMIInteractType cMIInteractType) {
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getCommands(Player player) {
        return this.getCommands(player, null);
    }

    public void goToNextPage(UUID uUID) {
        Integer n = this.inPage.get(uUID);
        if (n == null) {
            n = 2;
            if (this.pages.size() == 1) {
                n = 1;
            }
        } else if ((n = Integer.valueOf(n + 1)) > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, this.getPlayerPage(uUID), n);
        this.inPage.put(uUID, n);
        this.skipPageChange.add(uUID);
    }

    private void goToNextPageAuto(UUID uUID) {
        if (this.skipPageChange.contains(uUID)) {
            return;
        }
        Integer n = this.inPage.get(uUID);
        if (n == null) {
            n = 2;
            if (this.pages.size() == 1) {
                n = 1;
            }
        } else if ((n = Integer.valueOf(n + 1)) > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, this.getPlayerPage(uUID), n);
        this.inPage.put(uUID, n);
    }

    public Integer getPlayerPage(UUID uUID) {
        Integer n = this.inPage.get(uUID);
        return n == null ? 1 : n;
    }

    public void goToPrevPage(UUID uUID) {
        Integer n = this.inPage.get(uUID);
        if (n == null) {
            n = this.pages.size();
        } else if ((n = Integer.valueOf(n - 1)) <= 0) {
            n = this.pages.size();
        }
        this.checkPageChange(uUID, this.getPlayerPage(uUID), n);
        this.inPage.put(uUID, n);
        this.skipPageChange.add(uUID);
    }

    public void goToPage(UUID uUID, int n) {
        if (n <= 0) {
            n = this.pages.size();
        } else if (n > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, this.getPlayerPage(uUID), n);
        this.inPage.put(uUID, n);
        this.skipPageChange.add(uUID);
    }

    private void checkPageChange(UUID uUID, Integer n, Integer n2) {
        if (n == null || n2 == null) {
            this.removeFromCache(uUID);
            return;
        }
        CMIHologramPage cMIHologramPage = this.getPage(n);
        CMIHologramPage cMIHologramPage2 = this.getPage(n2);
        if (cMIHologramPage != null && cMIHologramPage2 != null) {
            List<String> list2;
            int n3 = cMIHologramPage.getLines().size();
            int n4 = cMIHologramPage2.getLines().size();
            if (n3 > 0 && cMIHologramPage.getLines().get(0).getType() == CMIHoloLineType.image && (list2 = cMIHologramPage.getLines().get(0).getPlainImage()) != null) {
                n3 = list2.size();
            }
            if (n4 > 0 && cMIHologramPage2.getLines().get(0).getType() == CMIHoloLineType.image && (list2 = cMIHologramPage2.getLines().get(0).getPlainImage()) != null) {
                n4 = list2.size();
            }
            if (n3 != n4) {
                this.removeFromCache(uUID, n4);
            }
            this.clearIconLines(uUID, cMIHologramPage2);
            this.skipPlayers.add(uUID);
        } else {
            this.removeFromCache(uUID);
        }
        this.recheckLines();
    }

    private double getLineHeight() {
        return 0.25 * this.getScaleH();
    }

    private List<String> getCommandsByPlayerPage(UUID uUID) {
        if (uUID == null) {
            return this.commands;
        }
        Integer n = this.inPage.get(uUID);
        if (n == null) {
            n = 1;
        }
        n = this.pages.size() < n ? 1 : n;
        if (this.pages.isEmpty()) {
            return this.commands;
        }
        List<String> list2 = this.pages.get(n).getCommands();
        if (list2.isEmpty() && !this.getCommands().isEmpty()) {
            list2 = new ArrayList<String>(this.getCommands());
        }
        return list2;
    }

    private List<CMIHologramLine> getLinesByPlayerPage(Player player) {
        Integer n = this.inPage.get(player.getUniqueId());
        if (n == null) {
            n = 1;
        }
        n = this.pages.size() < n ? 1 : n;
        if (this.pages.isEmpty()) {
            return null;
        }
        CMIHologramPage cMIHologramPage = this.pages.get(n);
        if (cMIHologramPage == null) {
            if (this.pages.values().iterator().hasNext()) {
                return this.pages.values().iterator().next().getLines();
            }
            return new ArrayList<CMIHologramLine>();
        }
        return cMIHologramPage.getLines();
    }

    public void updatePages() {
        CMIHologramPage cMIHologramPage;
        Matcher matcher;
        int n = 1;
        this.oldPages.clear();
        this.oldPages.putAll(this.pages);
        this.pages.clear();
        for (String string : this.commands) {
            matcher = pagePatern.matcher(string);
            while (matcher.find()) {
                ++n;
            }
            cMIHologramPage = this.pages.get(n);
            if (cMIHologramPage == null) {
                cMIHologramPage = new CMIHologramPage();
                cMIHologramPage.setPage(n);
                this.pages.put(n, cMIHologramPage);
            }
            cMIHologramPage.getCommands().add(string);
        }
        n = 1;
        for (String string : this.lines) {
            matcher = pagePatern.matcher(string);
            if (matcher.find()) {
                ++n;
                continue;
            }
            cMIHologramPage = this.pages.get(n);
            if (cMIHologramPage == null) {
                cMIHologramPage = new CMIHologramPage();
                cMIHologramPage.setPage(n);
                this.pages.put(n, cMIHologramPage);
            }
            CMIHologramLine cMIHologramLine = new CMIHologramLine(string);
            cMIHologramPage.getLines().add(cMIHologramLine);
            cMIHologramPage.setHeight(this.getHeight(cMIHologramPage.getLines()));
            cMIHologramPage.calculateWidth();
        }
        this.recalculateChangedPages();
        this.centerLocation = null;
    }

    public List<String> getCommands(Player player, CMIInteractType cMIInteractType) {
        Snd snd = new Snd().setSender(player).setTarget(player);
        ArrayList<String> arrayList = new ArrayList<String>();
        block8: for (String string : this.getCommandsByPlayerPage(player == null ? null : player.getUniqueId())) {
            String string2 = string;
            if (string2.startsWith(left) || string2.startsWith(right)) {
                if (cMIInteractType != null) {
                    switch (cMIInteractType) {
                        case LeftClick: {
                            if (!string2.startsWith(left)) continue block8;
                            string2 = string2.substring(left.length());
                            if (player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        case RightClick: {
                            if (!string2.startsWith(right)) continue block8;
                            string2 = string2.substring(right.length());
                            if (player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        default: {
                            if (string2.startsWith(left)) {
                                string2 = string2.substring(left.length());
                            }
                            if (string2.startsWith(right)) {
                                string2 = string2.substring(right.length());
                            }
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                    }
                    continue;
                }
                if (string2.startsWith(left)) {
                    string2 = string2.substring(left.length());
                }
                if (string2.startsWith(right)) {
                    string2 = string2.substring(right.length());
                }
                if (string2.startsWith(shiftLeft)) {
                    string2 = string2.substring(shiftLeft.length());
                }
                if (string2.startsWith(shiftRight)) {
                    string2 = string2.substring(shiftRight.length());
                }
                arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                continue;
            }
            if (string2.startsWith(shiftLeft) || string2.startsWith(shiftRight)) {
                if (cMIInteractType != null) {
                    switch (cMIInteractType) {
                        case LeftClick: {
                            if (!string2.startsWith(shiftLeft)) continue block8;
                            string2 = string2.substring(shiftLeft.length());
                            if (!player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        case RightClick: {
                            if (!string2.startsWith(shiftRight)) continue block8;
                            string2 = string2.substring(shiftRight.length());
                            if (!player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        default: {
                            if (string2.startsWith(shiftLeft)) {
                                string2 = string2.substring(shiftLeft.length());
                            }
                            if (string2.startsWith(shiftRight)) {
                                string2 = string2.substring(shiftRight.length());
                            }
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                    }
                    continue;
                }
                if (string2.startsWith(left)) {
                    string2 = string2.substring(left.length());
                }
                if (string2.startsWith(right)) {
                    string2 = string2.substring(right.length());
                }
                if (string2.startsWith(shiftLeft)) {
                    string2 = string2.substring(shiftLeft.length());
                }
                if (string2.startsWith(shiftRight)) {
                    string2 = string2.substring(shiftRight.length());
                }
                arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                continue;
            }
            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
        }
        return arrayList;
    }

    public void setCommands(List<String> list2) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        this.commands.addAll(list2);
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    @Deprecated
    public Location getLoc() {
        return this.getLocation();
    }

    public CMILocation getLocation() {
        return this.loc;
    }

    public void setLoc(Location location) {
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        this.loc = new CMILocation(location);
        if (this.getPlayerToShowFor() != null) {
            this.setArea(null);
            this.setAreaExtra(null);
        } else {
            this.setArea(null);
            this.setAreaExtra(null);
            CMI.getInstance().getHologramManager().recalculateChunksExtra(this);
            CMI.getInstance().getHologramManager().addPlayersNearHoloExtra(this, false);
            CMI.getInstance().getHologramManager().recalculateChunks(this);
            CMI.getInstance().getHologramManager().addPlayersNearHolo(this, false);
            this.centerLocation = null;
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String getLine(int n) {
        return this.lines.size() - 1 < n || n < 0 ? "" : (this.lines.get(n) == null ? "" : this.lines.get(n));
    }

    public void setLines(List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) == null || arrayList.get(n).isEmpty()) {
                arrayList.set(n, "_");
            }
            ++n;
        }
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        this.lines.clear();
        this.lines.addAll(arrayList);
        this.recheckLines();
    }

    public void addLine(String string) {
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        this.lines.add(string);
        this.recheckLines();
    }

    public void setLine(int n, String string) {
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        while (this.lines.size() <= n) {
            this.lines.add("");
        }
        this.lines.set(n, string);
        this.recheckLines();
    }

    public void removeLine(int n) {
        if (this.lines.size() >= n) {
            try {
                this.lines.remove(n - 1);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.recheckLines();
    }

    public boolean isChangedLine() {
        return this.changedLines;
    }

    private void recheckLines() {
        if (this.oldLines.size() != this.lines.size()) {
            this.changedLines = true;
            this.recalcualteChangedLines();
            return;
        }
        for (String string : this.lines) {
            if (this.oldLines.contains(string)) continue;
            this.changedLines = true;
            this.recalcualteChangedLines();
            return;
        }
        this.changedLines = false;
    }

    public CuboidArea getArea() {
        if (this.area == null) {
            this.area = new CuboidArea(this.getLocation().clone().add((double)(-this.updateRange), (double)(-this.updateRange), (double)(-this.updateRange)), this.getLocation().clone().add((double)this.updateRange, (double)this.updateRange, (double)this.updateRange));
        }
        return this.area;
    }

    public CuboidArea getAreaExtra() {
        if (this.areaExtra == null) {
            this.areaExtra = new CuboidArea(this.getLocation().clone().add((double)(-this.showRange), (double)(-this.showRange), (double)(-this.showRange)), this.getLocation().clone().add((double)this.showRange, (double)this.showRange, (double)this.showRange));
        }
        return this.areaExtra;
    }

    public void setArea(CuboidArea cuboidArea) {
        this.area = cuboidArea;
    }

    public void setAreaExtra(CuboidArea cuboidArea) {
        this.areaExtra = cuboidArea;
    }

    public void update() {
        this.updatePages();
        this.recheckTaskers();
        if (this.getPlayerToShowFor() != null) {
            if (this.getPlayerToShowFor().isOnline()) {
                this.update(this.getPlayerToShowFor());
            }
            return;
        }
        if (this.area != null) {
            for (UUID uUID : this.getLastHoloInRangeExtra()) {
                this.update(CMIUser.getOnlinePlayer(uUID));
            }
        }
    }

    @Deprecated
    public void hide(Player player) {
        if (player == null) {
            return;
        }
        this.hide(player.getUniqueId());
    }

    public void refresh() {
        this.hide();
        this.updatePages();
        this.update();
    }

    public void hide() {
        try {
            if (this.task != null) {
                this.task.cancel(true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeFromCache(player.getUniqueId());
        }
        this.stop();
    }

    public void hide(UUID uUID) {
        if (uUID == null) {
            return;
        }
        this.removeFromCache(uUID);
    }

    public double getHeight() {
        double d = 0.0;
        int n = 0;
        while (n < this.lines.size()) {
            String string = this.lines.get(n);
            if (string.equalsIgnoreCase("!nextpage!")) break;
            if (string.equals("_")) {
                string = "";
            }
            d = string.startsWith("SICON:") ? (d += this.getSpacing().doubleValue()) : (string.startsWith("ICON:") ? (d += this.getIconSpacing().doubleValue()) : (d += this.getSpacing().doubleValue()));
            ++n;
        }
        return d;
    }

    private double getHeight(List<CMIHologramLine> list2) {
        double d = this.getSpacing() / 2.0;
        int n = 0;
        while (n < list2.size()) {
            CMIHologramLine cMIHologramLine = list2.get(n);
            String string = cMIHologramLine.getText();
            if (string.equalsIgnoreCase("!nextpage!")) break;
            if (string.equals("_")) {
                string = "";
            }
            if (cMIHologramLine.getType().equals((Object)CMIHoloLineType.staticIcon)) {
                d += this.getSpacing().doubleValue();
            } else if (cMIHologramLine.getType().equals((Object)CMIHoloLineType.icon)) {
                d += this.getIconSpacing().doubleValue();
                d += this.getSpacing() / 2.0;
            } else {
                d += this.getSpacing().doubleValue();
            }
            ++n;
        }
        if (this.isAutoPagination()) {
            d += this.getSpacing().doubleValue();
        }
        return d;
    }

    public Vector getCenterVector() {
        if (this.centerLocation != null) {
            return this.centerLocation.clone();
        }
        this.centerLocation = this.getCenterLocation().toVector();
        return this.centerLocation.clone();
    }

    public Location getCenterLocation() {
        double d = this.getHeight();
        CMILocation cMILocation = this.getLocation().clone();
        cMILocation.add(0.0, 0.25, 0.0);
        if (this.isDownOrder().booleanValue()) {
            cMILocation.add(0.0, -(d / 2.0), 0.0);
        } else {
            cMILocation.add(0.0, d / 2.0, 0.0);
        }
        return cMILocation;
    }

    private void recalcualteChangedLines() {
        if (!this.changedLines) {
            this.changed.clear();
            this.changedPages.clear();
            return;
        }
        List<String> list2 = this.getLines();
        int n = 0;
        while (n < list2.size()) {
            String string = this.lines.get(n);
            String string2 = "";
            if (n < this.oldLines.size()) {
                string2 = this.oldLines.get(n);
            }
            if (!string.equals(string2)) {
                this.changed.put(n, string);
            }
            ++n;
        }
    }

    @Deprecated
    private void recalcualteChangedPages() {
        this.recalculateChangedPages();
    }

    private void recalculateChangedPages() {
        if (!this.changedLines) {
            return;
        }
        this.changedPages.clear();
        for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
            Map.Entry<UUID, Integer> entry2 = this.oldPages.get(entry.getKey());
            if (entry2 == null) {
                this.changedPages.add(entry.getKey());
                continue;
            }
            if (((CMIHologramPage)((Object)entry2)).getLines().size() == entry.getValue().getLines().size()) continue;
            this.changedPages.add(entry.getKey());
        }
        for (Integer n : this.changedPages) {
            for (Map.Entry<UUID, Integer> entry2 : new ConcurrentHashMap<UUID, Integer>(this.inPage).entrySet()) {
                if (entry2.getValue() != n) continue;
                this.removeFromCache((UUID)entry2.getKey());
            }
        }
    }

    public void moveTo(Location location) {
        this.setLoc(location);
        this.move(this.getLocation().clone().toVector(), location, true);
        if (this.isSaveToFile()) {
            CMI.getInstance().getHologramManager().save();
        }
    }

    public void superficialMoveTo(Location location) {
        this.move(this.getLocation().clone().toVector(), location, false);
    }

    private void move(Vector vector, Location location, boolean bl) {
        if (this.isNewDisplayMethod()) {
            double d = 0.0;
            if (this.isDownOrder().booleanValue()) {
                d = (double)this.lineCount * this.getLineHeight();
            }
            for (UUID uUID : this.lastHoloInRangeExtra) {
                this.moveHologramFor(uUID, location, d);
            }
            return;
        }
        for (UUID uUID : this.lastHoloInRangeExtra) {
            this.moveHologramFor(uUID, location, vector, bl);
        }
    }

    private void moveHologramFor(UUID uUID, Location location, double d) {
        CMIHologramBatch cMIHologramBatch = this.playerDisplays.get(uUID);
        if (cMIHologramBatch == null) {
            return;
        }
        for (CMIDisplay object : cMIHologramBatch.getDisplays().values()) {
            object.setLocation(location.clone().add(0.0, -d, 0.0));
            object.update(CMIUser.getOnlinePlayer(uUID));
        }
        for (Map.Entry entry : cMIHologramBatch.getIcons().entrySet()) {
            CMIVector3D cMIVector3D = this.getIconPositionOffset((Integer)entry.getKey());
            ((CMIDisplay)entry.getValue()).setLocation(location.clone().add(cMIVector3D.getX(), cMIVector3D.getY(), cMIVector3D.getZ()));
        }
    }

    private void moveHologramFor(UUID uUID, Location location, Vector vector, boolean bl) {
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        List<CMIDataWatcher> list2 = this.cache.get(uUID);
        if (list2 == null) {
            return;
        }
        for (CMIDataWatcher cMIDataWatcher : list2) {
            Vector vector2 = cMIDataWatcher.getLoc().toVector();
            Vector vector3 = vector2.subtract(vector);
            vector3.setZ(0);
            vector3.setX(0);
            Location location2 = location.clone().add(vector3);
            if (bl) {
                cMIDataWatcher.setLoc(location2);
            }
            CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, cMIDataWatcher.getStand(), location2);
        }
    }

    public void update(Player player) {
        this.update(player, false);
    }

    private List<CMIVector3D> getLocation(Player player, int n) {
        CMIHologramPage cMIHologramPage = this.getPage(this.getPlayerPage(player.getUniqueId()));
        if (cMIHologramPage == null) {
            cMIHologramPage = this.getPage(1);
        }
        if (cMIHologramPage == null) {
            return null;
        }
        double d = (double)cMIHologramPage.getWidth() / 74.0 * this.getScaleW() + this.getExtraParticleWidth();
        double d2 = cMIHologramPage.getHeight() * this.getScaleH() + this.getExtraParticleHeight();
        if (this.isNewDisplayMethod()) {
            d2 += 0.2;
        }
        int n2 = 10;
        double d3 = 0.1;
        double d4 = 0.1;
        if (this.getParticleSpacing() > 0.0) {
            d3 = this.getParticleSpacing();
            d4 = this.getParticleSpacing();
        } else {
            d3 = d > d2 ? d / (double)n2 : d2 / (double)n2;
            if (d3 < 0.05) {
                d3 = 0.05;
            }
            if (d3 > 0.3) {
                d3 = 0.3;
            }
            d4 = d3;
        }
        double d5 = 0.0;
        if (!this.isStabilizedHoverParticles()) {
            d5 = Math.toRadians(player.getLocation().getYaw());
        } else {
            Location location = player.getLocation().clone();
            Vector vector = this.getLocation().toVector();
            location.setDirection(vector.subtract(location.toVector()));
            d5 = Math.toRadians(location.getYaw());
        }
        double d6 = 0.0;
        if (!this.isStabilizedHoverParticles()) {
            d6 = -player.getLocation().getDirection().getY();
            d6 = Math.max(-0.1, d6);
            d6 = Math.min(0.1, d6);
        }
        if (this.isNewDisplayMethod()) {
            d6 = 0.0;
            switch (this.getBillboard()) {
                case CENTER: {
                    break;
                }
                case FIXED: {
                    d5 = Math.toRadians((360 + this.getYaw()) % 360);
                    d6 = Math.toRadians(this.getPitch() % 90);
                    break;
                }
                case HORIZONTAL: {
                    break;
                }
                case VERTICAL: {
                    break;
                }
            }
        }
        double d7 = d * 2.0 / d3 * 2.0 + (d2 + d4 * 2.0) / d4 * 2.0 - 3.0;
        int n3 = (int)Math.ceil(d7 / (double)n);
        int n4 = this.particlePosition % n3;
        ++n4;
        ArrayList<CMIVector3D> arrayList = new ArrayList<CMIVector3D>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n5 = 1;
        while (n5 <= n) {
            double d8;
            int n6 = 0;
            int n7 = n4 + (n5 - 1) * n3;
            if (d * 2.0 / d3 >= (double)n7) {
                d8 = -d + d3;
                while (d8 <= d) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d8 + this.getParticleOffsetX(), this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 += d3;
                }
            } else if (d2 / d4 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d * 2.0 / d3))))) {
                d8 = d4 / 2.0;
                while (d8 <= d2) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d + this.getParticleOffsetX(), d8 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 += d4;
                }
            } else if (d * 2.0 / d3 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d2 / d4))))) {
                d8 = d - d3;
                while (d8 >= -d) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d8 + this.getParticleOffsetX(), d2 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 -= d3;
                }
            } else if (d2 / d4 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d * 2.0 / d3))))) {
                d8 = d2 - d4 / 2.0;
                while (d8 >= 0.0) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(-d + this.getParticleOffsetX(), d8 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 -= d4;
                }
            }
            arrayList2.add(n6);
            ++n5;
        }
        return arrayList;
    }

    private int getLineCount(CMIHologramPage cMIHologramPage) {
        return this.isAutoPagination() ? cMIHologramPage.getLines().size() + 1 : cMIHologramPage.getLines().size();
    }

    public void processPrevNextPageClick(Player player) {
        if (!this.isAutoPagination()) {
            return;
        }
        Boolean bl = this.hoveringSide.remove(player.getUniqueId());
        Integer n = this.hoveringLine.remove(player.getUniqueId());
        if (bl != null && n != null && n == this.lineCount) {
            if (!bl.booleanValue()) {
                this.goToNextPage(player.getUniqueId());
            } else {
                this.goToPrevPage(player.getUniqueId());
            }
            this.update(player);
        }
    }

    public void checkHoverPosition(Player player) {
        if (!this.isNewIneractionMethod()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            double d;
            boolean bl;
            double d2;
            CMIHologramPage cMIHologramPage = this.getPage(this.getPlayerPage(player.getUniqueId()));
            if (cMIHologramPage == null) {
                cMIHologramPage = this.getPage(1);
            }
            if (cMIHologramPage == null) {
                Integer n = this.hoveringLine.remove(player.getUniqueId());
                if (n != null) {
                    this.update(player, true);
                }
                return;
            }
            CMIHologramPage cMIHologramPage2 = cMIHologramPage;
            double d3 = d2 = this.isNewDisplayMethod() ? cMIHologramPage2.getHeight() : cMIHologramPage2.getHeight() - this.getSpacing() / 2.0 + this.getExtraInteractionHeight();
            if (CMI.getInstance().getUtilManager().getDistance(player.getEyeLocation(), (Location)this.getLocation()) > (double)this.getUpdateRange()) {
                HologramManager.CMIAiming cMIAiming;
                Integer n = this.hoveringLine.remove(player.getUniqueId());
                if (n != null) {
                    this.update(player, true);
                }
                if ((cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId())) != null && cMIAiming.getName().equals(this.getName())) {
                    CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
                }
                return;
            }
            if (!CMI.getInstance().getUtilManager().lookingAt(player, this.getCenterVector(), 90.0, 90.0)) {
                Integer n = this.hoveringLine.remove(player.getUniqueId());
                if (n != null) {
                    this.update(player, true);
                }
                return;
            }
            boolean bl2 = bl = this.isDownOrder().booleanValue();
            if (this.getLocation().getY() < 0.0) {
                bl2 = !bl2;
            }
            CMIPlane cMIPlane = new CMIPlane(this.getLocation().clone().add(0.0, this.isDownOrder() != false ? this.getSpacing() / 2.0 - 0.05 : -this.getSpacing().doubleValue() + 0.05, 0.0).toVector(), new CMIVector2D(-((double)cMIHologramPage2.getWidth() / 74.0) + this.getExtraInteractionWidth(), bl2 ? -d2 : 0.0), new CMIVector2D((double)cMIHologramPage2.getWidth() / 74.0 + this.getExtraInteractionWidth(), bl2 ? 0.0 : d2));
            Vector vector = player.getLocation().getDirection().clone();
            Vector vector2 = player.getEyeLocation().toVector();
            Vector vector3 = vector.clone();
            int n = this.getLineCount(cMIHologramPage2);
            if (this.isNewDisplayMethod()) {
                cMIPlane = new CMIPlane(this.getLocation().clone().toVector(), new CMIVector2D(-((double)cMIHologramPage2.getWidth() / 74.0) * this.getScaleW() + this.getExtraInteractionWidth(), bl2 ? -((double)n * this.getLineHeight()) + this.getExtraInteractionHeight() : 0.0), new CMIVector2D((double)cMIHologramPage2.getWidth() / 74.0 * this.getScaleW() + this.getExtraInteractionWidth(), bl2 ? 0.0 : (double)n * this.getLineHeight() + this.getExtraInteractionHeight()));
                switch (this.getBillboard()) {
                    case CENTER: {
                        break;
                    }
                    case FIXED: {
                        d = Math.toRadians(this.getPitch());
                        double d4 = Math.toRadians(this.getYaw());
                        double d5 = Math.cos(d) * Math.sin(d4);
                        double d6 = Math.sin(d);
                        double d7 = -Math.cos(d) * Math.cos(d4);
                        vector3.setX(d5);
                        vector3.setY(d6);
                        vector3.setZ(d7);
                        break;
                    }
                    case HORIZONTAL: {
                        vector3.setX(0);
                        break;
                    }
                    case VERTICAL: {
                        vector3.setY(0);
                        break;
                    }
                }
            }
            d = Math.abs(cMIPlane.getSizeMax().getX() - cMIPlane.getSizeMin().getX());
            CompletableFuture<CMIPlaneIntersection> completableFuture = CMIPlaneIntersection.get(vector, vector2, vector3, cMIPlane);
            completableFuture.thenApply(cMIPlaneIntersection -> {
                double d3;
                double d4;
                boolean bl;
                List<CMIVector3D> list2;
                if (cMIPlaneIntersection == null) {
                    Integer n2 = this.hoveringLine.remove(player.getUniqueId());
                    HologramManager.CMIAiming cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    if (cMIAiming != null && cMIAiming.getName().equals(this.getName())) {
                        CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
                    }
                    if (n2 != null) {
                        this.update(player, true);
                    }
                    return null;
                }
                if (this.isShowHoverParticle() && (list2 = this.getLocation(player, this.particleCount)) != null && !list2.isEmpty()) {
                    Location location;
                    if (this.isNewDisplayMethod()) {
                        double d5 = this.isDownOrder() != false ? 0.0 : cMIHologramPage2.getHeight();
                        for (CMIVector3D cMIVector3D : list2) {
                            location = this.getLocation().clone().add(cMIVector3D.getX(), cMIVector3D.getY() + d5 + this.getLineHeight() / 2.0, cMIVector3D.getZ());
                            CMILib.getInstance().getReflectionManager().playEffect(player, location, this.getHoverEffect());
                        }
                    } else {
                        for (CMIVector3D cMIVector3D : list2) {
                            double d6 = cMIVector3D.getY();
                            location = this.getLocation().clone().add(cMIVector3D.getX(), d6 += this.isDownOrder() != false ? this.getSpacing() / 2.0 : cMIHologramPage2.getHeight() - this.getSpacing(), cMIVector3D.getZ());
                            CMILib.getInstance().getReflectionManager().playEffect(player, location, this.getHoverEffect());
                        }
                    }
                }
                double d7 = d2 / (double)n;
                if (this.isNewDisplayMethod()) {
                    d7 = this.getLineHeight();
                }
                double d8 = Math.abs(cMIPlaneIntersection.getLocalLoc().getY()) / d7;
                double d9 = d8 = (d8 = (double)(Math.abs((int)d8) + 1)) > (double)n ? (double)n : d8;
                if (this.isNewDisplayMethod() && !this.isDownOrder().booleanValue()) {
                    d8 = (double)n - d8 + 1.0;
                }
                boolean bl2 = bl = cMIPlaneIntersection.getLocalLoc().getX() < 0.0;
                if (this.getTextAlignment().equals((Object)CMITextAlignment.LEFT) || this.getTextAlignment().equals((Object)CMITextAlignment.RIGHT)) {
                    int n3 = CMI.getInstance().getHologramManager().getPrevPageLength();
                    int n4 = CMI.getInstance().getHologramManager().getNextPageLength();
                    d4 = (double)n3 / 32.0 * this.getScaleW();
                    d3 = (double)n4 / 32.0 * this.getScaleW();
                    bl = this.getTextAlignment().equals((Object)CMITextAlignment.LEFT) ? cMIPlaneIntersection.getLocalLoc().getX() + d / 2.0 <= d4 + this.getExtraInteractionWidth() : cMIPlaneIntersection.getLocalLoc().getX() + d / 2.0 < d - d3;
                }
                Object object = this.stillUpdating;
                synchronized (object) {
                    if (this.stillUpdating.contains(player.getUniqueId()) && this.nextUpdate.contains(player.getUniqueId()) && this.nextUpdate.get(player.getUniqueId()) > System.currentTimeMillis()) {
                        return null;
                    }
                }
                if (this.hoveringLine.getOrDefault(player.getUniqueId(), -1) != (int)d8) {
                    this.hoveringSide.put(player.getUniqueId(), bl);
                    object = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    if (object != null) {
                        CMIHologram cMIHologram = CMI.getInstance().getHologramManager().getByName(((HologramManager.CMIAiming)object).getName());
                        if (cMIHologram != null && !cMIHologram.getName().equals(this.getName())) {
                            d4 = CMI.getInstance().getUtilManager().getDistance(player.getLocation(), (Location)cMIHologram.getLocation());
                            if (d4 < (d3 = CMI.getInstance().getUtilManager().getDistance(player.getLocation(), (Location)this.getLocation()))) {
                                this.hoveringLine.remove(player.getUniqueId());
                                return null;
                            }
                            cMIHologram.hoveringLine.remove(player.getUniqueId());
                            cMIHologram.update(player, true);
                            CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc(), cMIPlaneIntersection.getLocalLoc().getX());
                        }
                    } else {
                        CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc(), cMIPlaneIntersection.getLocalLoc().getX());
                    }
                    this.hoveringLine.put(player.getUniqueId(), (int)d8);
                    this.update(player, true);
                } else {
                    object = this.clickableByPlayer.get(player.getUniqueId());
                    if (object != null && ((FakeInfo)object).getEntity() != null) {
                        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
                            CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, ((FakeInfo)object).getEntity(), cMIPlaneIntersection.getGlobalLoc().toLocation(player.getWorld()).add(0.0, -0.5, 0.0));
                        } else {
                            CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, ((FakeInfo)object).getEntity(), cMIPlaneIntersection.getGlobalLoc().toLocation(player.getWorld()).add(0.0, -0.25, 0.0));
                        }
                    }
                    HologramManager.CMIAiming cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    boolean bl3 = false;
                    if (cMIAiming != null && cMIAiming.getName().equals(this.getName()) && cMIAiming.getPos().toString().equals(cMIPlaneIntersection.getGlobalLoc().toString())) {
                        bl3 = true;
                    }
                    if (this.hoveringSide.get(player.getUniqueId()) == null || this.hoveringSide.get(player.getUniqueId()) != bl) {
                        this.hoveringSide.put(player.getUniqueId(), bl);
                        this.update(player, true);
                    }
                    if (bl3) {
                        return null;
                    }
                    CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc());
                    this.hoveringLine.put(player.getUniqueId(), (int)d8);
                }
                return null;
            });
        });
    }

    private void modifyIcon(CMIItemDisplay cMIItemDisplay) {
        cMIItemDisplay.setScale(0.5 * this.getIconScale() * this.getScaleH());
        cMIItemDisplay.setBillboard(this.getIconBillboard() == null ? this.getBillboard().getBillboard() : this.getIconBillboard().getBillboard());
        cMIItemDisplay.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
        cMIItemDisplay.setFacing(this.getIconPitch() + this.getPitch(), this.getIconYaw() + this.getYaw());
        cMIItemDisplay.setRange(this.getShowRange());
    }

    private CMIVector3D getIconPositionOffset(int n) {
        double d = this.isDownOrder() != false ? -((double)n * this.getLineHeight()) + this.getLineHeight() / 1.8 : (double)(this.lineCount - n) * this.getLineHeight() + this.getLineHeight() / 1.8;
        CMIVector3D cMIVector3D = new CMIVector3D(0.0, d, 0.0);
        if (this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            if (this.isDownOrder().booleanValue()) {
                cMIVector3D = CMIPlaneIntersection.rotateAroundCenter(0.0, d + this.getLineHeight() / 1.2, Math.toRadians(this.getYaw()), Math.toRadians(this.getPitch()));
                double d2 = 0.0;
                if (this.isDownOrder().booleanValue()) {
                    d2 = (double)this.lineCount * this.getLineHeight();
                }
                cMIVector3D.setY(cMIVector3D.getY() - d2);
            } else {
                cMIVector3D = CMIPlaneIntersection.rotateAroundCenter(0.0, d, Math.toRadians(this.getYaw()), Math.toRadians(-this.getPitch()));
                cMIVector3D.setY(-cMIVector3D.getY());
            }
        }
        return cMIVector3D;
    }

    /*
     * WARNING - void declaration
     */
    private void newUpdate(Player player) {
        Object object;
        Object object2;
        if (this.loc.getWorld() == null) {
            return;
        }
        if (!player.isOnline()) {
            this.stillUpdating.remove(player.getUniqueId());
            return;
        }
        List<CMIHologramLine> list2 = this.getLinesByPlayerPage(player);
        if (list2 == null || list2.isEmpty()) {
            this.stillUpdating.remove(player.getUniqueId());
            return;
        }
        Integer n = this.inPage.get(player.getUniqueId());
        if (n == null) {
            n = 1;
        }
        ArrayList<CMIHologramLine> arrayList = new ArrayList<CMIHologramLine>();
        int n2 = 0;
        while (n2 < list2.size()) {
            object2 = list2.size() - 1 < n2 || n2 < 0 ? new CMIHologramLine("") : (list2.get(n2) == null ? new CMIHologramLine("") : list2.get(n2));
            arrayList.add((CMIHologramLine)object2);
            ++n2;
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        if (this.lastHoloInRangeExtra.isEmpty() && this.lastHoloInRange.isEmpty()) {
            this.stillUpdating.remove(player.getUniqueId());
            return;
        }
        object2 = this.pages.get(n);
        if (object2 == null) {
            this.stillUpdating.remove(player.getUniqueId());
            return;
        }
        arrayList2.clear();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        CMIHologramBatch cMIHologramBatch = this.playerDisplays.get(player.getUniqueId());
        if (cMIHologramBatch == null) {
            cMIHologramBatch = new CMIHologramBatch();
            this.playerDisplays.put(player.getUniqueId(), cMIHologramBatch);
        }
        this.lineCount = arrayList.size();
        if (this.isAutoPagination()) {
            ++this.lineCount;
        }
        int n3 = 0;
        int n4 = 0;
        for (final CMIHologramLine object3 : arrayList) {
            ++n4;
            switch (object3.getType()) {
                case icon: 
                case staticIcon: {
                    List<String> list3;
                    object = null;
                    if (cMIHologramBatch.getIcon(n4) != null) {
                        object = (CMIItemDisplay)cMIHologramBatch.getIcon(n4);
                    } else {
                        CMIVector3D cMIVector3D = this.getIconPositionOffset(n4);
                        object = new CMIItemDisplay(this.loc.clone().add(cMIVector3D.getX(), cMIVector3D.getY(), cMIVector3D.getZ()));
                        this.modifyIcon((CMIItemDisplay)object);
                        ((CMIDisplay)object).show(player);
                        if (cMIHologramBatch.getIcon(n4) != null) {
                            this.stillUpdating.remove(player.getUniqueId());
                            return;
                        }
                        cMIHologramBatch.addIcon(n4, (CMIDisplay)object);
                    }
                    Object object4 = object;
                    CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((CMIItemDisplay)object4, player){
                        private final /* synthetic */ CMIItemDisplay val$d;
                        private final /* synthetic */ Player val$player;
                        {
                            this.val$d = cMIItemDisplay;
                            this.val$player = player;
                        }

                        public void afterAsyncUpdate(ItemStack itemStack) {
                            object3.setItem(new CMIItemStack(itemStack));
                            this.val$d.setItemStack(itemStack);
                            this.val$d.update(this.val$player);
                        }
                    };
                    cMIAsyncHead.setForce(true);
                    CMIItemStack cMIItemStack = object3.getItem(player, cMIAsyncHead);
                    if (cMIItemStack != null) {
                        ((CMIItemDisplay)object).setItemStack(cMIItemStack);
                        this.modifyIcon((CMIItemDisplay)object);
                        if (Version.isFolia()) {
                            CMIScheduler.runAtLocation((Location)((CMIDisplay)object4).getLocation(), () -> CMIHologram.lambda$2((CMIItemDisplay)object4, cMIItemStack, player));
                        } else if (((CMIItemDisplay)object).getItemStack() == null || ((CMIItemDisplay)object).getItemStack().getType().isAir() || !((CMIItemDisplay)object).getItemStack().equals((Object)cMIItemStack.getItemStack())) {
                            ((CMIDisplay)object).show(player);
                        } else {
                            ((CMIDisplay)object).update(player);
                        }
                    } else {
                        list3 = null;
                        ((CMIItemDisplay)object).setItemStack((ItemStack)list3);
                        ((CMIDisplay)object).show(player);
                    }
                    if (n3 == 0) {
                        arrayList3.add(" ");
                    } else {
                        arrayList3.add("");
                    }
                    ++n3;
                    break;
                }
                case image: {
                    List<String> list3 = object3.getPlainImage();
                    if (list3 == null) break;
                    arrayList3.addAll(list3);
                    n3 += list3.size();
                    break;
                }
                case plainText: 
                case placeholder: {
                    Integer n5 = this.hoveringLine.get(player.getUniqueId());
                    String string = "";
                    string = n5 != null && n5 == ++n3 ? (object3.getHoverText() == null ? object3.getText(player) : object3.getHoverText(player)) : object3.getText(player);
                    arrayList3.add(CMIText.replaceUnderScoreSpace((String)CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string.isEmpty() ? " " : string)));
                    break;
                }
            }
        }
        if (this.isAutoPagination()) {
            void var11_21;
            String d = "";
            Boolean bl = this.hoveringSide.get(player.getUniqueId());
            object = this.hoveringLine.get(player.getUniqueId());
            if (bl != null && object != null && (Integer)object == this.lineCount) {
                if (!bl.booleanValue()) {
                    String string2 = String.valueOf(d) + CMI.getInstance().getHologramManager().getPrevPageSection().getText();
                    string2 = String.valueOf(string2) + CMI.getInstance().getHologramManager().getNextPageSection().getHoverText();
                } else {
                    String string3 = String.valueOf(d) + CMI.getInstance().getHologramManager().getPrevPageSection().getHoverText();
                    string3 = String.valueOf(string3) + CMI.getInstance().getHologramManager().getNextPageSection().getText();
                }
            } else {
                String string4 = String.valueOf(d) + CMI.getInstance().getHologramManager().getPrevPageSection().getText();
                string4 = String.valueOf(string4) + CMI.getInstance().getHologramManager().getNextPageSection().getText();
            }
            arrayList3.add((String)var11_21);
        }
        if (arrayList3.isEmpty()) {
            this.stillUpdating.remove(player.getUniqueId());
            return;
        }
        double d = 0.0;
        if (this.isDownOrder().booleanValue()) {
            d = (double)arrayList3.size() * this.getLineHeight();
        }
        if (cMIHologramBatch.getDisplay(1) == null) {
            object = this.createDisplay(arrayList3, -d, true);
            cMIHologramBatch.addDisplay(1, (CMIDisplay)object);
            ((CMIDisplay)object).show(player);
            if (this.isDoubleSided() && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
                object = this.createDisplay(arrayList3, -d, false);
                cMIHologramBatch.addDisplay(2, (CMIDisplay)object);
                ((CMIDisplay)object).show(player);
            }
        }
        ((CMIHologramPage)object2).setHeight((double)this.lineCount * this.getLineHeight());
        int n6 = 0;
        for (CMIDisplay cMIDisplay : cMIHologramBatch.getDisplays().values()) {
            if (!(cMIDisplay instanceof CMITextDisplay)) continue;
            ((CMITextDisplay)cMIDisplay).setText(arrayList3);
            if (++n6 > 1 && !this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
                cMIDisplay.destroy(player);
                continue;
            }
            this.updateDisplaySettings((CMITextDisplay)cMIDisplay, n6 == 1);
            cMIDisplay.update(player);
        }
        this.playerDisplays.put(player.getUniqueId(), cMIHologramBatch);
        this.addInteractionCheck(player);
        this.stillUpdating.remove(player.getUniqueId());
    }

    private void addInteractionCheck(Player player) {
        if (!this.isInteractable() || this.getPitch() != 0 || this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            return;
        }
        FakeInfo fakeInfo = this.clickableByPlayer.get(player.getUniqueId());
        if (fakeInfo != null) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            CMIInteractionEntity cMIInteractionEntity = new CMIInteractionEntity(this.getCenterLocation());
            FakeInfo fakeInfo2 = new FakeInfo().setObj(this).setPlayer(player).setId(cMIInteractionEntity.getId());
            fakeInfo2.setEntity(cMIInteractionEntity.getDisplay());
            this.clickableById.put(fakeInfo2.getId(), fakeInfo2);
            this.clickableByPlayer.put(player.getUniqueId(), fakeInfo2);
            PacketHandler.addFakeEntity(fakeInfo2);
            cMIInteractionEntity.show(player);
            return;
        }
        FakeInfo fakeInfo3 = CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), this, this.bigButton);
        if (fakeInfo3 == null) {
            return;
        }
        this.clickableById.put(fakeInfo3.getId(), fakeInfo3);
        this.clickableByPlayer.put(player.getUniqueId(), fakeInfo3);
        PacketHandler.addFakeEntity(fakeInfo3);
    }

    private void oldUpdate(Player player, boolean bl) {
        CMIHologram cMIHologram = this;
        this.task = CMIScheduler.runTaskAsynchronously(() -> {
            if (this.loc.getWorld() == null) {
                return;
            }
            try {
                FakeInfo fakeInfo;
                Object object;
                Object object2;
                Object object3;
                Block block;
                if (!player.isOnline()) {
                    this.stillUpdating.remove(player.getUniqueId());
                    return;
                }
                if (this.isCheckLineOfSight() && (block = CMI.getInstance().getNMS().getBlockLookingAt(this.getLocation().getWorld(), player.getEyeLocation().toVector(), this.getCenterLocation().toVector(), false)) != null) {
                    this.stillUpdating.remove(player.getUniqueId());
                    return;
                }
                block = this.getLinesByPlayerPage(player);
                if (block == null || block.isEmpty()) {
                    this.stillUpdating.remove(player.getUniqueId());
                    return;
                }
                Integer n = this.inPage.get(player.getUniqueId());
                if (n == null) {
                    n = 1;
                }
                int n2 = 0;
                for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
                    if (entry.getKey() == n) break;
                    n2 += entry.getValue().getLines().size() + 1;
                }
                int n3 = n2;
                ArrayList arrayList = new ArrayList();
                int n4 = 0;
                while (n4 < block.size()) {
                    object3 = block.size() - 1 < n4 || n4 < 0 ? new CMIHologramLine("") : (block.get(n4) == null ? new CMIHologramLine("") : (CMIHologramLine)block.get(n4));
                    arrayList.add(object3);
                    ++n4;
                }
                ArrayList arrayList2 = new ArrayList(arrayList);
                if (!this.isDownOrder().booleanValue()) {
                    int n5 = 0;
                    int n6 = arrayList2.size() - 1;
                    while (n6 >= 0) {
                        arrayList.set(n6, (CMIHologramLine)arrayList2.get(n5));
                        ++n5;
                        --n6;
                    }
                }
                if (this.lastHoloInRangeExtra.isEmpty() && this.lastHoloInRange.isEmpty() && !bl) {
                    this.stillUpdating.remove(player.getUniqueId());
                    return;
                }
                object3 = this.pages.get(n);
                if (object3 == null) {
                    this.stillUpdating.remove(player.getUniqueId());
                    return;
                }
                Double d = 0.0;
                int n7 = -1;
                int n8 = 0;
                while (n8 < arrayList.size()) {
                    Object object4;
                    object2 = (CMIHologramLine)arrayList.get(n8);
                    object = new ArrayList<String>(Arrays.asList(((CMIHologramLine)object2).getText()));
                    if (((CMIHologramLine)object2).getType() == CMIHoloLineType.image) {
                        object.clear();
                        object4 = ((CMIHologramLine)object2).getPlainImage();
                        if (object4 != null) {
                            object.addAll(object4);
                            if (!this.isDownOrder().booleanValue()) {
                                Collections.reverse(object);
                            }
                        }
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object object5;
                        object4 = (String)iterator.next();
                        CMIDataWatcher cMIDataWatcher = this.getCache(player.getUniqueId(), ++n7);
                        if (((CMIHologramLine)object2).getType() != CMIHoloLineType.image && ((CMIHologramLine)object2).isStaticText() && cMIDataWatcher != null && !this.changed.containsKey(n3 + n7)) continue;
                        if (cMIDataWatcher == null) {
                            object5 = this.loc.clone();
                            if (this.isDownOrder().booleanValue()) {
                                object5.add(0.0, -((double)n7 * this.getSpacing()), 0.0);
                                object5.add(0.0, d.doubleValue(), 0.0);
                            } else {
                                object5.add(0.0, (double)n7 * this.getSpacing(), 0.0);
                                object5.add(0.0, -d.doubleValue(), 0.0);
                            }
                            int n9 = n7;
                            if (((CMIHologramLine)object2).getType() == CMIHoloLineType.staticIcon) {
                                CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((CMIHologramLine)object2, player, n9, (Location)object5){
                                    private final /* synthetic */ CMIHologramLine val$one;
                                    private final /* synthetic */ Player val$player;
                                    private final /* synthetic */ int val$ao;
                                    private final /* synthetic */ Location val$lc;
                                    {
                                        this.val$one = cMIHologramLine;
                                        this.val$player = player;
                                        this.val$ao = n;
                                        this.val$lc = location;
                                    }

                                    public void afterAsyncUpdate(ItemStack itemStack) {
                                        this.val$one.setItem(new CMIItemStack(itemStack));
                                        CMIDataWatcher cMIDataWatcher = CMIHologram.this.getCache(this.val$player.getUniqueId(), this.val$ao);
                                        if (cMIDataWatcher != null) {
                                            CMIScheduler.runTask(() -> {
                                                CMI.getInstance().getNMS().removeHologram(this.val$player, cMIDataWatcher.getId());
                                                if (cMIDataWatcher.getLoc() != null) {
                                                    CMIDataWatcher cMIDataWatcher2 = CMI.getInstance().getNMS().spawnHologram(this.val$player, this.val$lc, null, itemStack);
                                                    cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                                    cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                                                }
                                                cMIDataWatcher.setItem(this.val$one.getItem());
                                                if (this.val$player.isOnline()) {
                                                    CMIHologram.this.updateCache(this.val$player.getUniqueId(), this.val$ao, cMIDataWatcher);
                                                }
                                                cMIDataWatcher.setUpdatingHead(false);
                                            });
                                        }
                                    }
                                };
                                cMIAsyncHead.setForce(true);
                                CMIItemStack cMIItemStack = ((CMIHologramLine)object2).getItem(player, cMIAsyncHead);
                                CMIScheduler.runTask(() -> this.lambda$4(player, (Location)object5, cMIItemStack, n9));
                                continue;
                            }
                            if (((CMIHologramLine)object2).getType() == CMIHoloLineType.icon) {
                                double d2 = -(this.getIconSpacing() / 2.0);
                                if (this.isDownOrder().booleanValue()) {
                                    d2 -= this.getSpacing().doubleValue();
                                    object5.add(0.0, this.getIconSpacing() / 4.0 - 0.1, 0.0);
                                }
                                d = d + d2;
                                if (this.isDownOrder().booleanValue()) {
                                    d = d + this.getSpacing();
                                }
                                object5.add(0.0, d2, 0.0);
                                CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((CMIHologramLine)object2, player, n9){
                                    private final /* synthetic */ CMIHologramLine val$one;
                                    private final /* synthetic */ Player val$player;
                                    private final /* synthetic */ int val$ao;
                                    {
                                        this.val$one = cMIHologramLine;
                                        this.val$player = player;
                                        this.val$ao = n;
                                    }

                                    public void afterAsyncUpdate(ItemStack itemStack) {
                                        this.val$one.setItem(new CMIItemStack(itemStack));
                                        CMIDataWatcher cMIDataWatcher = CMIHologram.this.getCache(this.val$player.getUniqueId(), this.val$ao);
                                        if (cMIDataWatcher != null) {
                                            CMIScheduler.runTask(() -> {
                                                CMI.getInstance().getNMS().removeHologram(this.val$player, cMIDataWatcher.getId());
                                                if (cMIDataWatcher.getLoc() != null) {
                                                    CMIDataWatcher cMIDataWatcher2 = CMI.getInstance().getNMS().makeFloatingIcon(this.val$player, cMIDataWatcher.getLoc(), itemStack, this.val$one.isGlowing());
                                                    cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                                    cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                                                }
                                                cMIDataWatcher.setItem(this.val$one.getItem());
                                                if (this.val$player.isOnline()) {
                                                    CMIHologram.this.updateCache(this.val$player.getUniqueId(), this.val$ao, cMIDataWatcher);
                                                }
                                                cMIDataWatcher.setUpdatingHead(false);
                                            });
                                        }
                                    }
                                };
                                cMIAsyncHead.setForce(true);
                                CMIItemStack cMIItemStack = ((CMIHologramLine)object2).getItem(player, cMIAsyncHead);
                                CMIScheduler.runTask(() -> this.lambda$5(cMIItemStack, player, (Location)object5, (CMIHologramLine)object2, cMIAsyncHead, n9));
                                continue;
                            }
                            if (((CMIHologramLine)object2).getType() != CMIHoloLineType.plainText && ((CMIHologramLine)object2).getType() != CMIHoloLineType.placeholder && ((CMIHologramLine)object2).getType() != CMIHoloLineType.image || !player.isOnline()) continue;
                            CMIScheduler.runTask(() -> this.lambda$6((CMIHologramLine)object2, player, (Location)object5, (String)object4, n9));
                            continue;
                        }
                        if (((CMIHologramLine)object2).isIcon() && !cMIDataWatcher.isUpdatingHead()) {
                            object5 = ((CMIHologramLine)object2).getItem(player);
                            if (!(cMIDataWatcher.getItem() == null && object5 != null || cMIDataWatcher.getItem() != null && object5 == null) && (object5 == null || cMIDataWatcher.getItem() == null || cMIDataWatcher.getItem().getType().equals((Object)object5.getType()) && cMIDataWatcher.getItem().getAmount() == object5.getAmount() && cMIDataWatcher.getItem().isSimilar((CMIItemStack)object5))) continue;
                            CMI.getInstance().getNMS().removeHologram(player, cMIDataWatcher.getId());
                            if (object5 != null && object5.getCMIType().isAir()) {
                                cMIDataWatcher.setItem(null);
                                continue;
                            }
                            CMIDataWatcher cMIDataWatcher2 = null;
                            if (object5 != null && object5.getItemStack() != null) {
                                if (cMIDataWatcher.getLoc() != null) {
                                    cMIDataWatcher2 = ((CMIHologramLine)object2).getType() == CMIHoloLineType.staticIcon ? CMI.getInstance().getNMS().spawnHologram(player, cMIDataWatcher.getLoc(), null, object5.getItemStack()) : CMI.getInstance().getNMS().makeFloatingIcon(player, cMIDataWatcher.getLoc(), object5.getItemStack(), ((CMIHologramLine)object2).isGlowing());
                                    cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                    cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                                }
                                cMIDataWatcher.setItem((CMIItemStack)object5);
                                continue;
                            }
                            if (cMIDataWatcher.getLoc() != null) {
                                cMIDataWatcher2 = CMI.getInstance().getNMS().spawnHologram(player, cMIDataWatcher.getLoc(), null, null);
                                cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                            }
                            cMIDataWatcher.setItem(null);
                            continue;
                        }
                        if (((CMIHologramLine)object2).getType() == CMIHoloLineType.image) {
                            if (!player.isOnline()) continue;
                            CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, (String)object4, null);
                            continue;
                        }
                        if (this.isNewIneractionMethod()) {
                            object5 = this.hoveringLine.get(player.getUniqueId());
                            if (object5 != null && (Integer)object5 - 1 == n7) {
                                if (((CMIHologramLine)object2).getHoverText() == null) {
                                    CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getText(player), null);
                                    continue;
                                }
                                CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getHoverText(player), null);
                                continue;
                            }
                            String string = ((CMIHologramLine)object2).getText(player);
                            if (!string.isEmpty()) {
                                CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, string, null);
                                continue;
                            }
                            CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, null, null);
                            continue;
                        }
                        CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getText(player), null);
                    }
                    ++n8;
                }
                if (this.isInteractable() && (fakeInfo = this.clickableByPlayer.get(player.getUniqueId())) == null) {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
                        object2 = new CMIInteractionEntity(this.getCenterLocation());
                        object = new FakeInfo().setObj(this).setPlayer(player).setId(((CMIDisplay)object2).getId());
                        ((FakeInfo)object).setEntity(((CMIDisplay)object2).getDisplay());
                        this.clickableById.put(((FakeInfo)object).getId(), (FakeInfo)object);
                        this.clickableByPlayer.put(player.getUniqueId(), (FakeInfo)object);
                        PacketHandler.addFakeEntity((FakeInfo)object);
                        ((CMIDisplay)object2).show(player);
                    } else {
                        object2 = null;
                        object2 = !this.isNewIneractionMethod() ? CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), cMIHologram, this.bigButton) : CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), cMIHologram, this.bigButton);
                        if (object2 != null) {
                            this.clickableById.put(((FakeInfo)object2).getId(), (FakeInfo)object2);
                            this.clickableByPlayer.put(player.getUniqueId(), (FakeInfo)object2);
                            PacketHandler.addFakeEntity((FakeInfo)object2);
                        }
                    }
                }
                this.stillUpdating.remove(player.getUniqueId());
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.task = null;
                return;
            }
        });
    }

    private CMITextDisplay createDisplay(List<String> list2, double d, boolean bl) {
        CMITextDisplay cMITextDisplay = new CMITextDisplay(this.loc.clone().add(0.0, d, 0.0));
        cMITextDisplay.setText(list2);
        this.updateDisplaySettings(cMITextDisplay, bl);
        return cMITextDisplay;
    }

    private void updateDisplaySettings(CMITextDisplay cMITextDisplay, boolean bl) {
        cMITextDisplay.setShadowed(this.isShadowed());
        cMITextDisplay.setLineWidth(1000);
        cMITextDisplay.setBillboard(this.getBillboard().getBillboard());
        cMITextDisplay.setAligment(this.getTextAlignment().getTextAlignment());
        cMITextDisplay.setBackgroundColor(this.getBackgroundColor().getRGBColor().setAlpha(this.getBackgroundAlpha()));
        cMITextDisplay.setWidth(this.getScaleW());
        cMITextDisplay.setHeight(this.getScaleH());
        cMITextDisplay.setTextOpacity((byte)this.getTextAlpha());
        cMITextDisplay.setRange(this.getShowRange());
        if (this.getSkyLevel() > -1 || this.getBlockLevel() > -1) {
            cMITextDisplay.setBrightness(this.getSkyLevel(), this.getBlockLevel());
        }
        if (this.isSeeThrough()) {
            cMITextDisplay.setSeeThrough(true);
        }
        if (this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            if (bl) {
                cMITextDisplay.setFacing(this.getPitch(), this.getYaw());
            } else {
                cMITextDisplay.setFacing(-this.getPitch(), (this.getYaw() + 180) % 360);
            }
        }
    }

    private void generalUpdate(Player player, boolean bl) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3) && this.newDisplayMethod) {
            this.task = CMIScheduler.runTaskAsynchronously(() -> {
                try {
                    this.newUpdate(player);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                List<UUID> list2 = this.stillUpdating;
                synchronized (list2) {
                    this.stillUpdating.remove(player.getUniqueId());
                }
            });
            return;
        }
        this.oldUpdate(player, bl);
    }

    public void update(Player player, boolean bl) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!this.enabled || !CMI.getInstance().isEnabled()) {
            return;
        }
        Long l = this.nextUpdate.getOrDefault(player.getUniqueId(), 0L);
        if (l > 0L && l > System.currentTimeMillis()) {
            return;
        }
        if (this.stillUpdating.contains(player.getUniqueId())) {
            return;
        }
        this.nextUpdate.put(player.getUniqueId(), System.currentTimeMillis() + 50L);
        this.stillUpdating.add(player.getUniqueId());
        this.generalUpdate(player, bl);
    }

    public void removeFromCache(UUID uUID) {
        CMIHologramBatch cMIHologramBatch = this.playerDisplays.remove(uUID);
        if (cMIHologramBatch != null) {
            cMIHologramBatch.destroy(CMIUser.getOnlinePlayer(uUID));
        }
        List<CMIDataWatcher> list2 = this.cache.remove(uUID);
        this.nextUpdate.remove(uUID);
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        FakeInfo fakeInfo = this.clickableByPlayer.remove(uUID);
        if (fakeInfo != null) {
            this.clickableById.remove(fakeInfo.getId());
            PacketHandler.removeFakeEntity(fakeInfo);
            CMI.getInstance().getNMS().removeHologram(player, fakeInfo.getId());
        }
        if (list2 == null) {
            return;
        }
        for (CMIDataWatcher cMIDataWatcher : list2) {
            if (cMIDataWatcher == null) continue;
            CMI.getInstance().getNMS().removeHologram(player, cMIDataWatcher.getId());
        }
        list2.clear();
    }

    public void clearFakeEntities() {
        PacketHandler.clearFakeEntities();
    }

    private void clearIconLines(UUID uUID, CMIHologramPage cMIHologramPage) {
        Object object;
        List<CMIDataWatcher> list2 = this.cache.get(uUID);
        if (list2 == null) {
            return;
        }
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        int n = list2.size() - 1;
        while (n >= 0) {
            object = list2.get(n);
            if (object != null && (((CMIDataWatcher)object).getType() == CMIHoloLineType.icon || ((CMIDataWatcher)object).getType() == CMIHoloLineType.staticIcon)) {
                this.removeFromCache(uUID);
                break;
            }
            --n;
        }
        n = 0;
        while (n < cMIHologramPage.getLines().size()) {
            object = cMIHologramPage.getLines().get(n);
            if (((CMIHologramLine)object).getType() == CMIHoloLineType.icon || ((CMIHologramLine)object).getType() == CMIHoloLineType.staticIcon) {
                this.removeFromCache(uUID);
                break;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeFromCache(UUID var1_1, int var2_2) {
        var3_3 = this.playerDisplays.remove(var1_1);
        if (var3_3 != null) {
            var3_3.destroy(CMIUser.getOnlinePlayer(var1_1));
        }
        this.nextUpdate.remove(var1_1);
        try {
            var4_4 = this.cache.get(var1_1);
            if (var4_4 == null) {
                return;
            }
            var5_6 = CMIUser.getOnlinePlayer(var1_1);
            if (var5_6 != null && var5_6.isOnline()) ** GOTO lbl18
            return;
lbl-1000:
            // 1 sources

            {
                if (this.isDownOrder().booleanValue()) {
                    var4_4.add(null);
                    continue;
                }
                var4_4.add(0, null);
lbl18:
                // 3 sources

                ** while (var4_4.size() <= var2_2)
            }
lbl19:
            // 1 sources

            if (var4_4.size() > var2_2) {
                var6_7 = var4_4.size();
                var7_9 = var2_2;
                while (var7_9 < var6_7) {
                    var8_10 = null;
                    var8_10 = this.isDownOrder() != false ? var4_4.remove(var4_4.size() - 1) : var4_4.remove(0);
                    if (var8_10 != null) {
                        CMI.getInstance().getNMS().removeHologram(var5_6, var8_10.getId());
                    }
                    ++var7_9;
                }
            }
            if ((var6_8 = this.clickableByPlayer.get(var1_1)) != null) {
                this.clickableByPlayer.remove(var1_1);
                this.clickableById.remove(var6_8.getId());
                PacketHandler.removeFakeEntity(var6_8);
                CMI.getInstance().getNMS().removeHologram(var5_6, var6_8.getId());
            }
        }
        catch (Throwable var4_5) {
            var4_5.printStackTrace();
        }
    }

    private void updateCache(UUID uUID, int n, CMIDataWatcher cMIDataWatcher) {
        List<CMIDataWatcher> list2 = this.cache.get(uUID);
        if (list2 == null) {
            list2 = new ArrayList<CMIDataWatcher>();
            this.cache.put(uUID, list2);
        }
        if (list2.size() - 1 < n) {
            while (list2.size() - 1 < n - 1) {
                list2.add(null);
            }
            list2.add(cMIDataWatcher);
        } else {
            list2.set(n, cMIDataWatcher);
        }
    }

    private CMIDataWatcher getCache(UUID uUID, int n) {
        List<CMIDataWatcher> list2 = this.cache.get(uUID);
        if (list2 == null) {
            list2 = new ArrayList<CMIDataWatcher>();
            this.cache.put(uUID, list2);
        }
        return list2.size() - 1 < n ? null : list2.get(n);
    }

    public double getUpdateIntervalSec() {
        return this.updateIntervalSec;
    }

    public void setUpdateIntervalSec(double d) {
        this.updateIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
        if (this.updateIntervalSec <= 0.0) {
            this.updateIntervalSec = 0.0;
        }
    }

    public int getUpdateRange() {
        this.updateRange = this.updateRange > this.showRange ? this.showRange : this.updateRange;
        return this.updateRange;
    }

    public void setUpdateRange(int n) {
        this.updateRange = n;
        if (this.updateRange < 1) {
            this.updateRange = 1;
        }
        if (!this.isNewDisplayMethod() && this.updateRange > 64) {
            this.updateRange = 64;
        }
        if (this.isNewDisplayMethod() && this.updateRange > 128) {
            this.updateRange = 128;
        }
        if (this.updateRange > this.showRange) {
            this.updateRange = this.showRange;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getShowRange() {
        this.showRange = this.showRange < this.updateRange ? this.updateRange : this.showRange;
        return this.showRange;
    }

    public void setShowRange(int n) {
        this.showRange = n;
        if (this.showRange < 1) {
            this.showRange = 1;
        }
        if (!this.isNewDisplayMethod() && this.showRange > 64) {
            this.showRange = 64;
        }
        if (this.isNewDisplayMethod() && this.showRange > 128) {
            this.showRange = 128;
        }
        if (this.showRange < this.updateRange) {
            n = this.updateRange;
        }
    }

    public Double getIconSpacing() {
        return this.iconSpacing;
    }

    public void setIconSpacing(Double d) {
        this.iconSpacing = d;
        this.updatePages();
    }

    public Double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Double d) {
        this.spacing = d;
        this.updatePages();
    }

    public Boolean isDownOrder() {
        return this.downOrder;
    }

    public void setDownOrder(Boolean bl) {
        this.downOrder = bl;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean bl) {
        this.interactable = bl;
    }

    public boolean isShowParticle() {
        return this.showParticle;
    }

    public void setShowParticle(boolean bl) {
        this.showParticle = bl;
    }

    public boolean isBigButton() {
        return this.bigButton;
    }

    public void setBigButton(boolean bl) {
        this.bigButton = bl;
    }

    public CMITask getSched() {
        return this.schedId;
    }

    public void setSched(CMITask cMITask) {
        this.schedId = cMITask;
    }

    public void stop() {
        if (this.lineOfSightSchedId != null) {
            this.lineOfSightSchedId.cancel();
            this.lineOfSightSchedId = null;
        }
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        if (this.pageSchedId != null) {
            this.pageSchedId.cancel();
            this.pageSchedId = null;
        }
        if (this.hoverOverSchedId != null) {
            this.hoverOverSchedId.cancel();
            this.hoverOverSchedId = null;
        }
        this.hoveringLine.clear();
    }

    private void tasker() {
        if (this.lastHoloInRange.isEmpty()) {
            if (this.schedId != null) {
                this.schedId.cancel();
                this.schedId = null;
            }
            return;
        }
        if (this.schedId != null) {
            return;
        }
        if (this.updateIntervalSec <= 0.0) {
            if (this.schedId != null) {
                this.schedId.cancel();
                this.schedId = null;
            }
            return;
        }
        int n = (int)(this.updateIntervalSec * 1000.0 / 50.0);
        if (n <= 0) {
            return;
        }
        if (n < 1) {
            n = 1;
        }
        boolean bl = true;
        block0: for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
            for (CMIHologramLine cMIHologramLine : entry.getValue().getLines()) {
                if (cMIHologramLine.isStaticText()) continue;
                bl = false;
                continue block0;
            }
        }
        if (bl && !this.isChangedLine()) {
            return;
        }
        this.schedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.lastHoloInRange.isEmpty()) {
                if (this.schedId != null) {
                    this.schedId.cancel();
                    this.schedId = null;
                }
                return;
            }
            boolean bl = true;
            if (this.LOSupdateIntervalSec > 0.0 && this.updateIntervalSec >= this.LOSupdateIntervalSec || this.pageChangeIntervalSec > 0.0) {
                // empty if block
            }
            if (bl) {
                this.updateHolo();
            }
        }, (long)0L, (long)n);
    }

    private void lineOfSightTasker() {
        if (this.isNewDisplayMethod()) {
            return;
        }
        if (this.lastHoloInRangeExtra.isEmpty() || !this.isCheckLineOfSight()) {
            if (this.lineOfSightSchedId != null) {
                this.lineOfSightSchedId.cancel();
                this.lineOfSightSchedId = null;
            }
            return;
        }
        if (this.lineOfSightSchedId != null) {
            return;
        }
        if (this.getLOSupdateIntervalSec() <= 0.0) {
            if (this.lineOfSightSchedId != null) {
                this.lineOfSightSchedId.cancel();
                this.lineOfSightSchedId = null;
            }
            return;
        }
        int n = (int)(this.getLOSupdateIntervalSec() * 1000.0 / 50.0);
        if (n < 1) {
            n = 1;
        }
        this.lineOfSightSchedId = CMIScheduler.runTimerAsync(() -> {
            if (this.lastHoloInRangeExtra.isEmpty() || !this.isCheckLineOfSight() || this.isNewDisplayMethod()) {
                if (this.lineOfSightSchedId != null) {
                    this.lineOfSightSchedId.cancel();
                    this.lineOfSightSchedId = null;
                }
                return;
            }
            Multiset<UUID> multiset = this.lastHoloInRangeExtra;
            synchronized (multiset) {
                for (UUID uUID : new HashSet<UUID>((Collection<UUID>)this.lastHoloInRangeExtra)) {
                    Player player = CMIUser.getOnlinePlayer(uUID);
                    if (player == null || !player.isOnline() || player.getWorld() != this.getLocation().getWorld()) continue;
                    Block block = CMI.getInstance().getNMS().getBlockLookingAt(this.getLocation().getWorld(), player.getEyeLocation().toVector(), this.getCenterLocation().toVector(), false);
                    if (block != null) {
                        this.hide(player.getUniqueId());
                        continue;
                    }
                    this.update(player);
                }
            }
        }, (long)0L, (long)n);
    }

    private void pageTasker() {
        if (this.lastHoloInRange.isEmpty()) {
            if (this.pageSchedId != null) {
                this.pageSchedId.cancel();
                this.pageSchedId = null;
            }
            return;
        }
        if (this.pageSchedId != null) {
            return;
        }
        if (this.pageChangeIntervalSec <= 0.0) {
            if (this.pageSchedId != null) {
                this.pageSchedId.cancel();
                this.pageSchedId = null;
            }
            return;
        }
        int n = (int)(this.pageChangeIntervalSec * 1000.0 / 50.0);
        if (n < 1) {
            n = 1;
        }
        if (this.pages.size() == 1) {
            return;
        }
        this.pageSchedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.lastHoloInRange.isEmpty()) {
                if (this.pageSchedId != null) {
                    this.pageSchedId.cancel();
                    this.pageSchedId = null;
                }
                return;
            }
            for (UUID uUID : this.lastHoloInRange) {
                this.goToNextPageAuto(uUID);
                this.skipPlayers.add(uUID);
            }
            this.skipPageChange.clear();
            boolean bl = true;
            if (this.LOSupdateIntervalSec > 0.0 && this.pageChangeIntervalSec >= this.LOSupdateIntervalSec || this.updateIntervalSec > 0.0) {
                // empty if block
            }
            if (bl) {
                this.update();
            }
        }, (long)0L, (long)n);
    }

    private void hoverOverTasker() {
        if (this.lastHoloInRange.isEmpty()) {
            if (this.hoverOverSchedId != null) {
                this.hoverOverSchedId.cancel();
                this.hoverOverSchedId = null;
            }
            return;
        }
        if (this.hoverOverSchedId != null) {
            return;
        }
        if (!this.isInteractable() || !this.isNewIneractionMethod()) {
            if (this.hoverOverSchedId != null) {
                this.hoverOverSchedId.cancel();
                this.hoverOverSchedId = null;
            }
            return;
        }
        this.hoverOverSchedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.lastHoloInRange.isEmpty() || !this.isInteractable()) {
                if (this.hoverOverSchedId != null) {
                    this.hoverOverSchedId.cancel();
                    this.hoverOverSchedId = null;
                }
                for (UUID uUID : this.lastHoloInRange) {
                    HologramManager.CMIAiming cMIAiming;
                    Player player = CMIUser.getOnlinePlayer(uUID);
                    if (player == null || (cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId())) == null || !cMIAiming.getName().equals(this.getName())) continue;
                    CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
                }
                this.hoveringLine.clear();
                this.update();
                return;
            }
            this.particlePosition = (short)(this.particlePosition + 1);
            if (this.particlePosition > 10000) {
                this.particlePosition = 0;
            }
            for (UUID uUID : this.lastHoloInRange) {
                this.checkHoverPosition(CMIUser.getOnlinePlayer(uUID));
            }
        }, (long)0L, (long)1L);
    }

    private void updateHolo() {
        if (this.lastHoloInRange.isEmpty()) {
            return;
        }
        for (UUID uUID : new HashSet<UUID>((Collection<UUID>)this.lastHoloInRange)) {
            if (this.skipPlayers.contains(uUID)) continue;
            Player player = CMIUser.getOnlinePlayer(uUID);
            this.update(player);
        }
        this.skipPlayers.clear();
    }

    public Set<UUID> getLastHoloInRange() {
        return this.lastHoloInRange.elementSet();
    }

    public void recheckTaskers() {
        this.tasker();
        this.lineOfSightTasker();
        this.pageTasker();
        this.hoverOverTasker();
    }

    public void addLastHoloInRange(UUID uUID) {
        this.lastHoloInRange.add((Object)uUID);
        this.recheckTaskers();
    }

    public void removeLastHoloInRange(UUID uUID) {
        this.lastHoloInRange.remove((Object)uUID);
        this.recheckTaskers();
    }

    public Set<UUID> getLastHoloInRangeExtra() {
        return this.lastHoloInRangeExtra.elementSet();
    }

    public void addLastHoloInRangeExtra(UUID uUID) {
        this.lastHoloInRangeExtra.add((Object)uUID);
        this.recheckTaskers();
    }

    public void removeLastHoloInRangeExtra(UUID uUID) {
        this.lastHoloInRangeExtra.remove((Object)uUID);
        this.recheckTaskers();
        this.hide(uUID);
    }

    public boolean isuSync() {
        return this.uSync;
    }

    public void setuSync(boolean bl) {
        this.uSync = bl;
    }

    public void disable() {
        this.enabled = false;
        this.hide();
    }

    public void enable() {
        this.enabled = true;
        this.update();
    }

    public boolean isSaveToFile() {
        return this.saveToFile;
    }

    public void setSaveToFile(boolean bl) {
        this.saveToFile = bl;
    }

    public void makePersistent() {
        this.saveToFile = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public CMIHologramPage getPage(int n) {
        return this.pages.get(n);
    }

    public boolean isRequiresPermission() {
        return this.requestPermission;
    }

    public void setPermissionRequirement(boolean bl) {
        this.requestPermission = bl;
    }

    public double getPageChangeIntervalSec() {
        return this.pageChangeIntervalSec;
    }

    public void setPageChangeIntervalSec(double d) {
        boolean bl = false;
        if (this.pageChangeIntervalSec != d) {
            bl = true;
        }
        this.pageChangeIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
        if (this.pageChangeIntervalSec <= 0.0) {
            this.pageChangeIntervalSec = 0.0;
        }
        if (bl) {
            this.pageTasker();
        }
    }

    public void remove() {
        CMI.getInstance().getHologramManager().removeHolo(this);
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean isCheckLineOfSight() {
        return this.LOSupdateIntervalSec > 0.0;
    }

    public void setLOSInterval(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.LOSupdateIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
    }

    public double getLOSupdateIntervalSec() {
        return this.LOSupdateIntervalSec;
    }

    public boolean isFollowPlayer() {
        return this.LOSupdateIntervalSec > 0.0;
    }

    public void setFollowPlayer(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.followPlayer = Math.ceil((int)(d * 100.0)) / 100.0;
    }

    public double getFollowPlayer() {
        return this.followPlayer;
    }

    public int getHoveringLine(UUID uUID) {
        return this.hoveringLine.getOrDefault(uUID, 0);
    }

    public boolean isShowHoverParticle() {
        return this.showHoverParticle;
    }

    public void setShowHoverParticle(boolean bl) {
        this.showHoverParticle = bl;
    }

    public boolean isNewIneractionMethod() {
        return this.newIneractionMethod;
    }

    public void setNewIneractionMethod(boolean bl) {
        this.newIneractionMethod = bl;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int n) {
        n = Math.max(1, n);
        this.particleCount = n = Math.min(10, n);
    }

    public double getParticleSpacing() {
        return this.particleSpacing;
    }

    public void setParticleSpacing(double d) {
        d = Math.max(0.0, d);
        this.particleSpacing = d = Math.min(1.0, d);
    }

    public double getExtraParticleHeight() {
        return this.extraParticleHeight;
    }

    public void setExtraParticleHeight(double d) {
        d = Math.max(-this.getHeight() / 2.0, d);
        this.extraParticleHeight = d = Math.min(3.0, d);
    }

    public double getExtraParticleWidth() {
        return this.extraParticleWidth;
    }

    public void setExtraParticleWidth(double d) {
        d = Math.max(-3.0, d);
        this.extraParticleWidth = d = Math.min(3.0, d);
    }

    public double getExtraInteractionHeight() {
        return this.extraInteractionHeight;
    }

    public void setExtraInteractionHeight(double d) {
        this.extraInteractionHeight = d;
    }

    public double getExtraInteractionWidth() {
        return this.extraInteractionWidth;
    }

    public void setExtraInteractionWidth(double d) {
        this.extraInteractionWidth = d;
    }

    public CMIEffect getHoverEffect() {
        return this.effect;
    }

    public void setHoverEffect(CMIEffectManager.CMIParticle cMIParticle) {
        this.effect = new CMIEffect(cMIParticle);
        this.effect.setAmount(0);
        this.effect.setSpeed(1.0f);
    }

    public double getParticleOffsetX() {
        return this.particleOffsetX;
    }

    public void setParticleOffsetX(double d) {
        this.particleOffsetX = d;
    }

    public double getParticleOffsetY() {
        return this.particleOffsetY;
    }

    public void setParticleOffsetY(double d) {
        this.particleOffsetY = d;
    }

    public boolean isStabilizedHoverParticles() {
        return this.stabilizedHoverParticles;
    }

    public void setStabilizedHoverParticles(boolean bl) {
        this.stabilizedHoverParticles = bl;
    }

    public boolean isShowWhenNotPersistent() {
        return this.showWhenNotPersistent;
    }

    public void setShowWhenNotPersistent(boolean bl) {
        this.showWhenNotPersistent = bl;
    }

    public boolean isNewDisplayMethod() {
        return this.newDisplayMethod;
    }

    public CMIHologram setNewDisplayMethod(boolean bl) {
        this.newDisplayMethod = bl;
        return this;
    }

    public CMIBillboard getBillboard() {
        if (this.billboard == null) {
            return CMIBillboard.VERTICAL;
        }
        return this.billboard;
    }

    public CMIHologram setBillboard(CMIBillboard cMIBillboard) {
        this.billboard = cMIBillboard;
        return this;
    }

    public CMIBillboard getIconBillboard() {
        return this.iconBillboard;
    }

    public CMIHologram setIconBillboard(CMIBillboard cMIBillboard) {
        this.iconBillboard = cMIBillboard;
        return this;
    }

    public int getYaw() {
        return this.yaw;
    }

    public CMIHologram setYaw(int n) {
        this.yaw = n;
        return this;
    }

    public int getPitch() {
        return this.pitch;
    }

    public CMIHologram setPitch(int n) {
        this.pitch = CMINumber.clamp((int)n, (int)-180, (int)180);
        return this;
    }

    public CMITextAlignment getTextAlignment() {
        if (this.textAlignment == null) {
            return CMITextAlignment.CENTER;
        }
        return this.textAlignment;
    }

    public CMIHologram setTextAlignment(CMITextAlignment cMITextAlignment) {
        this.textAlignment = cMITextAlignment;
        return this;
    }

    public CMIChatColor getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = CMIChatColor.BLACK;
        }
        return this.backgroundColor;
    }

    public CMIHologram setBackgroundColor(CMIChatColor cMIChatColor) {
        this.backgroundColor = cMIChatColor;
        return this;
    }

    public int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public CMIHologram setBackgroundAlpha(int n) {
        this.backgroundAlpha = CMINumber.clamp((int)n, (int)0, (int)255);
        return this;
    }

    public int getTextAlpha() {
        return this.textAlpha;
    }

    public CMIHologram setTextAlpha(int n) {
        this.textAlpha = CMINumber.clamp((int)n, (int)0, (int)255);
        return this;
    }

    public boolean isDoubleSided() {
        return this.doubleSided;
    }

    public CMIHologram setDoubleSided(boolean bl) {
        this.doubleSided = bl;
        return this;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }

    public CMIHologram setShadowed(boolean bl) {
        this.shadowed = bl;
        return this;
    }

    public double getScaleW() {
        return this.scaleW;
    }

    public CMIHologram setScaleW(double d) {
        d = (double)((int)(d * 100.0)) / 100.0;
        this.scaleW = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public double getScaleH() {
        return this.scaleH;
    }

    public CMIHologram setScaleH(double d) {
        d = (double)((int)(d * 100.0)) / 100.0;
        this.scaleH = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public CMIHologram setIconScale(double d) {
        this.iconScale = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public int getIconPitch() {
        return this.iconPitch;
    }

    public CMIHologram setIconPitch(int n) {
        this.iconPitch = n;
        return this;
    }

    public int getIconYaw() {
        return this.iconYaw;
    }

    public CMIHologram setIconYaw(int n) {
        this.iconYaw = n;
        return this;
    }

    public int getSkyLevel() {
        return this.skyLevel;
    }

    public CMIHologram setSkyLevel(int n) {
        this.skyLevel = n;
        return this;
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public CMIHologram setBlockLevel(int n) {
        this.blockLevel = n;
        return this;
    }

    public String getWorldName() {
        return this.loc.getWorldName();
    }

    public Player getPlayerToShowFor() {
        return this.playerToShowFor;
    }

    public CMIHologram setPlayerToShowFor(Player player) {
        this.playerToShowFor = player;
        return this;
    }

    public int getSelfDestructIn() {
        return this.selfDestructIn;
    }

    public CMIHologram setSelfDestructIn(int n) {
        this.selfDestructIn = n;
        return this;
    }

    public void showToPlayer() {
        if (this.getPlayerToShowFor() == null || !this.getPlayerToShowFor().isOnline()) {
            return;
        }
        if (this.getSelfDestructIn() > 0) {
            CMIScheduler.runTaskLater(() -> this.hide(this.getPlayerToShowFor().getUniqueId()), (long)this.getSelfDestructIn());
        }
        this.updatePages();
        this.generalUpdate(this.getPlayerToShowFor(), true);
    }

    public boolean isAutoPagination() {
        return this.autoPagination;
    }

    public void setAutoPagination(boolean bl) {
        this.autoPagination = bl;
    }

    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    public void setSeeThrough(boolean bl) {
        this.seeThrough = bl;
    }

    private static /* synthetic */ void lambda$2(CMIItemDisplay cMIItemDisplay, CMIItemStack cMIItemStack, Player player) {
        if (cMIItemDisplay.getItemStack() == null || cMIItemDisplay.getItemStack().getType().isAir() || !cMIItemDisplay.getItemStack().equals((Object)cMIItemStack.getItemStack())) {
            cMIItemDisplay.show(player);
        } else {
            cMIItemDisplay.update(player);
        }
    }

    private /* synthetic */ void lambda$4(Player player, Location location, CMIItemStack cMIItemStack, int n) {
        CMIDataWatcher cMIDataWatcher = CMI.getInstance().getNMS().spawnHologram(player, location, null, cMIItemStack == null ? null : cMIItemStack.getItemStack());
        if (cMIItemStack != null) {
            cMIDataWatcher.setItem(cMIItemStack);
        }
        if (cMIDataWatcher != null) {
            cMIDataWatcher.setLoc(location);
            if (player.isOnline()) {
                this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
            }
        }
    }

    private /* synthetic */ void lambda$5(CMIItemStack cMIItemStack, Player player, Location location, CMIHologramLine cMIHologramLine, CMIAsyncHead cMIAsyncHead, int n) {
        CMIDataWatcher cMIDataWatcher = null;
        if (cMIItemStack != null && !cMIItemStack.getCMIType().isAir()) {
            cMIDataWatcher = CMI.getInstance().getNMS().makeFloatingIcon(player, location, cMIItemStack.getItemStack(), cMIHologramLine.isGlowing());
            if (cMIDataWatcher != null) {
                cMIDataWatcher.setItem(cMIItemStack);
            }
        } else {
            cMIDataWatcher = CMI.getInstance().getNMS().spawnHologram(player, location, null, null);
            cMIDataWatcher.setItem(null);
        }
        if (cMIDataWatcher != null) {
            cMIDataWatcher.setUpdatingHead(cMIAsyncHead.isAsyncHead());
            cMIDataWatcher.setLoc(location);
            if (player.isOnline()) {
                this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
            }
        }
    }

    private /* synthetic */ void lambda$6(CMIHologramLine cMIHologramLine, Player player, Location location, String string, int n) {
        CMIDataWatcher cMIDataWatcher = null;
        cMIDataWatcher = cMIHologramLine.getType() == CMIHoloLineType.image ? CMI.getInstance().getNMS().spawnHologram(player, location, string, null) : CMI.getInstance().getNMS().spawnHologram(player, location, cMIHologramLine.getText(player), null);
        cMIDataWatcher.setItem(null);
        cMIDataWatcher.setLoc(location);
        this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
    }
}

