/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.commands.list;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.commands.CAnnotation;
import com.Zrips.CMI.commands.Cmd;
import com.Zrips.CMI.utils.CMIDiskUsage;
import com.Zrips.CMI.utils.Lag;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.DecimalFormat;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class status
implements Cmd {
    @Override
    public void getExtra(ConfigReader configReader) {
        configReader.get("Platform", " &ePlatform: &6[platform] &e(&6[os]&e) &eRunning threads: &6[threads]");
        configReader.get("Tps", " &eTPS: &6[tps]");
        configReader.get("CpuUsage", " &eCpu usage: &6[cpuusage]% &e(&6[cores] cores&e)");
        configReader.get("Uptime.main", " &eUptime: ");
        configReader.get("Uptime.weeks", "&e[weeks] &6weeks ");
        configReader.get("Uptime.days", "&e[days] &6days ");
        configReader.get("Uptime.hours", "&e[hours] &6hours ");
        configReader.get("Uptime.mins", "&e[mins] &6mins ");
        configReader.get("Uptime.secs", "&e[secs] &6secs ");
        configReader.get("MemoryUsage", " &eMemory usage: &6[percent]% &e(&6[current]&e/&6[max] MB&e)");
        configReader.get("MemoryUsageHover", "&fFree: &7[free] \n&fAllocated: &7[allocated] \n&fMax: &7[max] \n&fTotal: &7[total]");
        configReader.get("Java", " &eJava version: &6[mainV].[majorV].[minorV]&e(&6[update]&e) Build: &6[build]");
        configReader.get("DiskUsage", " &eDisk usage: &6[percent]% &e(&6[current]&e/&6[max] GB&e)");
        configReader.get("Worlds", "&e [number]. &6[world] &e[chunks] Chunks &6[entities] Entities &e[tiles] tiles &6[players] players");
    }

    @Override
    @CAnnotation(priority=257, info="&eShow server status", regVar={0}, consoleVar={0}, customAlias={"gc", "!lag"}, others=false)
    public Boolean perform(CMI cMI, CommandSender commandSender, String[] stringArray) {
        status status2 = this;
        CMIScheduler.runTaskAsynchronously(() -> {
            Object object;
            RawMessage rawMessage = new RawMessage();
            if (!(commandSender instanceof Player)) {
                rawMessage.addText("\n");
            }
            rawMessage.addText(LC.info_Spliter.getLocale(new Object[0]));
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            try {
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                int n = operatingSystemMXBean.getAvailableProcessors();
                rawMessage.addText("\n");
                rawMessage.addText(CMILC.getIM(status2, "Platform", "[platform]", operatingSystemMXBean.getArch(), "[os]", operatingSystemMXBean.getName(), "[threads]", Thread.getAllStackTraces().keySet().size()));
                if (commandSender instanceof Player) {
                    rawMessage.addText("\n");
                    rawMessage.addText(CMILC.getIM(status2, "Tps", "[tps]", decimalFormat.format(cMI.getLagMeter().getTPS(20)))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 1}));
                    rawMessage.addText(" (" + decimalFormat.format(cMI.getLagMeter().getTPS(200))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 10}));
                    rawMessage.addText(" " + decimalFormat.format(cMI.getLagMeter().getTPS(600))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 30}));
                    rawMessage.addText(" " + decimalFormat.format(cMI.getLagMeter().getTPS(1200))).addHover(LC.info_min.getLocale(new Object[]{"[mins]", 1}));
                    rawMessage.addText(" " + decimalFormat.format(cMI.getLagMeter().getTPS(6000)) + ")").addHover(LC.info_min.getLocale(new Object[]{"[mins]", 10}));
                } else {
                    rawMessage.addText("\n");
                    rawMessage.addText(String.valueOf(CMILC.getIM(status2, "Tps", "[tps]", decimalFormat.format(cMI.getLagMeter().getTPS(20)))) + " (" + decimalFormat.format(cMI.getLagMeter().getTPS(200)) + " " + decimalFormat.format(cMI.getLagMeter().getTPS(600)) + " " + decimalFormat.format(cMI.getLagMeter().getTPS(1200)) + " " + decimalFormat.format(cMI.getLagMeter().getTPS(6000)) + ")");
                }
                double d = Lag.getProcessCpuLoad();
                rawMessage.addText("\n");
                rawMessage.addText(CMILC.getIM(status2, "CpuUsage", "[cpuusage]", decimalFormat.format(d), "[cores]", n));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l = ManagementFactory.getRuntimeMXBean().getStartTime();
            l = System.currentTimeMillis() - l;
            long l2 = l / 1000L % 60L;
            long l3 = l / 60000L % 60L;
            long l4 = l / 3600000L % 24L;
            long l5 = l / 86400000L % 7L;
            long l6 = l / 604800000L;
            String string = CMILC.getIM(status2, "Uptime.main", new Object[0]);
            if (l6 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.weeks", "[weeks]", l6);
            }
            if (l5 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.days", "[days]", l5);
            }
            if (l4 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.hours", "[hours]", l4);
            }
            if (l3 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.mins", "[mins]", l3);
            }
            if (l2 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.secs", "[secs]", l2);
            }
            rawMessage.addText("\n");
            rawMessage.addText(string);
            Runtime runtime = Runtime.getRuntime();
            long l7 = runtime.maxMemory();
            long l8 = runtime.totalMemory();
            long l9 = runtime.freeMemory();
            long l10 = l7 - (l8 - l9);
            rawMessage.addText("\n");
            rawMessage.addText(CMILC.getIM(status2, "MemoryUsage", "[percent]", decimalFormat.format(100.0 - (double)l10 * 100.0 / (double)l7), "[current]", decimalFormat.format((l7 - l10) / 1024L / 1024L), "[max]", l7 / 1024L / 1024L));
            rawMessage.addHover(CMILC.getIM(status2, "MemoryUsageHover", "[free]", decimalFormat.format(l9 / 1024L / 1024L), "[allocated]", decimalFormat.format(l8 / 1024L / 1024L), "[total]", decimalFormat.format(l7 / 1024L / 1024L), "[max]", decimalFormat.format(l7 / 1024L / 1024L)));
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String[] stringArray = System.getProperty("java.runtime.version").split("\\.|_|-b");
            try {
                string2 = stringArray[0];
                string3 = stringArray[1];
                string4 = stringArray[2];
                string5 = stringArray[3];
                string6 = stringArray[4];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    String string7 = System.getProperty("java.version");
                    string5 = string7.split("_")[1];
                    object = string7.split("_")[0].split(".");
                    string2 = object[0];
                    string3 = object[1];
                    string4 = object[2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                    // empty catch block
                }
            }
            rawMessage.addText("\n");
            rawMessage.addText(CMILC.getIM(status2, "Java", "[mainV]", string2, "[majorV]", string3, "[minorV]", string4, "[update]", string5, "[build]", string6));
            try {
                int n = (int)(CMIDiskUsage.getTotal() / 1024L / 1024L / 1024L);
                int n2 = (int)(CMIDiskUsage.getUsable() / 1024L / 1024L / 1024L);
                object = decimalFormat.format((double)(n - n2) * 100.0 / (double)n);
                rawMessage.addText("\n");
                rawMessage.addText(CMILC.getIM(status2, "DiskUsage", "[percent]", object, "[current]", n - n2, "[max]", n));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CMIScheduler.runTask(() -> {
                int n = 0;
                for (World world2 : Bukkit.getServer().getWorlds()) {
                    ++n;
                    int n2 = 0;
                    try {
                        Chunk[] chunkArray = world2.getLoadedChunks();
                        int n3 = chunkArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Chunk chunk = chunkArray[n4];
                            n2 += chunk.getTileEntities().length;
                            ++n4;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    rawMessage.addText("\n");
                    rawMessage.addText(CMILC.getIM(status2, "Worlds", "[number]", n, "[world]", world2.getName(), "[chunks]", world2.getLoadedChunks().length, "[entities]", world2.getEntities().size(), "[tiles]", n2, "[players]", world2.getPlayers().size()));
                }
                rawMessage.addText("\n");
                rawMessage.addText(LC.info_Spliter.getLocale(new Object[0]));
                rawMessage.show(commandSender);
            });
        });
        return true;
    }
}

