/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Player;

public class CMIExperience {
    public static long getXpToLevelUpFrom(int n) {
        if (Version.isCurrentLower((Version)Version.v1_8_R1)) {
            return n <= 16 ? 17L : (n <= 31 ? (long)(3 * n - 31) : 7L * (long)n - 155L);
        }
        return n <= 15 ? (long)(2 * n + 7) : (n <= 30 ? (long)(5 * n - 38) : 9L * (long)n - 158L);
    }

    public static long getTotalExpToLevel(int n) {
        if (Version.isCurrentLower((Version)Version.v1_8_R1)) {
            return n <= 16 ? 17 * n : (n <= 31 ? 3 * n * n / 2 - 59 * n / 2 + 360 : 7 * n * n / 2 - 303 * n / 2 + 2220);
        }
        return (long)(n <= 16 ? (double)(n * n + 6 * n) : (n <= 31 ? 2.5 * (double)n * (double)n - 40.5 * (double)n + 360.0 : 4.5 * (double)n * (double)n - 162.5 * (double)n + 2220.0));
    }

    public static void setLevel(Player player, int n) {
        if (player == null) {
            return;
        }
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.setLevel(n);
    }

    public static int levelFromExp(long l) {
        return (int)Math.floor((Math.sqrt(72.0 * (double)l - 54215.0) + 325.0) / 18.0);
    }

    public static void setExp(Player player, long l) {
        if (player == null) {
            return;
        }
        l = (long)CMINumber.clamp((double)l, (double)0.0, (double)3.4028234663852886E38);
        if (Version.isCurrentLower((Version)Version.v1_8_R1) || l < Integer.MAX_VALUE) {
            player.setLevel(0);
            player.setExp(0.0f);
            player.setTotalExperience(0);
            player.giveExp((int)l);
            return;
        }
        int n = CMIExperience.levelFromExp(l);
        float f = l - CMIExperience.getTotalExpToLevel(n);
        float f2 = CMIExperience.getXpToLevelUpFrom(n);
        player.setTotalExperience(0);
        player.setLevel(n);
        player.setExp((float)CMINumber.clamp((double)(f / f2), (double)0.0, (int)1));
    }

    public static void addExp(Player player, long l) {
        if (player == null) {
            return;
        }
        CMIExperience.setExp(player, CMIExperience.getTotalExp(player) + l);
    }

    public static void takeExp(Player player, long l) {
        if (player == null) {
            return;
        }
        CMIExperience.setExp(player, CMIExperience.getTotalExp(player) - l);
    }

    public static long getMissingExp(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getXpToLevelUpFrom(player.getLevel()) - CMIExperience.getExpForCurrentLevel(player);
    }

    public static int getLevel(Player player) {
        if (player == null) {
            return 0;
        }
        return player.getLevel();
    }

    public static long getExpForCurrentLevel(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getTotalExp(player) - CMIExperience.getTotalExpToLevel(player.getLevel());
    }

    public static long getTotalExp(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getTotalExpToLevel(player.getLevel()) + (long)Math.round((float)CMIExperience.getXpToLevelUpFrom(player.getLevel()) * player.getExp());
    }
}

