/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.AStand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.AStand.ArmorStandCopy;
import com.Zrips.CMI.Modules.AStand.ArmorStandManager;
import com.Zrips.CMI.Modules.AStand.ArmorStandSave;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.armorstand;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ArmorStandListener
implements Listener {
    private CMI plugin;
    public static HashMap<UUID, ArmorStandCopy> acMap = new HashMap();

    public ArmorStandListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler
    public void onBlockInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        if (acMap.isEmpty()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (!acMap.containsKey(player.getUniqueId())) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        acMap.remove(player.getUniqueId());
        CMILC.info(armorstand.class, (CommandSender)player, "canceled", new Object[0]);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onArmorStandDeath(EntityDeathEvent entityDeathEvent) {
        if (!entityDeathEvent.getEntity().getType().name().equals("ARMOR_STAND")) {
            return;
        }
        if (!this.plugin.getArmorStandManager().isBeingEdited(entityDeathEvent.getEntity().getUniqueId())) {
            return;
        }
        UUID uUID = this.plugin.getArmorStandManager().getEditorOf(entityDeathEvent.getEntity().getUniqueId());
        if (uUID == null) {
            return;
        }
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null) {
            return;
        }
        player.closeInventory();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void armorStandSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        if (!creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.DEFAULT)) {
            return;
        }
        if (!creatureSpawnEvent.getEntity().getType().name().equals("ARMOR_STAND")) {
            return;
        }
        Player object2 = null;
        Double d = 10.0;
        List<Player> list2 = this.plugin.getUtilManager().getPlayersFromRangeForCounter(creatureSpawnEvent.getLocation(), 5, true);
        for (Player object3 : list2) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(object3);
            if (cMIUser == null) continue;
            ItemStack itemStack = cMIUser.getItemInHand();
            ItemStack itemStack2 = cMIUser.getItemInOffHand();
            if ((itemStack == null || !itemStack.getType().equals((Object)Material.ARMOR_STAND)) && (itemStack2 == null || !itemStack2.getType().equals((Object)Material.ARMOR_STAND)) || object2 != null && d < creatureSpawnEvent.getEntity().getLocation().distance(object3.getLocation())) continue;
            d = creatureSpawnEvent.getEntity().getLocation().distance(object3.getLocation());
            object2 = object3;
        }
        Boolean bl = this.processArmorStand(object2, (Entity)creatureSpawnEvent.getEntity());
        if (bl == null) {
            creatureSpawnEvent.setCancelled(true);
            return;
        }
        if (bl.booleanValue()) {
            return;
        }
        Iterator<Player> iterator = object2;
        CMIScheduler.runAtEntityLater(iterator, () -> {
            if (iterator == null) {
                return;
            }
            Block block = this.plugin.getUtilManager().getTargetBlock((Player)iterator, 5);
            if (block == null || block.getType().equals((Object)Material.AIR)) {
                return;
            }
            Entity entity = this.plugin.getUtilManager().getClosestEntity(block.getLocation().clone().add(0.5, 0.5, 0.5), 2, EntityType.ARMOR_STAND);
            if (entity == null) {
                return;
            }
            if (!entity.equals(creatureSpawnEvent.getEntity())) {
                return;
            }
            if (!PermissionsManager.CMIPerm.armorstand_hands.hasPermission((CommandSender)iterator)) {
                return;
            }
            ArmorStand armorStand = (ArmorStand)creatureSpawnEvent.getEntity();
            armorStand.setArms(true);
        }, (long)1L);
    }

    private Boolean processArmorStand(Player player, Entity entity) {
        if (player == null) {
            return false;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return false;
        }
        ItemStack itemStack = cMIUser.getItemInHand();
        ItemStack itemStack2 = cMIUser.getItemInOffHand();
        if (!(itemStack != null && itemStack.getType().equals((Object)Material.ARMOR_STAND) || itemStack2 != null && itemStack2.getType().equals((Object)Material.ARMOR_STAND))) {
            return false;
        }
        ItemStack itemStack3 = null;
        if (itemStack != null && new CMINBT(itemStack).hasNBT("CMISavedArmorStand")) {
            itemStack3 = itemStack;
        } else if (itemStack2 != null && new CMINBT(itemStack2).hasNBT("CMISavedArmorStand")) {
            itemStack3 = itemStack2;
        }
        if (itemStack3 == null) {
            return false;
        }
        String string = new CMINBT(itemStack3).getString("CMISavedArmorStand");
        if (string == null) {
            return false;
        }
        if ((string = CMIEncoder.decode(string)) == null) {
            return false;
        }
        ArmorStandSave armorStandSave = this.plugin.getArmorStandManager().getSavedArmorStand(string);
        if (armorStandSave == null) {
            return false;
        }
        if (ArmorStandManager.TemplatesSpecificPermission && !PermissionsManager.CMIPerm.command_armorstand_template_$1.hasPermission((CommandSender)player, true, armorStandSave.getName().toLowerCase())) {
            ItemStack itemStack4 = itemStack3.clone();
            itemStack4.setAmount(1);
            CMIScheduler.runTask(() -> {
                HashMap hashMap = player.getInventory().addItem(new ItemStack[]{itemStack4});
            });
            return null;
        }
        armorStandSave.apply((ArmorStand)entity);
        return true;
    }
}

