/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Animations;

import com.Zrips.CMI.CMI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class AnimationRideListener
implements Listener {
    private CMI plugin;

    public AnimationRideListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void EntityDamageEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (!entityDamageEvent.getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION)) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (!this.plugin.getAnimationManager().isRiding(player.getUniqueId())) {
            return;
        }
        player.leaveVehicle();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void PlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (this.plugin.getAnimationManager().isBeingRiden(player.getUniqueId())) {
            this.plugin.getTeleportHandler().shakePassengers((Entity)player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityDeathEvent(EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntityType() != EntityType.SLIME) {
            return;
        }
        if (entityDeathEvent.getEntity().getCustomName() == null || !entityDeathEvent.getEntity().getCustomName().equals("CMIFakeSlime")) {
            return;
        }
        entityDeathEvent.setDroppedExp(0);
        entityDeathEvent.getDrops().clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerMoveEvent(VehicleMoveEvent vehicleMoveEvent) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerMoveEvent(PlayerMoveEvent playerMoveEvent) {
        if (this.plugin.getAnimationManager().getRidingList().isEmpty()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (!this.plugin.getAnimationManager().isRiding(player.getUniqueId())) {
            return;
        }
        if (!this.plugin.getAnimationManager().isRidingNonSteerable(player.getUniqueId())) {
            return;
        }
        if (!playerMoveEvent.isCancelled()) {
            return;
        }
        this.plugin.getAnimationManager().removePassengers(player, null);
    }
}

