/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DataBase;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.DataBase.DBDAO;
import com.Zrips.CMI.Modules.DataBase.DBMySQL;
import com.Zrips.CMI.Modules.DataBase.DBSQLite;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayDay;
import com.Zrips.CMI.PlayerManager;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Logs.CMIDebug;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DBManager {
    private DBDAO dao;
    private CMI plugin;
    private DataBaseType DbType = DataBaseType.SqLite;
    int autoSaveInterval = 15;
    private boolean ForceSaveOnLogOut = false;
    private boolean ForceLoadOnLogIn = false;
    private static final String fileName = "DataBaseInfo.yml";
    private String username = "";
    private String password = "";
    private String hostname = "";
    private String database = "";
    private String prefix = "";
    private boolean autoReconnect = true;
    private boolean useSSL = true;
    private boolean verifyServerCertificate = true;
    private Set<InvSave> invToSave = ConcurrentHashMap.newKeySet();
    private Set<CMIUser> playerListToSave = ConcurrentHashMap.newKeySet();
    private Set<CMIUser> playerPlayTimeRewardToSave = ConcurrentHashMap.newKeySet();
    CMITask autosaveBukkitId = null;
    CompletableFuture<Void> task = null;
    Long startedAt = 0L;
    private Runnable autoSave = new Runnable(){

        @Override
        public void run() {
            if (DBManager.this.task != null && DBManager.this.startedAt + 60000L < System.currentTimeMillis()) {
                DBManager.this.task.cancel(false);
                DBManager.this.task = null;
            }
            if (DBManager.this.task == null) {
                DBManager.this.startedAt = System.currentTimeMillis();
                DBManager.this.task = CMIScheduler.runTaskAsynchronously(() -> {
                    DBManager.this.saveBatch(DBManager.this.all);
                    DBManager.this.all = false;
                });
            }
        }
    };
    HashMap<String, CMIUser> getPlayerId = new HashMap();
    HashMap<Integer, CMIUser> getPlayerInvId = new HashMap();
    HashMap<CMIPlayDay, CMIUser> getPlayerPlayTimeId = new HashMap();
    HashMap<Integer, CMIUser> getPlayerPlayTimeRewardId = new HashMap();
    Boolean all = false;
    Integer oldRapidvalue = null;
    boolean startingDb = false;

    public DBManager(CMI cMI) {
        this.plugin = cMI;
    }

    public DBDAO getDB() {
        return this.dao;
    }

    public void switchDataBase() {
        if (this.dao != null) {
            this.dao.closeConnections();
        }
        this.plugin.setFullyLoaded(false);
        switch (this.DbType) {
            case MySQL: {
                this.DbType = DataBaseType.SqLite;
                this.dao = this.startSqlite(false);
                this.dao.setDbType(this.DbType);
                break;
            }
            case SqLite: {
                this.DbType = DataBaseType.MySQL;
                this.dao = this.startMysql(false);
                this.dao.setDbType(this.DbType);
            }
        }
        this.plugin.setFullyLoaded(true);
    }

    public void load() {
        ConfigReader configReader = null;
        CMI.getInstance().safeRenameFile("dataBaseInfo.yml", "Settings" + File.separator + fileName);
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            CMI.getInstance().consoleMessage("&cFailed to load Settings" + File.separator + fileName + " file");
            return;
        }
        ConfigReader configReader2 = CMI.getInstance().getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("storage")) {
            configReader.getC().set("storage", configReader2.getC().get("storage"));
        }
        if (configReader2.getC().isConfigurationSection("mysql")) {
            configReader.getC().set("mysql", configReader2.getC().get("mysql"));
        }
        if (configReader2.getC().isInt("AutoSaveInterval")) {
            configReader.getC().set("AutoSaveInterval", configReader2.getC().get("AutoSaveInterval"));
        }
        if (configReader2.getC().isBoolean("ForceSaveOnLogOut")) {
            configReader.getC().set("ForceSaveOnLogOut", configReader2.getC().get("ForceSaveOnLogOut"));
        }
        if (configReader2.getC().isBoolean("ForceLoadOnLogIn")) {
            configReader.getC().set("ForceLoadOnLogIn", configReader2.getC().get("ForceLoadOnLogIn"));
        }
        configReader.addComment("storage.method", new String[]{"storage method, can be MySQL or sqlite", "ATTENTION! DON'T USE SAME DATABASE TABLES FOR MORE THEN ONE SERVER, YOU WILL HAVE UNEXPECTED ISSUES. EACH SERVER SHOULD HAVE ITS OWN DATABASE TABLE SETUP"});
        String string = configReader.get("storage.method", "sqlite");
        configReader.addComment("mysql.username", new String[]{"Requires Mysql."});
        configReader.get("mysql.username", "root");
        configReader.get("mysql.password", "");
        configReader.get("mysql.hostname", "localhost:3306");
        configReader.get("mysql.database", "minecraft");
        configReader.addComment("mysql.tablePrefix", new String[]{"Valid characters are a-z 0-9 and _"});
        configReader.get("mysql.tablePrefix", "CMI_");
        configReader.addComment("mysql.autoReconnect", new String[]{"If you have no clue what these values do, then keep it at default values"});
        configReader.get("mysql.autoReconnect", Boolean.valueOf(true));
        configReader.get("mysql.useSSL", Boolean.valueOf(false));
        configReader.get("mysql.verifyServerCertificate", Boolean.valueOf(false));
        configReader.addComment("AutoSaveInterval", new String[]{"Auto save interval in seconds", "This will define how often to write down data into data base", "Save operation will not be performed if there is no changes to save", "!ATTENTION! Keep it in low numbers, around 60 seconds", "Minimal interval is 10 seconds"});
        this.autoSaveInterval = configReader.get("AutoSaveInterval", 15);
        this.autoSaveInterval = this.autoSaveInterval > 3600 ? 3600 : this.autoSaveInterval;
        configReader.addComment("ForceSaveOnLogOut", new String[]{"Player data will be recorded straight after he logs out, without any delay"});
        this.ForceSaveOnLogOut = configReader.get("ForceSaveOnLogOut", Boolean.valueOf(false));
        configReader.addComment("ForceLoadOnLogIn", new String[]{"EXPERIMENTAL. This is not fully tested yet and some minor issues can happen when ussing on bungee network", "Player data will be loaded from database each time player joins server", "When its set to false then precached data will be uses which is more efficient"});
        this.ForceLoadOnLogIn = configReader.get("ForceLoadOnLogIn", Boolean.valueOf(false));
        this.ForceSaveOnLogOut = this.ForceLoadOnLogIn ? this.ForceLoadOnLogIn : this.ForceSaveOnLogOut;
        configReader.save();
        if (string.equalsIgnoreCase("mysql")) {
            this.DbType = DataBaseType.MySQL;
            this.dao = this.startMysql(true);
        } else if (string.equalsIgnoreCase("sqlite")) {
            this.DbType = DataBaseType.SqLite;
            this.dao = this.startSqlite(true);
        } else {
            this.plugin.consoleMessage("&cInvalid storage method!  Changing method to sqlite!");
            configReader.getC().set("storage.method", (Object)"sqlite");
            this.DbType = DataBaseType.SqLite;
            this.dao = this.startSqlite(true);
        }
        configReader.save();
        this.start();
    }

    private synchronized DBMySQL startMysql(boolean bl) {
        String[] stringArray;
        String string;
        File file = new File(this.plugin.getDataFolder(), "Settings" + File.separator + fileName);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        String string2 = yamlConfiguration.getString("mysql.url");
        if (string2 != null) {
            string = "jdbc:mysql://";
            if (string2.toLowerCase().startsWith(string) && (stringArray = (string2 = string2.substring(string.length())).split("/")).length >= 2) {
                yamlConfiguration.set("mysql.hostname", (Object)stringArray[0]);
                yamlConfiguration.set("mysql.database", (Object)stringArray[1]);
            }
        }
        if ((string = yamlConfiguration.getString("mysql.username")) == null) {
            this.plugin.consoleMessage("&cmysql.username property invalid or missing");
        }
        stringArray = yamlConfiguration.getString("mysql.password");
        String string3 = yamlConfiguration.getString("mysql.hostname");
        String string4 = yamlConfiguration.getString("mysql.database");
        String string5 = yamlConfiguration.getString("mysql.tablePrefix");
        boolean bl2 = yamlConfiguration.getBoolean("mysql.autoReconnect");
        boolean bl3 = yamlConfiguration.getBoolean("mysql.useSSL");
        boolean bl4 = yamlConfiguration.getBoolean("mysql.verifyServerCertificate");
        if (bl && this.dao != null) {
            boolean bl5 = false;
            if (!this.username.equals(string)) {
                bl5 = true;
            }
            if (!this.password.equals(stringArray)) {
                bl5 = true;
            }
            if (!this.hostname.equals(string3)) {
                bl5 = true;
            }
            if (!this.database.equals(string4)) {
                bl5 = true;
            }
            if (!this.prefix.equals(string5)) {
                bl5 = true;
            }
            if (this.autoReconnect != bl2) {
                bl5 = true;
            }
            if (this.useSSL != bl3) {
                bl5 = true;
            }
            if (this.verifyServerCertificate != bl4) {
                bl5 = true;
            }
            if (this.dao != null && !bl5) {
                return (DBMySQL)this.dao;
            }
        }
        this.username = string;
        this.password = stringArray;
        this.hostname = string3;
        this.database = string4;
        this.prefix = string5;
        this.autoReconnect = bl2;
        this.useSSL = bl3;
        this.verifyServerCertificate = bl4;
        if (this.plugin.isEnabled()) {
            DBMySQL dBMySQL = new DBMySQL(this.plugin, string3, string4, string, (String)stringArray, string5, bl2, bl4, bl3);
            dBMySQL.initialize();
            return dBMySQL;
        }
        return null;
    }

    private synchronized DBSQLite startSqlite(boolean bl) {
        if (bl && this.dao != null) {
            return (DBSQLite)this.dao;
        }
        DBSQLite dBSQLite = new DBSQLite(this.plugin, this.plugin.getDataFolder());
        dBSQLite.initialize();
        return dBSQLite;
    }

    public DataBaseType getDbType() {
        return this.DbType;
    }

    public void stop() {
        if (this.autosaveBukkitId != null) {
            CMIDebug.d((Object[])new Object[]{"Stopped auto save task"});
            this.autosaveBukkitId.cancel();
        }
        if (this.task != null) {
            this.task.cancel(false);
        }
    }

    public void start() {
        int n = this.autoSaveInterval;
        if (this.oldRapidvalue != null) {
            n = 1;
        }
        if (n < 1) {
            n = 1;
        }
        this.stop();
        this.autosaveBukkitId = CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.autoSave, (long)(n *= 20), (long)n);
    }

    public void addForSave(CMIUser cMIUser) {
        this.playerListToSave.add(cMIUser);
    }

    public void addForPlayTimeRewardSave(CMIUser cMIUser) {
        this.playerPlayTimeRewardToSave.add(cMIUser);
    }

    public void addForSave(CMIUser cMIUser, String string) {
        InvSave invSave = new InvSave(cMIUser, string);
        this.invToSave.add(invSave);
    }

    public void clear() {
        this.getPlayerId.clear();
        this.getPlayerInvId.clear();
        this.getPlayerPlayTimeId.clear();
        this.getPlayerPlayTimeRewardId.clear();
    }

    private synchronized HashSet<CMIUser> getFirstPlayersForSave(boolean bl) {
        int n;
        HashSet<CMIUser> hashSet = new HashSet<CMIUser>();
        if (this.playerListToSave.size() < 10) {
            n = 0;
            for (CMIUser cMIUser : this.playerListToSave) {
                ++n;
            }
            if (n == 0) {
                this.playerListToSave.clear();
            }
        }
        if (bl) {
            hashSet.addAll(this.playerListToSave);
            return hashSet;
        }
        n = 0;
        int n2 = this.oldRapidvalue == null ? 50 : 250;
        int n3 = (int)((double)this.playerListToSave.size() * 0.1);
        n2 = n3 > n2 ? n3 : n2;
        n2 = n2 > 500 ? 500 : n2;
        for (CMIUser cMIUser : this.playerListToSave) {
            if (n >= n2) break;
            hashSet.add(cMIUser);
            ++n;
        }
        return hashSet;
    }

    public void saveAllInNextCicle() {
        this.all = true;
    }

    public void saveBatchAsync(boolean bl) {
        if (this.task != null && this.startedAt + 60000L < System.currentTimeMillis()) {
            this.task.cancel(false);
            this.task = null;
        }
        if (this.task == null) {
            this.startedAt = System.currentTimeMillis();
            this.task = CMIScheduler.runTaskAsynchronously(() -> {
                this.saveBatch(bl);
                this.all = false;
            });
        }
    }

    public void startRapidSave() {
        this.oldRapidvalue = this.autoSaveInterval;
        this.autoSaveInterval = 1;
        this.all = false;
    }

    public void saveBatch(boolean bl) {
        if (this.startingDb) {
            return;
        }
        try {
            if (!(this.playerListToSave.isEmpty() && this.invToSave.isEmpty() && this.playerPlayTimeRewardToSave.isEmpty())) {
                Object object;
                if (!this.getDB().isConnected() && this.DbType == DataBaseType.MySQL) {
                    block40: {
                        if (!this.startingDb) {
                            this.startingDb = true;
                            try {
                                try {
                                    this.dao = this.startMysql(false);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    this.startingDb = false;
                                    break block40;
                                }
                            }
                            catch (Throwable throwable) {
                                this.startingDb = false;
                                throw throwable;
                            }
                            this.startingDb = false;
                        }
                    }
                    if (this.getDB() != null && this.getDB().isConnected()) {
                        CMI.getInstance().consoleMessage("&2Re-established MySQL connection");
                        return;
                    }
                }
                if (!(this.getDB() != null && this.getDB().isConnected() || this.DbType != DataBaseType.MySQL)) {
                    CMI.getInstance().consoleMessage("&cCan't save player data. DataBase connection can't be established");
                    return;
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                this.getDB().prepareTempBatch();
                HashSet<CMIUser> hashSet = this.getFirstPlayersForSave(bl);
                if (this.oldRapidvalue != null) {
                    this.plugin.consoleMessage("Saving player data: " + hashSet.size() + "/" + this.playerListToSave.size());
                }
                CMIDebug.d((Object[])new Object[]{"TempList ", hashSet.size(), " pFullList ", this.playerListToSave.size(), " pRewards: ", this.playerPlayTimeRewardToSave.size(), " InvSave: ", this.invToSave.size()});
                for (CMIUser object22 : hashSet) {
                    if (object22.getUniqueId() == null || !object22.isFakeAccount().booleanValue() && !object22.isOnline() && (!object22.isOnline() || object22.getTotalPlayTime(true) <= 0L) && object22.getTotalPlayTime(false) <= 0L && object22.getId() != 0) continue;
                    if (object22.getId() == 0) {
                        this.getPlayerId.put(object22.getUniqueId().toString(), object22);
                    }
                    boolean cMIUser = false;
                    try {
                        cMIUser = this.getDB().updatePlayer(object22);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (cMIUser) continue;
                    this.addForSave(object22);
                }
                if (this.plugin.getConfigManager().isCMIPlayTimeTracking()) {
                    for (CMIUser cMIUser : hashSet) {
                        for (CMIPlayDay cMIPlayDay : cMIUser.getCMIPlayTime().getForSave()) {
                            if (cMIPlayDay.getId() != 0) continue;
                            this.getPlayerPlayTimeId.put(cMIPlayDay, cMIUser);
                        }
                        this.getDB().updatePlayerPlayTime(cMIUser);
                    }
                }
                Iterator<InvSave> iterator = this.invToSave.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((InvSave)object).getUser().getInvId() == 0 && ((InvSave)object).getUser().getId() != 0) {
                        this.getPlayerInvId.put(((InvSave)object).getUser().getId(), ((InvSave)object).getUser());
                    }
                    this.getDB().updatePlayerInventory(((InvSave)object).getUser(), ((InvSave)object).getInv());
                    iterator.remove();
                }
                object = this.playerPlayTimeRewardToSave.iterator();
                while (object.hasNext()) {
                    CMIUser cMIUser = (CMIUser)object.next();
                    if (cMIUser.getPlayTimeRewardId() == 0 && cMIUser.getId() != 0) {
                        this.getPlayerPlayTimeRewardId.put(cMIUser.getId(), cMIUser);
                    }
                    this.getDB().updatePlayerPlayTimeRewards(cMIUser);
                    object.remove();
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                try {
                    if (this.getDB().executeTempBatch()) {
                        this.playerListToSave.removeAll(hashSet);
                    } else {
                        CMIDebug.d((Object[])new Object[]{"Failed to save"});
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                if (!this.getPlayerId.isEmpty()) {
                    this.getDB().getUserIds(this.getPlayerId);
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                if (!this.getPlayerPlayTimeId.isEmpty()) {
                    this.getDB().getUserPlayTimeIds(this.getPlayerPlayTimeId);
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                if (!this.getPlayerInvId.isEmpty()) {
                    this.getDB().getUserInvIds(this.getPlayerInvId);
                }
                if (!this.getPlayerPlayTimeRewardId.isEmpty()) {
                    this.getDB().getUserPlayTimeRewardIds(this.getPlayerPlayTimeRewardId);
                }
                if (this.getDB().isLocked()) {
                    return;
                }
                this.clear();
                this.task = null;
                return;
            }
            if (this.oldRapidvalue != null) {
                this.autoSaveInterval = this.oldRapidvalue;
                this.oldRapidvalue = null;
                this.task = null;
                this.start();
                CMI.getInstance().consoleMessage("Saved all player data");
            }
        }
        catch (Exception exception) {
            this.plugin.consoleMessage(" SEVERE SAVE ERROR");
            exception.printStackTrace();
            this.task = null;
            return;
        }
        this.task = null;
    }

    public boolean isRapidModeEnabled() {
        return this.oldRapidvalue != null;
    }

    private void showStats() {
        for (Map.Entry<DBDAO.UserTablesFields, Long> entry : PlayerManager.timer.entrySet()) {
            CMIDebug.d((Object[])new Object[]{(Object)((Object)entry.getKey()) + " : " + entry.getValue() / (long)PlayerManager.timesProcessed});
        }
    }

    public boolean isForceSaveOnLogOut() {
        return this.ForceSaveOnLogOut;
    }

    public boolean isForceLoadOnLogIn() {
        return this.ForceLoadOnLogIn;
    }

    public static enum DataBaseType {
        MySQL,
        SqLite;

    }

    class InvSave {
        private CMIUser user;
        private String inv;

        public InvSave(CMIUser cMIUser, String string) {
            this.user = cMIUser;
            this.inv = string;
        }

        public String getInv() {
            return this.inv;
        }

        public CMIUser getUser() {
            return this.user;
        }
    }
}

