/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.utils.SpawnUtil;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BossBarCompassListener
implements Listener {
    private CMI plugin;
    ConcurrentHashMap<UUID, Long> compassCheck = new ConcurrentHashMap();

    public BossBarCompassListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerItemHeldEvent(PlayerJoinEvent playerJoinEvent) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerItemHeldEvent(PlayerItemHeldEvent playerItemHeldEvent) {
        if (playerItemHeldEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isBossBarCompassEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isCompassRequireCompass()) {
            return;
        }
        ItemStack itemStack = playerItemHeldEvent.getPlayer().getInventory().getItem(playerItemHeldEvent.getNewSlot());
        if (itemStack != null && itemStack.getType().equals((Object)Material.COMPASS)) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerItemHeldEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        itemStack = cMIUser.getItemInOffHand();
        if (itemStack != null && itemStack.getType().equals((Object)Material.COMPASS)) {
            return;
        }
        BossBarInfo bossBarInfo = cMIUser.getBossBar("CMICompass");
        if (bossBarInfo == null) {
            return;
        }
        cMIUser.removeBossBar(bossBarInfo);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerMoveEvent(PlayerMoveEvent playerMoveEvent) {
        Material material;
        Material material2;
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isBossBarCompassEnabled()) {
            return;
        }
        Location location = playerMoveEvent.getTo();
        Player player = playerMoveEvent.getPlayer();
        Long l = this.compassCheck.get(playerMoveEvent.getPlayer().getUniqueId());
        if (l != null && l + (long)this.plugin.getConfigManager().getCompassUpdateInterval() > System.currentTimeMillis()) {
            return;
        }
        this.compassCheck.put(playerMoveEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerMoveEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.getOptionState(PlayerOption.bassBarCompass).booleanValue()) {
            return;
        }
        if (System.currentTimeMillis() - cMIUser.getLastLogin() < 2000L) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.plugin.getConfigManager().isCompassRequireCompass() || this.plugin.getConfigManager().isRecoveryAsRegularCompass()) {
            material2 = cMIUser.getItemInHand().getType();
            material = cMIUser.getItemInOffHand().getType();
            if (this.plugin.getConfigManager().isCompassRequireCompass() && (material2 != null && material2.equals((Object)Material.COMPASS) || material != null && material.equals((Object)Material.COMPASS))) {
                bl = true;
            }
            if (this.plugin.getConfigManager().isRecoveryAsRegularCompass() && !bl && Version.isCurrentEqualOrHigher((Version)Version.v1_19_R1) && (material2 != null && material2.equals((Object)Material.RECOVERY_COMPASS) || material != null && material.equals((Object)Material.RECOVERY_COMPASS))) {
                bl = true;
                bl2 = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return;
        }
        material2 = cMIUser.getBossBar("CMICompass");
        if (material2 == null) {
            material2 = new BossBarInfo(cMIUser.getPlayer(), "CMICompass");
            material2.setKeepForTicks(Integer.valueOf(20));
            try {
                material2.setColor(BarColor.WHITE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                material2.setStyle(BarStyle.SOLID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            material2.setAuto(Integer.valueOf(1));
            cMIUser.addBossBar((BossBarInfo)material2);
        }
        material2.setPercentage(Double.valueOf(0.01));
        material2.setStarted(System.currentTimeMillis());
        material = material2;
        boolean bl3 = bl2;
        CMIScheduler.runTaskAsynchronously(() -> this.lambda$0(bl3, cMIUser, location, (BossBarInfo)material));
    }

    private Integer process(Location location, Location location2, double d) {
        if (location == null || location2 == null) {
            return null;
        }
        if (!location.getWorld().equals(location2.getWorld())) {
            return null;
        }
        double d2 = BossBarCompassListener.getYaw(location, location2);
        d2 = (d2 + 540.0) % 360.0;
        return (int)Math.floor(d2 / d);
    }

    private static double getYaw(Location location, Location location2) {
        Vector vector = location.toVector().subtract(location2.toVector());
        Location location3 = location.clone();
        location3.setDirection(vector);
        return location3.getYaw();
    }

    private /* synthetic */ void lambda$0(boolean bl, CMIUser cMIUser, Location location, BossBarInfo bossBarInfo) {
        String string = this.plugin.getConfigManager().getCompassShape();
        double d = 360.0 / (double)string.length();
        Location location2 = Config.CompassShowDeath ? (this.plugin.getConfigManager().isRecoveryRequireCompass() && !bl ? null : cMIUser.getDeathLoc()) : null;
        CMILocation cMILocation = null;
        if (Config.CompassShowHome) {
            try {
                cMILocation = cMIUser.getHome(CMI.getInstance().getHomeManager().getDefaultHomeName()) != null ? cMIUser.getHome(CMI.getInstance().getHomeManager().getDefaultHomeName()).getLoc() : (cMIUser.getHomes().isEmpty() ? null : cMIUser.getHome(cMIUser.getHomesList().get(0)).getLoc());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!cMIUser.isOnline()) {
            return;
        }
        CMILocation cMILocation2 = Config.CompassShowSpawn ? SpawnUtil.getSpawnPoint(cMIUser.getPlayer()) : null;
        Location location3 = Config.CompassShowCompass ? cMIUser.getPlayer().getCompassTarget() : null;
        Integer n = location2 != null ? this.process(cMIUser.getPlayer().getLocation(), location2, d) : null;
        Integer n2 = cMILocation != null ? this.process(cMIUser.getPlayer().getLocation(), (Location)cMILocation, d) : null;
        Integer n3 = cMILocation2 != null ? this.process(cMIUser.getPlayer().getLocation(), (Location)cMILocation2, d) : null;
        Integer n4 = location3 != null ? this.process(cMIUser.getPlayer().getLocation(), location3, d) : null;
        int n5 = (int)location.getYaw() - 2;
        n5 = (n5 + 540) % 360;
        int n6 = (int)Math.floor((double)n5 / d);
        int n7 = string.length() / 2;
        int n8 = n6;
        n8 = n8 < 0 ? string.length() - -n8 : n8;
        n8 = n8 < 0 ? 0 : n8;
        int n9 = n8 - n7 - 1;
        n9 = n9 < 0 ? string.length() - -n9 : n9;
        String string2 = this.plugin.getConfigManager().getCompassColor();
        StringBuilder stringBuilder = new StringBuilder().append(string2);
        int n10 = 0;
        while (n10 < string.length()) {
            if (n8 >= string.length()) {
                n8 = 0;
            }
            if (n2 != null && n8 == n2) {
                var24_24 = CMIChatColor.getLastColors((String)stringBuilder.toString());
                if (n8 == n9) {
                    stringBuilder.append("&f&n" + this.plugin.getConfigManager().getCompassHomeIcon() + var24_24);
                } else {
                    stringBuilder.append("&2" + this.plugin.getConfigManager().getCompassHomeIcon() + var24_24);
                }
            } else if (n3 != null && n8 == n3) {
                var24_24 = CMIChatColor.getLastColors((String)stringBuilder.toString());
                if (n8 == n9) {
                    stringBuilder.append("&f&n" + this.plugin.getConfigManager().getCompassSpawnIcon() + var24_24);
                } else {
                    stringBuilder.append("&5&l" + this.plugin.getConfigManager().getCompassSpawnIcon() + var24_24);
                }
            } else if (n != null && n8 == n) {
                var24_24 = CMIChatColor.getLastColors((String)stringBuilder.toString());
                if (n8 == n9) {
                    stringBuilder.append("&f&n" + this.plugin.getConfigManager().getCompassDeathIcon() + var24_24);
                } else {
                    stringBuilder.append("&c" + this.plugin.getConfigManager().getCompassDeathIcon() + var24_24);
                }
            } else if (n4 != null && n8 == n4) {
                var24_24 = CMIChatColor.getLastColors((String)stringBuilder.toString());
                if (n8 == n9) {
                    stringBuilder.append("&f&n" + this.plugin.getConfigManager().getCompassTargetIcon() + var24_24);
                } else {
                    stringBuilder.append("&5" + this.plugin.getConfigManager().getCompassTargetIcon() + var24_24);
                }
            } else if (n8 == n9) {
                var24_24 = CMIChatColor.getLastColors((String)stringBuilder.toString());
                stringBuilder.append("&f&n" + string.charAt(n8) + var24_24);
            } else {
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1) && Config.CompassColors.size() - 1 >= n8) {
                    stringBuilder.append("{#" + Config.CompassColors.get(n8) + "}");
                }
                stringBuilder.append(string.charAt(n8));
            }
            ++n8;
            ++n10;
        }
        bossBarInfo.setTitleOfBar(stringBuilder.toString());
    }
}

