/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.RuleResponce;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class ChatFilterListener
implements Listener {
    private CMI plugin;

    public ChatFilterListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void capsFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        boolean bl = this.plugin.getChatFilterManager().checkCaps(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void AsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        RuleResponce ruleResponce = this.plugin.getChatFilterManager().getCorrectMessage(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
        if (ruleResponce.getRules().isEmpty()) {
            return;
        }
        ruleResponce.informStaff(asyncPlayerChatEvent.getPlayer());
        ruleResponce.performCommands(asyncPlayerChatEvent.getPlayer());
        switch (ruleResponce.getMaxFilterBlockType()) {
            case None: {
                break;
            }
            case All: {
                asyncPlayerChatEvent.setCancelled(true);
                asyncPlayerChatEvent.getRecipients().clear();
                return;
            }
            case Others: {
                Player player = asyncPlayerChatEvent.getPlayer();
                asyncPlayerChatEvent.getRecipients().clear();
                asyncPlayerChatEvent.getRecipients().add(player);
                break;
            }
        }
        asyncPlayerChatEvent.setMessage(ruleResponce.getUpdatedMessage());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void spamFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        if (this.plugin.getChatFilterManager().isSpam(player, asyncPlayerChatEvent.getMessage())) {
            CMILC.info_noSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
            asyncPlayerChatEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void spamCommandFilter(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (this.plugin.getChatFilterManager().isSpamedCommand(player, playerCommandPreprocessEvent.getMessage())) {
            CMILC.info_noCmdSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChangeEventAdvertisement(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        String[] stringArray = signChangeEvent.getLines();
        Object object = "";
        int n = 0;
        while (n < stringArray.length) {
            if (!((String)object).isEmpty()) {
                object = (String)object + "%break%";
            }
            object = (String)object + stringArray[n];
            ++n;
        }
        this.plugin.getPlayerManager().sendMessageToSignSpies(player, (String)object, signChangeEvent.getBlock().getLocation());
    }
}

