/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.ChatFilter.MessageLog;
import com.Zrips.CMI.Modules.ChatFilter.RuleResponce;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Chat.ChatFilterBlockType;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatFilterManager {
    private CMI plugin;
    private HashMap<String, ChatFilterRule> rules = new HashMap();
    private ChatFilterRule whiteRules = null;
    private HashMap<UUID, MessageLog> spamMessages = new HashMap();
    private HashMap<UUID, MessageLog> spamCommands = new HashMap();
    private double similarityPercentage = 0.8;
    private boolean preventDoublicates = true;
    private int douplicateInterval = 5;
    private int douplicateChatMinAmount = 5;
    private double similarityComamndPercentage = 0.8;
    private boolean preventCommandDoublicates = true;
    private int douplicateCommandInterval = 5;
    private int douplicateCommandMinAmount = 5;
    private List<String> douplicateCommandWhiteList = new ArrayList<String>();
    private boolean capsFilter = true;
    private int capsIgnoreUnder;
    private int capsPercentage;
    private List<String> capsCommands;
    private List<String> capsWhiteList;
    public static final String StringchatFilterFile = "ChatFilter.yml";

    public void clearCache(UUID uUID) {
        this.spamMessages.remove(uUID);
        this.spamCommands.remove(uUID);
    }

    public ChatFilterManager(CMI cMI) {
        this.plugin = cMI;
        try {
            this.whiteRules = new ChatFilterRule();
            this.whiteRules.setPattern(Arrays.asList("\\bgoogle.\\s?([a-zA-Z]{2,4})\\b", "\\bltcraft.\\s?([a-zA-Z]{2,4})\\b", "\\bspigotmc.\\s?([a-zA-Z]{2,4})\\b"));
        }
        catch (Exception exception) {
            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(String.valueOf(ChatColor.RED) + "Cant load chat filter"));
            exception.printStackTrace();
        }
    }

    public boolean checkCaps(Player player, String string) {
        int n = string.length();
        if (!this.capsFilter) {
            return true;
        }
        if (PermissionsManager.CMIPerm.chatfilter_capbypass.hasSetPermission((CommandSender)player, new String[0])) {
            return true;
        }
        if (this.capsWhiteList.contains(CMIChatColor.stripColor((String)string).toLowerCase())) {
            return true;
        }
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            string = string.replaceFirst(Pattern.quote(player2.getName()), Matcher.quoteReplacement(player2.getName().toLowerCase()));
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player2);
            if (cMIUser.getNickName() == null) continue;
            string = string.replaceFirst(Pattern.quote(cMIUser.getNickName()), Matcher.quoteReplacement(cMIUser.getNickName().toLowerCase()));
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c == ' ') {
                ++n3;
            } else if (Character.toLowerCase(c) != c) {
                ++n2;
            }
            ++n4;
        }
        n4 = (int)((double)n2 * 100.0 / (double)(n - n3));
        if (n - n3 <= this.capsIgnoreUnder) {
            return true;
        }
        if (n4 > this.capsPercentage) {
            CMIScheduler.runTask(() -> {
                List<String> list2 = new ArrayList<String>(this.capsCommands);
                list2 = this.plugin.getLM().updateSnd(new Snd(player, player), list2);
                this.plugin.getSpecializedCommandManager().processCmds(list2, player);
            });
            return true;
        }
        return true;
    }

    public RuleResponce getCorrectMessage(Player player, String string) {
        return this.getCorrectMessage(player, string, false);
    }

    public RuleResponce getCorrectMessage(Player player, String string, boolean bl) {
        Object object;
        Object object2;
        RuleResponce ruleResponce = new RuleResponce(string);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        int n = 0;
        for (Pattern object3 : this.whiteRules.getPattern()) {
            object2 = object3.matcher(string);
            ++n;
            if (object2 == null) continue;
            while (((Matcher)object2).find()) {
                object = "%" + n + "%tipitop%" + n + "%";
                string = string.replace(((Matcher)object2).group(), (CharSequence)object);
                hashMap.put(object, ((Matcher)object2).group());
            }
        }
        for (Map.Entry entry : this.rules.entrySet()) {
            object2 = (ChatFilterRule)entry.getValue();
            if (bl && !((ChatFilterRule)object2).isApplyToPrivateMessages() || (object = ((ChatFilterRule)object2).getMatcher(string)) == null) continue;
            while (((Matcher)object).find()) {
                ruleResponce.addRule((ChatFilterRule)object2);
                if (PermissionsManager.CMIPerm.chatfilter_bypass_$1.hasPermission((CommandSender)player, ((ChatFilterRule)object2).getGroup())) {
                    ruleResponce.addBypass(((ChatFilterRule)object2).getGroup());
                    continue;
                }
                if (((ChatFilterRule)object2).getReplaceWith() == null || ((ChatFilterRule)object2).getReplaceWith().isEmpty()) continue;
                string = string.replace(((Matcher)object).group(), ((ChatFilterRule)object2).getReplaceWith());
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = string.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        ruleResponce.setUpdatedMessage(string);
        return ruleResponce;
    }

    public boolean isSpamedCommand(Player player, String string) {
        if (!this.preventCommandDoublicates) {
            return false;
        }
        if (this.isWhiteListedCommand(string)) {
            return false;
        }
        if (PermissionsManager.CMIPerm.commandfilter_bypass.hasPermission((CommandSender)player)) {
            return false;
        }
        MessageLog messageLog = this.spamCommands.get(player.getUniqueId());
        if (messageLog == null) {
            messageLog = new MessageLog(this.douplicateCommandInterval);
            messageLog.addMessage(string);
            this.spamCommands.put(player.getUniqueId(), messageLog);
            return false;
        }
        int n = 0;
        for (Map.Entry<Long, String> entry : messageLog.getMessages().entrySet()) {
            double d = ChatFilterManager.similarity(string, entry.getValue());
            if (!(d > this.similarityComamndPercentage)) continue;
            ++n;
        }
        if (n >= this.douplicateCommandMinAmount) {
            return true;
        }
        messageLog.addMessage(string);
        return false;
    }

    private boolean isWhiteListedCommand(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        for (String string2 : this.douplicateCommandWhiteList) {
            if (string2.startsWith("/")) {
                string2 = string2.substring(1, string2.length());
            }
            if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isSpam(Player player, String string) {
        if (!this.preventDoublicates) {
            return false;
        }
        if (PermissionsManager.CMIPerm.chatfilter_spambypass.hasPermission((CommandSender)player)) {
            return false;
        }
        MessageLog messageLog = this.spamMessages.get(player.getUniqueId());
        if (messageLog == null) {
            messageLog = new MessageLog(this.douplicateInterval);
            messageLog.addMessage(string);
            this.spamMessages.put(player.getUniqueId(), messageLog);
            return false;
        }
        int n = 0;
        for (Map.Entry<Long, String> entry : new HashMap<Long, String>(messageLog.getMessages()).entrySet()) {
            double d = ChatFilterManager.similarity(string, entry.getValue());
            if (!(d > this.similarityPercentage)) continue;
            ++n;
        }
        if (n >= this.douplicateChatMinAmount) {
            return true;
        }
        messageLog.addMessage(string);
        return false;
    }

    public static double similarity(String string, String string2) {
        int n;
        String string3 = string;
        String string4 = string2;
        if (string.length() < string2.length()) {
            string3 = string2;
            string4 = string;
        }
        if ((n = string3.length()) == 0) {
            return 1.0;
        }
        return (double)(n - ChatFilterManager.editDistance(string3, string4)) / (double)n;
    }

    public static int editDistance(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int[] nArray = new int[string2.length() + 1];
        int n = 0;
        while (n <= string.length()) {
            int n2 = n;
            int n3 = 0;
            while (n3 <= string2.length()) {
                if (n == 0) {
                    nArray[n3] = n3;
                } else if (n3 > 0) {
                    int n4 = nArray[n3 - 1];
                    if (string.charAt(n - 1) != string2.charAt(n3 - 1)) {
                        n4 = Math.min(Math.min(n4, n2), nArray[n3]) + 1;
                    }
                    nArray[n3 - 1] = n2;
                    n2 = n4;
                }
                ++n3;
            }
            if (n > 0) {
                nArray[string2.length()] = n2;
            }
            ++n;
        }
        return nArray[string2.length()];
    }

    private static ChatFilterBlockType getBlockType(String string) {
        ChatFilterBlockType[] chatFilterBlockTypeArray = ChatFilterBlockType.values();
        int n = chatFilterBlockTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatFilterBlockType chatFilterBlockType = chatFilterBlockTypeArray[n2];
            if (chatFilterBlockType.name().equalsIgnoreCase(string)) {
                return chatFilterBlockType;
            }
            ++n2;
        }
        return ChatFilterBlockType.None;
    }

    public void load() {
        Object object;
        Object object2;
        this.plugin.safeRenameFile(StringchatFilterFile.toLowerCase(), "Settings" + File.separator + StringchatFilterFile);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + StringchatFilterFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        boolean bl = configReader.get("ChatFilter.Enabled", Boolean.valueOf(false));
        this.rules.clear();
        if (!configReader.getC().isConfigurationSection("ChatFilter.Deny")) {
            object2 = new ChatFilterRule();
            ((ChatFilterRule)object2).setRuleName("ipBlock");
            boolean bl2 = configReader.get("ChatFilter.Deny.ipBlock.Enabled", Boolean.valueOf(true));
            ((ChatFilterRule)object2).setGroup(configReader.get("ChatFilter.Deny.ipBlock.Group", "Advertising"));
            ((ChatFilterRule)object2).setInformConsole(configReader.get("ChatFilter.Deny.ipBlock.InformConsole", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setPattern(configReader.get("ChatFilter.Deny.ipBlock.Regex", Arrays.asList("[a-zA-Z0-9\\-\\.]+\\s?(\\.|dot|\\(dot\\)|-|;|:|,|_|\\/)\\s?([a-zA-Z]{2}|aero|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel)\\b", "\\b[0-9]{1,3}(\\.|dot|\\(dot\\)|-|;|:|,|(\\W|\\d|_)*\\s)+[0-9]{1,3}(\\.|dot|\\(dot\\)|-|;|:|,|(\\W|\\d|_)*\\s)+[0-9]{1,3}(\\.|dot|\\(dot\\)|-|;|:|,|(\\W|\\d|_)*\\s)+[0-9]{1,3}\\b")));
            ((ChatFilterRule)object2).setReplaceWith(configReader.get("ChatFilter.Deny.ipBlock.ReplaceWith", ""));
            ((ChatFilterRule)object2).setBlockType(ChatFilterManager.getBlockType(configReader.get("ChatFilter.Deny.ipBlock.BlockType", "others")));
            ((ChatFilterRule)object2).setApplyToPrivateMessages(configReader.get("ChatFilter.Deny.ipBlock.includePrivateMessages", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setMessageToStaff(configReader.get("ChatFilter.Deny.ipBlock.msgToStaff", "&4!&6[playerName] &4advertising with: &r[message]"));
            ((ChatFilterRule)object2).setCommands(configReader.get("ChatFilter.Deny.ipBlock.Commands", new ArrayList()));
            if (bl2 && bl) {
                this.rules.put(((ChatFilterRule)object2).getRuleName(), (ChatFilterRule)object2);
            }
            object2 = new ChatFilterRule();
            ((ChatFilterRule)object2).setRuleName("swearing1");
            bl2 = configReader.get("ChatFilter.Deny.swearing1.Enabled", Boolean.valueOf(true));
            ((ChatFilterRule)object2).setGroup(configReader.get("ChatFilter.Deny.swearing1.Group", "Swearing"));
            ((ChatFilterRule)object2).setInformConsole(configReader.get("ChatFilter.Deny.swearing1.InformConsole", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setPattern(configReader.get("ChatFilter.Deny.swearing1.Regex", Arrays.asList("\\bass\\b|\\basshole")));
            ((ChatFilterRule)object2).setReplaceWith(configReader.get("ChatFilter.Deny.swearing1.ReplaceWith", "dude"));
            ((ChatFilterRule)object2).setBlockType(ChatFilterManager.getBlockType(configReader.get("ChatFilter.Deny.swearing1.BlockType", "none")));
            ((ChatFilterRule)object2).setApplyToPrivateMessages(configReader.get("ChatFilter.Deny.swearing1.includePrivateMessages", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setMessageToStaff(configReader.get("ChatFilter.Deny.swearing1.msgToStaff", "&4!&6[playerName] &4swearing"));
            ((ChatFilterRule)object2).setCommands(configReader.get("ChatFilter.Deny.swearing1.Commands", Arrays.asList("msg [senderName] &eDon't swear!")));
            if (bl2 && bl) {
                this.rules.put(((ChatFilterRule)object2).getRuleName(), (ChatFilterRule)object2);
            }
            object2 = new ChatFilterRule();
            ((ChatFilterRule)object2).setRuleName("swearing2");
            bl2 = configReader.get("ChatFilter.Deny.swearing2.Enabled", Boolean.valueOf(true));
            ((ChatFilterRule)object2).setGroup(configReader.get("ChatFilter.Deny.swearing2.Group", "Swearing"));
            ((ChatFilterRule)object2).setInformConsole(configReader.get("ChatFilter.Deny.swearing2.InformConsole", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setPattern(configReader.get("ChatFilter.Deny.swearing2.Regex", Arrays.asList("\\b(?i)(f+(\\W|_)*(u?)+(\\W|_)*(c?)+(\\W|_)*k+)")));
            ((ChatFilterRule)object2).setReplaceWith(configReader.get("ChatFilter.Deny.swearing2.ReplaceWith", "not good"));
            ((ChatFilterRule)object2).setApplyToPrivateMessages(configReader.get("ChatFilter.Deny.swearing2.includePrivateMessages", Boolean.valueOf(true)));
            ((ChatFilterRule)object2).setBlockType(ChatFilterManager.getBlockType(configReader.get("ChatFilter.Deny.swearing2.BlockType", "none")));
            ((ChatFilterRule)object2).setMessageToStaff(configReader.get("ChatFilter.Deny.swearing2.msgToStaff", "&4!&6[playerName] &4swearing"));
            ((ChatFilterRule)object2).setCommands(configReader.get("ChatFilter.Deny.swearing2.Commands", Arrays.asList("msg [senderName] &eDon't swear!")));
            if (bl2 && bl) {
                this.rules.put(((ChatFilterRule)object2).getRuleName(), (ChatFilterRule)object2);
            }
        } else {
            object2 = configReader.getC().getConfigurationSection("ChatFilter.Deny").getKeys(false);
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = "ChatFilter.Deny." + string + ".";
                ChatFilterRule chatFilterRule = new ChatFilterRule();
                chatFilterRule.setRuleName(string);
                Boolean bl3 = configReader.get(string2 + "Enabled", Boolean.valueOf(false));
                chatFilterRule.setGroup(configReader.get(string2 + "Group", string));
                chatFilterRule.setInformConsole(configReader.get(string2 + "InformConsole", Boolean.valueOf(false)));
                chatFilterRule.setPattern(configReader.get(string2 + "Regex", Arrays.asList("")));
                chatFilterRule.setReplaceWith(configReader.get(string2 + "ReplaceWith", ""));
                chatFilterRule.setBlockType(ChatFilterManager.getBlockType(configReader.get(string2 + "BlockType", "none")));
                chatFilterRule.setApplyToPrivateMessages(configReader.get(string2 + "includePrivateMessages", Boolean.valueOf(true)));
                chatFilterRule.setMessageToStaff(configReader.get(string2 + "msgToStaff", ""));
                chatFilterRule.setCommands(configReader.get(string2 + "Commands", new ArrayList()));
                if (!bl3.booleanValue() || !bl) continue;
                this.rules.put(chatFilterRule.getRuleName(), chatFilterRule);
            }
        }
        if (configReader.getC().isConfigurationSection("ChatFilter.Deny") && (object2 = configReader.getC().getConfigurationSection("ChatFilter.Deny").getKeys(false)) != null && object2.iterator().hasNext()) {
            String string = (String)object2.iterator().next();
            object = "ChatFilter.Deny." + string + ".";
            configReader.addComment((String)object + "Enabled", new String[]{"If not set to true, this filter will not be used"});
            configReader.addComment((String)object + "InformConsole", new String[]{"When set to true, each time player triggers filter, console will receive information about who triggered it, which filter and with what message"});
            configReader.addComment((String)object + "Group", new String[]{"Defines filter group and defines required permission node to bypass this filter: cmi.chatfilter.bypass.[groupName]"});
            configReader.addComment((String)object + "Regex", new String[]{"Regex expression to filter by. How to use regex https://regexone.com/"});
            configReader.addComment((String)object + "ReplaceWith", new String[]{"With what we need to replace word, if not defined found expression will not be changed"});
            configReader.addComment((String)object + "BlockType", new String[]{"possible: none, others, all", "Where 'none' means everyone will receive this message", "'others' means that sender will get message but not other players, this is usefull to prevent advertising and silently block it", "'all' means that no one will receive sent message"});
            configReader.addComment((String)object + "includePrivateMessages", new String[]{"When enabled rule will be applied to private messages"});
            configReader.addComment((String)object + "msgToStaff", new String[]{"Players with cmi.chatfilter.inform permission will receive defined message when rule is broken"});
            configReader.addComment((String)object + "Commands", new String[]{"List of commands to perform when rule is broken. Use [senderName] to include message sender name. Supports global variables same as locale file", "Use [message] to include original players message", "Use [updatedmessage] to include new modified message"});
        }
        this.whiteRules = new ChatFilterRule();
        configReader.addComment("ChatFilter.WhiteList", new String[]{"List of regex filter to exlude from block list. Usefull if you want to block all ip/host address but want to allow usage of your own server."});
        this.whiteRules.setPattern(configReader.get("ChatFilter.WhiteList", Arrays.asList("\\bgoogle.\\s?([a-zA-Z]{2,4})\\b", "\\bspigotmc.\\s?([a-zA-Z]{2,4})\\b")));
        configReader.addComment("ChatFilter.DuplicatedMessagePrevention.Use", new String[]{"When set to true, plugin will prevent spaming of same or similar messages in short time range. Can be bypased with cmi.chatfilter.spambypass permission"});
        this.preventDoublicates = configReader.get("ChatFilter.DuplicatedMessagePrevention.Use", Boolean.valueOf(false));
        configReader.addComment("ChatFilter.DuplicatedMessagePrevention.Percentage", new String[]{"How much in percentage message is counted as same"});
        this.similarityPercentage = configReader.get("ChatFilter.DuplicatedMessagePrevention.Percentage", 80);
        if (this.similarityPercentage > 1.0) {
            this.similarityPercentage /= 100.0;
        }
        configReader.addComment("ChatFilter.DuplicatedMessagePrevention.Interval", new String[]{"Defines how often in seconds you can send same/similar message"});
        this.douplicateInterval = configReader.get("ChatFilter.DuplicatedMessagePrevention.Interval", 5);
        configReader.addComment("ChatFilter.DuplicatedMessagePrevention.MinAmount", new String[]{"How many commands you can repeat before stopped for cooldown"});
        this.douplicateChatMinAmount = configReader.get("ChatFilter.DuplicatedMessagePrevention.MinAmount", 2);
        configReader.addComment("ChatFilter.Caps.Filter", new String[]{"When nebaled we will try to prevent chat messages with multiple capitalized letters by defined criteria", "Can be bypassed with " + PermissionsManager.CMIPerm.chatfilter_capbypass.getPermissionForShow() + " permission node"});
        this.capsFilter = configReader.get("ChatFilter.Caps.Filter", Boolean.valueOf(true));
        configReader.addComment("ChatFilter.Caps.IgnoreUnder", new String[]{"Defines amount of letters we can ignore", "For example ':DDD' would be made of 2 letters with 3 capitalized letters which would make it 75% capitalized"});
        this.capsIgnoreUnder = configReader.get("ChatFilter.Caps.IgnoreUnder", 6);
        this.capsIgnoreUnder = this.capsIgnoreUnder < 0 ? 0 : this.capsIgnoreUnder;
        configReader.addComment("ChatFilter.Caps.Percentage", new String[]{"Amount in percentage of capitalized letters we should not cross over.", "In example 'GOOD thing' would be 4 capitalized and 5 not, spaces gets ignored, whic makes it 44% capitalized and passes check"});
        this.capsPercentage = configReader.get("ChatFilter.Caps.Percentage", 50);
        this.capsPercentage = this.capsPercentage < 0 ? 0 : this.capsPercentage;
        this.capsPercentage = this.capsPercentage > 100 ? 100 : this.capsPercentage;
        configReader.addComment("ChatFilter.Caps.Commands", new String[]{"List of commands you want to perform when player uses too many caps"});
        this.capsCommands = configReader.get("ChatFilter.Caps.Commands", Arrays.asList("asConsole! cmi titlemsg [playerName] &cToo many caps! -keep:20"));
        configReader.addComment("ChatFilter.Caps.WhiteList", new String[]{"List of messages, excluding color codes, player can use even if it 100% capitalized"});
        this.capsWhiteList = configReader.get("ChatFilter.Caps.WhiteList", Arrays.asList("AFAIK", "AFK", "BRB", "IMHO", "OMG", "ROFL", "ROFLMAO", "LQTM", "LSMH", "LMHO"));
        CMIList.toLowerCase(this.capsWhiteList);
        configReader.save();
    }

    public void loadCommandFilters() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Command.CommandFilter.Duplicate.Use", new String[]{"When set to true, plugin will prevent spaming of same or similar command in short time range. Can be bypased with cmi.commandfilter.bypass permission"});
        this.preventCommandDoublicates = configReader.get("Command.CommandFilter.Duplicate.Use", Boolean.valueOf(false));
        configReader.addComment("Command.CommandFilter.Duplicate.Percentage", new String[]{"How much in percentage command is counted as same"});
        this.similarityComamndPercentage = configReader.get("Command.CommandFilter.Duplicate.Percentage", 80);
        if (this.similarityComamndPercentage > 1.0) {
            this.similarityComamndPercentage /= 100.0;
        }
        configReader.addComment("Command.CommandFilter.Duplicate.Interval", new String[]{"Defines how often in seconds you can send same/similar commands"});
        this.douplicateCommandInterval = configReader.get("Command.CommandFilter.Duplicate.Interval", 5);
        configReader.addComment("Command.CommandFilter.Duplicate.MinAmount", new String[]{"How many commands you can repeat before stopped for cooldown"});
        this.douplicateCommandMinAmount = configReader.get("Command.CommandFilter.Duplicate.MinAmount", 2);
        configReader.addComment("Command.CommandFilter.Duplicate.WhiteList", new String[]{"Whitelisted commands to ignore"});
        this.douplicateCommandWhiteList = configReader.get("Command.CommandFilter.Duplicate.WhiteList", Arrays.asList("msg", "tell", "login", "register"));
    }
}

