/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.CmdCooldown;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.CommandAlias;
import com.Zrips.CMI.Containers.CommandAliasType;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.CmdCooldown.CMICmdCooldown;
import com.Zrips.CMI.Modules.CmdCooldown.CmdCooldown;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.SpecializedCommands.SpecCMDCooldown;
import com.Zrips.CMI.commands.CommandsHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CooldownManager {
    private HashMap<String, CMICmdCooldown> cooldowns = new HashMap();
    CMI plugin;
    HashMap<UUID, CmdCooldown> playerCustomCooldowns = new HashMap();
    CmdCooldown globalCooldowns = new CmdCooldown();

    public CooldownManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Cooldowns.Enabled", new String[]{"You can enable any command cooldown to prevent instant usage of it", "cmi heal:180 means that player can use /cmi heal command only once every 180 seconds", "if cooldown set to -1 then this command can be performed only one time", "Administration can bypass limitations with cmi.cooldownbypass.[commandname] permission node", "Always use full command name and not its alias", "----------", "Alternatively you can use " + PermissionsManager.CMIPerm.cooldown_$1_$2.getPermission("[some_Command]", "[timer]") + " permission node. For example: cmi.cooldown.cmi_heal.30 which will set 30 second cooldown on /cmi heal command", "If you want to apply cooldown on command when variable is provided, add extra _ at end. For example cmi.cooldown.cmi_heal_.30 which will only use this cooldown when healing some one else", "KEEP IN MIND that for permission to work you need to set base command cooldown in this list, otherwise permission node will have no effect", "-----", "ATTENTION! If you have command like \"/cmi home\" and you want to prevent teleportation to home but allow gui opening without restrictions, use space after command, in example \"cmi home :10\""});
        long l = System.currentTimeMillis();
        boolean bl = configReader.get("Cooldowns.Enabled", Boolean.valueOf(false));
        List list2 = configReader.get("Cooldowns.List", Arrays.asList("cmi heal:180", "cmi feed:120"));
        this.getCooldowns().clear();
        if (bl) {
            for (String string : list2) {
                if (!string.contains(":")) continue;
                int n = -2;
                try {
                    n = Integer.parseInt(string.split(":")[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (n < -1) continue;
                this.addCooldown(string.split(":")[0].toLowerCase(), n);
            }
        }
        this.plugin.loadMessage(this.plugin.getCooldownManager().getCooldownCount(), "cooldowns", System.currentTimeMillis() - l);
    }

    public int getCooldownCount() {
        return this.cooldowns.size();
    }

    @Deprecated
    public void addCD(String string, Long l) {
        this.addCooldown(new CMICmdCooldown(string, l.intValue()));
    }

    public void addCooldown(String string, int n) {
        this.addCooldown(new CMICmdCooldown(string, n));
    }

    public void addCooldown(CMICmdCooldown cMICmdCooldown) {
        this.cooldowns.put(cMICmdCooldown.getCommand().toLowerCase(), cMICmdCooldown);
    }

    private CMICmdCooldown getCooldown(String string) {
        Map.Entry<String, CMICmdCooldown> entry2;
        string = (string = string.toLowerCase()).startsWith(":") ? string.substring(1) : string;
        CommandAlias commandAlias = this.plugin.getAliasManager().getAliasForCommand(string);
        if (commandAlias != null && commandAlias.getType() != CommandAliasType.custom) {
            return null;
        }
        CMICmdCooldown cMICmdCooldown = null;
        for (Map.Entry<String, CMICmdCooldown> entry2 : this.cooldowns.entrySet()) {
            if (!string.equalsIgnoreCase(entry2.getKey())) continue;
            cMICmdCooldown = entry2.getValue();
            break;
        }
        if (cMICmdCooldown != null) {
            return cMICmdCooldown;
        }
        entry2 = null;
        for (Map.Entry<String, CMICmdCooldown> entry3 : this.cooldowns.entrySet()) {
            String string2;
            if (!string.startsWith((String)entry3.getKey()) || !(string2 = string.substring(((String)entry3.getKey()).length())).isEmpty() && !string2.startsWith(" ") && !((String)entry3.getKey()).endsWith(" ")) continue;
            entry2 = (CMICmdCooldown)entry3.getValue();
            break;
        }
        return entry2;
    }

    private static Long getUsedTime(String string, CmdCooldown cmdCooldown) {
        return CooldownManager.getUsedTime(string, cmdCooldown, false);
    }

    private static Long getUsedTime(String string, CmdCooldown cmdCooldown, boolean bl) {
        CmdCooldown.CMICooldown cMICooldown;
        String string2 = CooldownManager.getCommandMatch(string = string.toLowerCase(), cmdCooldown, bl);
        if (string2 != null && (cMICooldown = cmdCooldown.getList().get(string2)) != null) {
            return cMICooldown.getInitialized();
        }
        return null;
    }

    private static String getCommandMatch(String string, CmdCooldown cmdCooldown) {
        return CooldownManager.getCommandMatch(string, cmdCooldown, false);
    }

    private static String getCommandMatch(String string, CmdCooldown cmdCooldown, boolean bl) {
        string = string.toLowerCase();
        for (Map.Entry<String, CmdCooldown.CMICooldown> entry : cmdCooldown.getList().entrySet()) {
            if (!string.equals(entry.getKey())) continue;
            return entry.getKey();
        }
        if (bl) {
            return null;
        }
        for (Map.Entry<String, CmdCooldown.CMICooldown> entry : cmdCooldown.getList().entrySet()) {
            if (!string.startsWith(entry.getKey())) continue;
            return entry.getKey();
        }
        for (Map.Entry<String, CmdCooldown.CMICooldown> entry : cmdCooldown.getList().entrySet()) {
            String string2;
            if (!string.startsWith(entry.getKey()) || !(string2 = string.substring(entry.getKey().length())).isEmpty() && !string2.startsWith(" ") && !entry.getKey().endsWith(" ")) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean removeCooldown(CommandSender commandSender, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (commandSender == null || !(commandSender instanceof Player)) {
            return false;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)commandSender);
        if (cMIUser == null) {
            return false;
        }
        CMICmdCooldown cMICmdCooldown = this.getCooldown(string);
        if (cMICmdCooldown == null) {
            return true;
        }
        cMIUser.getCommandCooldowns().removeCooldown(cMICmdCooldown.getCommand());
        return true;
    }

    public boolean isCmdInCooldown(CommandSender commandSender, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!(commandSender instanceof Player)) {
            return false;
        }
        if (!CMIModule.cooldown.isEnabled()) {
            return false;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)commandSender);
        if (cMIUser == null) {
            return false;
        }
        CMICmdCooldown cMICmdCooldown = this.getCooldown(string);
        if (cMICmdCooldown == null) {
            return false;
        }
        CmdCooldown cmdCooldown = cMIUser.getCommandCooldowns();
        Long l = CooldownManager.getUsedTime(string, cmdCooldown, cMICmdCooldown.getCommand().equalsIgnoreCase(string));
        if (l != null) {
            long l2;
            PermissionInfo permissionInfo;
            if (cMICmdCooldown.getCooldownSeconds() == -1) {
                return true;
            }
            long l3 = cMICmdCooldown.getCooldownSeconds();
            if ((string = CooldownManager.getCommandMatch(string, cmdCooldown)) != null && (permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo((Player)commandSender, PermissionsManager.CMIPerm.cooldown_$1_$2.getPermission(string.replace(" ", "_"), ""))) != null && permissionInfo.getMinValue() != null) {
                l3 = (long)(permissionInfo.getMinValue() < (double)l3 ? permissionInfo.getMinValue() : (double)l3);
            }
            if ((l2 = System.currentTimeMillis() - (l + l3 * 1000L)) < 0L) {
                CMILC.info_Cooldowns.sendMessage(commandSender, "[cmd]", cMICmdCooldown.getSubCommand(), "[time]", CMITimeManager.to24hourShort((Long)(-l2 + 1000L)));
                return true;
            }
        }
        return false;
    }

    public boolean canUseCmd(CommandSender commandSender, String string) {
        if (!CMIModule.cooldown.isEnabled()) {
            return true;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.startsWith(CommandsHandler.getLabel() + " :") ? CommandsHandler.getLabel() + " " + string.substring((CommandsHandler.getLabel() + " :").length()) : string;
        String string2 = string = string.startsWith(CommandsHandler.getLabel() + ":" + CommandsHandler.getLabel()) ? CommandsHandler.getLabel() + string.substring(CommandsHandler.getLabel().length() * 2 + 1) : string;
        if (!(commandSender instanceof Player)) {
            return true;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)commandSender);
        if (cMIUser == null) {
            return true;
        }
        CMICmdCooldown cMICmdCooldown = this.getCooldown(string);
        if (cMICmdCooldown == null) {
            return true;
        }
        if (PermissionsManager.CMIPerm.cooldownbypass_$1.hasPermission(commandSender, cMICmdCooldown.getSubCommand().replace(" ", ""))) {
            return true;
        }
        CmdCooldown cmdCooldown = cMIUser.getCommandCooldowns();
        Long l = CooldownManager.getUsedTime(string, cmdCooldown, cMICmdCooldown.getCommand().equalsIgnoreCase(string));
        if (l != null) {
            long l2;
            PermissionInfo permissionInfo;
            if (cMICmdCooldown.getCooldownSeconds() == -1) {
                CMILC.info_CooldownOneTime.sendMessage(commandSender, new Object[0]);
                return false;
            }
            long l3 = cMICmdCooldown.getCooldownSeconds();
            if ((string = CooldownManager.getCommandMatch(string, cmdCooldown, cMICmdCooldown.getCommand().equalsIgnoreCase(string))) != null && (permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo((Player)commandSender, PermissionsManager.CMIPerm.cooldown_$1_$2.getPermission(string.replace(" ", "_"), ""), false)) != null && permissionInfo.getMinValue() != null) {
                l3 = (long)(permissionInfo.getMinValue() < (double)l3 ? permissionInfo.getMinValue() : (double)l3);
            }
            if ((l2 = System.currentTimeMillis() - (l + l3 * 1000L)) < 0L) {
                CMILC.info_Cooldowns.sendMessage(commandSender, "[cmd]", cMICmdCooldown.getSubCommand(), "[time]", CMITimeManager.to24hourShort((Long)(-l2 + 1000L)));
                return false;
            }
        }
        cMIUser.getCommandCooldowns().addCooldown(cMICmdCooldown.getCommand(), (Long)System.currentTimeMillis(), cMICmdCooldown.getCooldownSeconds());
        return true;
    }

    public boolean canUseSpecCommandGlobal(CommandSender commandSender, SpecCMDCooldown specCMDCooldown, boolean bl) {
        Long l = CooldownManager.getUsedTime(specCMDCooldown.getCmd(), this.globalCooldowns);
        if (l != null) {
            if (specCMDCooldown.getCooldown() == -1L) {
                if (bl) {
                    CMILC.info_CooldownOneTime.sendMessage(commandSender, new Object[0]);
                }
                return false;
            }
            long l2 = specCMDCooldown.untilNextUse(l);
            if (l2 > 0L) {
                if (bl) {
                    CMILC.info_specializedCooldowns.sendMessage(commandSender, "[cmd]", specCMDCooldown.getCmd(), "[time]", CMITimeManager.to24hourShort((Long)(l2 + 1000L)));
                }
                return false;
            }
        }
        this.globalCooldowns.addCooldown(specCMDCooldown.getCmd().toLowerCase(), (Long)System.currentTimeMillis(), specCMDCooldown.getCooldown());
        return true;
    }

    public boolean canUseSpecCommand(Player player, SpecCMDCooldown specCMDCooldown, boolean bl) {
        if (player == null) {
            return true;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return true;
        }
        CmdCooldown cmdCooldown = cMIUser.getCommandCooldowns();
        Long l = CooldownManager.getUsedTime(specCMDCooldown.getCmd(), cmdCooldown);
        if (l != null) {
            if (specCMDCooldown.getCooldown() == -1L) {
                CMILC.info_CooldownOneTime.sendMessage(player, new Object[0]);
                return false;
            }
            long l2 = specCMDCooldown.untilNextUse(l);
            if (l2 > 0L) {
                if (bl) {
                    CMILC.info_specializedCooldowns.sendMessage(player, "[cmd]", specCMDCooldown.getCmd(), "[time]", CMITimeManager.to24hourShort((Long)(l2 + 1000L)));
                }
                return false;
            }
        }
        cmdCooldown.addCooldown(specCMDCooldown.getCmd().toLowerCase(), (Long)System.currentTimeMillis(), specCMDCooldown.getCooldown());
        cMIUser.addForDelayedSave();
        return true;
    }

    public HashMap<String, CMICmdCooldown> getCooldowns() {
        return this.cooldowns;
    }
}

