/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DataBase;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.DataBase.DBConnection;
import com.Zrips.CMI.Modules.DataBase.DBConnectionPool;
import com.Zrips.CMI.Modules.DataBase.DBManager;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayDay;
import com.Zrips.CMI.Modules.PlayTimeRewards.PTROneTime;
import com.Zrips.CMI.Modules.PlayTimeRewards.PTRRepeat;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class DBDAO {
    private DBConnectionPool pool;
    private static String prefix;
    protected CMI plugin;
    private static DBManager.DataBaseType dbType;
    public static mysqltypes Format;
    private PreparedStatement updateBatch = null;
    private boolean updateBatchExecuted = true;
    private PreparedStatement insertBatch = null;
    private boolean insertBatchExecuted = true;
    private PreparedStatement inventoryUpdateBatch = null;
    private boolean inventoryUpdateBatchExecuted = true;
    private PreparedStatement inventoryInsertBatch = null;
    private boolean inventoryInsertBatchExecuted = true;
    private PreparedStatement playtimerewardUpdateBatch = null;
    private boolean playtimerewardUpdateBatchExecuted = true;
    private PreparedStatement playtimerewardInsertBatch = null;
    private boolean playtimerewardInsertBatchExecuted = true;
    private PreparedStatement playtimeUpdateBatch = null;
    private boolean playtimeUpdateBatchExecuted = true;
    private PreparedStatement playtimeInsertBatch = null;
    private boolean playtimeInsertBatchExecuted = true;
    private boolean autoCommit = true;
    private boolean locked = false;
    boolean ignoredFirst = false;

    static {
        dbType = DBManager.DataBaseType.SqLite;
        Format = mysqltypes.MySQL;
    }

    protected DBDAO(CMI cMI, String string, String string2, String string3, String string4, String string5) {
        this.plugin = cMI;
        prefix = string5;
        try {
            this.pool = new DBConnectionPool(string, string2, string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.pool.getConnection();
        }
        catch (Throwable throwable) {
            try {
                this.pool = new DBConnectionPool(string, string2.replace("utf8mb4_unicode_ci", "utf-8"), string3, string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            CMI.getInstance().consoleMessage(this.pool.getConnection().getMetaData().getDatabaseProductVersion() + " data base type detected");
            if (this.pool.getConnection().getMetaData().getDatabaseProductVersion().toLowerCase().contains("mariadb")) {
                Format = mysqltypes.MariaDB;
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public final synchronized void setUp() {
        String string;
        if (this.plugin.isFullyLoaded()) {
            return;
        }
        this.createDefaultTable(DBTables.UserTable);
        String string2 = this.getTableCharSet(DBTables.UserTable);
        if (string2 != null && !string2.contains("utf8")) {
            this.convertTableToUTF8(DBTables.UserTable);
        }
        if ((string = this.getTableRowFormat(DBTables.UserTable)) != null && !string.equalsIgnoreCase("dynamic")) {
            this.convertTableRowFormat(DBTables.UserTable);
        }
        this.checkDefaultUserCollumns();
        this.createDefaultTable(DBTables.InvTable);
        this.checkDefaultInvCollumns();
        this.createDefaultTable(DBTables.PlayTime);
        this.checkDefaultPlayTimeCollumns();
        this.createDefaultTable(DBTables.PlayTimeReward);
        this.checkDefaultPlayTimeRewardCollumns();
    }

    public abstract Statement prepareStatement(String var1);

    public abstract boolean createTable(String var1);

    public abstract boolean isTable(String var1);

    public abstract boolean isCollumn(String var1, String var2);

    public abstract boolean truncate(String var1);

    public abstract boolean addCollumn(String var1, String var2, String var3);

    public abstract boolean convertTableToUTF8(DBTables var1);

    public abstract String getTableCharSet(DBTables var1);

    public abstract String getTableRowFormat(DBTables var1);

    public abstract boolean convertTableRowFormat(DBTables var1);

    public String getPrefix() {
        return prefix;
    }

    public void updateUUID(int n, UUID uUID) {
        block6: {
            this.locked = true;
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("UPDATE `" + DBTables.UserTable.getTableName() + "` SET `" + UserTablesFields.player_uuid.getCollumn() + "` = ? WHERE `id` = ?;");
                    preparedStatement.setString(1, uUID.toString());
                    preparedStatement.setInt(2, n);
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    this.close(preparedStatement);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(preparedStatement);
        }
        this.locked = false;
    }

    public void updateUserName(int n, String string) {
        block6: {
            this.locked = true;
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("UPDATE `" + DBTables.UserTable.getTableName() + "` SET `" + UserTablesFields.username.getCollumn() + "` = ? WHERE `id` = ?;");
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    this.close(preparedStatement);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(preparedStatement);
        }
        this.locked = false;
    }

    public void executeSQL(String string) {
        DBConnection dBConnection = this.getConnection();
        Statement statement = null;
        try {
            statement = dBConnection.createStatement();
            statement.execute(string);
        }
        finally {
            this.close(statement);
        }
    }

    public boolean isConnected() {
        try {
            return this.pool.getConnection() != null && !this.pool.getConnection().isClosed();
        }
        catch (Error | Exception throwable) {
            return false;
        }
    }

    protected DBConnection getConnection() {
        try {
            return this.pool.getConnection();
        }
        catch (Error | Exception throwable) {
            this.plugin.consoleMessage("&cUnable to connect to the database: " + throwable.getMessage());
            return null;
        }
    }

    public synchronized void closeConnections() {
        this.pool.closeConnection();
    }

    public void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public boolean updatePlayer(CMIUser cMIUser) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return false;
        }
        if (dBConnection.isClosed()) {
            return false;
        }
        int n = cMIUser.getId();
        if (n != 0) {
            return this.updatePlayerRecord(cMIUser);
        }
        this.createNewPlayerRecord(cMIUser);
        return true;
    }

    private boolean createNewPlayerRecord(CMIUser cMIUser) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return false;
        }
        if (dBConnection.isClosed()) {
            return false;
        }
        try {
            if (this.insertBatch == null) {
                this.insertBatch = dBConnection.prepareStatement(DBTables.UserTable.getInsertQuery());
            }
            try {
                this.plugin.getPlayerManager().savePlayerToDB(cMIUser, this.insertBatch, false);
            }
            catch (Throwable throwable) {
                if (this.insertBatch != null) {
                    try {
                        this.insertBatch.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.insertBatch = null;
                throwable.printStackTrace();
                return false;
            }
        }
        catch (Throwable throwable) {
            if (this.insertBatch != null) {
                try {
                    this.insertBatch.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    return false;
                }
            }
            this.insertBatch = null;
            throwable.printStackTrace();
            return false;
        }
        if (this.insertBatch != null) {
            this.insertBatch.addBatch();
            this.insertBatchExecuted = false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updatePlayerRecord(CMIUser cMIUser) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return false;
        }
        if (dBConnection.isClosed()) {
            return false;
        }
        try {
            if (this.updateBatch == null) {
                this.updateBatch = dBConnection.prepareStatement(DBTables.UserTable.getUpdateQuery());
            }
            try {
                this.plugin.getPlayerManager().savePlayerToDB(cMIUser, this.updateBatch, true);
            }
            catch (Throwable throwable) {
                if (this.updateBatch != null) {
                    try {
                        this.updateBatch.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        return false;
                    }
                }
                this.updateBatch = null;
                throwable.printStackTrace();
                return false;
            }
            if (this.updateBatch == null) return true;
            this.updateBatch.addBatch();
            this.updateBatchExecuted = false;
            return true;
        }
        catch (Throwable throwable) {
            if (this.updateBatch != null) {
                try {
                    this.updateBatch.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    return false;
                }
            }
            this.updateBatch = null;
            throwable.printStackTrace();
            return false;
        }
    }

    public void updatePlayerPlayTime(CMIUser cMIUser) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return;
        }
        try {
            for (CMIPlayDay cMIPlayDay : new HashSet<CMIPlayDay>(cMIUser.getCMIPlayTime().getForSave())) {
                PlaytimeTablesFields playtimeTablesFields;
                int n;
                int n2;
                PlaytimeTablesFields[] playtimeTablesFieldsArray;
                int n3;
                int n4;
                int n5 = cMIPlayDay.getId();
                if (n5 == 0) {
                    if (this.playtimeInsertBatch == null) {
                        this.playtimeInsertBatch = dBConnection.prepareStatement(DBTables.PlayTime.getInsertQuery());
                    }
                    n4 = 1;
                    this.playtimeInsertBatch.setInt(n4, cMIUser.getId());
                    this.playtimeInsertBatch.setInt(++n4, cMIPlayDay.getDate());
                    ++n4;
                    n3 = 0;
                    playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                    n2 = playtimeTablesFieldsArray.length;
                    n = 0;
                    while (n < n2) {
                        playtimeTablesFields = playtimeTablesFieldsArray[n];
                        if (playtimeTablesFields.isTimeField()) {
                            this.playtimeInsertBatch.setLong(n4, cMIPlayDay.getHourPlaytime(n3));
                            ++n3;
                            ++n4;
                        }
                        ++n;
                    }
                    this.playtimeInsertBatch.addBatch();
                    this.playtimeInsertBatchExecuted = false;
                    continue;
                }
                if (this.playtimeUpdateBatch == null) {
                    this.playtimeUpdateBatch = dBConnection.prepareStatement(DBTables.PlayTime.getUpdateQuery());
                }
                n4 = 1;
                n3 = 0;
                playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                n2 = playtimeTablesFieldsArray.length;
                n = 0;
                while (n < n2) {
                    playtimeTablesFields = playtimeTablesFieldsArray[n];
                    if (playtimeTablesFields.isTimeField()) {
                        this.playtimeUpdateBatch.setLong(n4, cMIPlayDay.getHourPlaytime(n3));
                        ++n3;
                        ++n4;
                    }
                    ++n;
                }
                this.playtimeUpdateBatch.setInt(n4, n5);
                this.playtimeUpdateBatch.addBatch();
                this.playtimeUpdateBatchExecuted = false;
            }
            cMIUser.getCMIPlayTime().getForSave().clear();
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public void updatePlayerInventory(CMIUser cMIUser, String string) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return;
        }
        int n = cMIUser.getInvId();
        try {
            if (n == 0) {
                if (this.inventoryInsertBatch == null) {
                    this.inventoryInsertBatch = dBConnection.prepareStatement(DBTables.InvTable.getInsertQuery());
                }
                this.inventoryInsertBatch.setInt(1, cMIUser.getId());
                this.inventoryInsertBatch.setString(2, string);
                this.inventoryInsertBatch.addBatch();
                this.inventoryInsertBatchExecuted = false;
            } else {
                if (this.inventoryUpdateBatch == null) {
                    this.inventoryUpdateBatch = dBConnection.prepareStatement(DBTables.InvTable.getUpdateQuery());
                }
                this.inventoryUpdateBatch.setString(1, string);
                this.inventoryUpdateBatch.setInt(2, n);
                this.inventoryUpdateBatch.addBatch();
                this.inventoryUpdateBatchExecuted = false;
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public void updatePlayerPlayTimeRewards(CMIUser cMIUser) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return;
        }
        int n = cMIUser.getPlayTimeRewardId();
        try {
            if (n == 0) {
                if (this.playtimerewardInsertBatch == null) {
                    this.playtimerewardInsertBatch = dBConnection.prepareStatement(DBTables.PlayTimeReward.getInsertQuery());
                }
                this.playtimerewardInsertBatch.setInt(1, cMIUser.getId());
                this.playtimerewardInsertBatch.setString(2, cMIUser.getPTRRString());
                this.playtimerewardInsertBatch.setString(3, cMIUser.getPTROString());
                this.playtimerewardInsertBatch.addBatch();
                this.playtimerewardInsertBatchExecuted = false;
            } else {
                if (this.playtimerewardUpdateBatch == null) {
                    this.playtimerewardUpdateBatch = dBConnection.prepareStatement(DBTables.PlayTimeReward.getUpdateQuery());
                }
                this.playtimerewardUpdateBatch.setString(1, cMIUser.getPTRRString());
                this.playtimerewardUpdateBatch.setString(2, cMIUser.getPTROString());
                this.playtimerewardUpdateBatch.setInt(3, cMIUser.getPlayTimeRewardId());
                this.playtimerewardUpdateBatch.addBatch();
                this.playtimerewardUpdateBatchExecuted = false;
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public void setAutoCommit(boolean bl) {
        try {
            this.getConnection().setAutoCommit(bl);
            this.autoCommit = bl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean executeTempBatch() {
        if (this.locked) {
            return false;
        }
        this.setAutoCommit(false);
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return false;
        }
        try {
            if (!this.updateBatchExecuted) {
                this.updateBatch.executeBatch();
                this.updateBatch.close();
                this.updateBatch = null;
                this.updateBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            if (this.updateBatch != null) {
                try {
                    this.updateBatch.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.updateBatch = null;
            throwable.printStackTrace();
        }
        try {
            if (!this.insertBatchExecuted) {
                this.insertBatch.executeBatch();
                this.insertBatch.close();
                this.insertBatch = null;
                this.insertBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            if (this.ignoredFirst) {
                throwable.printStackTrace();
            }
            this.ignoredFirst = true;
            Format = mysqltypes.old;
            if (this.insertBatch != null) {
                try {
                    this.insertBatch.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.insertBatch = null;
            this.insertBatchExecuted = true;
        }
        try {
            if (!this.playtimeUpdateBatchExecuted) {
                this.playtimeUpdateBatch.executeBatch();
                this.playtimeUpdateBatch.close();
                this.playtimeUpdateBatch = null;
                this.playtimeUpdateBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (!this.playtimeInsertBatchExecuted) {
                this.playtimeInsertBatch.executeBatch();
                this.playtimeInsertBatch.close();
                this.playtimeInsertBatch = null;
                this.playtimeInsertBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (!this.inventoryUpdateBatchExecuted) {
                this.inventoryUpdateBatch.executeBatch();
                this.inventoryUpdateBatch.close();
                this.inventoryUpdateBatch = null;
                this.inventoryUpdateBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (!this.inventoryInsertBatchExecuted) {
                this.inventoryInsertBatch.executeBatch();
                this.inventoryInsertBatch.close();
                this.inventoryInsertBatch = null;
                this.inventoryInsertBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (!this.playtimerewardUpdateBatchExecuted) {
                this.playtimerewardUpdateBatch.executeBatch();
                this.playtimerewardUpdateBatch.close();
                this.playtimerewardUpdateBatch = null;
                this.playtimerewardUpdateBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (!this.playtimerewardInsertBatchExecuted) {
                this.playtimerewardInsertBatch.executeBatch();
                this.playtimerewardInsertBatch.close();
                this.playtimerewardInsertBatch = null;
                this.playtimerewardInsertBatchExecuted = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.setAutoCommit(false);
        if (this.locked) {
            return false;
        }
        try {
            if (!this.autoCommit) {
                dBConnection.commit();
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public void prepareTempBatch() {
        if (this.locked) {
            return;
        }
        this.setAutoCommit(false);
    }

    public int getInvId(int n) {
        int n2;
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return 0;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n2 = 0;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT `id` FROM `" + DBTables.InvTable.getTableName() + "` WHERE `player_id` = ? LIMIT 1;");
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n2 = resultSet.getInt("id");
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return n2;
    }

    private int getPlayTimeId(CMIPlayDay cMIPlayDay, CMIUser cMIUser) {
        int n;
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return 0;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n = 0;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT `id` FROM `" + DBTables.PlayTime.getTableName() + "` WHERE `player_id` = ? AND `date` = ? LIMIT 1;");
                    preparedStatement.setInt(1, cMIUser.getId());
                    preparedStatement.setInt(2, cMIPlayDay.getDate());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt("id");
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return n;
    }

    private int getPlayTimeRewardId(CMIUser cMIUser) {
        int n;
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return 0;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n = 0;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT `id` FROM `" + DBTables.PlayTimeReward.getTableName() + "` WHERE `player_id` = ? LIMIT 1;");
                    preparedStatement.setInt(1, cMIUser.getId());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt("id");
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return n;
    }

    private int getId(String string) {
        int n;
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return 0;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n = 0;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT `id` FROM `" + DBTables.UserTable.getTableName() + "` WHERE `player_uuid` = ? LIMIT 1;");
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt("id");
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return n;
    }

    public String getInv(CMIUser cMIUser) {
        String string;
        block7: {
            this.locked = true;
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                this.locked = false;
                return null;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.InvTable.getTableName() + "` WHERE `player_id` = ? LIMIT 1;");
                    preparedStatement.setInt(1, cMIUser.getId());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        cMIUser.setInvId(resultSet.getInt("id"));
                        string = resultSet.getString(InventoryTablesFields.inventories.getCollumn());
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        this.locked = false;
        return string;
    }

    public void loadUser(UUID uUID) {
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.UserTable.getTableName() + "` WHERE `" + UserTablesFields.player_uuid.getCollumn() + "` = ? LIMIT 1;");
                    preparedStatement.setString(1, uUID.toString());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        this.plugin.getPlayerManager().loadUserFromDb(resultSet);
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    public void loadUser(int n) {
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.UserTable.getTableName() + "` WHERE `id` = ? LIMIT 1;");
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        this.plugin.getPlayerManager().loadUserFromDb(resultSet);
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    public void loadAllUsers() {
        block7: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.UserTable.getTableName() + "`;");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        this.plugin.getPlayerManager().loadUserFromDb(resultSet);
                    }
                    this.plugin.getDbManager().clear();
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    public void loadPlayTimes() {
        block13: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    long l = System.currentTimeMillis();
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.PlayTime.getTableName() + "`;");
                    resultSet = preparedStatement.executeQuery();
                    int n = 0;
                    while (resultSet.next()) {
                        try {
                            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(resultSet.getInt("player_id"));
                            if (cMIUser == null) continue;
                            CMIPlayDay cMIPlayDay = cMIUser.getCMIPlayTime().getPlayDay(resultSet.getInt("date"));
                            cMIPlayDay.setId(resultSet.getInt("id"));
                            PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                            int n2 = playtimeTablesFieldsArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n3];
                                switch (playtimeTablesFields) {
                                    case player_id: 
                                    case date: {
                                        break;
                                    }
                                    default: {
                                        Object object = this.plugin.getPlayerManager().getValueFromDb(resultSet, playtimeTablesFields.getFieldType(), playtimeTablesFields.getCollumn());
                                        if (object == null) break;
                                        Long l2 = (Long)object;
                                        cMIPlayDay.setHourPlaytime(playtimeTablesFields.getHour(), l2, true);
                                    }
                                }
                                ++n3;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n;
                    }
                    this.plugin.loadMessage(n, "playtime records", System.currentTimeMillis() - l);
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    public LinkedHashSet<CMIUser> getLastLogOffList(int n, int n2) {
        LinkedHashSet<CMIUser> linkedHashSet;
        block9: {
            DBConnection dBConnection = this.getConnection();
            linkedHashSet = new LinkedHashSet<CMIUser>();
            if (dBConnection == null) {
                return linkedHashSet;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            n = n < 0 ? 0 : n;
            this.setAutoCommit(true);
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT " + UserTablesFields.player_uuid.getCollumn() + " FROM `" + DBTables.UserTable.getTableName() + "` WHERE `" + UserTablesFields.LastLogoffTime.getCollumn() + "` > ? AND `" + UserTablesFields.FakeAccount.getCollumn() + "` = ? ORDER BY `" + UserTablesFields.LastLogoffTime.getCollumn() + "` DESC LIMIT " + n + "," + n2 + ";");
                    preparedStatement.setInt(1, 0);
                    preparedStatement.setInt(2, 0);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(UUID.fromString(resultSet.getString(UserTablesFields.player_uuid.getCollumn())));
                            if (cMIUser == null) continue;
                            linkedHashSet.add(cMIUser);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return linkedHashSet;
    }

    public int getLogOffCount(long l) {
        int n;
        block7: {
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return 0;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            long l2 = System.currentTimeMillis() - l * 1000L;
            n = 0;
            this.setAutoCommit(true);
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT COUNT(*)  FROM `" + DBTables.UserTable.getTableName() + "` WHERE (`" + UserTablesFields.LastLogoffTime.getCollumn() + "` > ? OR `" + UserTablesFields.LastLoginTime.getCollumn() + "` > ?) AND `" + UserTablesFields.FakeAccount.getCollumn() + "` = ?;");
                    preparedStatement.setLong(1, l2);
                    preparedStatement.setLong(2, l2);
                    preparedStatement.setInt(3, 0);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        n += resultSet.getInt(1);
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
        return n;
    }

    public void loadPlayTimes(CMIUser cMIUser) {
        block13: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.PlayTime.getTableName() + "`  WHERE `player_id` = ?;");
                    preparedStatement.setInt(1, cMIUser.getId());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            CMIPlayDay cMIPlayDay = cMIUser.getCMIPlayTime().getPlayDay(resultSet.getInt("date"));
                            cMIPlayDay.setId(resultSet.getInt("id"));
                            PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                            int n = playtimeTablesFieldsArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n2];
                                switch (playtimeTablesFields) {
                                    case player_id: 
                                    case date: {
                                        break;
                                    }
                                    default: {
                                        Object object = this.plugin.getPlayerManager().getValueFromDb(resultSet, playtimeTablesFields.getFieldType(), playtimeTablesFields.getCollumn());
                                        if (object == null) break;
                                        Long l = (Long)object;
                                        cMIPlayDay.setHourPlaytime(playtimeTablesFields.getHour(), l, true);
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    public void loadPlayerPlayTimeRewards() {
        block17: {
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                return;
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    long l = System.currentTimeMillis();
                    preparedStatement = dBConnection.prepareStatement("SELECT * FROM `" + DBTables.PlayTimeReward.getTableName() + "`;");
                    resultSet = preparedStatement.executeQuery();
                    int n = 0;
                    while (resultSet.next()) {
                        try {
                            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(resultSet.getInt(PlaytimeRewardTablesFields.player_id.name()));
                            if (cMIUser == null) continue;
                            cMIUser.setPlayTimeRewardId(resultSet.getInt("id"));
                            PlaytimeRewardTablesFields[] playtimeRewardTablesFieldsArray = PlaytimeRewardTablesFields.values();
                            int n2 = playtimeRewardTablesFieldsArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                PlaytimeRewardTablesFields playtimeRewardTablesFields = playtimeRewardTablesFieldsArray[n3];
                                switch (playtimeRewardTablesFields) {
                                    case player_id: {
                                        break;
                                    }
                                    case onetime: {
                                        Object object = this.plugin.getPlayerManager().getValueFromDb(resultSet, playtimeRewardTablesFields.getFieldType(), playtimeRewardTablesFields.getCollumn());
                                        if (object == null) break;
                                        List list2 = (List)object;
                                        for (Object object2 : list2) {
                                            PTROneTime pTROneTime = this.plugin.getPlayTimeRewardManager().getOneTimeRewardByName((String)object2);
                                            if (pTROneTime == null) continue;
                                            cMIUser.addOneTimeReward((String)object2);
                                        }
                                        break;
                                    }
                                    case repeatable: {
                                        Object object2;
                                        Object object = this.plugin.getPlayerManager().getValueFromDb(resultSet, playtimeRewardTablesFields.getFieldType(), playtimeRewardTablesFields.getCollumn());
                                        if (object == null) break;
                                        object2 = (HashMap)object;
                                        for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                                            PTRRepeat pTRRepeat = this.plugin.getPlayTimeRewardManager().getRepeatingRewardByName((String)entry.getKey());
                                            if (pTRRepeat == null) continue;
                                            cMIUser.addRepeatableReward((String)entry.getKey(), (Long)entry.getValue());
                                        }
                                        break;
                                    }
                                }
                                ++n3;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n;
                    }
                    this.plugin.loadMessage(n, "playtime reward records", System.currentTimeMillis() - l);
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    this.close(resultSet);
                    this.close(preparedStatement);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                throw throwable;
            }
            this.close(resultSet);
            this.close(preparedStatement);
        }
    }

    /*
     * Exception decompiling
     */
    public void getUserIds(HashMap<String, CMIUser> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getUserPlayTimeIds(HashMap<CMIPlayDay, CMIUser> hashMap) {
        if (this.locked) {
            return;
        }
        this.setAutoCommit(true);
        for (Map.Entry<CMIPlayDay, CMIUser> entry : new HashMap<CMIPlayDay, CMIUser>(hashMap).entrySet()) {
            entry.getKey().setId(this.plugin.getDbManager().getDB().getPlayTimeId(entry.getKey(), entry.getValue()));
        }
    }

    /*
     * Exception decompiling
     */
    public void getUserInvIds(HashMap<Integer, CMIUser> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void getUserPlayTimeRewardIds(HashMap<Integer, CMIUser> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean removeUser(int n) {
        boolean bl;
        block6: {
            this.locked = true;
            this.setAutoCommit(true);
            DBConnection dBConnection = this.getConnection();
            if (dBConnection == null) {
                this.locked = false;
                return false;
            }
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            PreparedStatement preparedStatement3 = null;
            PreparedStatement preparedStatement4 = null;
            bl = false;
            try {
                try {
                    preparedStatement = dBConnection.prepareStatement("DELETE FROM `" + DBTables.UserTable.getTableName() + "` WHERE `id` = ?;");
                    preparedStatement.setInt(1, n);
                    bl = preparedStatement.execute();
                    this.close(preparedStatement);
                    preparedStatement2 = dBConnection.prepareStatement("DELETE FROM `" + DBTables.InvTable.getTableName() + "` WHERE `player_id` = ?;");
                    preparedStatement2.setInt(1, n);
                    preparedStatement2.execute();
                    this.close(preparedStatement2);
                    preparedStatement3 = dBConnection.prepareStatement("DELETE FROM `" + DBTables.PlayTime.getTableName() + "` WHERE `player_id` = ?;");
                    preparedStatement3.setInt(1, n);
                    preparedStatement3.execute();
                    this.close(preparedStatement3);
                    preparedStatement4 = dBConnection.prepareStatement("DELETE FROM `" + DBTables.PlayTimeReward.getTableName() + "` WHERE `player_id` = ?;");
                    preparedStatement4.setInt(1, n);
                    preparedStatement4.execute();
                    this.close(preparedStatement4);
                    bl = true;
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    bl = false;
                    this.close(preparedStatement);
                    this.close(preparedStatement2);
                    this.close(preparedStatement3);
                    this.close(preparedStatement4);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(preparedStatement2);
                this.close(preparedStatement3);
                this.close(preparedStatement4);
                throw throwable;
            }
            this.close(preparedStatement);
            this.close(preparedStatement2);
            this.close(preparedStatement3);
            this.close(preparedStatement4);
        }
        this.locked = false;
        return bl;
    }

    private boolean createDefaultTable(DBTables dBTables) {
        if (this.isTable(dBTables.getTableName())) {
            return true;
        }
        try {
            CMI.getInstance().consoleMessage(dBTables.toString() + " creating " + dBTables.getQuery());
            this.createTable(dBTables.getQuery());
            return true;
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private boolean checkDefaultUserCollumns() {
        UserTablesFields[] userTablesFieldsArray = UserTablesFields.values();
        int n = userTablesFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserTablesFields userTablesFields = userTablesFieldsArray[n2];
            if (!this.isCollumn(DBTables.UserTable.getTableName(), userTablesFields.getCollumn())) {
                this.addCollumn(DBTables.UserTable.getTableName(), userTablesFields.getCollumn(), userTablesFields.getType());
            }
            ++n2;
        }
        return true;
    }

    private boolean checkDefaultInvCollumns() {
        InventoryTablesFields[] inventoryTablesFieldsArray = InventoryTablesFields.values();
        int n = inventoryTablesFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            InventoryTablesFields inventoryTablesFields = inventoryTablesFieldsArray[n2];
            if (!this.isCollumn(DBTables.InvTable.getTableName(), inventoryTablesFields.getCollumn())) {
                this.addCollumn(DBTables.InvTable.getTableName(), inventoryTablesFields.getCollumn(), inventoryTablesFields.getType());
            }
            ++n2;
        }
        return true;
    }

    private boolean checkDefaultPlayTimeCollumns() {
        PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
        int n = playtimeTablesFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n2];
            if (!this.isCollumn(DBTables.PlayTime.getTableName(), playtimeTablesFields.getCollumn())) {
                this.addCollumn(DBTables.PlayTime.getTableName(), playtimeTablesFields.getCollumn(), playtimeTablesFields.getType());
            }
            ++n2;
        }
        return true;
    }

    private boolean checkDefaultPlayTimeRewardCollumns() {
        PlaytimeRewardTablesFields[] playtimeRewardTablesFieldsArray = PlaytimeRewardTablesFields.values();
        int n = playtimeRewardTablesFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlaytimeRewardTablesFields playtimeRewardTablesFields = playtimeRewardTablesFieldsArray[n2];
            if (!this.isCollumn(DBTables.PlayTimeReward.getTableName(), playtimeRewardTablesFields.getCollumn())) {
                this.addCollumn(DBTables.PlayTimeReward.getTableName(), playtimeRewardTablesFields.getCollumn(), playtimeRewardTablesFields.getType());
            }
            ++n2;
        }
        return true;
    }

    public DBManager.DataBaseType getDbType() {
        return dbType;
    }

    public void setDbType(DBManager.DataBaseType dataBaseType) {
        dbType = dataBaseType;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static enum DBTables {
        UserTable("users", "CREATE TABLE `[tableName]` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY[fields]);", "CREATE TABLE `[tableName]` (`id` INTEGER PRIMARY KEY AUTOINCREMENT[fields]);"),
        InvTable("inventories", "CREATE TABLE `[tableName]` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY[fields]);", "CREATE TABLE `[tableName]` (`id` INTEGER PRIMARY KEY AUTOINCREMENT[fields]);"),
        PlayTime("playtime", "CREATE TABLE `[tableName]` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY[fields]);", "CREATE TABLE `[tableName]` (`id` INTEGER PRIMARY KEY AUTOINCREMENT[fields]);"),
        PlayTimeReward("playtimereward", "CREATE TABLE `[tableName]` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY[fields]);", "CREATE TABLE `[tableName]` (`id` INTEGER PRIMARY KEY AUTOINCREMENT[fields]);");

        private String mySQL;
        private String sQlite;
        private String tableName;

        private DBTables(String string2, String string3, String string4) {
            this.tableName = string2;
            this.mySQL = string3;
            this.sQlite = string4;
        }

        private String getQR() {
            switch (dbType) {
                case MySQL: {
                    return this.mySQL.replace("[tableName]", prefix + this.tableName);
                }
                case SqLite: {
                    return this.sQlite.replace("[tableName]", this.tableName);
                }
            }
            return "";
        }

        public String getQuery() {
            Object object = "";
            switch (this) {
                case InvTable: {
                    InventoryTablesFields[] inventoryTablesFieldsArray = InventoryTablesFields.values();
                    int n = inventoryTablesFieldsArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InventoryTablesFields inventoryTablesFields = inventoryTablesFieldsArray[n2];
                        object = (String)object + ", `" + inventoryTablesFields.getCollumn() + "` " + inventoryTablesFields.getType();
                        ++n2;
                    }
                    break;
                }
                case UserTable: {
                    UserTablesFields[] userTablesFieldsArray = UserTablesFields.values();
                    int n = userTablesFieldsArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        UserTablesFields userTablesFields = userTablesFieldsArray[n3];
                        object = (String)object + ", `" + userTablesFields.getCollumn() + "` " + userTablesFields.getType();
                        ++n3;
                    }
                    break;
                }
                case PlayTime: {
                    PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                    int n = playtimeTablesFieldsArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n4];
                        object = (String)object + ", `" + playtimeTablesFields.getCollumn() + "` " + playtimeTablesFields.getType();
                        ++n4;
                    }
                    break;
                }
                case PlayTimeReward: {
                    PlaytimeRewardTablesFields[] playtimeRewardTablesFieldsArray = PlaytimeRewardTablesFields.values();
                    int n = playtimeRewardTablesFieldsArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        PlaytimeRewardTablesFields playtimeRewardTablesFields = playtimeRewardTablesFieldsArray[n5];
                        object = (String)object + ", `" + playtimeRewardTablesFields.getCollumn() + "` " + playtimeRewardTablesFields.getType();
                        ++n5;
                    }
                    break;
                }
            }
            return this.getQR().replace("[fields]", (CharSequence)object);
        }

        public String getUpdateQuery() {
            switch (this) {
                case InvTable: {
                    Object object = "";
                    InventoryTablesFields[] inventoryTablesFieldsArray = InventoryTablesFields.values();
                    int n = inventoryTablesFieldsArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InventoryTablesFields inventoryTablesFields = inventoryTablesFieldsArray[n2];
                        if (inventoryTablesFields != InventoryTablesFields.player_id) {
                            if (!((String)object).isEmpty()) {
                                object = (String)object + ", ";
                            }
                            object = (String)object + "`" + inventoryTablesFields.getCollumn() + "` = ?";
                        }
                        ++n2;
                    }
                    object = "UPDATE `" + this.getTableName() + "` SET " + (String)object + " WHERE `id` = ?;";
                    return object;
                }
                case UserTable: {
                    Object object = "";
                    UserTablesFields[] userTablesFieldsArray = UserTablesFields.values();
                    int n = userTablesFieldsArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        UserTablesFields userTablesFields = userTablesFieldsArray[n3];
                        if (userTablesFields != UserTablesFields.player_uuid) {
                            if (!((String)object).isEmpty()) {
                                object = (String)object + ", ";
                            }
                            object = (String)object + "`" + userTablesFields.getCollumn() + "` = ?";
                        }
                        ++n3;
                    }
                    object = "UPDATE `" + this.getTableName() + "` SET " + (String)object + " WHERE `id` = ?;";
                    return object;
                }
                case PlayTime: {
                    Object object = "";
                    PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                    int n = playtimeTablesFieldsArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n4];
                        if (playtimeTablesFields.isTimeField()) {
                            if (!((String)object).isEmpty()) {
                                object = (String)object + ", ";
                            }
                            object = (String)object + "`" + playtimeTablesFields.getCollumn() + "` = ?";
                        }
                        ++n4;
                    }
                    object = "UPDATE `" + this.getTableName() + "` SET " + (String)object + " WHERE `id` = ?;";
                    return object;
                }
                case PlayTimeReward: {
                    Object object = "";
                    PlaytimeRewardTablesFields[] playtimeRewardTablesFieldsArray = PlaytimeRewardTablesFields.values();
                    int n = playtimeRewardTablesFieldsArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        PlaytimeRewardTablesFields playtimeRewardTablesFields = playtimeRewardTablesFieldsArray[n5];
                        if (playtimeRewardTablesFields != PlaytimeRewardTablesFields.player_id) {
                            if (!((String)object).isEmpty()) {
                                object = (String)object + ", ";
                            }
                            object = (String)object + "`" + playtimeRewardTablesFields.getCollumn() + "` = ?";
                        }
                        ++n5;
                    }
                    object = "UPDATE `" + this.getTableName() + "` SET " + (String)object + " WHERE `id` = ?;";
                    return object;
                }
            }
            return "";
        }

        public String getInsertQuery() {
            Object object = "";
            Object object2 = "";
            switch (this) {
                case UserTable: {
                    UserTablesFields[] userTablesFieldsArray = UserTablesFields.values();
                    int n = userTablesFieldsArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UserTablesFields userTablesFields = userTablesFieldsArray[n2];
                        if (!((String)object).isEmpty()) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "`" + userTablesFields.getCollumn() + "`";
                        if (!((String)object2).isEmpty()) {
                            object2 = (String)object2 + ", ";
                        }
                        object2 = (String)object2 + "?";
                        ++n2;
                    }
                    break;
                }
                case InvTable: {
                    InventoryTablesFields[] inventoryTablesFieldsArray = InventoryTablesFields.values();
                    int n = inventoryTablesFieldsArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        InventoryTablesFields inventoryTablesFields = inventoryTablesFieldsArray[n3];
                        if (!((String)object).isEmpty()) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "`" + inventoryTablesFields.getCollumn() + "`";
                        if (!((String)object2).isEmpty()) {
                            object2 = (String)object2 + ", ";
                        }
                        object2 = (String)object2 + "?";
                        ++n3;
                    }
                    break;
                }
                case PlayTime: {
                    PlaytimeTablesFields[] playtimeTablesFieldsArray = PlaytimeTablesFields.values();
                    int n = playtimeTablesFieldsArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        PlaytimeTablesFields playtimeTablesFields = playtimeTablesFieldsArray[n4];
                        if (!((String)object).isEmpty()) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "`" + playtimeTablesFields.getCollumn() + "`";
                        if (!((String)object2).isEmpty()) {
                            object2 = (String)object2 + ", ";
                        }
                        object2 = (String)object2 + "?";
                        ++n4;
                    }
                    break;
                }
                case PlayTimeReward: {
                    PlaytimeRewardTablesFields[] playtimeRewardTablesFieldsArray = PlaytimeRewardTablesFields.values();
                    int n = playtimeRewardTablesFieldsArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        PlaytimeRewardTablesFields playtimeRewardTablesFields = playtimeRewardTablesFieldsArray[n5];
                        if (!((String)object).isEmpty()) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "`" + playtimeRewardTablesFields.getCollumn() + "`";
                        if (!((String)object2).isEmpty()) {
                            object2 = (String)object2 + ", ";
                        }
                        object2 = (String)object2 + "?";
                        ++n5;
                    }
                    break;
                }
            }
            switch (this) {
                case UserTable: {
                    if (dbType.equals((Object)DBManager.DataBaseType.SqLite)) {
                        object = "INSERT INTO `" + this.getTableName() + "` (" + (String)object + ") SELECT " + (String)object2 + " WHERE NOT EXISTS (SELECT 1 FROM `" + this.getTableName() + "` WHERE " + UserTablesFields.player_uuid.getCollumn() + " = ?);";
                        break;
                    }
                    switch (Format) {
                        case MariaDB: {
                            object = "INSERT INTO `" + this.getTableName() + "` (" + (String)object + ") SELECT " + (String)object2 + " FROM dual WHERE NOT EXISTS (SELECT " + UserTablesFields.player_uuid.getCollumn() + " FROM " + this.getTableName() + " WHERE " + UserTablesFields.player_uuid.getCollumn() + " = ?) LIMIT 1;";
                            break;
                        }
                        case MySQL: {
                            object = "INSERT INTO `" + this.getTableName() + "` (" + (String)object + ") SELECT " + (String)object2 + " WHERE NOT EXISTS (SELECT " + UserTablesFields.player_uuid.getCollumn() + " FROM " + this.getTableName() + " WHERE " + UserTablesFields.player_uuid.getCollumn() + " = ?) LIMIT 1;";
                            break;
                        }
                        case old: {
                            object = "INSERT INTO `" + this.getTableName() + "` (" + (String)object + ") VALUES (" + (String)object2 + ");";
                        }
                    }
                    break;
                }
                default: {
                    object = "INSERT INTO `" + this.getTableName() + "` (" + (String)object + ") VALUES (" + (String)object2 + ");";
                }
            }
            return object;
        }

        public String getTableName() {
            return prefix + this.tableName;
        }
    }

    public static enum InventoryTablesFields {
        player_id("player_id", "int", TablesFieldsType.number),
        inventories("inventories", "longtext", TablesFieldsType.longtext);

        private String column;
        private String type;
        private TablesFieldsType fieldType;

        private InventoryTablesFields(String string2, String string3, TablesFieldsType tablesFieldsType) {
            this.column = string2;
            this.type = string3;
            this.fieldType = tablesFieldsType;
        }

        public String getCollumn() {
            return this.column;
        }

        public String getType() {
            return this.type;
        }

        public TablesFieldsType getFieldType() {
            return this.fieldType;
        }
    }

    public static enum PlaytimeRewardTablesFields {
        player_id(TablesFieldsType.number),
        repeatable(TablesFieldsType.stringLongMap),
        onetime(TablesFieldsType.stringList);

        private TablesFieldsType fieldType;

        private PlaytimeRewardTablesFields(TablesFieldsType tablesFieldsType) {
            this.fieldType = tablesFieldsType;
        }

        public String getCollumn() {
            return this.name();
        }

        public String getType() {
            return this.fieldType.getType();
        }

        public TablesFieldsType getFieldType() {
            return this.fieldType;
        }
    }

    public static enum PlaytimeTablesFields {
        player_id(TablesFieldsType.number),
        date(TablesFieldsType.number),
        h0(0, TablesFieldsType.longNumber),
        h1(1, TablesFieldsType.longNumber),
        h2(2, TablesFieldsType.longNumber),
        h3(3, TablesFieldsType.longNumber),
        h4(4, TablesFieldsType.longNumber),
        h5(5, TablesFieldsType.longNumber),
        h6(6, TablesFieldsType.longNumber),
        h7(7, TablesFieldsType.longNumber),
        h8(8, TablesFieldsType.longNumber),
        h9(9, TablesFieldsType.longNumber),
        h10(10, TablesFieldsType.longNumber),
        h11(11, TablesFieldsType.longNumber),
        h12(12, TablesFieldsType.longNumber),
        h13(13, TablesFieldsType.longNumber),
        h14(14, TablesFieldsType.longNumber),
        h15(15, TablesFieldsType.longNumber),
        h16(16, TablesFieldsType.longNumber),
        h17(17, TablesFieldsType.longNumber),
        h18(18, TablesFieldsType.longNumber),
        h19(19, TablesFieldsType.longNumber),
        h20(20, TablesFieldsType.longNumber),
        h21(21, TablesFieldsType.longNumber),
        h22(22, TablesFieldsType.longNumber),
        h23(23, TablesFieldsType.longNumber);

        private TablesFieldsType fieldType;
        private int hour = 0;

        private PlaytimeTablesFields(TablesFieldsType tablesFieldsType) {
            this.fieldType = tablesFieldsType;
        }

        private PlaytimeTablesFields(int n2, TablesFieldsType tablesFieldsType) {
            this.fieldType = tablesFieldsType;
            this.hour = n2;
        }

        public String getCollumn() {
            return this.name();
        }

        public String getType() {
            return this.fieldType.getType();
        }

        public TablesFieldsType getFieldType() {
            return this.fieldType;
        }

        public boolean isTimeField() {
            return this.name().startsWith("h") && this.name().length() < 4;
        }

        public int getHour() {
            return this.hour;
        }
    }

    public static enum TablesFieldsType {
        decimal("double"),
        number("int"),
        longtext("longtext"),
        text("text"),
        stringList("longtext"),
        stringLongMap("text"),
        stringIntMap("text"),
        stringDoubleMap("text"),
        stringStringMap("text"),
        locationMap("text"),
        state("boolean"),
        location("text"),
        longNumber("bigint");

        private String type;

        private TablesFieldsType(String string2) {
            this.type = string2;
        }

        public static TablesFieldsType getByname(String string) {
            TablesFieldsType[] tablesFieldsTypeArray = TablesFieldsType.values();
            int n = tablesFieldsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TablesFieldsType tablesFieldsType = tablesFieldsTypeArray[n2];
                if (tablesFieldsType.name().equalsIgnoreCase(string)) {
                    return tablesFieldsType;
                }
                ++n2;
            }
            return null;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum UserTablesFields {
        player_uuid("text", TablesFieldsType.text),
        username("text", TablesFieldsType.text),
        nickname("text", TablesFieldsType.text),
        LogOutLocation("text", TablesFieldsType.location),
        DeathLocation("text", TablesFieldsType.location),
        TeleportLocation("text", TablesFieldsType.location),
        Homes("text", TablesFieldsType.locationMap),
        LastLoginTime("bigint", TablesFieldsType.longNumber),
        LastLogoffTime("bigint", TablesFieldsType.longNumber),
        TotalPlayTime("bigint", TablesFieldsType.longNumber),
        tFly("bigint", TablesFieldsType.longNumber),
        tGod("bigint", TablesFieldsType.longNumber),
        Glow("text", TablesFieldsType.text),
        Ips("text", TablesFieldsType.stringIntMap),
        Cuffed("boolean", TablesFieldsType.state),
        AlertUntil("bigint", TablesFieldsType.longNumber),
        AlertReason("text", TablesFieldsType.text),
        JoinedCounter("boolean", TablesFieldsType.state),
        LockedIps("text", TablesFieldsType.stringList),
        pTime("bigint", TablesFieldsType.longNumber),
        Kits("text", TablesFieldsType.stringLongMap),
        Charges("text", TablesFieldsType.text),
        Cooldowns("mediumtext", TablesFieldsType.text),
        Balance("double", TablesFieldsType.decimal),
        Notes("text", TablesFieldsType.stringList),
        Rank("text", TablesFieldsType.text),
        BannedUntil("bigint", TablesFieldsType.longNumber),
        BannedAt("bigint", TablesFieldsType.longNumber),
        BannedBy("text", TablesFieldsType.text),
        BanReason("text", TablesFieldsType.text),
        Ignores("text", TablesFieldsType.text),
        Vanish("text", TablesFieldsType.text),
        Economy("text", TablesFieldsType.stringDoubleMap),
        Mail("mediumtext", TablesFieldsType.stringList),
        FlightCharge("double", TablesFieldsType.decimal),
        UserMeta("text", TablesFieldsType.stringStringMap),
        Flying("boolean", TablesFieldsType.state),
        Votifier("int", TablesFieldsType.number),
        Jail("text", TablesFieldsType.text),
        JailedUntil("bigint", TablesFieldsType.longNumber),
        FakeAccount("boolean", TablesFieldsType.state),
        PlaytimeOptimized("bigint", TablesFieldsType.longNumber),
        flightChargeEnabled("boolean", TablesFieldsType.state),
        JailReason("text", TablesFieldsType.text),
        Skin("text", TablesFieldsType.text),
        Collision("boolean", TablesFieldsType.state),
        NamePrefix("text", TablesFieldsType.text),
        NameSuffix("text", TablesFieldsType.text),
        Warnings("text", TablesFieldsType.stringLongMap),
        NameColor("text", TablesFieldsType.text),
        Muted("text", TablesFieldsType.text),
        AFRecharge("text", TablesFieldsType.text),
        DisplayName("text", TablesFieldsType.text),
        Options("text", TablesFieldsType.text),
        ChatColor("text", TablesFieldsType.text);

        private String type;
        private TablesFieldsType fieldType;

        private UserTablesFields(String string2, TablesFieldsType tablesFieldsType) {
            this.type = string2;
            this.fieldType = tablesFieldsType;
        }

        @Deprecated
        public String getCollumn() {
            return this.name();
        }

        public String getColumn() {
            return this.name();
        }

        public String getType() {
            return this.type;
        }

        public TablesFieldsType getFieldType() {
            return this.fieldType;
        }
    }

    public static enum mysqltypes {
        old,
        MySQL,
        MariaDB;

    }
}

