/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Elytra;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Elytra.ElytraBoostListener;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.launch;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;

public class ElytraLaunchListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, CMILaunch> map = new HashMap();

    public ElytraLaunchListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler
    public void onSneakEnd(PlayerToggleSneakEvent playerToggleSneakEvent) {
        CMILaunch cMILaunch;
        if (!playerToggleSneakEvent.isSneaking() && (cMILaunch = this.map.remove(playerToggleSneakEvent.getPlayer().getUniqueId())) != null && cMILaunch.isFullyCharged() && System.currentTimeMillis() - cMILaunch.getLastCharge() < 200L) {
            if (!PermissionsManager.CMIPerm.elytralaunch.hasPermission((CommandSender)playerToggleSneakEvent.getPlayer(), true, new String[0])) {
                return;
            }
            CMI.getInstance().getCommandManager().performCMICommand((CommandSender)Bukkit.getConsoleSender(), (Class<?>)launch.class, playerToggleSneakEvent.getPlayer().getName() + " a:90 p:1.5");
            Location location = playerToggleSneakEvent.getPlayer().getLocation().clone();
            location.setPitch(90.0f);
            location.add(0.0, 0.2, 0.0);
            ElytraBoostListener.spawnCircle(location);
        }
    }

    @EventHandler
    public void onMoveRemove(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        if (this.map.isEmpty()) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlockX() != playerMoveEvent.getTo().getBlockX() || playerMoveEvent.getFrom().getBlockY() != playerMoveEvent.getTo().getBlockY() || playerMoveEvent.getFrom().getBlockZ() != playerMoveEvent.getTo().getBlockZ()) {
            this.map.remove(playerMoveEvent.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onElytraLaunch(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (!player.isOnGround()) {
            return;
        }
        if (!this.plugin.getElytraManager().getLaunchItem().isAir() && playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack == null) {
            return;
        }
        if (!this.plugin.getElytraManager().getLaunchItem().isAir() && this.plugin.getElytraManager().getLaunchItem() != CMIMaterial.get((ItemStack)itemStack)) {
            return;
        }
        if (!PermissionsManager.CMIPerm.elytralaunch.hasPermission((CommandSender)playerInteractEvent.getPlayer())) {
            return;
        }
        CMILaunch cMILaunch = this.map.get(player.getUniqueId());
        if (cMILaunch == null) {
            cMILaunch = new CMILaunch();
        } else if (System.currentTimeMillis() - cMILaunch.getLastCharge() > 333L) {
            this.map.remove(playerInteractEvent.getPlayer().getUniqueId());
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerInteractEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        ItemStack itemStack2 = cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.ChestPlate);
        if (itemStack2 == null) {
            return;
        }
        try {
            if (itemStack2.getType() != Material.ELYTRA) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        cMILaunch.setLastCharge();
        this.map.put(player.getUniqueId(), cMILaunch);
        if (this.plugin.getElytraManager().getLaunchTime() > 0.0) {
            BossBarInfo bossBarInfo = cMIUser.getBossBar("ElytraLaunch");
            if (bossBarInfo == null) {
                bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), "ElytraLaunch");
            }
            long l = System.currentTimeMillis() - cMILaunch.getStarted();
            double d = (double)(l * 100L) / (this.plugin.getElytraManager().getLaunchTime() * 1000.0) / 100.0;
            bossBarInfo.setPercentage(Double.valueOf(d));
            bossBarInfo.setTitleOfBar(CMILC.Elytra_Charging.getLocale("[percentage]", (int)(bossBarInfo.getPercentage() * 100.0)));
            bossBarInfo.setKeepForTicks(Integer.valueOf(10));
            bossBarInfo.setColor(BarColor.RED);
            if (bossBarInfo.getBar() != null) {
                if (d > 0.3 && d < 0.6) {
                    bossBarInfo.getBar().setColor(BarColor.PURPLE);
                }
                if (d > 0.6) {
                    bossBarInfo.getBar().setColor(BarColor.BLUE);
                }
                if (d >= 1.0) {
                    bossBarInfo.getBar().setColor(BarColor.GREEN);
                }
            }
            cMIUser.addBossBar(bossBarInfo);
        }
    }

    private class CMILaunch {
        private Long started;
        private Long lastCharge;

        private CMILaunch() {
        }

        public Long getStarted() {
            return this.started;
        }

        public Long getLastCharge() {
            return this.lastCharge;
        }

        public void setLastCharge() {
            if (this.started == null) {
                this.started = System.currentTimeMillis();
            }
            if (this.lastCharge != null && this.lastCharge + 333L < System.currentTimeMillis()) {
                this.started = System.currentTimeMillis();
            } else {
                this.lastCharge = System.currentTimeMillis();
            }
        }

        public boolean isFullyCharged() {
            if (this.started == null || this.lastCharge == null) {
                return false;
            }
            return (double)this.started.longValue() + ElytraLaunchListener.this.plugin.getElytraManager().getLaunchTime() * 1000.0 < (double)System.currentTimeMillis();
        }
    }
}

