/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.FlightCharge;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.FlightCharge.FlightCharge;
import com.Zrips.CMI.Modules.FlightCharge.FlightListener;
import com.Zrips.CMI.Modules.FlightCharge.traveledDistance;
import com.Zrips.CMI.Modules.SpawnerCharge.PlayerCharge;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.commands.list.flightcharge;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Player;

public class FlightChargeManager {
    CMI plugin;
    private boolean FlightChargeEnabledByDefault = true;
    private boolean FlightChargeAutoSwitch = true;
    private boolean bossbar = true;
    private double ExpRechargeCost = 0.0;
    private double MoneyRechargeCost = 0.0;
    private int MaxChargeLevel = 0;
    private int DeductOnFallMulti = 0;
    private double DeductOnIdling = 0.0;
    private double DeductOnlyForTime = 0.0;
    private boolean DamageOnFall = true;
    private boolean DamageOnToggle = true;
    private boolean KillOnFall = true;
    private CMIChatColor GlowColor = null;
    private double autoRechargeFrom = 0.0;
    private double autoRechargeAmount = 0.0;
    private ConcurrentHashMap<UUID, FlightCharge> flightCharges = new ConcurrentHashMap();
    public static final String flightChargeBossBar = "CMIFlightChargeBossBar";

    public FlightChargeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public FlightCharge getFlightCharge(UUID uUID2) {
        return this.flightCharges.computeIfAbsent(uUID2, uUID -> new FlightCharge());
    }

    @Deprecated
    public PlayerCharge getPCharge(UUID uUID) {
        return this.getPCharge(uUID, true);
    }

    @Deprecated
    public PlayerCharge getPCharge(UUID uUID, boolean bl) {
        return this.plugin.getSpawnerChargesManager().getPCharge(CMIUser.getUser(uUID), bl);
    }

    public void load() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("FlightCharge.ShowBossBar", new String[]{"By default boss bar message will be shown with remaining charges. If disabled then bossbar will only appear when flight charge was modified but not when its depleating while flying"});
        this.bossbar = configReader.get("FlightCharge.ShowBossBar", Boolean.valueOf(true));
        configReader.addComment("FlightCharge.EnabledByDefault", new String[]{"When set to true, each time player gets flight charge or relogs, his fly mode will be toggled on", "If set to false, then players will have to manually turn on flight with /cmi flyc"});
        this.FlightChargeEnabledByDefault = configReader.get("FlightCharge.EnabledByDefault", Boolean.valueOf(true));
        configReader.addComment("FlightCharge.AutoSwitch", new String[]{"When set to true, in event of player changing his game mode from survival/adventure to creative/spectator his flight charge  mode will get disabled", "Same applies when changing game mode from creative/spectator to survival/adventure"});
        this.FlightChargeAutoSwitch = configReader.get("FlightCharge.AutoSwitch", Boolean.valueOf(false));
        configReader.addComment("FlightCharge.ExpRechargeCost", new String[]{"How much it costs for one recharge point in exp points. Value can be in decimals, like 0.2 but it cant be equal or lower than 0", "Set to 0 to disable this type of recharge"});
        this.ExpRechargeCost = configReader.get("FlightCharge.ExpRechargeCost", Double.valueOf(1.0));
        configReader.addComment("FlightCharge.MoneyRechargeCost", new String[]{"How much it costs for one recharge point. Value can be in decimals, like 0.2 but it cant be equal or lower than 0", "Set to 0 to disable this type of recharge"});
        this.MoneyRechargeCost = configReader.get("FlightCharge.MoneyRechargeCost", Double.valueOf(1.0));
        configReader.addComment("FlightCharge.MaxChargeLevel", new String[]{"Defines maximum amount of charge player can have", "One charge is one traveled block while flying", "if player doesn't move, then one charge for each second while hovering"});
        this.MaxChargeLevel = configReader.get("FlightCharge.MaxChargeLevel", 1000);
        configReader.addComment("FlightCharge.DeductOnIdling", new String[]{"Defines multiplier when player doesn't move but is hovering. For each second player hovers.", "Set to 0 to disable"});
        this.DeductOnIdling = configReader.get("FlightCharge.DeductOnIdling", Double.valueOf(1.0));
        configReader.addComment("FlightCharge.DeductOnlyForTime", new String[]{"If this is set above 0, then player will loose defined amount of charges each second they are flying instead of traveled blocks", "Set to 0 to disable, which will deduct charges for traveled blocks"});
        this.DeductOnlyForTime = configReader.get("FlightCharge.DeductOnlyForTime", Double.valueOf(0.0));
        configReader.addComment("FlightCharge.AutoRecharge.From", new String[]{"Value in percentage when we should automatically recharge players flight charges if player enabled autorecharge with /autorecharge command"});
        this.autoRechargeFrom = configReader.get("FlightCharge.AutoRecharge.From", Double.valueOf(10.0));
        this.autoRechargeFrom = this.autoRechargeFrom < 0.0 ? 0.0 : (this.autoRechargeFrom > 100.0 ? 100.0 : this.autoRechargeFrom);
        configReader.addComment("FlightCharge.AutoRecharge.Amount", new String[]{"Value in percentage of charges we need to recharge", "25 will result into 25% of max allowed charges being recharged each time auto recharge is triggered"});
        this.autoRechargeAmount = configReader.get("FlightCharge.AutoRecharge.Amount", Double.valueOf(25.0));
        this.autoRechargeAmount = this.autoRechargeAmount < 0.0 ? 0.0 : (this.autoRechargeAmount > 100.0 ? 100.0 : this.autoRechargeAmount);
        configReader.addComment("FlightCharge.DeductOnFallMulti", new String[]{"Defines multiplier when player falls down of charge to be taken", "This only effects when player falls from above 3 blocks of hight", "In example if player falls from 10 blocks height, then 7 * 2 = 14 charges will be taken", "This is to prevent avoiding no penalty from jumping from cliffs", "Set to 0 if you want to disable it"});
        this.DeductOnFallMulti = configReader.get("FlightCharge.DeductOnFallMulti", 2);
        configReader.addComment("FlightCharge.DamageOnFall", new String[]{"Defines if you want to damage player when he falls down from higher than 3 blocks height", "This will not kill player even if he would drop from 200 block height, but will leave him with 1 hp", "This will only effect players who jumped down and not those who disabled fly mode in mid air"});
        this.DamageOnFall = configReader.get("FlightCharge.DamageOnFall", Boolean.valueOf(true));
        configReader.addComment("FlightCharge.DamageOnToggle", new String[]{"DamageOnFall should be enabled for this to work", "This will define if you want to damage player when he deactivates fly mode in mid air"});
        this.DamageOnToggle = configReader.get("FlightCharge.DamageOnToggle", Boolean.valueOf(false));
        this.DamageOnToggle = !this.DamageOnFall ? false : this.DamageOnToggle;
        configReader.addComment("FlightCharge.KillOnFall", new String[]{"DamageOnFall should be enabled for this to work", "This will define if you want to kill player if fall damage if higher than his health amount"});
        this.KillOnFall = configReader.get("FlightCharge.KillOnFall", Boolean.valueOf(false));
        this.KillOnFall = !this.DamageOnFall ? false : this.KillOnFall;
        configReader.addComment("FlightCharge.GlowColor", new String[]{"When color name is defined then at moment player starts flying with flight charges, he will start glowing", "Set this to 'none' if you want to disable it"});
        this.GlowColor = CMIChatColor.getColor((String)configReader.get("FlightCharge.GlowColor", "none"));
    }

    public void process(Player player, Integer n) {
        traveledDistance traveledDistance2 = FlightListener.distanceMap.get(player.getUniqueId());
        if (traveledDistance2 == null) {
            traveledDistance2 = new traveledDistance(this.plugin.getPlayerManager().getUser(player));
            FlightListener.distanceMap.put(player.getUniqueId(), traveledDistance2);
        }
        this.process(traveledDistance2, n);
    }

    public void process(traveledDistance traveledDistance2, Integer n) {
        CMIUser cMIUser = traveledDistance2.getUser();
        if (cMIUser.getFlightCharge().getCharge() == null) {
            traveledDistance2.updateLocation();
            return;
        }
        if (cMIUser.getTfly() > 0L || cMIUser.getTfly() == -1L) {
            return;
        }
        if (cMIUser.isOnline() && cMIUser.getPlayer().getVehicle() != null) {
            traveledDistance2.updateLocation();
            return;
        }
        Double d2 = traveledDistance2.getDistanceTraveled();
        if (n != null) {
            d2 = n.doubleValue();
        }
        if (d2 == 0.0) {
            d2 = (double)(traveledDistance2.sinceLastUpdate() / 1000L) * this.DeductOnIdling;
        } else if (this.DeductOnlyForTime > 0.0) {
            d2 = (double)(traveledDistance2.sinceLastUpdate() / 1000L) * this.DeductOnlyForTime;
        }
        if (d2 == 0.0 && this.DeductOnIdling > 0.0 || d2 == 0.0 && this.DeductOnlyForTime > 0.0) {
            d2 = 1.0;
        }
        if (d2 > 0.0) {
            cMIUser.getFlightCharge().takeCharge((double)d2);
            this.autorecharge(cMIUser);
            if (cMIUser.isOnline()) {
                Player player = cMIUser.getPlayer();
                if (cMIUser.getFlightCharge().getSafeCharge() <= 0.0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    cMIUser.getFlightCharge().setEnabled(false);
                    CompletableFuture<Double> completableFuture = this.plugin.getTeleportHandler().getDistanceToDrop(player.getLocation());
                    completableFuture.thenAccept(d -> {
                        if (d <= 3.0) {
                            return;
                        }
                        this.plugin.getTeleportHandler().teleportPlayer(player, player.getLocation(), true, CMITeleportType.FlightCharge);
                    });
                    cMIUser.getFlightCharge().setCharge(null);
                }
            }
            if (this.bossbar) {
                this.updateBossBar(traveledDistance2);
            }
        }
        traveledDistance2.updateLocation();
    }

    private void autorecharge(CMIUser cMIUser) {
        if (cMIUser.getFlightCharge().isAutoRecharge().booleanValue() && cMIUser.getFlightCharge().getSafeCharge() * 100.0 / (double)cMIUser.getFlightCharge().getMax().intValue() <= this.plugin.getFlightChargeManager().getAutoRechargeFrom()) {
            if (cMIUser.getFlightCharge().isMoneyAutoRecharge() && this.plugin.getFlightChargeManager().getMoneyRechargeCost() > 0.0) {
                flightcharge.moneyRecharge(null, cMIUser, (int)((double)cMIUser.getFlightCharge().getMax().intValue() * (this.plugin.getFlightChargeManager().getAutoRechargeAmount() / 100.0)), false);
            } else if (cMIUser.getFlightCharge().isExpAutoRecharge() && this.plugin.getFlightChargeManager().getExpRechargeCost() > 0.0) {
                flightcharge.expRecharge(null, cMIUser, (int)((double)cMIUser.getFlightCharge().getMax().intValue() * (this.plugin.getFlightChargeManager().getAutoRechargeAmount() / 100.0)), false);
            }
        }
    }

    public void updateBossBar(CMIUser cMIUser) {
        traveledDistance traveledDistance2 = FlightListener.distanceMap.get(cMIUser.getUniqueId());
        if (traveledDistance2 == null) {
            traveledDistance2 = new traveledDistance(cMIUser);
            FlightListener.distanceMap.put(cMIUser.getUniqueId(), traveledDistance2);
        }
        this.updateBossBar(traveledDistance2);
    }

    private void updateBossBar(traveledDistance traveledDistance2) {
        if (!Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            return;
        }
        CMIUser cMIUser = traveledDistance2.getUser();
        Double d = cMIUser.getFlightCharge().getCharge();
        if (d != null && d > 0.0) {
            BossBarInfo bossBarInfo = cMIUser.getBossBar(flightChargeBossBar);
            if (bossBarInfo == null) {
                bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), flightChargeBossBar);
                bossBarInfo.setPercentage(cMIUser.getFlightCharge().getMax().doubleValue(), d.doubleValue());
                bossBarInfo.setColor(bossBarInfo.getPercentage() > 0.5 ? BarColor.GREEN : (bossBarInfo.getPercentage() > 0.2 ? BarColor.YELLOW : BarColor.RED));
            }
            bossBarInfo.setPercentage(cMIUser.getFlightCharge().getMax().doubleValue(), d.doubleValue());
            if (bossBarInfo.getBar() != null) {
                bossBarInfo.getBar().setColor(bossBarInfo.getPercentage() > 0.5 ? BarColor.GREEN : (bossBarInfo.getPercentage() > 0.2 ? BarColor.YELLOW : BarColor.RED));
            }
            String string = "";
            if (cMIUser.getFlightCharge().getLastChange() != 0.0) {
                string = CMILC.getIM(flightcharge.class, "changeAmount", "[amount]", cMIUser.getFlightCharge().getLastChange() > 0.0 ? "&2+" + cMIUser.getFlightCharge().getLastChange().intValue() : "&c" + cMIUser.getFlightCharge().getLastChange().intValue());
            }
            bossBarInfo.setTitleOfBar(CMILC.getIM(flightcharge.class, "bossbar", "[charge]", d.intValue(), "[max]", (int)cMIUser.getFlightCharge().getMax(), "[changeAmount]", string));
            bossBarInfo.setKeepForTicks(Integer.valueOf(60));
            cMIUser.addBossBar(bossBarInfo);
        } else {
            BossBarInfo bossBarInfo = cMIUser.getBossBar(flightChargeBossBar);
            if (bossBarInfo != null) {
                bossBarInfo.remove();
            }
        }
    }

    public double getExpRechargeCost() {
        return this.ExpRechargeCost;
    }

    public void setExpRechargeCost(double d) {
        this.ExpRechargeCost = d;
    }

    public double getMoneyRechargeCost() {
        return this.MoneyRechargeCost;
    }

    public void setMoneyRechargeCost(double d) {
        this.MoneyRechargeCost = d;
    }

    public int getMaxChargeLevel() {
        return this.MaxChargeLevel;
    }

    public void setMaxChargeLevel(int n) {
        this.MaxChargeLevel = n;
    }

    public int getDeductOnFallMulti() {
        return this.DeductOnFallMulti;
    }

    public void setDeductOnFallMulti(int n) {
        this.DeductOnFallMulti = n;
    }

    public boolean isDamageOnFall() {
        return this.DamageOnFall;
    }

    public void setDamageOnFall(boolean bl) {
        this.DamageOnFall = bl;
    }

    public boolean isDamageOnToggle() {
        return this.DamageOnToggle;
    }

    public void setDamageOnToggle(boolean bl) {
        this.DamageOnToggle = bl;
    }

    public boolean isKillOnFall() {
        return this.KillOnFall;
    }

    public void setKillOnFall(boolean bl) {
        this.KillOnFall = bl;
    }

    public double getDeductOnIdling() {
        return this.DeductOnIdling;
    }

    public void setDeductOnIdling(int n) {
        this.DeductOnIdling = n;
    }

    public boolean isFlightChargeEnabledByDefault() {
        return this.FlightChargeEnabledByDefault;
    }

    public void setFlightChargeEnabledByDefault(boolean bl) {
        this.FlightChargeEnabledByDefault = bl;
    }

    public boolean isFlightChargeAutoSwitch() {
        return this.FlightChargeAutoSwitch;
    }

    public CMIChatColor getGlowColor() {
        return this.GlowColor;
    }

    public void setGlowColor(CMIChatColor cMIChatColor) {
        this.GlowColor = cMIChatColor;
    }

    public double getAutoRechargeFrom() {
        return this.autoRechargeFrom;
    }

    public double getAutoRechargeAmount() {
        return this.autoRechargeAmount;
    }
}

