/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InteractiveCommand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.entity.Entity;

public class CitizensManager {
    private CMI plugin;
    NPCRegistry registry;

    public CitizensManager(CMI cMI) {
        this.plugin = cMI;
        if (CMIHookType.Citizens.isEnabled()) {
            this.registry = CitizensAPI.getNPCRegistry();
        }
    }

    public boolean isCitizen(Entity entity) {
        if (this.registry == null) {
            return false;
        }
        return this.registry.isNPC(entity);
    }

    public UUID getCitizenPrivateUUID(UUID uUID) {
        if (this.registry == null) {
            return null;
        }
        NPC nPC = this.registry.getByUniqueId(uUID);
        return nPC == null ? null : nPC.getUniqueId();
    }

    public Integer getEntityId(Entity entity) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entity);
        if (nPC != null) {
            return nPC.getId();
        }
        return null;
    }

    public Integer getEntityId(UUID uUID) {
        NPC nPC = CitizensAPI.getNPCRegistry().getByUniqueId(uUID);
        if (nPC != null) {
            return nPC.getId();
        }
        nPC = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(uUID);
        if (nPC != null) {
            return nPC.getId();
        }
        try {
            Object object = uUID.toString();
            String[] stringArray = ((String)object).split("-", 3);
            object = stringArray[0] + "-" + stringArray[1] + "-" + (stringArray[2].startsWith("2") ? "4" : "2") + stringArray[2].substring(1);
            UUID uUID2 = UUID.fromString((String)object);
            nPC = CitizensAPI.getNPCRegistry().getByUniqueId(uUID2);
            if (nPC != null) {
                return nPC.getId();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public UUID getEntityUUID(Entity entity) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entity);
        if (nPC != null) {
            return nPC.getUniqueId();
        }
        return null;
    }

    public UUID getEntityUUID(int n) {
        NPC nPC = CitizensAPI.getNPCRegistry().getById(n);
        if (nPC != null && nPC.getEntity() != null) {
            return nPC.getUniqueId();
        }
        return null;
    }

    public UUID getEntityRealUUID(int n) {
        NPC nPC = CitizensAPI.getNPCRegistry().getById(n);
        if (nPC != null && nPC.getEntity() != null) {
            return nPC.getEntity().getUniqueId();
        }
        return null;
    }
}

