/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Mirror;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIEvent;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Mirror.Mirrors;
import com.Zrips.CMI.commands.list.mirror;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Container.BlockStateType;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MirrorManager {
    HashMap<UUID, Mirrors> mirrorMap = new HashMap();
    private final String CMIMirrorBlock = "CMIMirrorBlock";
    private CMI plugin;

    public Mirrors getMirror(UUID uUID2) {
        return this.mirrorMap.computeIfAbsent(uUID2, uUID -> new Mirrors());
    }

    public void setMirror(UUID uUID, Mirrors mirrors) {
        this.mirrorMap.put(uUID, mirrors);
    }

    public MirrorManager(CMI cMI) {
        this.plugin = cMI;
    }

    public boolean isMirroring(Player player) {
        return this.mirrorMap.containsKey(player.getUniqueId());
    }

    public boolean addMirroring(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser != null) {
            return this.mirrorMap.computeIfAbsent(player.getUniqueId(), uUID -> new Mirrors()) != null;
        }
        return false;
    }

    public void removeMirroring(Player player) {
        this.removeMirroring(player.getUniqueId());
    }

    public void removeMirroring(UUID uUID) {
        this.mirrorMap.remove(uUID);
    }

    private static String toString(Location location) {
        return location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
    }

    private HashMap<String, blockInfo> getMapLocations(Mirrors mirrors, Location location, Block block) {
        Object object;
        HashMap<String, blockInfo> hashMap = new HashMap<String, blockInfo>();
        hashMap.put(MirrorManager.toString(location), new blockInfo(location, new CMIBlock(block).getData()));
        for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
            object = this.getMirroredLocMap(mirrors, ((blockInfo)entry.getValue()).getLoc());
            for (Map.Entry<String, blockInfo> entry2 : ((HashMap)object).entrySet()) {
                if (hashMap.containsKey(entry2.getKey())) continue;
                hashMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        if (mirrors.is(MirrorAction.Rotate90V)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = MirrorManager.rotate90vert(mirrors, ((blockInfo)entry.getValue()).getLoc());
                if (object == null || hashMap.containsKey(MirrorManager.toString((Location)object))) continue;
                hashMap.put(MirrorManager.toString((Location)object), new blockInfo((Location)object, new CMIBlock(block).setData(((blockInfo)entry.getValue()).getData()).flip(CMIBlock.FlipDirection.UP_DOWN, false).getData()));
            }
        }
        if (mirrors.is(MirrorAction.Rotate90H)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.rotate90horClockWise(mirrors, ((blockInfo)entry.getValue()).getLoc());
                if (object == null || hashMap.containsKey(MirrorManager.toString((Location)object))) continue;
                hashMap.put(MirrorManager.toString((Location)object), new blockInfo((Location)object, new CMIBlock(block).setData(((blockInfo)entry.getValue()).getData()).rotate90().getData()));
            }
        }
        if (mirrors.is(MirrorAction.Rotate90HC)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.rotate90horCounterClockWise(mirrors, ((blockInfo)entry.getValue()).getLoc());
                if (object == null || hashMap.containsKey(MirrorManager.toString((Location)object))) continue;
                hashMap.put(MirrorManager.toString((Location)object), new blockInfo((Location)object, new CMIBlock(block).setData(((blockInfo)entry.getValue()).getData()).rotate90Reverse().getData()));
            }
        }
        if (mirrors.is(MirrorAction.Rotate180H)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = MirrorManager.rotate180hor(mirrors, ((blockInfo)entry.getValue()).getLoc());
                if (object == null || hashMap.containsKey(MirrorManager.toString((Location)object))) continue;
                hashMap.put(MirrorManager.toString((Location)object), new blockInfo((Location)object, new CMIBlock(block).setData(((blockInfo)entry.getValue()).getData()).rotate90().rotate90().getData()));
            }
        }
        if (mirrors.is(MirrorAction.XY)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.getMirroredXYMap(mirrors, location.getBlock(), ((blockInfo)entry.getValue()).getData(), ((blockInfo)entry.getValue()).getLoc(), 8, null);
                for (Map.Entry<String, blockInfo> entry2 : ((HashMap)object).entrySet()) {
                    if (hashMap.containsKey(entry2.getKey())) continue;
                    hashMap.put(entry2.getKey(), entry2.getValue());
                }
            }
        }
        if (mirrors.is(MirrorAction.ZY)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.getMirroredZYMap(mirrors, location.getBlock(), ((blockInfo)entry.getValue()).getData(), ((blockInfo)entry.getValue()).getLoc(), 8, null);
                for (Map.Entry<String, blockInfo> entry3 : ((HashMap)object).entrySet()) {
                    if (hashMap.containsKey(entry3.getKey())) continue;
                    hashMap.put(entry3.getKey(), entry3.getValue());
                }
            }
        }
        if (mirrors.is(MirrorAction.XZ)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.getMirroredXZMap(mirrors, location.getBlock(), ((blockInfo)entry.getValue()).getData(), ((blockInfo)entry.getValue()).getLoc(), 8, null);
                for (Map.Entry<String, blockInfo> entry4 : ((HashMap)object).entrySet()) {
                    if (hashMap.containsKey(entry4.getKey())) continue;
                    hashMap.put(entry4.getKey(), entry4.getValue());
                }
            }
        }
        if (mirrors.is(MirrorAction.ZX)) {
            for (Map.Entry entry : new HashMap(hashMap).entrySet()) {
                object = this.getMirroredZXMap(mirrors, location.getBlock(), ((blockInfo)entry.getValue()).getData(), ((blockInfo)entry.getValue()).getLoc(), 8, null);
                for (Map.Entry<String, blockInfo> entry5 : ((HashMap)object).entrySet()) {
                    if (hashMap.containsKey(entry5.getKey())) continue;
                    hashMap.put(entry5.getKey(), entry5.getValue());
                }
            }
        }
        hashMap.remove(MirrorManager.toString(location));
        return hashMap;
    }

    private static Set<Location> getLocations(Mirrors mirrors, Location location) {
        HashSet<Location> hashSet = new HashSet<Location>();
        HashSet<Location> hashSet2 = new HashSet<Location>();
        hashSet.add(location);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.add(MirrorManager.rotate90vert(mirrors, location2));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.add(MirrorManager.rotate90hor(mirrors, location2, true));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.add(MirrorManager.rotate90hor(mirrors, location2, false));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.add(MirrorManager.rotate180hor(mirrors, location2));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.addAll(MirrorManager.getMirroredLocs(mirrors, location2));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.addAll(MirrorManager.getMirroredXY(mirrors, location2, 8));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.addAll(MirrorManager.getMirroredZY(mirrors, location2, 8));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.addAll(MirrorManager.getMirroredXZ(mirrors, location2, 8));
        }
        hashSet.addAll(hashSet2);
        for (Location location2 : hashSet) {
            if (location2 == null) continue;
            hashSet2.addAll(MirrorManager.getMirroredZX(mirrors, location2, 8));
        }
        hashSet2.remove(location);
        return hashSet2;
    }

    private boolean inRange(Location location, Location location2) {
        if (!location.getWorld().getName().equalsIgnoreCase(location2.getWorld().getName())) {
            return false;
        }
        int n = MirrorManager.getXdif(location, location2);
        int n2 = MirrorManager.getYdif(location, location2);
        int n3 = MirrorManager.getZdif(location, location2);
        n = n < 0 ? -n : n;
        n2 = n2 < 0 ? -n2 : n2;
        n3 = n3 < 0 ? -n3 : n3;
        int n4 = this.plugin.getConfigManager().MirrorMaxRange;
        return n < n4 && n2 < n4 && n3 < n4;
    }

    private HashMap<String, blockInfo> offset(Mirrors mirrors, Block block, mirrorShift mirrorShift2) {
        Location location = mirrorShift2.modifyLocation(block.getLocation().clone());
        HashMap<String, blockInfo> hashMap = new HashMap<String, blockInfo>(this.getMapLocations(mirrors.clone().setCenter(mirrorShift2.modifyLocation(mirrors.getCenter().clone())), location, block));
        hashMap.put(MirrorManager.toString(location), new blockInfo(location, new CMIBlock(block).getData()));
        return hashMap;
    }

    private HashMap<String, blockInfo> combineMaps(HashMap<String, blockInfo> hashMap, HashMap<String, blockInfo> hashMap2) {
        for (Map.Entry<String, blockInfo> entry : hashMap2.entrySet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public void MirrorPlace(Player player, Block block, ItemStack itemStack) {
        if (!this.isMirroring(player)) {
            return;
        }
        CMIUser cMIUser = CMIUser.getUser(player);
        Mirrors mirrors = cMIUser.getMirror();
        if (block.hasMetadata("CMIMirrorBlock")) {
            block.removeMetadata("CMIMirrorBlock", (Plugin)this.plugin);
            return;
        }
        if (mirrors.isPaused()) {
            return;
        }
        if (mirrors.getCenter() == null) {
            return;
        }
        if (!this.inRange(mirrors.getCenter(), block.getLocation())) {
            CMILC.info(mirror.class, (CommandSender)player, "tooFar", "[blocks]", this.plugin.getConfigManager().MirrorMaxRange);
            mirrors.setPaused(true);
            return;
        }
        CMIScheduler.runAtLocation((Location)block.getLocation(), () -> {
            if (itemStack == null) {
                return;
            }
            ItemStack itemStack2 = itemStack.clone();
            if (itemStack2.getType() == Material.AIR) {
                itemStack2 = CMIMaterial.get((Block)block).newItemStack();
            }
            if (itemStack2.getAmount() == 0) {
                itemStack2.setAmount(1);
            }
            Material material = block.getType();
            CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
            HashMap<String, blockInfo> hashMap = this.getMapLocations(mirrors, block.getLocation(), block);
            int n = this.plugin.getPlayerManager().getUser(player).getInventory().getTotalAmount(itemStack2, CMIPlayerInventory.itemCheckType.material, CMIPlayerInventory.itemCheckType.nbt);
            boolean bl = true;
            if (player.getGameMode() == GameMode.CREATIVE) {
                bl = false;
            }
            int n2 = 0;
            String string = MirrorManager.toString(block.getLocation());
            hashMap.remove(string);
            boolean bl2 = false;
            if (CMIHookType.NoCheatPlus.isEnabled()) {
                if (NCPExemptionManager.isExempted((Player)player, (CheckType)CheckType.BLOCKPLACE)) {
                    bl2 = true;
                }
                if (!bl2) {
                    NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.BLOCKPLACE);
                }
            }
            try {
                for (Map.Entry<String, blockInfo> itemStack3 : hashMap.entrySet()) {
                    HashMap hashMap2;
                    Block block2 = itemStack3.getValue().getLoc().getBlock();
                    Material material2 = block2.getType();
                    if (material2 == Material.BEDROCK && player.getGameMode() != GameMode.CREATIVE || MirrorManager.toString(block2.getLocation()).equals(string)) continue;
                    boolean bl3 = false;
                    if (cMIMaterial.isSlab()) {
                        hashMap2 = CMIBlock.getBlockStates((Block)block);
                        boolean bl4 = bl3 = hashMap2.containsKey(BlockStateType.type) && ((String)hashMap2.get(BlockStateType.type)).equalsIgnoreCase("double");
                    }
                    if (!bl3 && cMIMaterial == CMIMaterial.get((Material)material2) || itemStack3.getKey().equalsIgnoreCase(string)) continue;
                    if (bl && n2 >= n) {
                        CMILC.info(mirror.class, (CommandSender)player, "noBlocks", new Object[0]);
                        break;
                    }
                    block2.setMetadata("CMIMirrorBlock", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"CMIMirrorBlock"));
                    hashMap2 = CMIEvent.placeBlockEvent(block2, player);
                    Bukkit.getServer().getPluginManager().callEvent((Event)hashMap2);
                    if (hashMap2.isCancelled()) continue;
                    ++n2;
                    block2.setType(material);
                    if (Version.isCurrentEqualOrLower((Version)Version.v1_12_R1)) {
                        try {
                            block2.getClass().getMethod("setData", Byte.TYPE).invoke((Object)block2, (byte)((Byte)itemStack3.getValue().getData()));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    if (CMIMaterial.isFence((Material)material) || CMIMaterial.isGlassPane((Material)material) || CMIMaterial.IRON_BARS.equals(material) || CMIMaterial.isRail((Material)material) || CMIMaterial.isWall((Material)material) || itemStack3.getValue().getData() == null) continue;
                    block2.setBlockData(((BlockData)itemStack3.getValue().getData()).clone());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (CMIHookType.NoCheatPlus.isEnabled() && !bl2) {
                NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.BLOCKPLACE);
            }
            if (bl) {
                ItemStack itemStack3 = itemStack2.clone();
                itemStack3.setAmount(n2);
                HashMap<Integer, ItemStack> hashMap3 = this.plugin.getPlayerManager().getUser(player).getInventory().removeItemByCriteria(itemStack3, CMIPlayerInventory.itemCheckType.material, CMIPlayerInventory.itemCheckType.nbt);
                for (Map.Entry entry : hashMap3.entrySet()) {
                    ItemStack itemStack4 = CMIItemStack.getItemInOffHand((Player)player);
                    if (itemStack4 == null || !itemStack4.getType().equals((Object)material)) continue;
                    int n3 = itemStack4.getAmount() - ((ItemStack)entry.getValue()).getAmount();
                    if (n3 < 0) {
                        CMIItemStack.setItemInOffHand((Player)player, null);
                        continue;
                    }
                    itemStack4.setAmount(n3);
                }
                CMILC.info(mirror.class, (CommandSender)player, "used", "[blocks]", ++n2);
            }
        });
    }

    public void MirrorBreak(Player player, Block block) {
        Block block2;
        Location location;
        if (!this.isMirroring(player)) {
            return;
        }
        if (this.plugin.getConfigManager().isMirrorBreakDisabled()) {
            return;
        }
        CMIUser cMIUser = CMIUser.getUser(player);
        Mirrors mirrors = cMIUser.getMirror();
        if (block.hasMetadata("CMIMirrorBlock")) {
            block.removeMetadata("CMIMirrorBlock", (Plugin)this.plugin);
            return;
        }
        if (mirrors.isPaused()) {
            return;
        }
        if (mirrors.getCenter() == null) {
            return;
        }
        if (mirrors.getLastAction() != 0L && mirrors.getLastAction() + 30L > System.currentTimeMillis()) {
            return;
        }
        if (!this.inRange(mirrors.getCenter(), block.getLocation())) {
            player.sendMessage(this.plugin.getLM().getMessage("command.mirror.info.tooFar", "[blocks]", this.plugin.getConfigManager().MirrorMaxRange));
            mirrors.setPaused(true);
        }
        mirrors.setLastAction(System.currentTimeMillis());
        Set<Location> set = MirrorManager.getLocations(mirrors, block.getLocation());
        set.remove(block.getLocation());
        boolean bl = false;
        if (CMIHookType.NoCheatPlus.isEnabled()) {
            if (NCPExemptionManager.isExempted((Player)player, (CheckType)CheckType.BLOCKBREAK)) {
                bl = true;
            }
            if (!bl) {
                NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.BLOCKBREAK);
            }
        }
        int n = 0;
        CMINBT cMINBT = set.iterator();
        while (cMINBT.hasNext()) {
            location = cMINBT.next();
            if (location == null || (block2 = location.getBlock()).getType() == Material.BEDROCK && player.getGameMode() != GameMode.CREATIVE) continue;
            BlockState blockState = block.getState();
            block2.setMetadata("CMIMirrorBlock", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"CMIMirrorBlock"));
            BlockBreakEvent blockBreakEvent = new BlockBreakEvent(block2, player);
            Bukkit.getServer().getPluginManager().callEvent((Event)blockBreakEvent);
            if (blockBreakEvent.isCancelled()) continue;
            if (player.getGameMode() != GameMode.CREATIVE) {
                block2.breakNaturally();
            } else {
                block2.setType(Material.AIR);
                if (Version.isCurrentEqualOrLower((Version)Version.v1_14_R1)) {
                    blockState.getData().setData((byte)0);
                }
            }
            ++n;
        }
        if (player.getGameMode() == GameMode.SURVIVAL && (location = CMIItemStack.getItemInMainHand((Player)player)) != null && location.getItemMeta() instanceof Damageable && location.getType().getMaxDurability() > 15 && !(cMINBT = new CMINBT((ItemStack)location)).hasNBT("Unbreakable")) {
            block2 = (Damageable)location.getItemMeta();
            int n2 = block2.getDamage() + n;
            n2 = CMINumber.clamp((int)n2, (int)0, (int)location.getType().getMaxDurability());
            block2.setDamage(n2);
            location.setItemMeta((ItemMeta)block2);
            CMIItemStack.setItemInMainHand((Player)player, (ItemStack)location);
        }
        if (CMIHookType.NoCheatPlus.isEnabled() && !bl) {
            NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.BLOCKBREAK);
        }
    }

    private Location rotate90horClockWise(Mirrors mirrors, Location location) {
        Location location2 = location.clone();
        if (!mirrors.is(MirrorAction.Rotate90H)) {
            return null;
        }
        Location location3 = mirrors.getCenter();
        int n = MirrorManager.getXdif(location3, location);
        int n2 = MirrorManager.getZdif(location3, location);
        if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
            int n3 = n2;
            n2 = -n;
            n = n3;
        } else if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            int n4 = n;
            n = n2;
            n2 = -n4;
        } else if (n == 0) {
            n = n2;
            n2 = 0;
        } else if (n2 == 0) {
            n2 = -n;
            n = 0;
        }
        location2.setX(location3.getX() + (double)n);
        location2.setZ(location3.getZ() + (double)n2);
        return location2;
    }

    private Location rotate90horCounterClockWise(Mirrors mirrors, Location location) {
        Location location2 = location.clone();
        if (!mirrors.is(MirrorAction.Rotate90HC)) {
            return null;
        }
        Location location3 = mirrors.getCenter();
        int n = MirrorManager.getXdif(location3, location);
        int n2 = MirrorManager.getZdif(location3, location);
        if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
            int n3 = n2;
            n2 = n;
            n = -n3;
        } else if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            int n4 = n;
            n = -n2;
            n2 = n4;
        } else if (n == 0) {
            n = -n2;
            n2 = 0;
        } else if (n2 == 0) {
            n2 = n;
            n = 0;
        }
        location2.setX(location3.getX() + (double)n);
        location2.setZ(location3.getZ() + (double)n2);
        return location2;
    }

    private static Location rotate90hor(Mirrors mirrors, Location location, boolean bl) {
        Location location2 = location.clone();
        if (!mirrors.is(MirrorAction.Rotate90H) && bl || !mirrors.is(MirrorAction.Rotate90HC) && !bl) {
            return location;
        }
        Location location3 = mirrors.getCenter();
        int n = MirrorManager.getXdif(location3, location);
        int n2 = MirrorManager.getZdif(location3, location);
        if (bl) {
            if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
                int n3 = n2;
                n2 = -n;
                n = n3;
            } else if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
                int n4 = n;
                n = n2;
                n2 = -n4;
            } else if (n == 0) {
                n = n2;
                n2 = 0;
            } else if (n2 == 0) {
                n2 = -n;
                n = 0;
            }
        } else if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
            int n5 = n2;
            n2 = n;
            n = -n5;
        } else if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            int n6 = n;
            n = -n2;
            n2 = n6;
        } else if (n == 0) {
            n = -n2;
            n2 = 0;
        } else if (n2 == 0) {
            n2 = n;
            n = 0;
        }
        location2.setX(location3.getX() + (double)n);
        location2.setZ(location3.getZ() + (double)n2);
        return location2;
    }

    private static Location rotate180hor(Mirrors mirrors, Location location) {
        Location location2 = location.clone();
        if (!mirrors.is(MirrorAction.Rotate180H)) {
            return null;
        }
        Location location3 = mirrors.getCenter();
        int n = MirrorManager.getXdif(location3, location);
        int n2 = MirrorManager.getZdif(location3, location);
        location2.setX(location3.getX() + (double)n);
        location2.setZ(location3.getZ() + (double)n2);
        return location2;
    }

    private static Location rotate90vert(Mirrors mirrors, Location location) {
        int n;
        Location location2 = location.clone();
        if (!mirrors.is(MirrorAction.Rotate90V)) {
            return location;
        }
        Location location3 = mirrors.getCenter();
        int n2 = location3.getBlockX();
        int n3 = location.getBlockX();
        int n4 = n2 - n3;
        int n5 = location3.getBlockZ();
        int n6 = location.getBlockZ();
        int n7 = n5 - n6;
        int n8 = location3.getBlockY();
        int n9 = location.getBlockY();
        int n10 = n8 - n9;
        int n11 = n4 < 0 ? -n4 : n4;
        int n12 = n7 < 0 ? -n7 : n7;
        int n13 = n = n10 < 0 ? -n10 : n10;
        if (n11 < n12) {
            if (location3.getY() < (double)n9) {
                location2.setX(location3.getX() + (double)n);
                location2.setY(location3.getY() + (double)n12);
                location2.setZ(location3.getZ() + (double)n11);
            } else {
                location2.setX(location3.getX() - (double)n);
                location2.setY(location3.getY() - (double)n12);
                location2.setZ(location3.getZ() - (double)n11);
            }
        } else if (location3.getY() < (double)n9) {
            location2.setX(location3.getX() + (double)n12);
            location2.setY(location3.getY() + (double)n11);
            location2.setZ(location3.getZ() + (double)n);
        } else {
            location2.setX(location3.getX() - (double)n12);
            location2.setY(location3.getY() - (double)n11);
            location2.setZ(location3.getZ() - (double)n);
        }
        return location2;
    }

    private HashMap<String, blockInfo> getMirroredXZMap(Mirrors mirrors, Block block, Object object, Location location, int n, HashMap<String, blockInfo> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() + MirrorManager.getZdif(location2, location)));
        location3.setZ((double)(location2.getBlockZ() + MirrorManager.getXdif(location2, location)));
        Object object2 = new CMIBlock(block).setData(object).flip(CMIBlock.FlipDirection.NORTH_SOUTH, true).getData();
        if (mirrors.is(MirrorAction.XZ)) {
            hashMap.put(MirrorManager.toString(location3), new blockInfo(location3, object2));
        }
        if (n > 0 && mirrors.is(MirrorAction.ZX) && mirrors.is(MirrorAction.XZ)) {
            hashMap.putAll(this.getMirroredZXMap(mirrors, block, object2, location3, n - 1, hashMap));
        }
        return hashMap;
    }

    private HashMap<String, blockInfo> getMirroredZXMap(Mirrors mirrors, Block block, Object object, Location location, int n, HashMap<String, blockInfo> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() - MirrorManager.getZdif(location2, location)));
        location3.setZ((double)(location2.getBlockZ() - MirrorManager.getXdif(location2, location)));
        Object object2 = new CMIBlock(block).setData(object).flip(CMIBlock.FlipDirection.WEST_EAST, true).getData();
        if (mirrors.is(MirrorAction.ZX)) {
            hashMap.put(MirrorManager.toString(location3), new blockInfo(location3, object2));
        }
        if (n > 0 && mirrors.is(MirrorAction.ZX) && mirrors.is(MirrorAction.XZ)) {
            hashMap.putAll(this.getMirroredXZMap(mirrors, block, object2, location3, n - 1, hashMap));
        }
        return hashMap;
    }

    private static Set<Location> getMirroredXZ(Mirrors mirrors, Location location, int n) {
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() + MirrorManager.getZdif(location2, location)));
        location3.setZ((double)(location2.getBlockZ() + MirrorManager.getXdif(location2, location)));
        if (mirrors.is(MirrorAction.XZ)) {
            hashSet.add(location3);
        }
        if (n > 0 && mirrors.is(MirrorAction.ZX) && mirrors.is(MirrorAction.XZ)) {
            hashSet.addAll(MirrorManager.getMirroredZX(mirrors, location3, n - 1));
        }
        hashSet.remove(location);
        return hashSet;
    }

    private static Set<Location> getMirroredZX(Mirrors mirrors, Location location, int n) {
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() - MirrorManager.getZdif(location2, location)));
        location3.setZ((double)(location2.getBlockZ() - MirrorManager.getXdif(location2, location)));
        if (mirrors.is(MirrorAction.ZX)) {
            hashSet.add(location3);
        }
        if (n > 0 && mirrors.is(MirrorAction.ZX) && mirrors.is(MirrorAction.XZ)) {
            hashSet.addAll(MirrorManager.getMirroredXZ(mirrors, location3, n - 1));
        }
        hashSet.remove(location);
        return hashSet;
    }

    private HashMap<String, blockInfo> getMirroredZYMap(Mirrors mirrors, Block block, Object object, Location location, int n, HashMap<String, blockInfo> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() + MirrorManager.getXdif(location2, location)));
        location3.setY((double)(location2.getBlockY() + MirrorManager.getYdif(location2, location)));
        Object object2 = new CMIBlock(block).setData(object).flip(CMIBlock.FlipDirection.UP_DOWN, false).flip(CMIBlock.FlipDirection.WEST_EAST, true).getData();
        if (mirrors.is(MirrorAction.ZY)) {
            hashMap.put(MirrorManager.toString(location3), new blockInfo(location3, object2));
        }
        if (n > 0 && mirrors.is(MirrorAction.XY) && mirrors.is(MirrorAction.ZY)) {
            hashMap.putAll(this.getMirroredXYMap(mirrors, block, object2, location3, n - 1, hashMap));
        }
        return hashMap;
    }

    private HashMap<String, blockInfo> getMirroredXYMap(Mirrors mirrors, Block block, Object object, Location location, int n, HashMap<String, blockInfo> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setZ((double)(location2.getBlockZ() + MirrorManager.getZdif(location2, location)));
        location3.setY((double)(location2.getBlockY() + MirrorManager.getYdif(location2, location)));
        CMIBlock cMIBlock = new CMIBlock(block);
        Object object2 = cMIBlock.setData(object).flip(CMIBlock.FlipDirection.UP_DOWN, false).flip(CMIBlock.FlipDirection.NORTH_SOUTH, true).getData();
        if (mirrors.is(MirrorAction.XY)) {
            hashMap.put(MirrorManager.toString(location3), new blockInfo(location3, object2));
        }
        if (n > 0 && mirrors.is(MirrorAction.ZY) && mirrors.is(MirrorAction.XY)) {
            hashMap.putAll(this.getMirroredZYMap(mirrors, block, object2, location3, n - 1, hashMap));
        }
        return hashMap;
    }

    private static Set<Location> getMirroredZY(Mirrors mirrors, Location location, int n) {
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setX((double)(location2.getBlockX() + MirrorManager.getXdif(location2, location)));
        location3.setY((double)(location2.getBlockY() + MirrorManager.getYdif(location2, location)));
        if (mirrors.is(MirrorAction.ZY)) {
            hashSet.add(location3);
        }
        if (n > 0 && mirrors.is(MirrorAction.XY) && mirrors.is(MirrorAction.ZY)) {
            hashSet.addAll(MirrorManager.getMirroredXY(mirrors, location3, n - 1));
        }
        hashSet.remove(location);
        return hashSet;
    }

    private static Set<Location> getMirroredXY(Mirrors mirrors, Location location, int n) {
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location2 = mirrors.getCenter();
        Location location3 = location.clone();
        location3.setZ((double)(location2.getBlockZ() + MirrorManager.getZdif(location2, location)));
        location3.setY((double)(location2.getBlockY() + MirrorManager.getYdif(location2, location)));
        if (mirrors.is(MirrorAction.XY)) {
            hashSet.add(location3);
        }
        if (n > 0 && mirrors.is(MirrorAction.ZY) && mirrors.is(MirrorAction.XY)) {
            hashSet.addAll(MirrorManager.getMirroredZY(mirrors, location3, n - 1));
        }
        hashSet.remove(location);
        return hashSet;
    }

    private HashMap<String, blockInfo> getMirroredLocMap(Mirrors mirrors, Location location) {
        Location location2;
        Block block = location.getBlock();
        HashMap<String, blockInfo> hashMap = new HashMap<String, blockInfo>();
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location3 = mirrors.getCenter();
        if (mirrors.is(MirrorAction.X)) {
            location2 = location.clone();
            location2.setX((double)MirrorManager.getX(location3, location));
            hashSet.add(location2);
            if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.WEST_EAST, false).getData()));
            }
        }
        if (mirrors.is(MirrorAction.Z)) {
            location2 = location.clone();
            location2.setZ((double)MirrorManager.getZ(location3, location));
            hashSet.add(location2);
            if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.NORTH_SOUTH, false).getData()));
            }
            if (mirrors.is(MirrorAction.X)) {
                location2 = location.clone();
                location2.setX((double)MirrorManager.getX(location3, location));
                location2.setZ((double)MirrorManager.getZ(location3, location));
                hashSet.add(location2);
                if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                    hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.WEST_EAST, false).flip(CMIBlock.FlipDirection.NORTH_SOUTH, false).getData()));
                }
            }
        }
        if (mirrors.is(MirrorAction.Y)) {
            location2 = location.clone();
            location2.setY((double)MirrorManager.getY(location3, location));
            hashSet.add(location2);
            if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.UP_DOWN, false).getData()));
            }
            if (mirrors.is(MirrorAction.Z)) {
                location2 = location.clone();
                location2.setZ((double)MirrorManager.getZ(location3, location));
                location2.setY((double)MirrorManager.getY(location3, location));
                hashSet.add(location2);
                if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                    hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.NORTH_SOUTH, false).flip(CMIBlock.FlipDirection.UP_DOWN, false).getData()));
                }
                if (mirrors.is(MirrorAction.X)) {
                    location2 = location.clone();
                    location2.setX((double)MirrorManager.getX(location3, location));
                    location2.setZ((double)MirrorManager.getZ(location3, location));
                    location2.setY((double)MirrorManager.getY(location3, location));
                    hashSet.add(location2);
                    if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                        hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.WEST_EAST, false).flip(CMIBlock.FlipDirection.NORTH_SOUTH, false).flip(CMIBlock.FlipDirection.UP_DOWN, false).getData()));
                    }
                }
            }
            if (mirrors.is(MirrorAction.X)) {
                location2 = location.clone();
                location2.setX((double)MirrorManager.getX(location3, location));
                location2.setY((double)MirrorManager.getY(location3, location));
                hashSet.add(location2);
                if (!hashMap.containsKey(MirrorManager.toString(location2))) {
                    hashMap.put(MirrorManager.toString(location2), new blockInfo(location2, new CMIBlock(block).flip(CMIBlock.FlipDirection.WEST_EAST, false).flip(CMIBlock.FlipDirection.UP_DOWN, false).getData()));
                }
            }
        }
        hashMap.remove(MirrorManager.toString(location));
        return hashMap;
    }

    private static Set<Location> getMirroredLocs(Mirrors mirrors, Location location) {
        Location location2;
        HashSet<Location> hashSet = new HashSet<Location>();
        hashSet.add(location);
        Location location3 = mirrors.getCenter();
        if (mirrors.is(MirrorAction.X)) {
            location2 = location.clone();
            location2.setX((double)MirrorManager.getX(location3, location));
            hashSet.add(location2);
        }
        if (mirrors.is(MirrorAction.Z)) {
            location2 = location.clone();
            location2.setZ((double)MirrorManager.getZ(location3, location));
            hashSet.add(location2);
            if (mirrors.is(MirrorAction.X)) {
                location2 = location.clone();
                location2.setX((double)MirrorManager.getX(location3, location));
                location2.setZ((double)MirrorManager.getZ(location3, location));
                hashSet.add(location2);
            }
        }
        if (mirrors.is(MirrorAction.Y)) {
            location2 = location.clone();
            location2.setY((double)MirrorManager.getY(location3, location));
            hashSet.add(location2);
            if (mirrors.is(MirrorAction.Z)) {
                location2 = location.clone();
                location2.setZ((double)MirrorManager.getZ(location3, location));
                location2.setY((double)MirrorManager.getY(location3, location));
                hashSet.add(location2);
                if (mirrors.is(MirrorAction.X)) {
                    location2 = location.clone();
                    location2.setX((double)MirrorManager.getX(location3, location));
                    location2.setZ((double)MirrorManager.getZ(location3, location));
                    location2.setY((double)MirrorManager.getY(location3, location));
                    hashSet.add(location2);
                }
            }
            if (mirrors.is(MirrorAction.X)) {
                location2 = location.clone();
                location2.setX((double)MirrorManager.getX(location3, location));
                location2.setY((double)MirrorManager.getY(location3, location));
                hashSet.add(location2);
            }
        }
        hashSet.remove(location);
        return hashSet;
    }

    private static int getX(Location location, Location location2) {
        int n = location.getBlockX();
        int n2 = location2.getBlockX();
        int n3 = n - n2;
        int n4 = n + n3;
        return n4;
    }

    private static int getY(Location location, Location location2) {
        int n = location.getBlockY();
        int n2 = location2.getBlockY();
        int n3 = n - n2;
        int n4 = n + n3;
        return n4;
    }

    private static int getZ(Location location, Location location2) {
        int n = location.getBlockZ();
        int n2 = location2.getBlockZ();
        int n3 = n - n2;
        int n4 = n + n3;
        return n4;
    }

    private static int getXdif(Location location, Location location2) {
        return location.getBlockX() - location2.getBlockX();
    }

    private static int getYdif(Location location, Location location2) {
        return location.getBlockY() - location2.getBlockY();
    }

    private static int getZdif(Location location, Location location2) {
        return location.getBlockZ() - location2.getBlockZ();
    }

    public void openNewGui(final CMIUser cMIUser) {
        if (!cMIUser.isOnline()) {
            return;
        }
        final Mirrors mirrors = cMIUser.getMirror();
        CMIGui cMIGui = new CMIGui(cMIUser.getPlayer());
        cMIGui.setTitle(CMILC.getIM(mirror.class, "title", new Object[0]));
        CMIGuiButton cMIGuiButton = new CMIGuiButton(MirrorAction.Location.getSlot(), mirrors.getCenter() != null ? CMIMaterial.GREEN_STAINED_GLASS : CMIMaterial.RED_STAINED_GLASS){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (!cMIUser.isOnline()) {
                    return;
                }
                Mirrors mirrors2 = cMIUser.getMirror();
                mirrors2.setCenter(cMIUser.getPlayer().getLocation());
                this.updateLooks();
                this.update(this.getGui());
            }

            public void updateLooks() {
                this.setItem(mirrors.getCenter() != null ? CMIMaterial.GREEN_STAINED_GLASS.newItemStack() : CMIMaterial.RED_STAINED_GLASS.newItemStack());
                this.setName(MirrorAction.Location.getName());
                this.clearLore();
                this.addLore(Arrays.asList(mirrors.getCenter() == null ? CMILC.getIM(mirror.class, "notSet", new Object[0]) : CMILC.getIM(mirror.class, "set", new Object[0]) + "\n" + LC.Location_Full.getLocale(new Object[]{mirrors.getCenter()}), MirrorAction.Location.getDesc()));
            }
        };
        cMIGuiButton.setName(MirrorAction.Location.getName());
        cMIGuiButton.addLore(Arrays.asList(mirrors.getCenter() == null ? CMILC.getIM(mirror.class, "notSet", new Object[0]) : CMILC.getIM(mirror.class, "set", new Object[0]), MirrorAction.Location.getDesc()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(MirrorAction.Pause.getSlot(), mirrors.isPaused() ? CMIMaterial.RED_WOOL : CMIMaterial.GREEN_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Mirrors mirrors2;
                if (!cMIUser.isOnline()) {
                    return;
                }
                mirrors2.setPaused(!(mirrors2 = cMIUser.getMirror()).isPaused());
                this.updateLooks();
                this.update(this.getGui());
            }

            public void updateLooks() {
                this.setItem(mirrors.isPaused() ? CMIMaterial.RED_WOOL.newItemStack() : CMIMaterial.GREEN_WOOL.newItemStack());
                this.setName(MirrorAction.Pause.getName());
                this.clearLore();
                this.addLore(Arrays.asList(mirrors.isPaused() ? LC.modify_paused.getLocale(new Object[0]) : LC.modify_running.getLocale(new Object[0]), MirrorAction.Pause.getDesc()));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        MirrorAction[] mirrorActionArray = MirrorAction.values();
        int n = mirrorActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            final MirrorAction mirrorAction = mirrorActionArray[n2];
            if (mirrorAction != MirrorAction.Pause && mirrorAction != MirrorAction.Location) {
                cMIGuiButton = new CMIGuiButton(mirrorAction.getSlot(), mirrors.is(mirrorAction) ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        Mirrors mirrors2;
                        if (!cMIUser.isOnline()) {
                            return;
                        }
                        mirrors2.set(mirrorAction, !(mirrors2 = cMIUser.getMirror()).is(mirrorAction));
                        this.updateLooks();
                        this.update(this.getGui());
                    }

                    public void updateLooks() {
                        this.setItem(mirrors.is(mirrorAction) ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                        this.setName(mirrorAction.getName());
                        this.clearLore();
                        this.addLore(Arrays.asList(mirrors.is(mirrorAction) ? LC.modify_enabled.getLocale(new Object[0]) : LC.modify_disabled.getLocale(new Object[0]), mirrorAction.getDesc()));
                    }
                };
                cMIGui.addButton(cMIGuiButton);
            }
            ++n2;
        }
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public static enum MirrorAction {
        X("&eMirrors by &6X &eaxis", 1),
        Y("&eMirrors by &6Y &eaxis", 3),
        Z("&eMirrors by &6Z &eaxis", 5),
        XY("&eMirrors by &6X &eto &6Y &eaxis", 11),
        ZY("&eMirrors by &6Z &eto &6Y &eaxis", 13),
        XZ("&eMirrors by &6X &eto &6Z &eaxis", 20),
        ZX("&eMirrors by &6Z &eto &6Y &eaxis", 22),
        Rotate90V("&eRotates up", 28),
        Rotate90H("&eRotates &690 &edegrees clock wise", 29),
        Rotate90HC("&eRotates &690 &edegrees counter clock wise", 31),
        Rotate180H("&eRotates &6180 &edegrees", 32),
        Pause("&ePauses mirroring", 16),
        Location("&eSets mirroring center location", 34);

        private int slot;
        private String desc;
        private String name;

        private MirrorAction(String string2, int n2) {
            this.slot = n2;
            this.desc = string2;
        }

        public int getSlot() {
            return this.slot;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String string) {
            this.desc = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    class blockInfo {
        private Location loc;
        private Object data;

        blockInfo(Location location, Object object) {
            this.loc = location;
            this.data = object;
        }

        public Location getLoc() {
            return this.loc;
        }

        public void setLoc(Location location) {
            this.loc = location;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object object) {
            this.data = object;
        }
    }

    public static enum mirrorShift {
        north(0, 0, -1),
        northEast(1, 0, -1),
        east(1, 0, 0),
        southEast(1, 0, 1),
        south(0, 0, 1),
        southWest(-1, 0, 1),
        west(-1, 0, 0),
        northWest(-1, 0, -1);

        private int x;
        private int y;
        private int z;
        private int offset;

        private mirrorShift(int n2, int n3, int n4) {
            this.x = n2;
            this.y = n3;
            this.z = n4;
        }

        public Location modifyLocation(Location location) {
            location.add((double)(this.x * this.offset), (double)(this.y * this.offset), (double)(this.z * this.offset));
            return location;
        }

        public int getOffset() {
            return this.offset;
        }

        public mirrorShift setOffset(int n) {
            this.offset = n;
            return this;
        }
    }
}

