/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ModuleHandling;

import com.Zrips.CMI.AllListeners.BossBarCompassListener;
import com.Zrips.CMI.AllListeners.CustomMessagesListener;
import com.Zrips.CMI.AllListeners.FirstJoinListener;
import com.Zrips.CMI.AllListeners.LaunchPadListener;
import com.Zrips.CMI.AllListeners.LaunchPadListener1_9;
import com.Zrips.CMI.AllListeners.NoTargetListener;
import com.Zrips.CMI.AllListeners.PlayerItemDamageListener;
import com.Zrips.CMI.AllListeners.UserCuffedEvents;
import com.Zrips.CMI.AllListeners.WorldLimits;
import com.Zrips.CMI.AllListeners.WorldLimitsElytra;
import com.Zrips.CMI.AllListeners.versionCheck;
import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.AStand.ArmorStandListener;
import com.Zrips.CMI.Modules.AStand.ArmorStandListener1_8;
import com.Zrips.CMI.Modules.Afk.AfkListener;
import com.Zrips.CMI.Modules.Afk.AfkListener1_8;
import com.Zrips.CMI.Modules.Afk.AfkListener1_9;
import com.Zrips.CMI.Modules.Animations.AnimationColoredArmorListener;
import com.Zrips.CMI.Modules.Animations.AnimationRideListener;
import com.Zrips.CMI.Modules.Animations.AnimationSitListener;
import com.Zrips.CMI.Modules.Anvil.AnvilColorRenameListener;
import com.Zrips.CMI.Modules.ArmorEffects.ArmorEffectListener;
import com.Zrips.CMI.Modules.AttachedCommands.CustomNBTListener;
import com.Zrips.CMI.Modules.AttachedCommands.CustomNBTListener1_8;
import com.Zrips.CMI.Modules.Chat.ChatBubbleListener;
import com.Zrips.CMI.Modules.ChatTag.TagListener;
import com.Zrips.CMI.Modules.CmdCooldown.CooldownListener;
import com.Zrips.CMI.Modules.CmdWarmUp.WarmUpListener;
import com.Zrips.CMI.Modules.DeathMessages.DeathMessageListener;
import com.Zrips.CMI.Modules.DynamicSigns.SignListener;
import com.Zrips.CMI.Modules.Elytra.ElytraBoostListener;
import com.Zrips.CMI.Modules.Elytra.ElytraExploitListener;
import com.Zrips.CMI.Modules.Elytra.ElytraExploitListener1_13;
import com.Zrips.CMI.Modules.Elytra.ElytraLaunchListener;
import com.Zrips.CMI.Modules.Enchants.EnchantListener;
import com.Zrips.CMI.Modules.EventActions.EventActionListener;
import com.Zrips.CMI.Modules.EventActions.EventActionListener1_12;
import com.Zrips.CMI.Modules.EventActions.EventActionListener1_9;
import com.Zrips.CMI.Modules.FlightCharge.FlightListener;
import com.Zrips.CMI.Modules.Holograms.HologramListener;
import com.Zrips.CMI.Modules.Homes.HomeListener;
import com.Zrips.CMI.Modules.HpBar.HpBarListener;
import com.Zrips.CMI.Modules.InteractiveCommand.InteractiveCommandListener;
import com.Zrips.CMI.Modules.InteractiveCommand.InteractiveCommandListener1_8;
import com.Zrips.CMI.Modules.Jail.JailListener;
import com.Zrips.CMI.Modules.Kits.KitListener;
import com.Zrips.CMI.Modules.Mirror.MirrorListener;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModuleClass;
import com.Zrips.CMI.Modules.MoneyCheque.MoneyChequeListener;
import com.Zrips.CMI.Modules.Painting.PaintingListener;
import com.Zrips.CMI.Modules.PlayTime.PlayTimeListener;
import com.Zrips.CMI.Modules.PlayerCombat.HeadContainerListener;
import com.Zrips.CMI.Modules.PlayerCombat.HeadDropListener;
import com.Zrips.CMI.Modules.PlayerCombat.PlayerCombatListener;
import com.Zrips.CMI.Modules.Portals.PortalListener;
import com.Zrips.CMI.Modules.Selection.SelectionListener;
import com.Zrips.CMI.Modules.ShulkerBoxInventory.ShulkerBoxListener;
import com.Zrips.CMI.Modules.Signs.PlayerSignEdit1_20Listeners;
import com.Zrips.CMI.Modules.Signs.PlayerSignEditListeners;
import com.Zrips.CMI.Modules.SilentChest.silentChestListener;
import com.Zrips.CMI.Modules.Skin.SkinListener;
import com.Zrips.CMI.Modules.SpawnerCharge.SpawnerActionsListener;
import com.Zrips.CMI.Modules.SpawnerCharge.SpawnerChargeListener;
import com.Zrips.CMI.Modules.SpawnerCharge.SpawnerProximityListener;
import com.Zrips.CMI.Modules.TabList.TabListListener;
import com.Zrips.CMI.Modules.TimedCommands.TimedCommandListener;
import com.Zrips.CMI.Modules.Totems.ResurectionListener;
import com.Zrips.CMI.Modules.Vanish.VanishListener;
import com.Zrips.CMI.Modules.Vanish.VanishListener1_19;
import com.Zrips.CMI.Modules.Votifier.VotifierListener;
import java.lang.reflect.Constructor;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public enum CMIModule {
    silentChest("Handles silent chest opening actions", new CMIModuleClass(silentChestListener.class)),
    versionCheck("Version check when player logs in", new CMIModuleClass(versionCheck.class)),
    worldLimits("World limitations: fly, game mode and god mode", new CMIModuleClass(WorldLimits.class)),
    worldLimitsElytra("World limitations: elytra mode", new CMIModuleClass(WorldLimitsElytra.class, Version.v1_9_R1)),
    customMessages("Login, logout and death messages", new CMIModuleClass(CustomMessagesListener.class)),
    firstJoinMessages("First join messages", new CMIModuleClass(FirstJoinListener.class)),
    cuffed("Handling of cuffed players", new CMIModuleClass(UserCuffedEvents.class)),
    durabilityLoss("Handling of messages appearing when item durability gets low", new CMIModuleClass(PlayerItemDamageListener.class)),
    mirror("Handling of mirror feature, which checks block place and break actions", new CMIModuleClass(MirrorListener.class)),
    spawners("Spawner handling, like drop, place, egg interactions", new CMIModuleClass(SpawnerActionsListener.class)),
    spawnerProximity("Checking spawner place proximity", new CMIModuleClass(SpawnerProximityListener.class)),
    spawnerCharge("Checking spawner charges", new CMIModuleClass(SpawnerChargeListener.class)),
    warmup("Handling of command warmups", new CMIModuleClass(WarmUpListener.class)),
    cooldown("Handling of command cooldowns", new CMIModuleClass(CooldownListener.class)),
    interactiveCommands("Handling of interactive commands", new CMIModuleClass(InteractiveCommandListener.class), new CMIModuleClass(InteractiveCommandListener1_8.class, Version.v1_8_R1)),
    attachedCommands("Handling of attached commands", new CMIModuleClass(CustomNBTListener.class), new CMIModuleClass(CustomNBTListener1_8.class, Version.v1_8_R1)),
    armorEffects("Handling of armor effects", new CMIModuleClass(ArmorEffectListener.class)),
    playerChatTag("Handling of player tagging in chat and tabcomplete with @", new CMIModuleClass(TagListener.class)),
    chatBubble("Handling of chat bubbles", new CMIModuleClass(ChatBubbleListener.class, Version.v1_19_R3)),
    tablist("Handling of tablist", new CMIModuleClass(TabListListener.class)),
    paintingEditor("Handling of painting editing with shift+right click", new CMIModuleClass(PaintingListener.class)),
    vanish("Handles player vanish mode", new CMIModuleClass(VanishListener.class), new CMIModuleClass(VanishListener1_19.class, Version.v1_19_R1)),
    moneyCheque("Handles money cheques", new CMIModuleClass(MoneyChequeListener.class)),
    armorstand("Handles armor stand editor", new CMIModuleClass(ArmorStandListener.class), new CMIModuleClass(ArmorStandListener1_8.class, Version.v1_8_R1)),
    cmiPlaytime("Handles dedicated CMI playtime tracker", new CMIModuleClass(PlayTimeListener.class)),
    holograms("Handles hologram updates", new CMIModuleClass(HologramListener.class)),
    portals("Handles portals", new CMIModuleClass(PortalListener.class)),
    homeInteractions("Handles home bed interactions and bed destroy events. Disabling this homes will still work", new CMIModuleClass(HomeListener.class)),
    dynamicSigns("Handles dynamic signs", new CMIModuleClass(SignListener.class)),
    signEdit("Handles sign editing", new CMIModuleClass(PlayerSignEditListeners.class), new CMIModuleClass(PlayerSignEdit1_20Listeners.class, Version.v1_20_R1)),
    coloredArmor("Handles leather armor which has dynamic colors", new CMIModuleClass(AnimationColoredArmorListener.class)),
    noTarget("Handles entity target prevention on player /cmi notarget", new CMIModuleClass(NoTargetListener.class)),
    ranks("Handles rankup system", new CMIModuleClass[0]),
    votifier("Handles votifier system", new CMIModuleClass(VotifierListener.class)),
    playerCombat("Handles player combat system", new CMIModuleClass(PlayerCombatListener.class)),
    headDrop("Handles head drops system", new CMIModuleClass(HeadDropListener.class), new CMIModuleClass(HeadContainerListener.class, Version.v1_16_R3)),
    kits("Handles kit listener, mainly to give out new player kit", new CMIModuleClass(KitListener.class)),
    schedule("Handles schedule system", new CMIModuleClass[0]),
    namePlates("Handles player name plates", new CMIModuleClass[0]),
    jail("Handles jail system", new CMIModuleClass(JailListener.class)),
    flightCharge("Handles cmi flight charge system", new CMIModuleClass(FlightListener.class)),
    shulkerBackpack("Handles shulker box as backpacks", new CMIModuleClass(ShulkerBoxListener.class, Version.v1_11_R1)),
    skin("Handles player skins", new CMIModuleClass(SkinListener.class, Version.v1_8_R1)),
    selection("Handles selection areas. While this is disabled, command can still be used", new CMIModuleClass(SelectionListener.class)),
    hpBossBar("Handles mob and player hp bars as boss bar", new CMIModuleClass(HpBarListener.class, Version.v1_9_R1)),
    afk("Handling of afk feature. This will disable any checks related to afk and players will never get into afk mode", new CMIModuleClass(AfkListener.class), new CMIModuleClass(AfkListener1_8.class, Version.v1_8_R1), new CMIModuleClass(AfkListener1_9.class, Version.v1_9_R1)),
    timedCommands("Handling timed commands like tfly and tgod", new CMIModuleClass(TimedCommandListener.class)),
    eventCommands("Handling of eventCommands.yml feature ", new CMIModuleClass(EventActionListener.class), new CMIModuleClass(EventActionListener1_9.class, Version.v1_9_R1), new CMIModuleClass(EventActionListener1_12.class, Version.v1_12_R1)),
    disabledEnchants("Handling of disabled enchants in inventory", new CMIModuleClass(EnchantListener.class)),
    sitAnimation("Handling of siting on blocks", new CMIModuleClass(AnimationSitListener.class, Version.v1_8_R1)),
    rideAnimation("Handling of ride suffocation detection", new CMIModuleClass(AnimationRideListener.class)),
    bossBarCompass("Handling of boss bar compass", new CMIModuleClass(BossBarCompassListener.class, Version.v1_9_R1)),
    elytraBoost("Elytra boost", new CMIModuleClass(ElytraBoostListener.class, Version.v1_9_R1)),
    elytraLaunch("Elytra launch", new CMIModuleClass(ElytraLaunchListener.class, Version.v1_9_R1)),
    elytraExploit("Exploit prevention, like using trident for infinite flight or self damage with arrow", new CMIModuleClass(ElytraExploitListener.class, Version.v1_9_R1), new CMIModuleClass(ElytraExploitListener1_13.class, Version.v1_15_R1)),
    totemBehavior("Handling of custom totem behavior", new CMIModuleClass(ResurectionListener.class, Version.v1_11_R1)),
    anvilRenameColor("Handling of anvil item renaming and colorization", new CMIModuleClass(AnvilColorRenameListener.class, Version.v1_9_R1)),
    launchPad("Handling of launch command falldamage", new CMIModuleClass(LaunchPadListener.class), new CMIModuleClass(LaunchPadListener1_9.class, Version.v1_9_R1)),
    deathMessages("Handling of launch custom death messages", new CMIModuleClass(DeathMessageListener.class));

    private CMIModuleClass[] listeners;
    private boolean enabled = true;
    private String desc;

    private CMIModule(String string2, CMIModuleClass ... cMIModuleClassArray) {
        this.desc = string2;
        this.listeners = cMIModuleClassArray;
    }

    public static CMIModule getByName(String string) {
        CMIModule[] cMIModuleArray = CMIModule.values();
        int n = cMIModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIModule cMIModule = cMIModuleArray[n2];
            if (cMIModule.toString().equalsIgnoreCase(string)) {
                return cMIModule;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isEnabled(String string) {
        CMIModule[] cMIModuleArray = CMIModule.values();
        int n = cMIModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIModule cMIModule = cMIModuleArray[n2];
            if (cMIModule.toString().equalsIgnoreCase(string)) {
                return cMIModule.enabled;
            }
            ++n2;
        }
        return true;
    }

    public Version getFromVersion() {
        Version version2 = Version.v1_7_R4;
        if (this.listeners != null) {
            CMIModuleClass[] cMIModuleClassArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                CMIModuleClass cMIModuleClass = cMIModuleClassArray[n2];
                if (cMIModuleClass.getFrom() != null && cMIModuleClass.getFrom().isHigher(version2)) {
                    version2 = cMIModuleClass.getFrom();
                }
                ++n2;
            }
        }
        return version2;
    }

    public Version getToVersion() {
        Version version2 = null;
        if (this.listeners != null) {
            CMIModuleClass[] cMIModuleClassArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                CMIModuleClass cMIModuleClass = cMIModuleClassArray[n2];
                if (cMIModuleClass.getTo() != null) {
                    version2 = cMIModuleClass.getTo();
                }
                ++n2;
            }
        }
        return version2;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void registerListener() {
        PluginManager pluginManager = CMI.getInstance().getServer().getPluginManager();
        if (this.listeners == null) {
            return;
        }
        CMIModuleClass[] cMIModuleClassArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            CMIModuleClass cMIModuleClass = cMIModuleClassArray[n2];
            if (!(cMIModuleClass.getFrom() != null && Version.isCurrentLower((Version)cMIModuleClass.getFrom()) || cMIModuleClass.getTo() != null && Version.isCurrentHigher((Version)cMIModuleClass.getTo()))) {
                Constructor<?> constructor;
                Class<?> clazz = cMIModuleClass.getListener();
                try {
                    Constructor<?> constructor2 = clazz.getConstructor(CMI.class);
                    constructor = constructor2.newInstance(new Object[]{CMI.getInstance()});
                    pluginManager.registerEvents((Listener)constructor, (Plugin)CMI.getInstance());
                }
                catch (Error | Exception throwable) {
                    throwable.printStackTrace();
                    try {
                        constructor = clazz.getConstructor(new Class[0]);
                        Object obj = constructor.newInstance(clazz);
                        pluginManager.registerEvents((Listener)obj, (Plugin)CMI.getInstance());
                    }
                    catch (Error | Exception throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public CMIModuleClass[] getListeners() {
        return this.listeners;
    }
}

