/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayerCombat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerCombat.CMIPlayerCombat;
import com.Zrips.CMI.Modules.PlayerCombat.CombatDamageType;
import com.Zrips.CMI.Modules.PlayerCombat.EntityHeadDrop;
import com.Zrips.CMI.Modules.PlayerCombat.EntityKillCount;
import com.Zrips.CMI.Modules.PlayerCombat.PlayerKillCount;
import com.Zrips.CMI.events.CMIPvEEndEventAsync;
import com.Zrips.CMI.events.CMIPvEStartEventAsync;
import com.Zrips.CMI.events.CMIPvPEndEventAsync;
import com.Zrips.CMI.events.CMIPvPStartEventAsync;
import java.io.File;
import java.lang.constant.Constable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Entities.CMIEntitySubType;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Entities.MobHeadInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerCombatManager {
    private HashMap<CombatDamageType, Set<UUID>> combatMap = new HashMap();
    private HashMap<UUID, CMIPlayerCombat> playerCombatMap = new HashMap();
    private HashMap<UUID, HashMap<UUID, PlayerKillCount>> playerKills = new HashMap();
    private HashMap<UUID, HashMap<EntityType, EntityKillCount>> entityKills = new HashMap();
    private HashMap<EntityType, EntityHeadDrop> entityHeadDropChance = new HashMap();
    private HashMap<Integer, Double> lootMobBonus = new HashMap();
    private HashMap<Integer, Double> lootPlayerBonus = new HashMap();
    private CMI plugin;
    private boolean dropHead = false;
    private boolean IncludeVictim = false;
    private boolean PlayerShowBossBar = false;
    private boolean PlayerShowDamageNumbers = false;
    private String PlayerDamageNumbersFormat = "";
    private boolean MobShowBossBar = false;
    private boolean MobIncludeEnvironment = false;
    private boolean MobShowDamageNumbers = false;
    private String MobDamageNumbersFormat = "";
    private boolean PDisableFlight = false;
    private boolean PDisableFallDamage = false;
    private boolean MDisableFallDamage = false;
    private boolean MDisableFlight = false;
    private boolean PlayerBlockCommands = false;
    private List<String> playerWorlds = new ArrayList<String>();
    private boolean MobBlockCommands = false;
    private List<String> PlayerAllowedCommands = new ArrayList<String>();
    private List<String> MobAllowedCommands = new ArrayList<String>();
    private boolean PlayerMakeBlackList = false;
    private boolean MobMakeBlackList = false;
    private boolean maintainName = true;
    private boolean maintainLore = true;
    private boolean maintainEnchants = true;
    private boolean pvpNoGodDamage = false;
    private boolean pvpNoGodDamageInform = false;
    private boolean pveNoGodDamage = false;
    private boolean pveNoGodDamageInform = false;
    private boolean safeZoneDamage = false;
    private boolean dropEntityHead = false;
    private double DropHeadPercentage = 1.0;
    private List<String> mobWorlds = new ArrayList<String>();
    private double LowerChanceWithEachKill = 50.0;
    private int CombatTimer = 15;
    private List<String> PlayerHeadLore = new ArrayList<String>();
    Pattern lorePattern = Pattern.compile("(lore\\{(\"|'))(.+)((\"|')\\})");
    private CMITask sched = null;
    private String fileName = "CustomHeads.yml";

    public HashMap<UUID, PlayerKillCount> getKills(UUID uUID2) {
        return this.playerKills.computeIfAbsent(uUID2, uUID -> new HashMap());
    }

    public HashMap<EntityType, EntityKillCount> getEntityKills(UUID uUID2) {
        return this.entityKills.computeIfAbsent(uUID2, uUID -> new HashMap());
    }

    public PlayerCombatManager(CMI cMI) {
        this.plugin = cMI;
        CombatDamageType[] combatDamageTypeArray = CombatDamageType.values();
        int n = combatDamageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CombatDamageType combatDamageType = combatDamageTypeArray[n2];
            this.combatMap.put(combatDamageType, new HashSet());
            ++n2;
        }
        this.tasker();
    }

    public void clearCache(UUID uUID) {
        CMIPlayerCombat cMIPlayerCombat = this.playerCombatMap.get(uUID);
        if (cMIPlayerCombat != null && cMIPlayerCombat.getLeftCombatTime() <= 0L) {
            this.playerCombatMap.remove(uUID);
        }
        if (this.playerKills.containsKey(uUID)) {
            this.getKills(uUID).values().removeIf(playerKillCount -> System.currentTimeMillis() - playerKillCount.getLastKill() > 3600000L);
            if (this.getKills(uUID).isEmpty()) {
                this.playerKills.remove(uUID);
            }
        }
        if (this.entityKills.containsKey(uUID)) {
            this.getEntityKills(uUID).values().removeIf(entityKillCount -> System.currentTimeMillis() - entityKillCount.getLastKill() > 3600000L);
            if (this.getKills(uUID).isEmpty()) {
                this.entityKills.remove(uUID);
            }
        }
    }

    public void stop() {
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Combat.Timer", new String[]{"Defines combat timer to be used in particular features"});
        this.CombatTimer = configReader.get("Combat.Timer", 15);
        configReader.addComment("Combat.safeZoneDamage", new String[]{"When enabled we will allow for players to be damaged in safe zone if they are tagged for pvp"});
        this.safeZoneDamage = configReader.get("Combat.safeZoneDamage", Boolean.valueOf(false));
        configReader.addComment("Combat.IncludeVictim", new String[]{"If set to true, then attacked player will be included into combat mode even if he doesnt fight back", "If set to false then only attacker will be marked for pvp mode"});
        this.IncludeVictim = configReader.get("Combat.IncludeVictim", Boolean.valueOf(true));
        configReader.addComment("Combat.Player.DisableFlight", new String[]{"If set to true, then player who gets placed into combat mode will get its fly mode disabled", "This will disable players fly mode which will result in player dropping down and will disable option to start flying", "This can be bypassed by player performing fly command if he has access to it and commands durring combat are not blocked", "Can be bypassed with " + PermissionsManager.CMIPerm.pvp_PFlyBypass.getPermission() + " permission node"});
        this.PDisableFlight = configReader.get("Combat.Player.DisableFlight", Boolean.valueOf(false));
        configReader.addComment("Combat.Player.DisableFallDamage", new String[]{"If set to true player whose fly mode got disabled will not suffer fall damage, once"});
        this.PDisableFallDamage = configReader.get("Combat.Player.DisableFallDamage", Boolean.valueOf(false));
        if (Version.isCurrentHigher((Version)Version.v1_9_R1)) {
            configReader.addComment("Combat.Player.ShowBossBar", new String[]{"When set to true player will see boss bar message indicating how long until combat mode ends", "This only applies for pvp type combat"});
            this.PlayerShowBossBar = configReader.get("Combat.Player.ShowBossBar", Boolean.valueOf(false));
        }
        if (Version.isCurrentHigher((Version)Version.v1_8_R1)) {
            configReader.addComment("Combat.Player.ShowDamageNumbers", new String[]{"When enabled we will show damage numbers in a form of holograms when damaging players"});
            this.PlayerShowDamageNumbers = configReader.get("Combat.Player.ShowDamageNumbers", Boolean.valueOf(true));
            this.PlayerDamageNumbersFormat = configReader.get("Combat.Player.DamageNumbersFormat", "&c\u2694[damage]");
        }
        configReader.addComment("Combat.Player.noGodDamage", new String[]{"Prevents damage from players with god mode enabled", "Can be bypassed with " + PermissionsManager.CMIPerm.pvp_godBypass.getPermission() + " permission node"});
        this.pvpNoGodDamage = configReader.get("Combat.Player.noGodDamage", Boolean.valueOf(configReader.getC().getBoolean("Combat.noGodDamage", false)));
        configReader.addComment("Combat.Player.noGodDamageInform", new String[]{"Informs player that he cant damage players while in god mode"});
        this.pvpNoGodDamageInform = configReader.get("Combat.Player.noGodDamageInform", Boolean.valueOf(configReader.getC().getBoolean("Combat.noGodDamageInform", false)));
        configReader.addComment("Combat.Player.BlockCommands", new String[]{"When set to true players will be only able to use commands defined in the list", "This only applies for pvp type combat"});
        this.PlayerBlockCommands = configReader.get("Combat.Player.BlockCommands", Boolean.valueOf(false));
        this.PlayerAllowedCommands.clear();
        this.PlayerAllowedCommands = configReader.get("Combat.Player.AllowedCommands", Arrays.asList("msg", "r", "tell"));
        if (!this.PlayerBlockCommands) {
            this.PlayerAllowedCommands.clear();
        }
        configReader.addComment("Combat.Player.MakeBlackList", new String[]{"When set to true AllowedCommands become black list which will define which commands player cant use"});
        this.PlayerMakeBlackList = configReader.get("Combat.Player.MakeBlackList", Boolean.valueOf(false));
        configReader.addComment("Combat.Mob.DisableFlight", new String[]{"If set to true, then player who gets placed into combat mode will get its fly mode disabled", "Can be bypassed with " + PermissionsManager.CMIPerm.pvp_MFlyBypass.getPermission() + " permission node"});
        this.MDisableFlight = configReader.get("Combat.Mob.DisableFlight", Boolean.valueOf(false));
        configReader.addComment("Combat.Mob.DisableFallDamage", new String[]{"If set to true player whose fly mode got disabled will not suffer fall damage, once"});
        this.MDisableFallDamage = configReader.get("Combat.Mob.DisableFallDamage", Boolean.valueOf(false));
        if (Version.isCurrentHigher((Version)Version.v1_9_R1)) {
            configReader.addComment("Combat.Mob.ShowBossBar", new String[]{"When set to true player will see boss bar message indicating how long until combat mode ends", "This only applies for pve type combat"});
            this.MobShowBossBar = configReader.get("Combat.Mob.ShowBossBar", Boolean.valueOf(false));
        }
        configReader.addComment("Combat.Mob.IncludeEnvironment", new String[]{"When enabled we will include damage from environmental damage into mob combat timer", "This can include damage from cactus, magma blocks, suffocation, burning, fall damage and similar"});
        this.MobIncludeEnvironment = configReader.get("Combat.Mob.IncludeEnvironment", Boolean.valueOf(true));
        if (Version.isCurrentHigher((Version)Version.v1_8_R1)) {
            configReader.addComment("Combat.Mob.ShowDamageNumbers", new String[]{"When enabled we will show damage numbers in a form of holograms when damaging mobs"});
            this.MobShowDamageNumbers = configReader.get("Combat.Mob.ShowDamageNumbers", Boolean.valueOf(true));
            this.MobDamageNumbersFormat = configReader.get("Combat.Mob.DamageNumbersFormat", "&c\u2764[damage]");
        }
        configReader.addComment("Combat.Mob.noGodDamage", new String[]{"Prevents damage from players with god mode enabled", "Can be bypassed with " + PermissionsManager.CMIPerm.pve_godBypass.getPermission() + " permission node"});
        this.pveNoGodDamage = configReader.get("Combat.Mob.noGodDamage", Boolean.valueOf(false));
        configReader.addComment("Combat.Mob.noGodDamageInform", new String[]{"Informs player that he cant damage mobs while in god mode"});
        this.pveNoGodDamageInform = configReader.get("Combat.Mob.noGodDamageInform", Boolean.valueOf(false));
        configReader.addComment("Combat.Mob.BlockCommands", new String[]{"When set to true players will be only able to use commands defined in the list", "This only applies for pve type combat"});
        this.MobBlockCommands = configReader.get("Combat.Mob.BlockCommands", Boolean.valueOf(false));
        this.MobAllowedCommands.clear();
        this.MobAllowedCommands = configReader.get("Combat.Mob.AllowedCommands", Arrays.asList("msg", "r", "tell"));
        if (!this.MobBlockCommands) {
            this.MobAllowedCommands.clear();
        }
        configReader.addComment("Combat.Mob.MakeBlackList", new String[]{"When set to true AllowedCommands become black list which will define which commands player cant use"});
        this.MobMakeBlackList = configReader.get("Combat.Mob.MakeBlackList", Boolean.valueOf(false));
        this.dropHead = configReader.get("Combat.Heads.Player.Drop", Boolean.valueOf(false));
        configReader.addComment("Combat.Heads.Player.Percentage", new String[]{"Percentage from 0 to 100 for head to be dropped. Decimals are acceptable, like 0.2", "100 will mean that head will be dropped every time player kills another player", "1 will mean that there is 1% that player will drop head if he is killed by another player"});
        this.DropHeadPercentage = configReader.get("Combat.Heads.Player.Percentage", Double.valueOf(1.0));
        configReader.addComment("Combat.Heads.Player.LowerChanceOfterDrop", new String[]{"Percentage from 0 to 100 for lowering chance in getting second head of same player", "This will reset on each server restart"});
        this.LowerChanceWithEachKill = configReader.get("Combat.Heads.Player.LowerChanceOfterDrop", Double.valueOf(50.0));
        configReader.addComment("Combat.Heads.Player.LootBonus", new String[]{"When enabled player heads will have bigger chance to drop when using tools with looting enchantment", "Value is in % and it will add appropriate percentage to current drop chance by using drop chance itself", "For example player who has head drop change of 1% with looting 3 which has 30% bonus will have 1.3% as end value (default values)", "This only applies for player heads", "You can add as many levels as you want, simply duplicate line and set new number, in example", "Lvl33: 35.5"});
        boolean bl = configReader.get("Combat.Heads.Player.LootBonus.Enabled", Boolean.valueOf(true));
        if (configReader.getC().isDouble("Combat.Heads.Player.LootBonus.Lvl1")) {
            for (String string : configReader.getC().getConfigurationSection("Combat.Heads.Player.LootBonus").getKeys(false)) {
                if (!string.startsWith("Lvl")) continue;
                Integer n = 1;
                try {
                    n = Integer.parseInt(string.substring("lvl".length()));
                }
                catch (Exception exception) {
                    continue;
                }
                this.lootPlayerBonus.put(n, configReader.get("Combat.Heads.Player.LootBonus.Lvl" + String.valueOf(n), Double.valueOf((double)n.intValue() * 1.5)) / 100.0);
            }
        } else {
            this.lootPlayerBonus.put(1, configReader.get("Combat.Heads.Player.LootBonus.Lvl1", Double.valueOf(5.0)) / 100.0);
            this.lootPlayerBonus.put(2, configReader.get("Combat.Heads.Player.LootBonus.Lvl2", Double.valueOf(15.0)) / 100.0);
            this.lootPlayerBonus.put(3, configReader.get("Combat.Heads.Player.LootBonus.Lvl3", Double.valueOf(30.0)) / 100.0);
        }
        if (!bl) {
            this.lootPlayerBonus.clear();
        }
        configReader.addComment("Combat.Heads.Player.Worlds", new String[]{"List of worlds where we should drop player heads. Keep it empty if you want to include all possible ones"});
        this.playerWorlds = configReader.get("Combat.Heads.Player.Worlds", new ArrayList());
        CMIList.toLowerCase(this.playerWorlds);
        configReader.addComment("Combat.Heads.Mob.Drop", new String[]{"Enables custom mob heads dropping from mobs with particular chance", "Check " + this.fileName + " for customization by entityType"});
        this.dropEntityHead = configReader.get("Combat.Heads.Mob.Drop", Boolean.valueOf(false));
        configReader.addComment("Combat.Heads.Mob.Worlds", new String[]{"List of worlds where we should drop mob heads. Keep it empty if you want to include all possible ones"});
        this.mobWorlds = configReader.get("Combat.Heads.Mob.Worlds", new ArrayList());
        CMIList.toLowerCase(this.mobWorlds);
        this.loadHeads();
    }

    public void loadHeads() {
        Constable constable;
        Long l = System.currentTimeMillis();
        this.plugin.safeRenameFile("customHeads.yml", "Settings" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        int n = 0;
        this.entityHeadDropChance.clear();
        configReader.addComment("LootMobBonus", new String[]{"When enabled mob heads will have bigger chance to drop when using tools with looting enchantment", "Value is in % and it will add appropriate percentage to current drop chance by using drop chance itself", "For example player who has head drop change of 1% with looting 3 which has 30% bonus will have 1.3% as end value (default values)", "This only applies for monster heads", "You can add as many levels as you want, simply duplicate line and set new number, in example", "Lvl33: 35.5"});
        boolean bl = configReader.get("LootMobBonus.Enabled", Boolean.valueOf(true));
        if (configReader.getC().isDouble("LootMobBonus.Lvl1")) {
            for (String string : configReader.getC().getConfigurationSection("LootMobBonus").getKeys(false)) {
                if (!string.startsWith("Lvl")) continue;
                constable = Integer.valueOf(1);
                try {
                    constable = Integer.valueOf(Integer.parseInt(string.substring("lvl".length())));
                }
                catch (Exception exception) {
                    continue;
                }
                this.lootMobBonus.put((Integer)constable, configReader.get("LootMobBonus.Lvl" + String.valueOf(constable), Double.valueOf((double)((Integer)constable).intValue() * 1.5)) / 100.0);
            }
        } else {
            this.lootMobBonus.put(1, configReader.get("LootMobBonus.Lvl1", Double.valueOf(5.0)) / 100.0);
            this.lootMobBonus.put(2, configReader.get("LootMobBonus.Lvl2", Double.valueOf(15.0)) / 100.0);
            this.lootMobBonus.put(3, configReader.get("LootMobBonus.Lvl3", Double.valueOf(30.0)) / 100.0);
        }
        if (!bl) {
            this.lootMobBonus.clear();
        }
        configReader.addComment("useDefaultHeadLore", new String[]{"Defines if you want to use default head lore which will be used in case head doesnt have defined lore"});
        boolean bl2 = configReader.get("useDefaultHeadLore", Boolean.valueOf(true));
        configReader.addComment("defaultHeadLore", new String[]{"Default lore used when head doesnt have defined head lore set"});
        List list2 = configReader.get("defaultHeadLore", Arrays.asList("&7Killed by &6[playerName]"));
        configReader.addComment("PlayerHead.UseLore", new String[]{"Defines if you want to use player head lore"});
        constable = configReader.get("PlayerHead.UseLore", Boolean.valueOf(true));
        configReader.addComment("PlayerHead.Lore", new String[]{"Lore used for player head drops", "Global variables can be used for simple identification who was killed and who killed player", "Aditionally placeholders can be used too, but we will use victim as source for their translation if placeholder requires source player"});
        this.PlayerHeadLore = configReader.get("PlayerHead.Lore", Arrays.asList("&7Killed by &6[playerName]"));
        if (!((Boolean)constable).booleanValue()) {
            this.PlayerHeadLore.clear();
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R3)) {
            configReader.addComment("HeadHandling.Maintain.Name", new String[]{"Defines if we should maintain heads custom name when head is placed and then broken", "Vanilla minecraft will remove any custom information about head when you place it, this can help out to maintain data"});
            this.maintainName = configReader.get("HeadHandling.Maintain.Name", Boolean.valueOf(false));
            this.maintainLore = configReader.get("HeadHandling.Maintain.Lore", Boolean.valueOf(false));
            this.maintainEnchants = configReader.get("HeadHandling.Maintain.Enchants", Boolean.valueOf(false));
        }
        configReader.addComment("EntityHeads", new String[]{"Custom heads of every entity", "You can have as many custom heads as you want", "Format is [dropChance]:[texture]", "Drop chance is for that particular head", "While you have separate global drop chance for particular entity type", "Strongly recommend to have at least one head at 100% as in another case there will be a chance to not get a head even if player should", "You can find custom textures online", "If you have more then one possible head for one entity type, then it will be randomized", "Custom mob head can be defined by using format like [chance]:[HeadName]:c-[options]:lore{\"[lore]\"}:[texture]", "More information and some better examples can be found at www.zrips.net/cmi/extra/custom-mob-heads/", "Optionally you can shorten out texture string by removing first part which is eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUv which by itself will be added automatically if not present"});
        EntityType[] entityTypeArray = EntityType.values();
        int n2 = entityTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CMIEntityType cMIEntityType;
            EntityType entityType = entityTypeArray[n3];
            if (entityType != null && entityType.isAlive() && entityType.isSpawnable() && (cMIEntityType = CMIEntityType.getByType((EntityType)entityType)) != null && cMIEntityType != CMIEntityType.ARMOR_STAND) {
                String[] stringArray;
                Double d = configReader.get("EntityHeads." + entityType.toString().toLowerCase() + ".DropChance", Double.valueOf(1.0));
                Double d2 = configReader.get("EntityHeads." + entityType.toString().toLowerCase() + ".LowerWithEachDrop", Double.valueOf(50.0));
                EntityHeadDrop entityHeadDrop = new EntityHeadDrop(cMIEntityType);
                entityHeadDrop.setBaseDropChance(d);
                entityHeadDrop.setBaseLowerAmount(d2);
                List<CallSite> list3 = new ArrayList();
                HashMap<Object, MobHeadInfo> hashMap = new HashMap<Object, MobHeadInfo>();
                for (Map.Entry entry : cMIEntityType.getHeadTexturesMap().entrySet()) {
                    stringArray = new StringBuilder();
                    for (Object object2 : ((MobHeadInfo)entry.getValue()).getCriterias()) {
                        if (!stringArray.toString().isEmpty()) {
                            stringArray.append(",");
                        }
                        stringArray.append(object2.toString().toLowerCase());
                    }
                    list3.add((CallSite)((Object)("100:" + (((MobHeadInfo)entry.getValue()).getCustomName() == null ? "Default" : ((MobHeadInfo)entry.getValue()).getCustomName()) + ":" + (String)(stringArray.toString().isEmpty() ? "" : "c-" + stringArray.toString() + ":") + (String)entry.getKey())));
                }
                list3 = configReader.get("EntityHeads." + entityType.toString().toLowerCase() + ".Heads", list3);
                for (String string : list3) {
                    Object object;
                    Object object2;
                    if (!string.contains(":")) {
                        CMI.getInstance().consoleMessage("&cIncorrect head drop chance format (" + entityType.toString() + ")");
                        continue;
                    }
                    stringArray = string.split(":");
                    object2 = stringArray[0];
                    Object object3 = stringArray[stringArray.length - 1];
                    String string2 = string.substring(((String)object2).length() + 1);
                    string2 = string2.length() > ((String)object3).length() ? string2.substring(0, string2.length() - ((String)object3).length() - 1) : "";
                    MobHeadInfo mobHeadInfo = new MobHeadInfo();
                    if (!string2.isEmpty()) {
                        Object object4;
                        int n4;
                        String string3;
                        object = this.lorePattern.matcher(string2);
                        if (((Matcher)object).find()) {
                            string3 = ((Matcher)object).group(3);
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            String string4 = ((Matcher)object).group(2);
                            String[] stringArray2 = string3.split(string4 + "," + string4);
                            n4 = stringArray2.length;
                            int string5 = 0;
                            while (string5 < n4) {
                                object4 = stringArray2[string5];
                                if (((String)object4).startsWith(string4)) {
                                    object4 = ((String)object4).substring(1);
                                }
                                if (((String)object4).endsWith(string4)) {
                                    object4 = ((String)object4).substring(0, ((String)object4).length() - 2);
                                }
                                arrayList.add(object4);
                                ++string5;
                            }
                            mobHeadInfo.setLore(arrayList);
                            string2 = string2.replace(((Matcher)object).group(), "");
                        } else if (bl2) {
                            mobHeadInfo.setLore(list2);
                        }
                        object4 = string2.split(":");
                        int n5 = ((String[])object4).length;
                        int n6 = 0;
                        while (n6 < n5) {
                            string3 = object4[n6];
                            if (string3.startsWith("c-")) {
                                String[] stringArray3 = string3.substring("c-".length()).split(",");
                                int n7 = stringArray3.length;
                                n4 = 0;
                                while (n4 < n7) {
                                    String string5 = stringArray3[n4];
                                    CMIEntitySubType cMIEntitySubType = CMIEntitySubType.getByName((String)string5);
                                    if (cMIEntitySubType != null) {
                                        mobHeadInfo.addCriterias(cMIEntitySubType);
                                    }
                                    ++n4;
                                }
                            } else {
                                String string6 = null;
                                string6 = string3;
                                string6 = string6.equalsIgnoreCase("Default") ? null : string6;
                                mobHeadInfo.setCustomName(string6);
                            }
                            ++n6;
                        }
                    }
                    if (((String)object3).length() < 150) {
                        object3 = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUv" + (String)object3;
                    }
                    hashMap.put(object3, mobHeadInfo);
                    object = null;
                    try {
                        object = Double.parseDouble((String)object2);
                    }
                    catch (Exception exception) {
                        CMI.getInstance().consoleMessage("&cCan't determine head drop chance (" + entityType.toString() + ")");
                        continue;
                    }
                    ++n;
                    entityHeadDrop.addHead((String)object3, (Double)object);
                }
                cMIEntityType.setHeadTextures(hashMap);
                this.entityHeadDropChance.put(entityType, entityHeadDrop);
            }
            ++n3;
        }
        configReader.save();
        this.plugin.loadMessage(n, "custom mob heads", System.currentTimeMillis() - l);
    }

    private Set<UUID> get(CombatDamageType combatDamageType) {
        return this.combatMap.get((Object)combatDamageType);
    }

    public void removePlayerFromCombat(CMIUser cMIUser) {
        if (this.get(CombatDamageType.Player).remove(cMIUser.getUniqueId())) {
            this.setGotLastDamageFromPlayer(cMIUser.getUniqueId(), 0L);
            CMIScheduler.runTaskAsynchronously(() -> {
                CMIPvPEndEventAsync cMIPvPEndEventAsync = new CMIPvPEndEventAsync(cMIUser.getPlayer(false));
                Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvPEndEventAsync);
            });
        }
        if (this.get(CombatDamageType.Mob).remove(cMIUser.getUniqueId())) {
            this.setGotLastDamageFromMob(cMIUser.getUniqueId(), 0L);
            CMIScheduler.runTaskAsynchronously(() -> {
                CMIPvEEndEventAsync cMIPvEEndEventAsync = new CMIPvEEndEventAsync(cMIUser.getPlayer(false));
                Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvEEndEventAsync);
            });
        }
    }

    public void addPlayerIntoCombat(CMIUser cMIUser) {
        if (!this.get(CombatDamageType.Player).add(cMIUser.getUniqueId())) {
            return;
        }
        if (cMIUser.isOnline()) {
            CMIScheduler.runTaskAsynchronously(() -> {
                CMIPvPStartEventAsync cMIPvPStartEventAsync = new CMIPvPStartEventAsync(cMIUser.getPlayer(false));
                Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvPStartEventAsync);
                if (cMIPvPStartEventAsync.isCancelled()) {
                    this.get(CombatDamageType.Player).remove(cMIUser.getUniqueId());
                }
            });
        }
        this.tasker();
    }

    public void addPlayerIntoMobCombat(CMIUser cMIUser) {
        if (!this.get(CombatDamageType.Mob).add(cMIUser.getUniqueId())) {
            return;
        }
        if (cMIUser.isOnline()) {
            CMIScheduler.runTaskAsynchronously(() -> {
                CMIPvEStartEventAsync cMIPvEStartEventAsync = new CMIPvEStartEventAsync(cMIUser.getPlayer(false));
                Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvEStartEventAsync);
                if (cMIPvEStartEventAsync.isCancelled()) {
                    this.get(CombatDamageType.Mob).remove(cMIUser.getUniqueId());
                }
            });
        }
        this.tasker();
    }

    private void tasker() {
        if (this.sched != null) {
            return;
        }
        this.sched = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            CMIUser cMIUser;
            if (this.get(CombatDamageType.Player).isEmpty() && this.get(CombatDamageType.Mob).isEmpty()) {
                this.stop();
                return;
            }
            for (UUID uUID : new HashSet<UUID>(this.get(CombatDamageType.Player))) {
                cMIUser = this.plugin.getPlayerManager().getUser(uUID);
                if (cMIUser == null || !cMIUser.isOnline()) {
                    this.get(CombatDamageType.Player).remove(uUID);
                    continue;
                }
                if (cMIUser.isInCombatWithPlayer()) continue;
                this.get(CombatDamageType.Player).remove(uUID);
                CMIScheduler.runTaskAsynchronously(() -> {
                    if (!cMIUser.isOnline()) {
                        return;
                    }
                    CMIPvPEndEventAsync cMIPvPEndEventAsync = new CMIPvPEndEventAsync(cMIUser.getPlayer(false));
                    Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvPEndEventAsync);
                });
            }
            for (UUID uUID : new HashSet<UUID>(this.get(CombatDamageType.Mob))) {
                cMIUser = this.plugin.getPlayerManager().getUser(uUID);
                if (cMIUser == null || !cMIUser.isOnline()) {
                    this.get(CombatDamageType.Mob).remove(uUID);
                    continue;
                }
                if (cMIUser.isInCombatWithMob()) continue;
                this.get(CombatDamageType.Mob).remove(uUID);
                CMIScheduler.runTaskAsynchronously(() -> {
                    if (!cMIUser.isOnline()) {
                        return;
                    }
                    CMIPvEEndEventAsync cMIPvEEndEventAsync = new CMIPvEEndEventAsync(cMIUser.getPlayer(false));
                    Bukkit.getServer().getPluginManager().callEvent((Event)cMIPvEEndEventAsync);
                });
            }
        }, (long)20L, (long)20L);
    }

    public Boolean isDropPlayerHead() {
        return this.dropHead;
    }

    public Boolean isDropEntityHead() {
        return this.dropEntityHead;
    }

    public double getLowerChanceWithEachKill() {
        return this.LowerChanceWithEachKill;
    }

    public double getPlayerDropHeadPercentage() {
        return this.DropHeadPercentage;
    }

    public double getEntityDropHeadPercentage(EntityType entityType) {
        EntityHeadDrop entityHeadDrop = this.entityHeadDropChance.get(entityType);
        return entityHeadDrop == null ? 0.0 : entityHeadDrop.getBaseDropChance();
    }

    public double getEntityHeadDropChanceLowering(EntityType entityType) {
        EntityHeadDrop entityHeadDrop = this.entityHeadDropChance.get(entityType);
        return entityHeadDrop == null ? 0.0 : entityHeadDrop.getBaseLowerAmount();
    }

    @Deprecated
    public ItemStack tryToGetEntityHead(EntityType entityType) {
        EntityHeadDrop entityHeadDrop = this.entityHeadDropChance.get(entityType);
        return entityHeadDrop == null ? null : entityHeadDrop.getHead();
    }

    public ItemStack tryToGetEntityHead(Player player, Entity entity) {
        EntityHeadDrop entityHeadDrop = this.entityHeadDropChance.get(entity.getType());
        return entityHeadDrop == null ? null : entityHeadDrop.getHead(player, entity);
    }

    public HashMap<EntityType, EntityHeadDrop> getEntityHeadDropChance() {
        return this.entityHeadDropChance;
    }

    public int getCombatTimer() {
        return this.CombatTimer;
    }

    public void setCombatTimer(int n) {
        this.CombatTimer = n;
    }

    public Boolean isIncludeVictim() {
        return this.IncludeVictim;
    }

    public HashMap<Integer, Double> getLootMobBonus() {
        return this.lootMobBonus;
    }

    public HashMap<Integer, Double> getLootPlayerBonus() {
        return this.lootPlayerBonus;
    }

    public Boolean isPVPNoGodDamage() {
        return this.pvpNoGodDamage;
    }

    public Boolean isPVPNoGodDamageInform() {
        return this.pvpNoGodDamageInform;
    }

    public Boolean isPVENoGodDamage() {
        return this.pveNoGodDamage;
    }

    public Boolean isPVENoGodDamageInform() {
        return this.pveNoGodDamageInform;
    }

    public Boolean isPDisableFlight() {
        return this.PDisableFlight;
    }

    public Boolean isMDisableFlight() {
        return this.MDisableFlight;
    }

    public boolean isAllowedPlayerCommand(String string) {
        for (String string2 : this.PlayerAllowedCommands) {
            if (!string.equalsIgnoreCase(string2.toLowerCase()) && !string.startsWith(string2.toLowerCase() + " ")) continue;
            return !this.PlayerMakeBlackList;
        }
        return this.PlayerMakeBlackList;
    }

    public boolean isAllowedMobCommand(String string) {
        for (String string2 : this.MobAllowedCommands) {
            if (!string.equalsIgnoreCase(string2.toLowerCase()) && !string.startsWith(string2.toLowerCase() + " ")) continue;
            return !this.MobMakeBlackList;
        }
        return this.MobMakeBlackList;
    }

    public boolean isPlayerShowBossBar() {
        return this.PlayerShowBossBar;
    }

    public boolean isMobShowBossBar() {
        return this.MobShowBossBar;
    }

    public boolean isPlayerBlockCommands() {
        return this.PlayerBlockCommands;
    }

    public boolean isMobBlockCommands() {
        return this.MobBlockCommands;
    }

    public boolean isPDisableFallDamage() {
        return this.PDisableFallDamage;
    }

    public boolean isMDisableFallDamage() {
        return this.MDisableFallDamage;
    }

    public List<String> getMobWorlds() {
        return this.mobWorlds;
    }

    public List<String> getPlayerWorlds() {
        return this.playerWorlds;
    }

    public boolean isSafeZoneDamage() {
        return this.safeZoneDamage;
    }

    public List<String> getPlayerHeadLore() {
        return new ArrayList<String>(this.PlayerHeadLore);
    }

    public void showDamageNumber(Player player, Double d, Location location, boolean bl) {
        if (d == null || d == 0.0) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            String string;
            String string2 = string = bl ? this.PlayerDamageNumbersFormat : this.MobDamageNumbersFormat;
            if (!player.getWorld().equals(location.getWorld())) {
                return;
            }
            CMIHologram cMIHologram = new CMIHologram(location, player, Arrays.asList(string.replace("[damage]", CMINumber.format2Decimals((double)d))));
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3)) {
                cMIHologram.setNewDisplayMethod(true).setBillboard(CMIBillboard.CENTER).setBackgroundAlpha(0).setBlockLevel(15).setSkyLevel(15).setShadowed(false);
                double d2 = CMILocation.getDistance((Location)player.getLocation(), (Location)location);
                double d3 = 1.0;
                if (d2 > 5.0) {
                    cMIHologram.setLoc(location.clone().add(0.0, CMINumber.clamp((double)(d2 -= 5.0), (double)1.0, (int)64) / 32.0, 0.0));
                    d3 = 1.0 + d2 / 5.0;
                }
                d3 = CMINumber.clamp((double)d3, (double)1.0, (int)10);
                cMIHologram.setScaleH(d3).setScaleW(d3);
            }
            cMIHologram.setSelfDestructIn(20);
            cMIHologram.showToPlayer();
        });
    }

    public void show(Player player, String string, Location location) {
        CMIScheduler.runTaskAsynchronously(() -> {
            CMIHologram cMIHologram = new CMIHologram(location, player, Arrays.asList(string));
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3)) {
                cMIHologram.setNewDisplayMethod(true);
                cMIHologram.setBillboard(CMIBillboard.CENTER);
                cMIHologram.setSeeThrough(true);
            }
            cMIHologram.setSelfDestructIn(20);
            cMIHologram.showToPlayer();
        });
    }

    public boolean isPlayerShowDamageNumbers() {
        return this.PlayerShowDamageNumbers;
    }

    public boolean isMobShowDamageNumbers() {
        return this.MobShowDamageNumbers;
    }

    public Long getGotLastDamageAt(UUID uUID) {
        CMIPlayerCombat cMIPlayerCombat = this.playerCombatMap.get(uUID);
        return cMIPlayerCombat == null ? null : cMIPlayerCombat.getGotLastDamageAt();
    }

    private CMIPlayerCombat getCombatRecord(UUID uUID2) {
        return this.playerCombatMap.computeIfAbsent(uUID2, uUID -> new CMIPlayerCombat());
    }

    public void setGotLastDamageAt(UUID uUID, Long l) {
        this.getCombatRecord(uUID).setGotLastDamageAt(l);
    }

    public boolean isInCombatWithPlayer(UUID uUID) {
        if (!this.playerCombatMap.containsKey(uUID)) {
            return false;
        }
        return this.playerCombatMap.get(uUID).isInCombatWithPlayer();
    }

    public Long getGotLastDamageFromPlayer(UUID uUID) {
        CMIPlayerCombat cMIPlayerCombat = this.playerCombatMap.get(uUID);
        return cMIPlayerCombat == null ? 0L : cMIPlayerCombat.getGotLastDamageFromPlayer();
    }

    public void setGotLastDamageFromPlayer(UUID uUID, Long l) {
        if (!this.isInCombatWithPlayer(uUID)) {
            this.addPlayerIntoCombat(CMIUser.getUser(uUID));
        }
        this.getCombatRecord(uUID).setGotLastDamageFromPlayer(l);
    }

    public void setDidLastDamageToPlayer(UUID uUID, Long l) {
        if (!this.isInCombatWithPlayer(uUID)) {
            this.addPlayerIntoCombat(CMIUser.getUser(uUID));
        }
        this.getCombatRecord(uUID).setDidLastDamageToPlayer(l);
    }

    public boolean isInCombatWithMob(UUID uUID) {
        if (!this.playerCombatMap.containsKey(uUID)) {
            return false;
        }
        return this.playerCombatMap.get(uUID).isInCombatWithMob();
    }

    public Long getGotLastDamageFromMob(UUID uUID) {
        CMIPlayerCombat cMIPlayerCombat = this.playerCombatMap.get(uUID);
        return cMIPlayerCombat == null ? 0L : cMIPlayerCombat.getGotLastDamageFromMob();
    }

    public void setGotLastDamageFromMob(UUID uUID, Long l) {
        if (!this.isInCombatWithMob(uUID)) {
            CMI.getInstance().getPlayerCombatManager().addPlayerIntoMobCombat(CMIUser.getUser(uUID));
        }
        this.getCombatRecord(uUID).setGotLastDamageFromMob(l);
    }

    public void setDidLastDamageToEntity(UUID uUID, Long l) {
        if (!this.isInCombatWithMob(uUID)) {
            CMI.getInstance().getPlayerCombatManager().addPlayerIntoMobCombat(CMIUser.getUser(uUID));
        }
        this.getCombatRecord(uUID).setDidLastDamageToMob(l);
    }

    public long getLeftCombatTime(UUID uUID) {
        if (!this.playerCombatMap.containsKey(uUID)) {
            return 0L;
        }
        return this.playerCombatMap.get(uUID).getLeftCombatTime();
    }

    public boolean isMobIncludeEnvironment() {
        return this.MobIncludeEnvironment;
    }

    public boolean isMaintainName() {
        return this.maintainName;
    }

    public boolean isMaintainLore() {
        return this.maintainLore;
    }

    public boolean isMaintainEnchants() {
        return this.maintainEnchants;
    }
}

