/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Region;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Region.CMIRegion;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitTask;

public class WorldManager {
    private CMI plugin;
    public Pattern regionPattern = Pattern.compile("r\\.(.+)\\.(.+)\\.mca");
    private Map<String, WorldInfo> worldMap = Collections.synchronizedMap(new HashMap());
    BukkitTask task = null;

    public void cancelLoading() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public boolean stillLoading(World world2) {
        if (world2 == null) {
            return this.stillLoading();
        }
        return !this.worldMap.containsKey(world2.getName()) && this.stillLoading();
    }

    public boolean stillLoading() {
        return this.task != null;
    }

    public WorldManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void removeWorldInfo(World world2) {
        this.worldMap.remove(world2.getName());
    }

    public void loadWorldChunksInfo(World world2) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isDisableWorldChunkCheckInfo()) {
            this.plugin.consoleMessage("World (" + world2.getName() + ") chunk information is being checked.");
        }
        WorldInfo worldInfo = this.getWorldInfo(world2, null);
        if (!this.plugin.isEnabled()) {
            return;
        }
        this.worldMap.put(world2.getName(), worldInfo);
        if (!this.plugin.getConfigManager().isDisableWorldChunkCheckInfo()) {
            this.plugin.consoleMessage("World (" + world2.getName() + ") chunk information checked. " + worldInfo.getTotalChunks());
        }
        this.task = null;
    }

    public void addChunk(Chunk chunk) {
        List<Boolean> list2;
        Object object;
        WorldInfo worldInfo = this.worldMap.get(chunk.getWorld().getName());
        int n = chunk.getX();
        int n2 = chunk.getZ();
        if (worldInfo == null) {
            object = chunk.getWorld();
            worldInfo = new WorldInfo((World)object, new CMIRegion(object.getSpawnLocation().getChunk().getX(), object.getSpawnLocation().getChunk().getZ()));
            this.worldMap.put(object.getName(), worldInfo);
        }
        if ((list2 = worldInfo.getRegionPlaces((CMIRegion)(object = WorldManager.getRegionCord(n, n2)))) == null || list2.isEmpty()) {
            list2 = new ArrayList<Boolean>(Collections.nCopies(1024, false));
        }
        int n3 = WorldManager.CoordToChunkPlace(n - ((CMIRegion)object).getX() * 32, n2 - ((CMIRegion)object).getZ() * 32);
        list2.set(n3, true);
        worldInfo.addTotalChunks();
        worldInfo.setRegionPlaces((CMIRegion)object, list2);
    }

    public WorldInfo getWorldInfoInRange(World world2, CMIRegion cMIRegion, Integer n) {
        WorldInfo worldInfo = null;
        if ((cMIRegion == null || n == null || n > 1000) && world2 != null) {
            worldInfo = this.getWorldInfoFromWorld(world2);
            if (worldInfo != null) {
                worldInfo = worldInfo.clone();
            }
        } else {
            worldInfo = cMIRegion != null && world2 != null && n != null && n == -1 ? this.getWorldInfo(world2, cMIRegion, 5000) : this.getWorldInfo(world2, cMIRegion, n);
        }
        if (worldInfo == null) {
            worldInfo = this.fillEmpty(world2, cMIRegion, n);
        }
        return worldInfo;
    }

    public WorldInfo getWorldInfoFromWorld(World world2) {
        return this.worldMap.get(world2.getName());
    }

    public CMIRegion getNextInSpiral(long l) {
        int n = (int)Math.floor(Math.sqrt(l));
        int n2 = (int)Math.round((double)n / 2.0);
        double d = Math.pow(-1.0, n + 1);
        double d2 = (long)(n * (n + 1)) - l;
        double d3 = Math.abs((long)(n * (n + 1)) - l);
        int n3 = (int)((double)n2 * Math.pow(-1.0, n + 1) + d * (d2 - d3) / 2.0);
        int n4 = (int)((double)n2 * Math.pow(-1.0, n) + d * (d2 + d3) / 2.0);
        return new CMIRegion(n3, n4);
    }

    public CMIRegion getNextChunkLocation(WorldInfo worldInfo, boolean bl) {
        CMIRegion cMIRegion;
        CMIRegion cMIRegion2 = this.getNextInSpiral(worldInfo.getNextPlace());
        CMIRegion cMIRegion3 = new CMIRegion(cMIRegion2.getX() + worldInfo.getCenter().getX(), cMIRegion2.getZ() + worldInfo.getCenter().getZ());
        CMIRegion cMIRegion4 = WorldManager.getRegionCord(cMIRegion3);
        Boolean bl2 = worldInfo.getRegionsChunk(cMIRegion4, WorldManager.CoordToChunkPlace((cMIRegion = new CMIRegion(cMIRegion3.getX() - cMIRegion4.getX() * 32, cMIRegion3.getZ() - cMIRegion4.getZ() * 32)).getX(), cMIRegion.getZ()));
        if (bl2 == null) {
            return null;
        }
        if (bl && bl2.booleanValue()) {
            return cMIRegion3;
        }
        if (!bl && !bl2.booleanValue()) {
            return cMIRegion3;
        }
        return null;
    }

    public Chunk getNextChunk(WorldInfo worldInfo, boolean bl) {
        CMIRegion cMIRegion = this.getNextChunkLocation(worldInfo, bl);
        if (cMIRegion == null) {
            return null;
        }
        return worldInfo.getWorld().getChunkAt(cMIRegion.getX(), cMIRegion.getZ());
    }

    public WorldInfo getWorldInfo(World world2, CMIRegion cMIRegion, Integer n) {
        HashMap<Object, Object> hashMap = new HashMap();
        hashMap = cMIRegion != null && n != null ? this.getRegionFiles(cMIRegion, n) : this.getRegionFiles(world2);
        if (world2 == null) {
            return null;
        }
        WorldInfo worldInfo = new WorldInfo(world2, cMIRegion);
        WorldInfo worldInfo2 = this.worldMap.get(world2.getName());
        if (worldInfo2 == null) {
            return null;
        }
        for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
            List<Boolean> list2;
            CMIRegion cMIRegion2 = (CMIRegion)entry.getValue();
            if (cMIRegion2 == null || (list2 = worldInfo2.getRegionPlaces(cMIRegion2)) == null) continue;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1024);
            int n2 = 0;
            while (n2 < 1024) {
                arrayList.add(false);
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < 1024) {
                CMIRegion cMIRegion3;
                if (list2.get(n3).booleanValue() && WorldManager.inRange(cMIRegion, cMIRegion3 = WorldManager.getRealChunkFromPlace(cMIRegion2, n3), n)) {
                    ++n2;
                    arrayList.set(n3, true);
                }
                ++n3;
            }
            worldInfo.addTotalChunks(n2);
            worldInfo.setRegionChunks(cMIRegion2, arrayList);
        }
        return worldInfo;
    }

    public WorldInfo fillEmpty(World world2, CMIRegion cMIRegion, Integer n) {
        HashMap<Object, Object> hashMap = new HashMap();
        hashMap = this.getRegionFiles(cMIRegion, n);
        if (world2 == null) {
            return null;
        }
        WorldInfo worldInfo = new WorldInfo(world2, cMIRegion);
        for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
            CMIRegion cMIRegion2 = (CMIRegion)entry.getValue();
            if (cMIRegion2 == null) continue;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1024);
            int n2 = 0;
            while (n2 < 1024) {
                arrayList.add(false);
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < 1024) {
                CMIRegion cMIRegion3 = WorldManager.getRealChunkFromPlace(cMIRegion2, n3);
                if (WorldManager.inRange(cMIRegion, cMIRegion3, n)) {
                    ++n2;
                    arrayList.set(n3, true);
                }
                ++n3;
            }
            worldInfo.addTotalChunks(n2);
            worldInfo.setRegionChunks(cMIRegion2, arrayList);
        }
        return worldInfo;
    }

    public WorldInfo getWorldInfo(World world2, CMIRegion cMIRegion) {
        if (world2 == null) {
            return null;
        }
        WorldInfo worldInfo = new WorldInfo(world2, cMIRegion);
        Object object = "";
        if (new File(world2.getWorldFolder(), "region").exists()) {
            object = "";
        } else if (new File(world2.getWorldFolder(), "DIM-1").exists()) {
            object = "DIM-1" + File.separator;
        } else if (new File(world2.getWorldFolder(), "DIM1").exists()) {
            object = "DIM1" + File.separator;
        }
        File file = new File(world2.getWorldFolder(), (String)object + "region");
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    File file2 = fileArray[n2];
                    if (!this.plugin.isEnabled()) {
                        return null;
                    }
                    Matcher matcher = this.regionPattern.matcher(file2.getName());
                    if (matcher.matches()) {
                        int n3;
                        int n4;
                        try {
                            n4 = Integer.parseInt(matcher.group(1));
                            n3 = Integer.parseInt(matcher.group(2));
                        }
                        catch (Exception exception) {
                            break block17;
                        }
                        CMIRegion cMIRegion2 = new CMIRegion(n4, n3);
                        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1024);
                        int n5 = 0;
                        while (n5 < 1024) {
                            arrayList.add(false);
                            ++n5;
                        }
                        n5 = 0;
                        try {
                            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
                            int n6 = 0;
                            while (n6 < 1024) {
                                if (randomAccessFile.readInt() != 0) {
                                    ++n5;
                                    arrayList.set(n6, true);
                                }
                                ++n6;
                            }
                            randomAccessFile.close();
                        }
                        catch (Exception exception) {
                            break block17;
                        }
                        worldInfo.addTotalChunks(n5);
                        worldInfo.setRegionChunks(cMIRegion2, arrayList);
                    }
                }
                ++n2;
            }
        }
        return worldInfo;
    }

    private static boolean inRange(CMIRegion cMIRegion, CMIRegion cMIRegion2, Integer n) {
        int n2;
        if (n == null || cMIRegion == null || cMIRegion2 == null) {
            return true;
        }
        int n3 = cMIRegion.getX() - cMIRegion2.getX();
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = cMIRegion.getZ() - cMIRegion2.getZ()) < 0) {
            n2 = -n2;
        }
        return n3 <= n && n2 <= n;
    }

    public HashMap<String, CMIRegion> getRegionFiles(World world2) {
        HashMap<String, CMIRegion> hashMap = new HashMap<String, CMIRegion>();
        if (world2 == null) {
            return hashMap;
        }
        Object object = "";
        if (new File(world2.getWorldFolder(), "region").exists()) {
            object = "";
        } else if (new File(world2.getWorldFolder(), "DIM-1").exists()) {
            object = "DIM-1" + File.separator;
        } else if (new File(world2.getWorldFolder(), "DIM1").exists()) {
            object = "DIM1" + File.separator;
        }
        File file = new File(world2.getWorldFolder(), (String)object + "region");
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    File file2 = fileArray[n2];
                    Matcher matcher = this.regionPattern.matcher(file2.getName());
                    if (matcher.matches()) {
                        int n3;
                        int n4;
                        try {
                            n4 = Integer.parseInt(matcher.group(1));
                            n3 = Integer.parseInt(matcher.group(2));
                        }
                        catch (Exception exception) {
                            break block11;
                        }
                        hashMap.put((n4 >> 5) + ":" + (n3 >> 5), new CMIRegion(n4 >> 5, n3 >> 5));
                    }
                }
                ++n2;
            }
        }
        return hashMap;
    }

    public HashMap<String, CMIRegion> getRegionFiles(CMIRegion cMIRegion, Integer n) {
        HashMap<String, CMIRegion> hashMap = new HashMap<String, CMIRegion>();
        if (cMIRegion == null) {
            return hashMap;
        }
        if (n == null) {
            n = 1024;
        }
        int n2 = cMIRegion.getX();
        int n3 = cMIRegion.getZ();
        hashMap.put((n2 >> 5) + ":" + (n3 >> 5), new CMIRegion(n2 >> 5, n3 >> 5));
        int n4 = n2 - n;
        while (n4 <= n2 + n) {
            int n5 = n3 - n;
            while (n5 <= n3 + n) {
                hashMap.put((n4 >> 5) + ":" + (n5 >> 5), new CMIRegion(n4 >> 5, n5 >> 5));
                if (n5 + 32 > n3 + n && n5 < n3 + n) {
                    n5 = n3 + n - 32;
                }
                n5 += 32;
            }
            if (n4 + 32 > n2 + n && n4 < n2 + n) {
                n4 = n2 + n - 32;
            }
            n4 += 32;
        }
        return hashMap;
    }

    private static CMIRegion getRegionCord(CMIRegion cMIRegion) {
        return WorldManager.getRegionCord(cMIRegion.getX(), cMIRegion.getZ());
    }

    private static CMIRegion getRegionCord(int n, int n2) {
        return new CMIRegion(n >> 5, n2 >> 5);
    }

    private static CMIRegion getRealChunkFromPlace(CMIRegion cMIRegion, int n) {
        CMIRegion cMIRegion2 = WorldManager.getCordFromPlace(n);
        return new CMIRegion(cMIRegion.getX() * 32 + cMIRegion2.getX(), cMIRegion.getZ() * 32 + cMIRegion2.getZ());
    }

    private static CMIRegion getCordFromPlace(int n) {
        return new CMIRegion(n % 32, n / 32);
    }

    private static int CoordToChunkPlace(int n, int n2) {
        return n + n2 * 32;
    }
}

