/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Scavenger;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Scavenger.ScavengeManager;
import com.Zrips.CMI.Modules.Worth.WorthEnchantment;
import com.Zrips.CMI.Modules.Worth.WorthItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Recipes.CMIRecipe;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CMIScavengeItem {
    private ItemStack item;
    private Player player;
    private Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
    int maxDurability = 1;
    int durability = 1;
    private int recipeResultAmount = 1;
    Recipe recipe = null;

    CMIScavengeItem(ItemStack itemStack) {
        this(itemStack, null);
    }

    CMIScavengeItem(ItemStack itemStack, Player player) {
        this.item = itemStack;
        this.player = player;
        if (itemStack != null) {
            this.maxDurability = itemStack.getType().getMaxDurability();
            this.durability = this.maxDurability - itemStack.getDurability();
            this.maxDurability = this.maxDurability < 1 ? 1 : this.maxDurability;
            this.durability = this.durability < 1 ? 1 : this.durability;
            this.enchants = itemStack.getEnchantments();
        }
    }

    public boolean canScavenge() {
        if (this.getItem() == null) {
            return false;
        }
        if (CMIMaterial.isAir((Material)this.getItem().getType())) {
            return false;
        }
        if (this.isBlackListedItem()) {
            return false;
        }
        if (this.getItem() != null && this.getIngredients().isEmpty()) {
            return false;
        }
        return this.recipeResultAmount <= this.item.getAmount();
    }

    public boolean isBlackListedItem() {
        return ScavengeManager.InvertBlackList ? !ScavengeManager.blackList.contains(CMIMaterial.get((ItemStack)this.getItem())) : ScavengeManager.blackList.contains(CMIMaterial.get((ItemStack)this.getItem()));
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }

    public double getEnchantExtractionFailChance(Enchantment enchantment) {
        Integer n = this.enchants.get(enchantment);
        if (n == null) {
            n = 1;
        }
        Double d = ScavengeManager.baseEnchantFailPercentage;
        int n2 = enchantment.getMaxLevel();
        d = (d = Double.valueOf(d + (double)n.intValue() * ScavengeManager.levelEnchantFailPercentage / (double)n2)) > ScavengeManager.levelEnchantFailMaxChance ? ScavengeManager.levelEnchantFailMaxChance : d;
        return this.format(d);
    }

    private double format(double d) {
        return (double)((int)(d * 100.0)) / 100.0;
    }

    public double getExtractionCost() {
        if (this.item == null || CMIMaterial.isAir((Material)this.item.getType())) {
            return 0.0;
        }
        Double d = ScavengeManager.EnchantBaseCost;
        for (Map.Entry<Enchantment, Integer> object2 : this.enchants.entrySet()) {
            WorthEnchantment worthEnchantment = CMI.getInstance().getWorthManager().getEnchantWorth(object2.getKey(), object2.getValue());
            if (worthEnchantment == null || !(worthEnchantment.getSellPrice() > 0.0)) continue;
            d = d + worthEnchantment.getSellPrice() * (ScavengeManager.EnchantBaseCostExtra / 100.0);
        }
        WorthItem worthItem = CMI.getInstance().getWorthManager().getWorth(this.item);
        if (worthItem != null && worthItem.getSellPrice() > 0.0) {
            d = d + worthItem.getSellPrice() * (ScavengeManager.EnchantBaseCostExtra / 100.0);
        }
        return this.format(d);
    }

    public double getIngredientReturnChance() {
        double d = ScavengeManager.IngredientReturnBase;
        return this.format(d);
    }

    public double getEnchantLevelLowerChance(Enchantment enchantment) {
        Integer n = this.enchants.get(enchantment);
        if (n == null) {
            n = 1;
        }
        Double d = ScavengeManager.LowerLevelChanceBase;
        int n2 = enchantment.getMaxLevel();
        d = (d = Double.valueOf(d + (double)n.intValue() * ScavengeManager.LowerLevelForEachLevel / (double)n2)) > ScavengeManager.LowerLevelMaxChance ? ScavengeManager.LowerLevelMaxChance : d;
        return this.format(d);
    }

    public double getItemBreakChance() {
        if (this.enchants.isEmpty()) {
            return 100.0;
        }
        double d = ScavengeManager.baseBreakPercentage;
        if (!this.enchants.isEmpty()) {
            d += (double)this.enchants.size() * ScavengeManager.eachBreakPercentage;
            for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
                int n = entry.getValue();
                int n2 = entry.getKey().getMaxLevel();
                d += (double)n * ScavengeManager.eachBreakPercentageLevel / (double)n2;
            }
        }
        if ((d += this.getBreakChanceByItemDurability()) > 0.0) {
            d = d > ScavengeManager.itemBreakMaxBreakChance ? ScavengeManager.itemBreakMaxBreakChance : d;
        }
        return this.format(d);
    }

    public double getBreakChanceByItemDurability() {
        if (ScavengeManager.ItemBreakDurabilityChange > 0.0 && this.maxDurability != this.durability) {
            return this.format(ScavengeManager.ItemBreakDurabilityChange - Math.ceil(this.getLeftDurabilityPercentage() * ScavengeManager.ItemBreakDurabilityChange / 100.0));
        }
        return 0.0;
    }

    public List<ItemStack> getIngredients() {
        return this.getIngredients(ScavengeManager.ItemMaterialDurabilityCheck, false);
    }

    public List<ItemStack> getIngredients(boolean bl) {
        return this.getIngredients(bl, false);
    }

    public List<ItemStack> getIngredients(boolean bl, boolean bl2) {
        CMIItemStack cMIItemStack = new CMIItemStack(this.item);
        List list2 = cMIItemStack.getRecipesFor();
        if (list2 != null && !list2.isEmpty()) {
            List list3;
            ItemMeta itemMeta;
            Collections.shuffle(list2);
            ItemMeta itemMeta2 = itemMeta = this.item.hasItemMeta() ? this.item.getItemMeta() : null;
            if (this.recipe == null) {
                List list4;
                list3 = (Recipe)list2.get(0);
                List list5 = null;
                List list6 = null;
                List list7 = null;
                while (!list2.isEmpty()) {
                    list3 = (Recipe)list2.remove(0);
                    if (list6 == null || list6.getResult().getAmount() > list3.getResult().getAmount()) {
                        if (!CMIMaterial.isTool((Material)list3.getResult().getType()) && ((list4 = CMIRecipe.getIngredientsList((Recipe)list3)).isEmpty() || CMIMaterial.isTool((Material)((ItemStack)list4.get(0)).getType()))) continue;
                        list6 = list3;
                    }
                    if (itemMeta != null && list3.getResult().hasItemMeta() && ((list4 = list3.getResult().getItemMeta()).hasDisplayName() && itemMeta.hasDisplayName() && list4.getDisplayName().equals(itemMeta.getDisplayName()) || !list4.hasDisplayName() && !itemMeta.hasDisplayName()) && (list4.hasLore() && itemMeta.hasLore() && list4.getLore().equals(itemMeta.getLore()) || !list4.hasLore() && !itemMeta.hasLore())) {
                        list7 = list3;
                    }
                    if ((itemMeta == null && list3.getResult().hasItemMeta() || !list3.getResult().hasItemMeta()) && list3.getResult().getAmount() == 1 && !CMIRecipe.getIngredientsList((Recipe)list3).isEmpty()) {
                        if (!CMIMaterial.isTool((Material)list3.getResult().getType()) && ((list4 = CMIRecipe.getIngredientsList((Recipe)list3)).isEmpty() || CMIMaterial.isTool((Material)((ItemStack)list4.get(0)).getType()))) continue;
                        if (!list3.getResult().hasItemMeta()) {
                            list5 = list3;
                        } else {
                            list4 = list3.getResult().getItemMeta();
                            if (!list4.hasDisplayName() && !list4.hasLore()) {
                                list5 = list3;
                            }
                        }
                    }
                    if (list3.getResult().getAmount() == 1 && !CMIRecipe.getIngredientsList((Recipe)list3).isEmpty()) break;
                }
                while (!list2.isEmpty()) {
                    list3 = (Recipe)list2.remove(0);
                    if (itemMeta != null && list3.getResult().hasItemMeta() && ((list4 = list3.getResult().getItemMeta()).hasDisplayName() && itemMeta.hasDisplayName() && list4.getDisplayName().equals(itemMeta.getDisplayName()) || !list4.hasDisplayName() && !itemMeta.hasDisplayName()) && (list4.hasLore() && itemMeta.hasLore() && list4.getLore().equals(itemMeta.getLore()) || !list4.hasLore() && !itemMeta.hasLore())) {
                        list7 = list3;
                    }
                    if ((itemMeta != null || !list3.getResult().hasItemMeta()) && list3.getResult().hasItemMeta() || list3.getResult().getAmount() != 1 || CMIRecipe.getIngredientsList((Recipe)list3).isEmpty()) continue;
                    if (!list3.getResult().hasItemMeta()) {
                        list5 = list3;
                        continue;
                    }
                    list4 = list3.getResult().getItemMeta();
                    if (list4.hasDisplayName() || list4.hasLore()) continue;
                    list5 = list3;
                }
                if (list6 != null) {
                    if (list7 != null) {
                        list3 = list7;
                    } else if (list5 != null) {
                        list3 = list5;
                    } else {
                        list4 = CMIRecipe.getIngredientsList(list6);
                        for (ItemStack itemStack : list4) {
                            if (!this.item.getType().equals((Object)itemStack.getType())) continue;
                            return new ArrayList<ItemStack>();
                        }
                        list3 = list6;
                    }
                }
                this.recipeResultAmount = list3.getResult().getAmount();
                this.recipe = list3;
            }
            list3 = CMIRecipe.getIngredientsList((Recipe)this.recipe);
            if (bl2) {
                double d = 0.0;
                if (this.recipeResultAmount > this.item.getAmount()) {
                    d = (double)this.item.getAmount() * 100.0 / Double.valueOf(this.recipeResultAmount);
                }
            }
            if (bl) {
                Collections.shuffle(list3);
                int n = (int)Math.ceil(this.getLeftDurabilityPercentage() * (double)list3.size() / 100.0);
                while (list3.size() > n) {
                    list3.remove(0);
                }
            }
            return list3;
        }
        return new ArrayList<ItemStack>();
    }

    public double getLeftDurabilityPercentage() {
        return this.format(this.durability * 100 / this.maxDurability);
    }

    public List<ItemStack> enchantsToBooks() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        Map map = this.item.getEnchantments();
        if (map.isEmpty()) {
            return arrayList;
        }
        for (Map.Entry entry : map.entrySet()) {
            ItemStack itemStack = CMIMaterial.ENCHANTED_BOOK.newItemStack();
            if (itemStack.getItemMeta() instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
                enchantmentStorageMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
            }
            arrayList.add(itemStack);
        }
        return arrayList;
    }

    public ItemStack createBook(Enchantment enchantment) {
        Integer n = this.enchants.get(enchantment);
        if (n == null) {
            n = 1;
        }
        return this.createBook(enchantment, n);
    }

    public ItemStack createBook(Enchantment enchantment, int n) {
        ItemStack itemStack = CMIMaterial.ENCHANTED_BOOK.newItemStack();
        if (itemStack.getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
            enchantmentStorageMeta.addStoredEnchant(enchantment, n, true);
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        }
        return itemStack;
    }

    public int getRecipeResultAmount() {
        return this.recipeResultAmount;
    }
}

